

NativeSpr_InitReiKou:
	jsr AddressRemapViaTableHL	;Used by VM for address remapping
	
NativeSpr_Init:
	
	lda #%00000000  ;Turn off interrupts (Bitmap interrupt DMA would mess with vram dest)
	sta $4200

;Define Sprite Bitmaps
	lda #128
	;  i000abcd - I 0=inc on $2118 or $2139 1=$2119 or $213A… abcd=move size
	sta $2115 		;VMAIN - Video port control (Inc on write to $2119)
	
	
	
	lda #<SNS_SpritePatternVram
	sta $2116		;VRAM MemL 		$4000
	lda #>SNS_SpritePatternVram
	sta $2117		;VRAM MemH
	
	ldy #0
	
NativeSpr_Init_DefineTilesAgain	
	jsr WaitVblankNS ;Wait for vblank
	lda (z_HL),Y	
	sta $2118		;Transfer First Byte
	jsr DecBC
	jsr incHL
		
	jsr WaitVblankNS ;Wait for vblank
	lda (z_HL),Y	
	sta $2119		;Transfer 2nd byte (+autoinc)
	jsr DecBC
	jsr incHL
	
	ifdef NativeSpr_Multiplatform2Bitplane
		lda z_c
		and #%00001111
		bne NativeSpr_Init_DefineTilesNoskip
		
		ldx #8
NativeSpr_Init_DefineTilesAgain2	
		jsr WaitVblankNS ;Wait for vblank
		sty $2118
		jsr WaitVblankNS ;Wait for vblank
		sty $2119
		dex 
		bne NativeSpr_Init_DefineTilesAgain2
NativeSpr_Init_DefineTilesNoskip:
	endif 
	
	lda z_b			;Repeat until z_bc=0
	ora z_c
	bne NativeSpr_Init_DefineTilesAgain	
	
;Set Sprite palette
	ifdef SNS_SpritePalette
		lda #128
		sta $2121
		ldy #0
		
SpritePaletteAgain:		
		lda SNS_SpritePalette,y
		iny
		sta $2122
		cpy #0				;Do 256 bytes (128 palettes)
		bne SpritePaletteAgain
		
	else

		lda #$21
		sta z_h
		sta z_l
		ldy #0

		lda #128
		sta (z_hl),y	;$2121 CGADD - Colour selection  (0=Back)
		iny ;$2122
			 
		lda #%00000000	;gggrrrrr 
		sta (z_hl),y	;$2122 0GDATA - Colour data register
		lda #%00111100	;?bbbbbgg 
		sta (z_hl),y	;$2122 CGDATA
		
		lda #%11111111	;gggrrrrr 
		sta (z_hl),y	;$2122 CGDATA - Colour data register
		lda #%00000011	;?bbbbbgg 
		sta (z_hl),y	;$2122 CGDATA
		
		lda #%11100000	;gggrrrrr 
		sta (z_hl),y	;$2122 CGDATA - Colour data register
		lda #%11111111	;?bbbbbgg 
		sta (z_hl),y	;$2122 CGDATA

		lda #%00011111	;gggrrrrr 
		sta (z_hl),y	;$2122 CGDATA - Colour data register
		lda #%00000000	;?bbbbbgg 
		sta (z_hl),y	;$2122 CGDATA
	endif
		
;Sprite Ram Pos	
	lda #%00000010+(SNS_SpriteSize*32)	;Set Sprite pos to $4000
	sta $2101		;OAM settings SSSNNBBB S=size N=Bame addr B=Base addr
		
;Turn on the screen	+ Sprites
		; ---S4321 - S=sprites 4-1=enable Bgx
	lda #%00010001	;Turn on BG1 + SPRITES 
	sta $212C 		;Main screen designation [TM] 

;Turn on interrupts	
	lda #%10000000  ;Turn on interrupts
	sta $4200

	cli				;Interrupts on
	;jmp nativespr_hideAll_Reikou
	
nativespr_hideAll_Reikou:
nativespr_hideAll:
	stz HspriteCount
	
NativeSpr_ClearUnused:
	ldy HspriteCount
NativeSpr_ClearUnusedAgain:
	cpy #128
	beq NativeSpr_ClearUnusedDone
	phy
		tya
		jsr NativeSpr_Hide
	ply
	iny
	bne NativeSpr_ClearUnusedAgain	;Always NE
	
NativeSpr_ClearUnusedDone:
	stz HspriteCount
	rts
	
	

	
WaitVblankNS:
	lda $4212 			;HVBJOY - Status 	
		; xy00000a		- x=vblank state y=hblank state a=joypad ready
	and #%10000000
	beq WaitVblankNS	;Wait until we get nonzero - this means we're in VBLANK
	rts
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
NativeSpr_DrawArrayReiKou:			
	jsr AddressRemapViaTableHL	;Used by VM for address remapping
	
NativeSpr_DrawArray:	;Draw Sprite Array (HL)
	ldx #0				;X=Zero throughout
	stx HspriteCount
			
	lda (z_hl,x)
	beq NativeSpr_ClearUnusedb ;We're done, so check any remaining
	jsr IncHL
	
NativeSpr_DrawArrayB:	
	pha					 
		ldy #0
		lda (z_hl),y	;Xpos (Pairs of pixels)
		sta z_c
		iny
		lda (z_hl),y	;Ypos (Pairs of pixels)
		sta z_b	
		iny
		lda (z_hl),y	;SpriteDef-L
		sta z_ls
		iny
		lda (z_hl),y	;SpriteDef-H
		sta z_hs
		iny
		tya
		clc
		adc z_l
		pha				;Backup HL+Y
		lda z_h
		adc #0
		pha		
			lda z_hs
			sta z_h
			lda z_ls
			sta z_l
			
			jsr NativeSpr_DrawExtra	;HL=sprite data  BC=XY pos
		pla
		sta z_h
		pla 			;Restore HL
		sta z_l
		
		
		
		ifdef NativeSpr_ExtraBytes
			lda #NativeSpr_ExtraBytes
			adc z_l
			sta z_l
			bcc nativespr_nochangeHok
			inc z_h
nativespr_nochangeHok			
			
		endif
	pla
	sec
	sbc #1
	bne NativeSpr_DrawArrayB	;Repeat for next object
NativeSpr_ClearUnusedb:
	jmp NativeSpr_ClearUnused 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
NativeSpr_SpriteSizes: 			;X,Y size for regular / Large sprites
	ifdef SNS_SpriteSize0
		db 8/2,8/2,16/2,16/2
	endif 
	ifdef SNS_SpriteSize1
		db 8/2,8/2,32/2,32/2
	endif 
	ifdef SNS_SpriteSize2
		db 8/2,8/2,64/2,64/2
	endif 
	ifdef SNS_SpriteSize3
		db 16/2,16/2,32/2,32/2
	endif 
	ifdef SNS_SpriteSize4
		db 16/2,16/2,64/2,64/2
	endif 
	ifdef SNS_SpriteSize5
		db 32/2,32/2,64/2,64/2
	endif 
	ifdef SNS_SpriteSize6
		db 16/2,32/2,32/2,64/2
	endif 
	ifdef SNS_SpriteSize7
		db 16/2,32/2,32/2,32/2
	endif 

NativeSpr_DrawExtra:
	lda HspriteCount		;Sprnum
	jsr NativeSpr_Draw
	sta HspriteCount		;Sprnum
	rts
	
NativeSpr_DrawNoSprite:
	pla
	rts
NativeSpr_Draw:	;BC=XY in pairs of pixels	A=hspriteNum
	pha		 	;HL = Source Data
		ldx #0
		lda (z_hl,x)
		sta z_d			;W
		beq NativeSpr_DrawNoSprite
		jsr IncHL
		lda (z_hl,x)
		sta z_e			;H
		jsr IncHL
		
		ifdef NativeSpr_Multiplatform2Bitplane 
			lda #0
			sta z_ixl
			
			lda #8/2
			sta z_ds		;Wid
			sta z_es		;Hei
		else
			lda (z_hl,x)
			sta z_ixl		;Attrib
			tay
			jsr IncHL
			
			lda NativeSpr_SpriteSizes,y
			sta z_ds		;Wid
			iny
			lda NativeSpr_SpriteSizes,y
			sta z_es		;Hei
		endif 
NativeSpr_DrawY:
		lda z_d		;Width
		sta z_cs
		lda z_b		;Xpos
		sta z_bs
		
NativeSpr_DrawX:
	pla
	pha
		cmp #128
		bcs NativeSpr_NoSpritesLeft
		
		lda (z_hl,x)	;TTTTTTTT
		ifdef SNS_NativeSprite_PatternOffset
			clc 
			adc #SNS_NativeSprite_PatternOffset
		endif 
		sta z_iyl
		jsr IncHL
		
		ifdef NativeSpr_Multiplatform2Bitplane 
			lda #$30
		else 
			lda (z_hl,x)	;YXPPCCCT
			jsr IncHL
		endif 
		sta z_iyh
		
		ora z_iyl
		beq NativeSpr_Unused ;$0000= unused
	pla
	pha
		jsr SetHardwareSprite
NativeSpr_Unused:			
	pla
	clc
	adc #1
	pha
NativeSpr_NoSpritesLeft:
		lda z_bs
		clc
		adc z_ds		;Move across screen
		sta z_bs
		
		dec z_cs		;X loop
		bne NativeSpr_DrawX
	
		lda z_c
		clc
		adc z_es		;Move down screen
		sta z_c
	
		dec z_e			;Y loop
		bne NativeSpr_DrawY
NotNativeSpr_DrawY
	pla
nativespr_hideAllForBackground_Reikou:
	rts
	

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	

	
NativeSpr_Hide:
	stz z_bs		;Xpos
	stz z_c			;Ypos

;z_bs			Xpos
;z_c			Ypos
;z_iyl			TTTTTTTT
;z_iyh			YXPPCCCT
;z_ixl			Attrib (Size: %00=8x8 or %10=16x16)
SetHardwareSprite:		
	pha
		stz z_hs
		
		asl
		rol z_hs		;4 bytes per sprite
		asl
		rol z_hs
		sta z_ls		;z_hs = Sprite buffer address
			
		lda z_hs
		adc #>SnesSpriteBuffer
		sta z_hs
		
		ldy #0
		stz z_ixh
		
		lda z_bs		;Xpos
		sec
		sbc #64
		bcs SetHardwareSpriteB
			dec z_ixh
SetHardwareSpriteB:		
		asl
		rol z_ixh		;Xpos Top Bit
		sta (z_hls),y
		iny
						
		lda z_c			;Ypos
		clc
		sbc #80
		asl
		sec	
		ifdef MaxTileTilemap
			adc #2+16
		else
			adc #3
		endif 
		
		sta (z_hls),y
		iny
		
		lda z_iyl		;TTTTTTTT
		sta (z_hls),y
		iny
		
		lda z_iyh		;YXPPCCCT
		sta (z_hls),y
	pla
			
;2nd part
	tay
	and #%11111100
	lsr					;1 byte per 4 sprites
	lsr
	sta z_ls			;Address L
	
	lda #(>SnesSpriteBuffer+2)			
	sta z_hs			;Address H
	ldx #0
	lda (z_hls,x)
	sta z_as			;Get current attr2
	 
	tya
	and #%00000011		;4 sprites per byte of attr2
	tax
	 
	lda #%11111100		;Prep the mask
	sta z_iyl
	lda z_ixh			;Xpos Top bit
	and #%00000001
	ora z_ixl			;Attrib (Scale bit)
	
	and #%00000011		;2 bits of new sprite settings setting
	 
	cpx #0				;Shift bits ------sx into correct position
	beq SpriteSkipShift
SpriteShiftAgain:
	asl
	asl					;Shift new val
	sec
	rol z_iyl
	sec
	rol z_iyl			;Shift mask
	dex
	bne SpriteShiftAgain
SpriteSkipShift: 
	pha
		lda z_as		;Get back current value
		and z_iyl		;Apply mask
		sta z_as		;Get back current value
	pla
	ora z_as
	sta (z_hls,x)	;x=0
	rts
	

	

	
	ifndef SnesScreenBuffer	;This version only does sprites!
	ifndef CustomNmihandler
CustomNmihandler:		;Vblank interrupt handler
	pha
	
;Copy Sprites (OAM) Via DMA
		stz $2102
		stz $2103           ; Point to start of OAM

		lda #0				;Write mode 000=one byte address repeating 
		sta $4300
		lda #04
		sta $4301			;Destination $21xx= $2104
		
		lda #<SnesSpriteBuffer
		sta $4302			;Source (24 bit - Little endian)
		lda #>SnesSpriteBuffer
		sta $4303
		lda #0				;bits 16-23
		sta $4304
			
		lda #<$220
		sta $4305	
		lda #>$220			;No of bytes (24 bit - Little endian
		sta $4306
		lda #0
		sta $4307
		
		lda #0
		sta $420C			;Disable H-DMA transfer 
		lda #%00000001		
		sta $420B			;enable DMA 0 (bit0=1)	
			
;Dma's finished 
		lda #0
		sta $2115			;Inc address on write to $2118	
	pla
	rti
	endif
	endif 
	
	