MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 4
MPB_Pen5 equ 5
MPB_Pen6 equ 6
MPB_Pen7 equ 7
MPB_Pen8 equ 8
MPB_Pen9 equ 9
MPB_PenA equ 10
MPB_PenB equ 11
MPB_PenC equ 12
MPB_PenD equ 13
MPB_PenE equ 14
MPB_PenF equ 15

mpbitmap_tiletints:
	db 255,0,0

	
mpbitmap_getscreenposTile: 	;D=Xpos E=Ypos (tiles)
	sta z_As	;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
	asl z_d			;Tiles2Pixels
	asl z_e
	dex
	bne mpbitmap_getscreenposShift
		
	lda #8
	sta z_b			;Linecount
		
mpbitmap_getscreenpos: 	;D=Xpos E=Ypos (pixels)
	lda z_d		
	sta z_iyl		;Backup Xpos
		
	stz z_hs		;4  color mode: Address=$2000 (Ypos *32*16) + X*16
	stz z_ls		;16 color mode: Address=$2000 (Ypos *32*32) + X*32
	lda z_d			;			    2 bytes per VRAM address
	lsr
	lsr 
	lsr 			;/8 = Xpos to tiles
	
	lsr 
	ror z_ls		;*128
	lsr 
	ror z_ls		;*64
	lsr 
	ror z_ls		;*32
	ifndef SNS_BMPscreen_UseBuffer
		lsr 
		ror z_ls		;*16
	endif
	ifdef SNS_BMPscreen_UseBuffer_4Color
		lsr 
		ror z_ls		;*16/*8
	endif 
	sta z_hs
	
	lda z_e			;Ypos
	lsr
	lsr
	lsr				;Ypos to tiles
	ifndef SNS_BMPscreen_UseBuffer_4Color
		asl			
	endif
	ifdef SNS_BMPscreen_UseBuffer
		asl
	endif
	clc
	adc z_hs
	adc #$20		;Tile 256+
	sta z_hs
	
	lda z_e			;Ypos within tile
	and #%00000111	;Line 0-7
	ifdef SNS_BMPscreen_UseBuffer
		asl 		;2 bytes per entry
	endif 			; (Direct VRAM is in pairs of bytes)
	clc
	adc z_ls
	sta z_ls
	rts

	
	
	ifndef SNS_BMPscreen_UseBuffer
mpbitmap_setbytesAlt:	;Offset VRAM Destination by A
	sta z_As
	pushpair z_hls
		lda z_As
		clc
		adc z_ls		;HLs=HLs+A
		sta z_ls
		bcc mpbitmap_setbytesAltb
		inc z_hs
mpbitmap_setbytesAltb:			
		jsr mpbitmap_setbytes
	pullpair z_hls
	rts
	
mpbitmap_setbytes: ;write z_bs/z_cs to VRAM 
		lda $4212 		;HVBJOY - Status
		;	xy00000a	- x=vblank state y=hblank state a=joypad ready
		and #%10000000
		beq mpbitmap_setbytes	;Wait until we get nonzero 
								; this means we're in VBLANK
		lda z_ls
		sta $2116		;VRAM MemL
		lda z_hs
		sta $2117		;VRAM MemH
		
		lda z_bs
		sta $2118		;Bitplanes 2/3 unused in 4 color mode
		
		lda z_cs	
		sta $2119		
		
		lda $4212 		;HVBJOY - Status
		;	xy00000a	- x=vblank state y=hblank state a=joypad ready
		and #%10000000
		beq mpbitmap_setbytes	;Did VRAM end while we were writing?
		rts
	endif 
	
	
mpbitmap_getpixelbytes:	;Get 4 bitplanes
	ifndef SNS_BMPscreen_UseBuffer
		lda $4212 		;HVBJOY - Status
		;	xy00000a		- x=vblank state y=hblank state a=joypad ready
		and #%10000000
		beq mpbitmap_getpixelbytes	;Wait until we get nonzero
									; this means we're in VBLANK
		lda z_ls
		sta $2116		;VRAM MemL
		lda z_hs
		sta $2117		;VRAM MemH
		
		lda $2139		;Bitplanes 2/3 unused in 4 color mode
		sta z_bs	
		lda $213A		
		sta z_cs
		
		lda z_ls
		clc
		adc #8
		sta $2116		;VRAM MemL
		lda z_hs
		sta $2117		;VRAM MemH
		
		lda $2139		;Bitplane 2
		sta z_ds
		lda $213A		;Bitplane 3
		sta z_es
		
		lda $4212 		;HVBJOY - Status
		and #%10000000
		beq mpbitmap_getpixelbytes	;Did VBLANK endwhile we were working?
	endif 

	ifdef SNS_BMPscreen_UseBuffer
		lda z_ls
		sta $2181		;WMADDL
		lda z_hs
		sta $2182		;WMADDM
		stz $2183		;WMADDH
	
		lda $2180		;Bitplane 0
		sta z_bs
		lda $2180		;Bitplane 1
		sta z_cs
			
		ifndef SNS_BMPscreen_UseBuffer_4Color
			ldx #7*2	;Skip 7 pairs
mpbitmap_setpixelSkip:	
			lda $2180
			dex 
			bne mpbitmap_setpixelSkip
			
			lda $2180	;Bitplane 2
			sta z_ds
			lda $2180	;Bitplane 3
			sta z_es
		else 
			stz z_ds
			stz z_es
		endif 
	endif 
	rts	
	
	
mpbitmap_setpixel:	;D=Xpos E=Ypos A=Color
	sta z_iyh		;Color number
	
	jsr mpbitmap_getscreenpos		;Get VRAM destination
	jsr mpbitmap_getpixelbytes		;Read in the bitplane lines
	
	ifdef SNS_BMPscreen_UseBuffer
		lda z_ls
		sta $2181	;WMADDL
		lda z_hs
		sta $2182	;WMADDM
		stz $2183	;WMADDH
	endif 
		
	lda #%01111111	;Background mask of pixels to keep
	sta z_c
		
	lda z_iyl
	and #%00000111	;Xpos 0-7
	beq mpbitmap_setpixel_shiftdone
	tay
mpbitmap_setpixel_shiftagain:
	sec
	ror z_c			;Shift mask
	dey
	bne mpbitmap_setpixel_shiftagain
mpbitmap_setpixel_shiftdone:

	lda z_c			;Background mask
	eor #255
	sta z_b			;Pixel Mask

	lda z_bs
	and z_c
	ror z_iyh		;Test Bitplane 0
	bcc mpbitmap_setpixel_B0
	ora z_b			;Set Bitplane 0
mpbitmap_setpixel_B0:	
	ifndef SNS_BMPscreen_UseBuffer
		sta z_bs	;Store for VRAM 
	else
		sta $2180	;Write to Buffer
	endif 

	lda z_cs
	and z_c
	ror z_iyh		;Test Bitplane 1
	bcc mpbitmap_setpixel_B1
	ora z_b			;Set Bitplane 1
mpbitmap_setpixel_B1:
	
	ifndef SNS_BMPscreen_UseBuffer
		sta z_cs	;Store for VRAM
		jsr mpbitmap_setbytes ;Send to VRAM
	else
		sta $2180	;Write to buffer
	endif 
	
	ifndef SNS_BMPscreen_UseBuffer	
		lda z_ls
		clc
		adc #8			;Jump to bitplanes 2/3
		sta z_ls
		
		lda z_ds
		and z_c			;Test Bitplane 2
		ror z_iyh
		bcc mpbitmap_setpixel_B2
		ora z_b			;Set Bitplane 2
mpbitmap_setpixel_B2:
		sta z_bs		;Store for VRAM

		lda z_es
		and z_c			;Test Bitplane 3
		ror z_iyh
		bcc mpbitmap_setpixel_B3
		ora z_b			;Set Bitplane 3
mpbitmap_setpixel_B3:
		sta z_cs				 ;Store for VRAM
		jsr mpbitmap_setbytes	 ;Send to VRAM
	else 	
		ifndef SNS_BMPscreen_UseBuffer_4Color
			lda z_ls
			clc
			adc #16		;Jump to bitplanes 2/3
			sta $2181	;WMADDL
			lda z_hs
			sta $2182	;WMADDM
			stz $2183	;WMADDH
			
			lda z_ds
			and z_c		;Test Bitplane 2
			ror z_iyh
			bcc mpbitmap_setpixel_B2
			ora z_b		;Set Bitplane 2
mpbitmap_setpixel_B2:
			sta $2180

			lda z_es
			and z_c		;Test Bitplane 3
			ror z_iyh
			bcc mpbitmap_setpixel_B3
			ora z_b		;Set Bitplane 3
mpbitmap_setpixel_B3:
			sta $2180
		endif
	endif 
	rts


mpbitmap_getpixel:	;D=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos		;Get VRAM destination
	jsr mpbitmap_getpixelbytes		;Read in the bitplane lines
			
	lda z_iyl
	and #%00000111	;Xpos 0-3
	eor #%00000111
	beq mpbitmap_getpixel_shiftdone
	tay
mpbitmap_getpixel_shiftagain:
	lsr z_bs		;Shift Bitplane 0
	lsr z_cs		;Shift Bitplane 1
	lsr z_ds		;Shift Bitplane 2
	lsr z_es		;Shift Bitplane 3

	dey
	bne mpbitmap_getpixel_shiftagain
mpbitmap_getpixel_shiftdone:	
	lsr z_es		;Bitplane 3 bit
	rol
	lsr z_ds		;Bitplane 2 bit
	rol
	lsr z_cs		;Bitplane 1 bit
	rol
	lsr z_bs		;Bitplane 0 bit
	rol
	rts
	
	
;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile

	ifdef SNS_BMPscreen_UseBuffer
		lda z_ls
		sta $2181	;WMADDL
		lda z_hs
		sta $2182	;WMADDM
		stz $2183	;WMADDH
	endif 
	
	ldx z_As		;Bitplane count
	ifndef SNS_BMPscreen_UseBuffer
		pushpair z_hls	;Bachup VRAM dest
	endif 
		
;Do Bitplanes 0/1
	ldy #0
mpbitmap_settile_RepeatB01:
	lda (z_hl),y	;Bitplane 0
	iny
	ifdef SNS_BMPscreen_UseBuffer
		sta $2180
	else 
		sta z_bs
	endif 
	
	ifdef mpbitmap_tiletints
		lda mpbitmap_tiletints
    else
		lda #0
	endif
	cpx #2
	bcc mpbitmap_settile_NoB1
	lda (z_hl),y	;Bitplane 1
	iny
mpbitmap_settile_NoB1:
	ifdef SNS_BMPscreen_UseBuffer
		sta $2180
	else 
		sta z_cs
		jsr mpbitmap_setbytes
		inc z_ls
	endif 
	
	cpx #3
	bcc mpbitmap_settile_NoB2
	iny
mpbitmap_settile_NoB2:	

	cpx #4
	bcc mpbitmap_settile_NoB3
	iny
mpbitmap_settile_NoB3:	

	dec z_b
	bne mpbitmap_settile_RepeatB01
		
	ifndef SNS_BMPscreen_UseBuffer
		pullpair z_hls
	endif 

	ifndef SNS_BMPscreen_UseBuffer_4Color
		
;Do Bitplanes 2/3
		ldy #0
		lda #8
		sta z_b		;Linecount
			
mpbitmap_settile_RepeatB23:	
	ifndef SNS_BMPscreen_UseBuffer
		
		pushpair z_hls
	endif 

		iny			;Skip Bitplane 0
		cpx #2
		bcc mpbitmap_settile_NoB1b
		iny			;Skip Bitplane 1
mpbitmap_settile_NoB1b:
		
		ifdef mpbitmap_tiletints
			lda mpbitmap_tiletints+1
		else
			lda #0
		endif
		cpx #3
		bcc mpbitmap_settile_NoB2b
		lda (z_hl),y	;Bitplane 2
		iny
mpbitmap_settile_NoB2b:
		ifdef SNS_BMPscreen_UseBuffer
			sta $2180	;Write to Buffer
		else 
			sta z_bs	;Save for VRAM
		endif 
		
		ifdef mpbitmap_tiletints
			lda mpbitmap_tiletints+2
		else
			lda #0
		endif
		cpx #3
		bcc mpbitmap_settile_NoB3b
		lda (z_hl),y	;Bitplane 3
		iny
mpbitmap_settile_NoB3b:
		ifdef SNS_BMPscreen_UseBuffer
			sta $2180	;Write to Buffer
		else 
			sta z_cs	;Save for VRAM
			
			lda #8		;Save to offset 8 (Bitplane 2/3)
			jsr mpbitmap_setbytesAlt ;Send to VRAM
			inc z_ls
		endif 	
	
		ifndef SNS_BMPscreen_UseBuffer
			pullpair z_hls
			jsr IncHLs	;Move to next VRAM line
		endif 
		dec z_b
		bne mpbitmap_settile_RepeatB23
	endif 
		
mpbitmap_settile_Cleanup:		;Update HL for read data
	tya				;HL=HL+Y
	clc
	adc z_l
	sta z_l
	bcc mpbitmap_settile_Done
	inc z_h
mpbitmap_settile_Done:	
	rts

	
	
;HL = Destination Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile	;Get VRAM source
		
	ldy #0
mpbitmap_gettileAgain:
	jsr mpbitmap_getpixelbytes		;Get a line of screen data
	ldx z_As		;X=Bitplane count
	
	lda z_bs
	sta (z_hl),y	;Bitplane 0
	iny
	
	dex
	beq	mpbitmap_gettile_Done
	lda z_cs
	sta (z_hl),y	;Bitplane 1
	iny
			
	dex
	beq mpbitmap_gettile_Done
	lda z_ds
	sta (z_hl),y	;Bitplane 2
	iny

	dex 
	beq mpbitmap_gettile_Done
	lda z_es
	sta (z_hl),y	;Bitplane 3
	iny
	
mpbitmap_gettile_Done:	
	ifdef SNS_BMPscreen_UseBuffer
		inc z_ls		;Next Source Bitplanes
	endif 	
	inc z_ls		;Next Source Bitplanes
	
	dec z_b
	bne mpbitmap_gettileAgain	;Next Line
	
	jmp mpbitmap_settile_Cleanup ;Update HL for written data

	