
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


DrawTile:	
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		bne DrawTileAdvanced
	endif
	asl
	sta (z_bcs),y	;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
	
DrawTileBasicOnly:
	and #%11110000	;%nnnn---
	sta z_ls
	lda (z_bcs),y	;%NNNNNNNN
	
	lsr 
	ror z_ls		;*8
	lsr 
	ror z_ls		;*4
	lsr 
	ror z_ls		;*2
	lsr 
	ror z_ls		;*1
	sta z_hs
	
DrawTileBasic:	
	dey	;ldy #0
	
	lda z_ls
	clc
	adc z_es		 ;DEs = Tile pattern base address 
	sta (z_hl),y	 ;%TTTTTTTT
	iny

	lda z_hs
	adc z_ds		;%VHLPPPTT T=tile number V=vflip H=hflip 
	sta (z_hl),y 	;L=layer (in front of sprites) P=palette 
	
	dey ;ldy #0
	
	jmp TileDoneBCs_Plus2



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


DrawTileAdvanced:			;YX flip
	and #%00000110
	beq DrawTileCustom
		
NotDrawTileCustom:			;X/Y/XY Flip
	lda (z_bcs),y
	and #%11111110			;Clear Update Flag
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnly
	endif

	and #%11110000	;nnnn---
	sta z_ls
	lda (z_bcs),y	;%NNNNNNNN
	lsr 
	ror z_ls		;*8
	lsr 
	ror z_ls		;*4
	lsr 
	ror z_ls		;*2
	lsr 
	ror z_ls		;*1
	sta z_hs
	
	dey	;ldy #0
		
	lda (z_bcs),y
	bit LookupBits+2
	bne DrawTileYFlip

	lda #%01000000		;X flip Attribute
DrawTileFlip:
	sta z_B
	
	lda z_ls
	clc
	adc z_es
	sta (z_hl),y	 ;%TTTTTTTT
	iny

	lda z_hs
	adc z_ds		
		;%VHLPPPTT T=tile number V=vflip H=hflip 
	ora z_B
	sta (z_hl),y 	;L=layer (in front of sprites) P=palette 
	
	dey ;ldy #0
	
	jmp TileDoneBCs_Plus2

	
DrawTileYflip:
	bit LookupBits+3
	bne DrawTileXYFlip
	
	lda #%10000000		;Y flip Attribute
	bne DrawTileFlip	;Always NE
	
DrawTileXYflip:
	lda #%11000000		;XY flip Attribute
	bne DrawTileFlip	;Always NE
			
	
	
	
DrawTileEmpty:
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTransp
	dey
	jmp TileDoneBCs_Plus2
	
DrawTileTransp:;;;;;;;;;;;;;;;;;;Transparent
	sta z_ls
	jmp DrawTileBasic
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustom:
		lda (z_bcs),y 			;NN------
		and #%11111110			;Clear update flag
		sta (z_bcs),y 
		rol
		rol				
		rol
		and #%00000011			;------NN
		sta z_hs
		
		lda (z_bcs),y 
		and #%00110000	;Cmd Bits
		beq DrawTileFill		;--00----
NotDrawTileFill:
		cmp #%00110000			;--11----
		beq DrawTileEmpty
			
	
DrawTileDouble:	
	iny 
	lda (z_bcs),y	;%nnnnnnnn
	sta z_ls
	dey ;ldy #0

	lda z_ls
	clc
	adc #<OffsetToDoubled
	sta z_ls
	lda z_hs
	adc #>OffsetToDoubled
	sta z_hs
			
	lda z_ls
	clc
	adc z_es
	sta (z_hl),y	 ;%TTTTTTTT
	iny

	lda z_hs
	adc z_ds		
		;%VHLPPPTT T=tile number V=vflip H=hflip 
	sta (z_hl),y 	;L=layer (in front of sprites) P=palette 
	
	dey ;ldy #0
	jmp TileDoneBCs_Plus2
	
	
DrawTileFill:
	iny
	
	lda (z_bcs),y	;%nnnnnnnn
	dey
	clc
	adc #<FillData
	sta (z_hl),y	;%TTTTTTTT
	iny
	lda z_hs		
	adc #>FillData
		;%VHLPPPTT T=tile number V=vflip H=hflip 
	sta (z_hl),y 	;L=layer (in front of sprites) P=palette 
	dey
	jmp TileDoneBCs_Plus2


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
GetScreenPos:
	lda z_b
	and #%11111100			;4 Logical Units per Tile
	lsr 					;2 Bytes per tile
	sta z_b					;Xpos in bytes
	
	lda z_c					;Ypos in logical units
	lsr
	lsr						;Ypos in tiles
	clc
	adc #2					;Skip top 2 lines
	sta z_h					;32 tiles per Y line
							; 2 bytes per tile
	lda #0		
	lsr z_h			;128
	ror 
	lsr z_h			;64
	ror 
	
	adc z_b 				;Add X line
	sta z_l
	
	lda #>SnesScreenBuffer	;Add screen buffer base
	adc z_h
	sta z_h
	rts
		
		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	;BC=Bytes
	;DE=Destination Ram
	;HL=Source Bytes	
	
DefineTiles:
	lda #128
	sta $2115			;Inc address on write to $2119
	
	jsr prepareVram	;Get VRAM address
	
	ldx z_C			;B=High byte of count - X=Low byte
	ldy #0
DefineTilesAgain	
	jsr WaitVblank
	lda (z_HL),Y	
	sta $2118		;VMDATAH - Write first byte to VRAM
	iny	
	
	jsr WaitVblank	
	lda (z_HL),Y	
	sta $2119		;VMDATAL - write set to Autoinc address 
	
	ifdef FourColorPatterns
		tya
		and #%00001111			;Have we sent 16 bytes?
		cmp #%00001111			;(Bitplane 0/1 complete?)
		bne NotEmptyPlanes
		phx
			ldx #8				;8 empty lines for Bitplanes 2/3
ZeroEmptyPlanes:				;on 4 color systems
			jsr WaitVblank	
			lda z_ixh
			sta $2118
			lda z_ixl
			sta $2119
			dex
			bne ZeroEmptyPlanes
		plx
NotEmptyPlanes:	
	endif

	iny
	bne DefineTilesAgainYok	
	
	inc z_h			;INC High byte Y=low byte
DefineTilesAgainYok:		
	txa				;Is Low Byte Zero
	bne DefineTilesDecBC_C
	lda z_B			;Are We done
	beq DefineTilesAgainDone
	DEC z_B			;DEC high byte (X is low byte)
DefineTilesDecBC_C:	
	DEx				;Subtract 2 
	DEX				;Since we did 2 bytes
	jmp DefineTilesAgain
DefineTilesAgainDone:
	rts
	
	

DefineFills:
	jsr prepareVram		;Get VRAM address
	
	ldy #0
DefineFillsAgain:	
	
	ldx #8			;Send 8 lines
DefineFills8b:
	jsr WaitVblank
	lda (z_HL),Y	
	sta $2118		;VMDATAH - Write first byte to VRAM
	iny	
	
	jsr WaitVblank	
	lda (z_HL),Y	
	sta $2119		;VMDATAL - write set to Autoinc address 
	dey
	dex 
	bne DefineFills8b	;Repeat for 8 lines
	
	jsr DecBC		;Sent 2 bytes
	jsr DecBC
	
	iny				;Next bitplane pair
	iny
	
	lda z_b			;Repeat for all bytes
	ora z_c
	bne DefineFillsAgain
	rts
	
	
	
DefineDoubleTiles:
	jsr prepareVram	;Get VRAM address
		
DefineTilesAgainD:
	ldy #0
	jsr DefineTiles4Lines
	
	ldy #8
	jsr DefineTiles4Lines
	
	lda z_l
	clc
	ifdef FourColorPatterns
		adc #16
	else
		adc #32
	endif
	sta z_l
	bcc DefineTilesAgainNoHD
	inc z_h
DefineTilesAgainNoHD
		
	lda z_b
	ora z_c
	bne DefineTilesAgainD
	rts	
	
DefineTiles4Lines:
	jsr DefineTiles4LinesAgain
	
	ifdef FourColorPatterns
		ldx #8
ZeroEmptyPlanesB:
		jsr WaitVblank	
		lda z_ixh
		sta $2118
		lda z_ixl
		sta $2119
		dex
		bne ZeroEmptyPlanesB
		rts
	else
		tya
		clc
		adc #8			;Move to matching 2nd half
		tay
	endif
	
DefineTiles4LinesAgain:	
	ldx #4
DefineTiles4LinesB:	
	jsr WaitVblank
	lda (z_HL),Y	
	sta $2118		;VMDATAH - Write first byte to VRAM
	iny	
	
	jsr WaitVblank	
	lda (z_HL),Y	
	sta $2119		;VMDATAL - write set to Autoinc address 
	dey
	
	jsr WaitVblank
	lda (z_HL),Y	
	sta $2118		;VMDATAH - Write first byte to VRAM
	iny	
	
	jsr WaitVblank	
	lda (z_HL),Y	
	sta $2119		;VMDATAL - write set to Autoinc address 
	iny
	
	jsr DecBC
	jsr DecBC
	
	dex
	bne DefineTiles4LinesB
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
