
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


DrawTile:	

	pha
		lda z_l		;Select the VRAM destination
		sta $2181	;WMADDL
		lda z_h
		sta $2182	;WMADDM
		stz $2183	;WMADDH
	pla
	

	
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		bne DrawTileAdvanced
	endif
	asl
	sta (z_bcs),y	;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
	
DrawTileBasicOnly:
	and #%11110000	;%nnnn---
	sta z_ls
	
	
	lda (z_bcs),y	;%NNNNNNNN
DrawTileBasic:	
	sta z_hs
	
	clc
	lda z_ls
	adc z_es		 ;DEs = Tile pattern base address 
	sta z_ls

	lda z_hs
	adc z_ds		
	sta z_hs
	
	dey	;ldy #0
	
DrawTileBasicAgainY:		
	lda (z_hls),y
	iny
	sta $2180 		;Bitplane 0
	lda (z_hls),y
	iny
	sta $2180		;Bitplane 0
	
	cpy #16
	bne DrawTileBasicAgainY
		
	ldy #0
	jmp TileDoneBCs_Plus2



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


DrawTileAdvanced:			;YX flip
	and #%00000110		;YX flip
	bne NotDrawTileCustom
		jmp DrawTileCustom
		
NotDrawTileCustom:		;X/Y/XY Flip
	lda (z_bcs),y
	and #%11111110		;Clear Update Flag
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnly
	endif

	and #%11110000		;%nnnn---
	sta z_ls

	lda (z_bcs),y		;%NNNNNNNN
	sta z_hs
	
	lda z_ls
	clc
	adc z_es			;DEs = Tile pattern base address 
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	
	dey		
	lda (z_bcs),y
	
	bit LookupBits+2	;%----XYPU
	beq NotDrawTileYFlip
		jmp DrawTileYFlip
NotDrawTileYFlip:		;XFLIP

	lda #>FlipLUT
	sta z_b				;BC= Xflip LUT
		
	ldy #0
DrawTileXAgain:	
	lda (z_hls),y
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta $2180 
	iny
	
	lda (z_hls),y
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta $2180
	
	iny
	cpy #16
	bne DrawTileXAgain
		
	ldy #0
	jmp TileDoneBCs_Plus2

	
DrawTileYflip:
	bit LookupBits+3
	bne DrawTileXYFlip
			
	ldy #14				;Last line bitplane 0
DrawTileYflipagain:		
	lda (z_hls),y		
	sta $2180 			;Store Bitplane 0
	
	iny					;move to bitplane 1
	lda (z_hls),y
	sta $2180			;Store Bitplane 1
	
	dey					;Back to bitplane 0
	dey
	dey					;Back 2 lines
	
	cpy #254			;Done all 16 bytes?
	bne DrawTileYflipagain
	
	ldy #0
	jmp TileDoneBCs_Plus2
	
	
	
DrawTileXYflip:
	lda #>FlipLUT
	sta z_b				;BC= Xflip LUT
				
	ldy #14				;Last line bitplane 0
DrawTileXYflipagain:		
	lda (z_hls),y		
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta $2180 			;Store Bitplane 0
	
	iny					;move to bitplane 1
	lda (z_hls),y
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta $2180			;Store Bitplane 1
		
	dey					;Back to bitplane 0
	dey
	dey					;Back 2 lines
	
	cpy #254			;Done all 16 bytes?
	bne DrawTileXYflipagain
		
	ldy #0
	jmp TileDoneBCs_Plus2
			
	
	
	
DrawTileEmpty:
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTransp
	dey
	jmp TileDoneBCs_Plus2
	
DrawTileTransp:;;;;;;;;;;;;;;;;;;Transparent
	asl 
	rol z_hs
	asl 
	rol z_hs
	asl 
	rol z_hs			;8 Bytes per pattern
	asl 
	rol z_hs			;16 Bytes per pattern
	
	clc
	adc z_es			;DEs = Tile pattern base address 
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	
	
	tsx
	stx z_as			;Stack pointer 
	
	ldy #16
DrawTileTransp_GetCurrent:
	lda $2180
	pha				;Get current data into stack from VRAM
	dey
	bne DrawTileTransp_GetCurrent

;Reselect the VRAM destination
	lda z_l
	sta $2181	;WMADDL
	lda z_h
	sta $2182	;WMADDM
	stz $2183	;WMADDH
		
	ldx z_as		;Get start of cached data
		
DrawTileTranspAgainY:		
	lda (z_hls),y
	iny
	ora (z_hls),y
	dey
	eor #255		;Get mask for bits to change
	sta z_b
	
		
	lda $100,x		;Get current vram data from stack
	and z_b			;Mask existing data
	ora (z_hls),y	;Or in new data
	sta $2180 		;Store to the screen
	dex
	iny
		
	lda $100,x		;Get current vram data from stack
	and z_b			;Mask existing data
	ora (z_hls),y	;Or in new data
	sta $2180		;Store to the screen
	dex
	iny
		
	cpy #16
	bne DrawTileTranspAgainY
	
	ldx z_as
	txs				;Restore old stack pointer
	
	ldy #0
	ldx #0
	jmp TileDoneBCs_Plus2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustom:
		lda (z_bcs),y 			;NN------
		and #%11111110			;Clear update flag
		sta (z_bcs),y 
		rol
		rol				
		rol
		and #%00000011			;------NN
		sta z_hs
		
		lda (z_bcs),y 
		and #%00110000	;Cmd Bits
		beq DrawTileFill		;--00----
NotDrawTileFill:
		cmp #%00110000			;--11----
		bne DrawTileDouble
		jmp DrawTileEmpty	
	
DrawTileDouble:	
		iny 
		lda (z_bcs),y		;%NNNNNNNN
		asl 
		rol z_hs
		asl 
		rol z_hs		;*4
		asl 
		rol z_hs		;*8

		clc
		adc z_es		;Add Pattern base DE
		sta z_ls
		
		lda z_hs
		adc z_ds
		sta z_hs

	
	ldy #0
DrawTileDoubleAgainY:		
	lda (z_hls),y	
	sta $2180 			;Bitplane 0 - 1st time
	iny
	
	lda (z_hls),y		;Bitplane 1 - 1st time
	sta $2180
	dey
	
	lda (z_hls),y		;Bitplane 0 - 2nd time
	sta $2180
	iny
	
	lda (z_hls),y		;Bitplane 1 - 2nd time
	sta $2180
	iny
	
	cpy #8				;Done 8 source bytes?
	bne DrawTileDoubleAgainY
	
	ldy #0
	jmp TileDoneBCs_Plus2

	
DrawTileFill:
	iny
	lda (z_bcs),y
	asl					;2 bytes * 2lines per fill
	asl
	
	adc z_es			;Add Pattern base
	sta z_ls

	lda z_hs
	adc z_ds
	sta z_hs

	dey		;ldy #0
	
	ldx #4				;4 pairs of lines
DrawTileFillAgainY:		
	lda (z_hls),y		;Bitplane 0 - 1st line
	sta $2180
	iny
	
	lda (z_hls),y		;Bitplane 1 - 1st line
	sta $2180
	iny
	
	lda (z_hls),y		;Bitplane 0 - 2st line
	sta $2180
	iny
	
	lda (z_hls),y		;Bitplane 1 - 2nd line
	sta $2180
	
	dey					;Back to bitplane 0 1st line
	dey
	dey
	
	
	dex
	bne DrawTileFillAgainY

	;ldy #0
	jmp TileDoneBCs_Plus2


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
GetScreenPos:
	lda z_c					;Ypos in logical units
	and #%11111100			;4 Logical Units per Tile
	lsr						;Ypos *512
	sta z_c
		
	stz z_h
	
	lda z_b
	and #%11111100			;X Logical Units per Tile
	asl
	rol z_h
	asl
	rol z_h					;Ypos in tiles *16
	
	sta z_l
	
	lda z_h
	clc 
	adc z_c
	adc #$20				;Bitmap buffer from $2000
	sta z_h
	rts
		
		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	