
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


;HspriteNum

DrawTileH:	
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		bne DrawTileAdvancedH
NotDrawTileAdvancedH
	endif
	asl
	sta (z_bcs),y		;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
	
DrawTileBasicOnlyH:
	and #%11110000		;%nnnn----
	clc
	sta z_ls
		 ;YXPPCCCT		Y=yflip X=xflip P=priority compared to BG 
	lda #%00110000		;(C=palette +128) T= Tile Pattern number 
	sta z_as
	
	lda (z_bcs),y		;%NNNNNNNN
DrawTileBasicH:	
	
	lsr 
	ror z_ls		;*8
	lsr 
	ror z_ls		;*4
	lsr 
	ror z_ls		;*2
	lsr 
	ror z_ls		;*1
	sta z_hs
	
DrawTileBasicH2:
	clc
	lda z_ls 
	adc z_es					;Add Tile Base DEs
	sta z_ls
	lda z_hs
	adc z_ds
		
DrawTileBasicHunflip:		
	ora z_as					;Set Flip attributes+Palette
	sta z_hs					;YXPPCCCT

	lda HspriteNum
	cmp #128					;We only have 128 hardware sprites
	beq MaxTile_NoSpritesLeft
	
	pushpair z_hl
		jsr SetHardwareSprite	;Write sprite data into cache
								;LB=X  C=Y  IYL=pattern A=HSpriteNum 
	pullpair z_hl
MaxTile_NoSpritesLeft:
	ldy #0
	jmp TileDoneBCs_Plus2H

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileAdvancedH:	
	and #%00000110			;-----XY-
	beq DrawTileCustomH
NotDrawTileCustomH:
	lda (z_bcs),y
	and #%11111110
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnlyH
	endif

	and #%11110000	;nnnn----
	sta z_ls

	lda (z_bcs),y
	sta z_hs
	dey		
	lda (z_bcs),y
	bit LookupBits+2
	bne DrawTileYFlipH
	
;DrawTileXflip
		 ;YXPPCCCT		Y=yflip X=xflip P=priority C=palette T=Tile
	lda #%01110000
DrawTileFlipped:
	sta z_as
	lda z_hs
	jmp DrawTileBasicH

DrawTileYflipH:
	bit LookupBits+3
	bne DrawTileXYFlipH

;DrawTileYflip	
		 ;YXPPCCCT		Y=yflip X=xflip P=priority C=palette T=Tile
	lda #%10110000
	bne DrawTileFlipped	;Always NE

DrawTileXYflipH:
		 ;YXPPCCCT		Y=yflip X=xflip P=priority C=palette T=Tile
	lda #%11110000
	bne DrawTileFlipped	;Always NE
			
	
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustomH:
	lda (z_bcs),y ; ld a,(bc)	;BB------
	and #%11111110			;Clear Update flag
	sta (z_bcs),y ; ld (bc),a
	rol
	rol	; rlca*2
	rol
	and #%00000011
	sta z_hs
	
	lda (z_bcs),y ; ld a,(bc)
	and #%00110000	;Cmd Bits
	beq DrawTileFillH		;--00---- fill
NotDrawTileFillH:
	cmp #%00110000			;--11---- transp
	bne DrawTileDoubleH	
							
			
;DrawTileEmptyH
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTranspH
	dey
	jmp TileDoneBCs_Plus2H
	
DrawTileTranspH:;;;;;;;;;;;;;;;;;;Transparent
	sta z_ls
		 ;YXPPCCCT		Y=yflip X=xflip P=priority C=palette T=Tile
	lda #%00110000		
	sta z_as
	jmp DrawTileBasicH2
	
	
DrawTileDoubleH:	
	iny 
	lda (z_bcs),y
	sta z_ls	
	dey ;ldy #0

	lda z_ls
	clc
	adc #<OffsetToDoubled	;Double Patterns
	sta z_ls
	lda z_hs
	adc #>OffsetToDoubled
	sta z_hs
	
		 ;YXPPCCCT		Y=yflip X=xflip P=priority C=palette T=Tile
	lda #%00110000
	sta z_as
	jmp DrawTileBasicH2
		
		
DrawTileFillH:
	iny
	lda (z_bcs),y
	dey ;ldy #0
	clc
	adc #<FillData		;Fill patterns
	sta z_ls 
	iny
	lda z_hs		
	adc #>FillData
	sta z_hs		
		 ;YXPPCCCT		Y=yflip X=xflip P=priority C=palette T=Tile
	lda #%00110000
	jmp DrawTileBasicHunflip


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ClearUnusedHsprites:
	ldx HspriteNum				;Last Sprite used
ClearUnsusedSpritesB:		
	cpx #128
	bne ClearUnsusedSpritesB2
	stz HspriteNum
	rts
ClearUnsusedSpritesB2:			
	phx
		txa
		clc
		adc #<(SnesSpriteBuffer/4)
		sta z_e			;Address L
		
		lda #>(SnesSpriteBuffer/4)
		sta z_d			;Address H
		
		asl z_e
		rol z_d
		asl z_e
		rol z_d			;4 bytes per entry
		
		lda #0
		tay
		sta (z_de),y 	;X
		iny
		sta (z_de),y  	;Y
		iny
		sta (z_de),y 	;Tile
		iny
		sta (z_de),y  	;Attribs
	plx
	inx 
	jmp ClearUnsusedSpritesB
	
	
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


GetScreenPosH:	;Move to a memory address in VDP by BC cursor pos
	lda z_c
	sta z_l		;Transfer XY pos into z_HL (to maintain compatibility)
	
	lda z_b
	sta z_h
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Address Byte 1		Byte 2 		Meaning 													SprNum
;$0000	XXXXXXXX	YYYYYYYY	X=Xpos (bits 0-7) Y=Ypos									0
;$0001	YXPPPCCCT	TTTTTTTT	Y=yflip X=xflip P=priority compared to BG (C=palette +128)	0
;$0002	XXXXXXXX	YYYYYYYY	X=Xpos (bits 0-7) Y=Ypos									1
;$0003	YXPPPCCCT	TTTTTTTT	Y=yflip X=xflip P=priority compared to BG (C=palette +128)	1
;…	…	…	…	…
;…	…	…	…	…
;$00FE	XXXXXXXX	YYYYYYYY	X=Xpos (bits 0-7) Y=Ypos									127
;$00FF	YXPPCCCT	TTTTTTTT	Y=yflip X=xflip P=priority compared to BG (C=palette +128)  127
;								T= Tile Pattern number 	
;$0100	SXSXSXSX	(no 2nd)	S=doubleSize sprite X=Xpos (bit 8)							0-3
;$0101	SXSXSXSX	(no 2nd)	S=doubleSize sprite X=Xpos (bit 8)							4-6
;…	…	
;…	…
;$011F	SXSXSXSX	(no 2nd)	S=doubleSize sprite X=Xpos (bit 8)							124-127

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
SetHardwareSprite:			;Write sprite data into cache
	lda HspriteNum
							;H=X  L=Y  HLs=pattern (HLs not preserved)
;1st part
	clc
	adc #<(SnesSpriteBuffer/4)
	sta z_e			;Address L
	
	lda #>(SnesSpriteBuffer/4)
	sta z_d			;Address H
	
	asl z_e
	rol z_d
	asl z_e
	rol z_d			;4 bytes per entry

	ldy #0
	lda z_h
	asl
	sta (z_de),y 	;X			XXXXXXXX
	iny
	
	lda z_l
	clc
	adc #8
	asl
	sta (z_de),y  	;Y			YYYYYYYY
	iny
	lda z_ls
	sta (z_de),y 	;Tile		TTTTTTTT
	iny
	
	lda z_hs
	sta (z_de),y  	;Attribs	YXPPCCCT
	
;2nd part (X bit 9 + DoubleSize bit S)
	lda z_h
	rol
	rol
	and #%00000001		;Top bit of xpos
	pha
		lda HspriteNum
		tay
		and #%11111100
		lsr					;1 byte per 4 sprites
		lsr
		sta z_e				;Address L
		
		lda #(>SnesSpriteBuffer+2)			
		sta z_d				;Address H
		ldx #0
		lda (z_de,x)
		sta z_ls			;Get current attr2
		 
		tya
		and #%00000011		;4 sprites per byte of attr2
		tax
		 
		lda #%11111100		;Prep the mask
		sta z_hs
	pla					;Top X byte
	and #%00000011		;2 bits of new sprite settings setting
	 
	cpx #0				;Shift bits ------sx into correct position
	beq SpriteSkipShift
SpriteShiftAgain:
	asl
	asl					;Shift new val
	sec
	rol z_hs
	sec
	rol z_hs			;Shift mask
	dex
	bne SpriteShiftAgain
SpriteSkipShift: 
	pha
		lda z_ls		;Get back current value
		and z_hs		;Apply mask
		sta z_ls		;Get back current value
	pla
	ora z_ls
	ldx #0
	sta (z_de,x)		;Extra	SXSXSXSX
	
	inc HspriteNum		;Move to next hardware sprite
	rts	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;