	

z_Regs 		equ $60			;Fake Registers

Cursor_L 	equ $40			;Used for Printchar
Cursor_H 	equ Cursor_L+1

RPage equ $2000				;Ram is at $2000
HPage equ $0000				;Hardware regs at $0000

UserRam equ $2200

SPpage equ $2100
ZPpage equ $0000

	
	ifdef PCErelocateStart


		org $4000		;bank $0	
		setdp $2000			;Define the direct page as #$2000
PCE_Start:
		sei				;Disable interrupts
		csh				;Highspeed Mode
		cld				;Clear Decimal mode
		
		
		
		
		
			;      T12 - TIQ, IRQ1, IRQ2
		lda #%00000111
		sta $1402		;IRQ mask... 1=Off
		
		lda #$f8		;map in RAM
		tam #%00000010	;TAM1 (2000-3FFF)

		lda #$ff		;map in I/O (#$ff)
		tam #%00000001	;TAM0 (0000-1FFF)
		tax				
		txs				;Init stack pointer
			
		;Page in the banks of our cartridge
		lda #$00		;map in ROM
		tam #%00000100	;TAM1 (4000-5FFF)
		lda #$01		;map in ROM
		tam #%00001000	;TAM1 (6000-7FFF)
		lda #$02		;map in ROM
		tam #%00010000	;TAM1 (8000-9FFF)
		lda #$03		;map in ROM
		tam #%00100000	;TAM1 (A000-BFFF)
		lda #$04		;map in ROM
		tam #%01000000	;TAM1 (C000-DFFF)
		
		
		jmp PCERestart		;Jump to $4000
PCERestart:		
		;Page in last bank (We were running here before)
		lda #$05		;map in ROM
		tam #%10000000	;TAM1 (E000-FFFF)	
		

	else

		org $e000		;bank $0
		setdp $2000				;Define the direct page as #$2000
PCE_Start:
		sei				;Disable interrupts
		csh				;Highspeed Mode
		cld				;Clear Decimal mode
		
		lda #$ff		;map in I/O
		tam #%00000001	;TAM0 (0000-1FFF)
		
		lda #$f8		;map in RAM
		tam #%00000010	;TAM1 (2000-3FFF)

		ldx #$ff		;Init stack pointer
		txs
		
		lda #$07
		sta HPage+$1402	;IRQ mask, INTS OFF

	endif 
		
		
	