

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	

NativeSpr_DrawArrayReiKou:			
	jsr AddressRemapViaTableHL
	
NativeSpr_DrawArray:	;Draw Sprite Array (HL)
	ldx #0				;X=Zero throughout
	stx HspriteCount
			
	lda (z_hl,x)
	beq NativeSpr_ClearUnusedb ;We're done, so check any remaining
	jsr IncHL
	
NativeSpr_DrawArrayB:	
	pha					 
		ldy #0
		lda (z_hl),y	;Xpos (Pairs of pixels)
		sta z_c
		iny
		lda (z_hl),y	;Ypos (Pairs of pixels)
		sta z_b	
		iny
		lda (z_hl),y	;SpriteDef-L
		sta z_ls
		iny
		lda (z_hl),y	;SpriteDef-H
		sta z_hs
		iny
		tya
		clc
		adc z_l
		pha				;Backup HL+Y
		lda z_h
		adc #0
		pha		
			lda z_hs
			sta z_h
			lda z_ls
			sta z_l
			
			jsr NativeSpr_DrawExtra	;HL=sprite data  BC=XY pos
		pla
		sta z_h
		pla 			;Restore HL
		sta z_l
	pla
	sec
	sbc #1
	bne NativeSpr_DrawArrayB	;Repeat for next object
NativeSpr_ClearUnusedb:
	jmp NativeSpr_ClearUnused 
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
NativeSpr_InitReiKou:
	jsr AddressRemapViaTableHL	;Address space Remap option for ChibiVM

;HL= Sprite Pattern data
;BC= Bytecount  (32 byte per pattern)

NativeSpr_Init:
	lda #64
	sta HspriteLimit

;Turn on Sprites
	st0 #5				;RegSelect 5
		 ;BSXXIIII	Backgroundon Spriteon eXtendedsync Interruptenable
	st1 #%11000000		;Background ON, Sprites On
	st2 #0

;Define Sprite Patterns	
	st0 #0				;Select Memory Write Reg
	lda #<PCE_SpritePatternVram	
	sta $0102 			;st1 - L address ($2000)
	lda #>PCE_SpritePatternVram
	sta $0103 			;st2 - H Address ($2000)
	st0 #2				;Select Data reg
	
;BC=Bytes to transfer ... 	128 bytes per 16x16 @ 16 color sprite
	ldx z_C			;B=High byte of count - X=Low byte 
			
	ldy #0	
DefineTilesAgain:
	lda (z_HL),Y		;Load a byte
	sta $0102			;Store Low byte
	iny
	lda (z_HL),Y		;Load a byte
	sta $0103			;Store High Byte
	iny
	bne DefineTilesAgainYok
	inc z_h				;INC High byte Y=low byte
DefineTilesAgainYok:		
	txa					;Is Low Byte Zero?
	bne DefineTilesDecBC_C
	lda z_B				;Are We done
	beq DefineTilesAgainDone
	DEC z_B				;DEC high byte (X is low byte)
DefineTilesDecBC_C:	
	DEx					;Subtract 2 
	DEX					;Since we did 2 bytes
	jmp DefineTilesAgain
DefineTilesAgainDone:
	
;Define Sprite Palettes
	ldy #0	;X=0
	loadpair z_hl,Palette
	stz $0402			;Palette address L ($0100 = Palette 256)
	lda #$1
	sta $0403			;Palette address H
PaletteAgain2:
	lda (z_hl),y
	sta $0404			;GGRRRBBB
	iny
	lda (z_hl),y
	sta $0405			;-------G
	iny
	inx
	cpx #16
	bne PaletteAgain2
		
	;jmp NativeSpr_ClearUnused		;Hide all sprites

	
NativeSpr_HideAll_Reikou:
	stz HspriteCount		;Zero sprites used
	
NativeSpr_ClearUnused:
	ldy HspriteCount		
NativeSpr_ClearUnusedAgain:
	cpy #64					;Clear upto Hsprite 64
	beq NativeSpr_ClearUnusedDone
	phy
		tya
		jsr NativeSpr_Hide
	ply
	iny
	jmp NativeSpr_ClearUnusedAgain
	
NativeSpr_ClearUnusedDone:
	stz HspriteCount
	rts
		
NativeSpr_Hide:
	asl						;4 bytes per sprite
	asl
	st0 #0	  ;sta $0100	;Select Write Address ($00)
	sta $0102 ;st1 			;Low Byte of address  (Sprite x 4)
	st2 #$7F  ;sta $0103	;High Byte of address ($7Fxx)
	
	st0 #2	  ;sta $0100	;Data Write ($02)

	ldx #4
NativeSpr_HideAgain:		
	stz $0102 ;st1 
	stz $0103 ;st2
	dex
	bne NativeSpr_HideAgain
	rts
	
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
NativeSpr_DrawExtra:
	lda HspriteCount		;Sprnum
	jsr NativeSpr_Draw
	sta HspriteCount		;Sprnum
	rts
	
NativeSpr_DrawNoSprite:
	pla
	rts
NativeSpr_Draw:	;BC=XY in pairs of pixels	A=hspriteNum	HL=Object Def
	pha		 		
		ldx #0
		ldy #0
		lda (z_hl),y
		sta z_d			;W
		beq NativeSpr_DrawNoSprite
		iny ;jsr IncHL
		
		lda (z_hl),y
		sta z_e			;H
		iny ;jsr IncHL
	
		lda (z_hl),y
		sta z_ixl		;AttribL
		iny ;jsr IncHL
		
		lda (z_hl),y
		sta z_ixh		;AttribH
		iny ;jsr IncHL
		
		lda #8			;16 pixels in logical units
		sta z_ds		;Wid
		sta z_es		;Hei
		
;Scale Sprite by shared Attrib 16/32 wid ... 16/32/64 hei
		lda z_ixh
		and #%00000001
		beq NativeSpr_XScaledone
		asl z_ds		;32 px
NativeSpr_XScaledone:
	
		lda z_ixh
		and #%00110000
		beq NativeSpr_YScaledone
NativeSpr_Yagain:
		asl z_es		;32/64 px
		sec
		sbc #%00010000
		bne NativeSpr_Yagain
NativeSpr_YScaledone:	

;Draw the patterns for this object as hsprites
		
NativeSpr_DrawY:
		lda z_d
		sta z_cs		;Width
		
		lda z_b
		sta z_bs		;Xpos
		
NativeSpr_DrawX:
	pla
	pha
		cmp #64
		bcs NativeSpr_NoSpritesLeft
		asl						;4 bytes per sprite
		asl
;$7Fxx Sprite attribute table buffer(copy in ram) 4 bytes per sprite x 64
		st0 #0	  ;sta $0100	;Select Write Address ($00)		
		sta $0102 ;st1 			;Low Byte of address  (Sprite x 4)
		st2 #$7F  ;sta $0103	;High Byte of address ($7Fxx)
		
		st0 #2	  ;sta $0100	;Data Write ($02)
		
		stx	z_iyh	;x=0
		
		lda z_c
		asl 
		rol z_iyh
		sec
		sbc #88					;Ypos (64 is visible top left corner)
		sta $0102 ;st1 
		lda z_iyh
		sbc #0
		sta $0103 ;st2
		
		stx	z_iyh	;x=0
		
		lda z_bs
		asl 
		rol z_iyh		
		sec
		sbc #96			
		sta $0102 ;st1 			;Xpos (64 is visible top left corner)
		lda z_iyh
		sbc #0
		sta $0103 ;st2
		
		
		
		
		lda (z_hl),y			;Sprite VRAM Address >>5
		sta $0102 ;st1
		iny
		lda (z_hl),y
		sta $0103 ;st2 
		iny
		
		lda z_ixl				;Sprite Attributes
		sta $0102 ;st1
		lda z_ixh
		sta $0103 ;st2 
	
;Update the STAB address to force a copy to the graphics hardware
		st0 #$13  ;sta $0100	;VRAM-SATB Block Transfer Source
		st1 #$00  ;sta $0102
		st2 #$7F  ;sta $0103
	pla
	clc
	adc #1
	pha
NativeSpr_NoSpritesLeft:
		lda z_bs
		clc
		adc z_ds				;Move one pattern across
		sta z_bs
		
		dec z_cs				;X repeat
		bne NativeSpr_DrawX
	
		lda z_c
		clc
		adc z_es				;Move one pattern down
		sta z_c
	
		dec z_e					;Y repeat
		beq NotNativeSpr_DrawY
		jmp NativeSpr_DrawY
NotNativeSpr_DrawY
	pla
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	ifndef Palette
Palette:
		dw %0000000000000000; ;0  %-------GGGRRRBBB
		dw %0000000111000000; ;1  %-------GGGRRRBBB
		dw %0000000010010010; ;2  %-------GGGRRRBBB
		dw %0000000101101101; ;3  %-------GGGRRRBBB
		dw %0000000111111111; ;4  %-------GGGRRRBBB
		dw %0000000100001011; ;5  %-------GGGRRRBBB
		dw %0000000110001001; ;6  %-------GGGRRRBBB
		dw %0000000001111001; ;7  %-------GGGRRRBBB
		dw %0000000011111011; ;8  %-------GGGRRRBBB
		dw %0000000101111010; ;9  %-------GGGRRRBBB
		dw %0000000111111010; ;10  %-------GGGRRRBBB
		dw %0000000001101101; ;11  %-------GGGRRRBBB
		dw %0000000000111111; ;12  %-------GGGRRRBBB
		dw %0000000001000110; ;13  %-------GGGRRRBBB
		dw %0000000011001101; ;14  %-------GGGRRRBBB
		dw %0000000110000111; ;15  %-------GGGRRRBBB
	endif 