	
	
MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 4
MPB_Pen5 equ 5
MPB_Pen6 equ 6
MPB_Pen7 equ 7
MPB_Pen8 equ 8
MPB_Pen9 equ 9
MPB_PenA equ 10
MPB_PenB equ 11
MPB_PenC equ 12
MPB_PenD equ 13
MPB_PenE equ 14
MPB_PenF equ 15

mpbitmap_tiletints:
	db 255,0,0

	
mpbitmap_getscreenposTile: 	;D=Xpos E=Ypos (tiles)
	sta z_As	;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
	asl z_d		;Tiles2Pixels
	asl z_e
	dex
	bne mpbitmap_getscreenposShift
		
	lda #8
	sta z_b	;Linecount
		
mpbitmap_getscreenpos: 	;D=Xpos E=Ypos (pixels)
	ldx #0
	stx z_ls	
	
;Caclulate VRAM Dest
	lda z_d		;Xpos
	lsr
	lsr
	lsr			;Xpos /8 (Xpos in bytes)
	
	lsr 
	ror z_ls	;*128
	lsr 
	ror z_ls	;*64
	lsr 
	ror z_ls	;*32
	lsr 
	ror z_ls		;*16 (32 bytes per tile )
	sta z_hs		;    ( 2 bytes per VRAM Address)
	
	lda z_e		;Ypos (32 tiles per line *32 bytesPerTile = 1024)
	lsr
	lsr
	and #%11111110	;*512 (1024/2 =512 (2 byte per addr))
	clc
	adc z_hs
	adc #$40		;Tile 1024+
	sta z_hs
	
	lda z_e
	and #%0000111	;Ypos *1 (Points to bitplane 0,1)
	adc z_ls		;   (bitplane 2,3 are at Vram+8)
	sta z_ls
	rts

	
mpbitmap_getpixelbytes:	;Get 4 bitplanes
	st0 #1			;Select Vram Read Addr Select
	lda z_ls
	sta $0102		;Send to Data-L
	lda z_hs
	sta $0103		;Send to Data-H
	
	st0 #2			;Select Vram Access
	
	lda $0102		;Bitplane 0
	sta z_bs
	lda $0103		;Bitplane 1
	sta z_cs
	
	ldx #7			;Skip 7 pairs
mpbitmap_setpixelSkip:	
	lda $0102		;Skip other Bitplane 1/2 bytes
	lda $0103
	dex 
	bne mpbitmap_setpixelSkip
		
	lda $0102		;Bitplane 2
	sta z_ds
	lda $0103		;Bitplane 3
	sta z_es
	rts	
	
	
mpbitmap_setpixel:	;D=Xpos E=Ypos A=Color
	sta z_iyh		;Color number
	
	jsr mpbitmap_getscreenpos		;Get VRAM destination
	jsr mpbitmap_getpixelbytes		;Read in the bitplane lines
	
	st0 #0			;Select Vram Write Addr Select
	lda z_ls
	sta $0102		;Send to Data-L
	lda z_hs
	sta $0103		;Send to Data-H
	st0 #2			;Select Vram Access
		
	lda #%01111111	;Background mask of pixels to keep
	sta z_c
		
	lda z_d
	and #%00000111	;Xpos 0-7
	beq mpbitmap_setpixel_shiftdone
	tay
mpbitmap_setpixel_shiftagain:
	sec
	ror z_c			;Shift mask
	dey
	bne mpbitmap_setpixel_shiftagain
mpbitmap_setpixel_shiftdone:

	lda z_c			;Background mask
	eor #255
	sta z_b			;Pixel Mask

	lda z_bs
	and z_c
	ror z_iyh		;Test Bitplane 0
	bcc mpbitmap_setpixel_B0
	ora z_b			;Set Bitplane 0
mpbitmap_setpixel_B0	
	sta $0102

	lda z_cs
	and z_c
	ror z_iyh		;Test Bitplane 1
	bcc mpbitmap_setpixel_B1
	ora z_b			;Set Bitplane 1
mpbitmap_setpixel_B1
	sta $0103
		
		
	st0 #0			;Select Vram Write Addr Select
	lda z_ls
	clc
	adc #8			;Jump to bitplanes 2/3
	sta $0102		;Send to Data-L
	lda z_hs
	sta $0103		;Send to Data-H
	st0 #2			;Select Vram Access
	
	lda z_ds
	and z_c			;Test Bitplane 2
	ror z_iyh
	bcc mpbitmap_setpixel_B2
	ora z_b			;Set Bitplane 2
mpbitmap_setpixel_B2
	sta $0102

	lda z_es
	and z_c			;Test Bitplane 3
	ror z_iyh
	bcc mpbitmap_setpixel_B3
	ora z_b			;Set Bitplane 3
mpbitmap_setpixel_B3
	sta $0103
	rts


mpbitmap_getpixel:	;D=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos		;Get VRAM destination
	jsr mpbitmap_getpixelbytes		;Read in the bitplane lines
			
	lda z_d
	and #%00000111	;Xpos 0-3
	eor #%00000111
	beq mpbitmap_getpixel_shiftdone
	tay
mpbitmap_getpixel_shiftagain:
	lsr z_bs		;Shift Bitplane 0
	lsr z_cs		;Shift Bitplane 1
	lsr z_ds		;Shift Bitplane 2
	lsr z_es		;Shift Bitplane 3

	dey
	bne mpbitmap_getpixel_shiftagain
mpbitmap_getpixel_shiftdone:	
	lsr z_es		;Bitplane 3 bit
	rol
	lsr z_ds		;Bitplane 2 bit
	rol
	lsr z_cs		;Bitplane 1 bit
	rol
	lsr z_bs		;Bitplane 0 bit
	rol
	rts
	
	
;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile

	st0 #0			;Select Vram Write Addr Select
	lda z_ls
	sta $0102		;Send to Data-L
	lda z_hs
	sta $0103		;Send to Data-H
	st0 #2			;Select Vram Access
	
	ldx z_As		;Bitplane count
		
;Do Bitplanes 0/1
	cly
mpbitmap_settile_RepeatB01:
	lda (z_hl),y	;Bitplane 0
	iny
	sta $0102
	ifdef mpbitmap_tiletints
		lda mpbitmap_tiletints
    else
		lda #0
	endif
	cpx #2
	bcc mpbitmap_settile_NoB1
	lda (z_hl),y	;Bitplane 1
	iny
mpbitmap_settile_NoB1:
	sta $0103
	
	cpx #3
	bcc mpbitmap_settile_NoB2
	iny
mpbitmap_settile_NoB2:	

	cpx #4
	bcc mpbitmap_settile_NoB3
	iny
mpbitmap_settile_NoB3:	

	dec z_b
	bne mpbitmap_settile_RepeatB01
		

;Do Bitplanes 2/3
	cly
	lda #8
	sta z_b		;Linecount
		
mpbitmap_settile_RepeatB23:	
	iny			;Skip Bitplane 0
	cpx #2
	bcc mpbitmap_settile_NoB1b
	iny			;Skip Bitplane 1
mpbitmap_settile_NoB1b:
	
	ifdef mpbitmap_tiletints
		lda mpbitmap_tiletints+1
    else
		lda #0
	endif
	cpx #3
	bcc mpbitmap_settile_NoB2b
	lda (z_hl),y	;Bitplane 2
	iny
mpbitmap_settile_NoB2b:
	sta $0102
	
	ifdef mpbitmap_tiletints
		lda mpbitmap_tiletints+2
    else
		lda #0
	endif
	cpx #3
	bcc mpbitmap_settile_NoB3b
	lda (z_hl),y	;Bitplane 3
	iny
mpbitmap_settile_NoB3b:
	sta $0103
	
	dec z_b
	bne mpbitmap_settile_RepeatB23
	
mpbitmap_settile_Cleanup:		;Update HL for read data
	tya				;HL=HL+Y
	clc
	adc z_l
	sta z_l
	bcc mpbitmap_settile_Done
	inc z_h
mpbitmap_settile_Done:	
	rts

	
	
;HL = Destination Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile	;Get VRAM source
		
	ldy #0
mpbitmap_gettileAgain:
	jsr mpbitmap_getpixelbytes		;Get a line of screen data
	ldx z_As		;X=Bitplane count
	
	lda z_bs
	sta (z_hl),y	;Bitplane 0
	iny
	
	dex
	beq	mpbitmap_gettile_Done
	lda z_cs
	sta (z_hl),y	;Bitplane 1
	iny
			
	dex
	beq mpbitmap_gettile_Done
	lda z_ds
	sta (z_hl),y	;Bitplane 2
	iny

	dex 
	beq mpbitmap_gettile_Done
	lda z_es
	sta (z_hl),y	;Bitplane 3
	iny
	
mpbitmap_gettile_Done:	
	inc z_ls		;Next Source Bitplanes

	dec z_b
	bne mpbitmap_gettileAgain	;Next Line
	
	jmp mpbitmap_settile_Cleanup ;Update HL for written data

	