
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


DrawTile:	
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		bne DrawTileAdvanced
	endif
	asl
	sta (z_bcs),y	;Clear update flag
	iny
DrawTileBasicOnly:
	and #%11110000	;%nnnn----
	sta z_ls
	lda (z_bcs),y	;%NNNNNNNN
	
	lsr 
	ror z_ls		;/2
	lsr 
	ror z_ls		;/4
	lsr 
	ror z_ls		;/8
	lsr 
	ror z_ls		;/16
	sta z_hs
	
	dey ;ldy #0
	
DrawTileBasic:	
	st0 #0				;Select Memory Write Reg
	lda z_L
	sta $0102 			;st1 - L address
	lda z_H
	sta $0103 			;st2 - H Address
	st0 #2				;Select Data reg
	
	lda z_ls
	clc
	adc z_es			;Add DEs = Tile pattern base address 
	sta $0102			;Send to Data-L (%nnnnnnnn)
	lda z_hs		
	adc z_ds
	sta $0103			;Send to Data-H (%ppppNNNN)
		
	jmp TileDoneBCs_Plus2



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


DrawTileAdvanced:	
	and #%00000110
	bne NotDrawTileCustom
		jmp DrawTileCustom
NotDrawTileCustom:
	lda (z_bcs),y
	and #%11111110
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnly
	endif

	and #%11110000	;%nnnn----
	sta z_ls
	lda (z_bcs),y	;%NNNNNNNN
	
	lsr 
	ror z_ls		;/2
	lsr 
	ror z_ls		;/4
	lsr 
	ror z_ls		;/8
	lsr 
	ror z_ls		;/16
	sta z_hs
			
	dey		
	lda (z_bcs),y
	
	bit LookupBits+2
	beq NotDrawTileYFlip
		jmp DrawTileYFlip
NotDrawTileYFlip:

;DrawTileXflip	
	lda z_ls
	clc
	adc #<OffsetToXflipped
	sta z_ls
	lda z_hs
	adc #>OffsetToXflipped
	sta z_hs
	jmp DrawTileBasic
	
DrawTileXYflip:
	lda z_ls
	clc
	adc #<OffsetToXYflipped
	sta z_ls
	lda z_hs
	adc #>OffsetToXYflipped
	sta z_hs
	jmp DrawTileBasic
		
DrawTileYflip:
	bit LookupBits+3
	beq NotDrawTileXYFlip
		jmp DrawTileXYFlip
NotDrawTileXYFlip:
	lda z_ls
	clc
	adc #<OffsetToYflipped
	sta z_ls
	lda z_hs
	adc #>OffsetToYflipped
	sta z_hs
	jmp DrawTileBasic
	

	
	
	
	
	
	

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustom:
	lda (z_bcs),y 		;%NN------
	and #%11111110
	sta (z_bcs),y
	rol
	rol	
	rol
	and #%00000011		;%------NN
	sta z_hs
	
	lda (z_bcs),y
	iny 
	and #%00110000				;Cmd Bits
	bne NotDrawTileFill
		jmp DrawTileFill		;--00----
NotDrawTileFill:
	cmp #%00110000				;--11----
	bne NotDrawTileEmpty					
;DrawTileEmpty:
		lda (z_bcs),y
		cmp #255				;Empty tile?
		bne DrawTileTransp	
		dey
		jmp TileDoneBCs_Plus2
	
DrawTileTransp:;;;;;;;;;;;;;;;;;;Transparent
		sta z_ls				;Tile number in Ls
		dey ;ldy #0
		jmp DrawTileBasic
NotDrawTileEmpty:
	
	
DrawTileDouble:	
	lda (z_bcs),y		;%nnnnnnnn
	dey ;ldy #0

	clc
	adc #<OffsetToDoubled
	sta z_ls
	lda z_hs
	adc #>OffsetToDoubled
	sta z_hs
	
	jmp DrawTileBasic
	
	
DrawTileFill:
	st0 #0				;Select Memory Write Reg
	lda z_L
	sta $0102 			;st1 - L address
	lda z_H
	sta $0103 			;st2 - H Address
	st0 #2				;Select Data reg
	
	lda (z_bcs),y		;%nnnnnnnn
	dey ;ldy #0
	
	clc
	adc #<filldata
	sta $0102			;Send to Data-L (%nnnnnnnn)
	lda z_hs		
	adc #>filldata
	sta $0103			;Send to Data-H (%ppppNNNN)
	
	jmp TileDoneBCs_Plus2
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

GetScreenPos:	
	lda z_b			;Xpos in logical units (Pairs of pixels)
	lsr
	lsr
	sta z_b			;Xpos in tiles

	lda z_c
	clc
	adc #8			;2 lines down (Center Screen)
	sta z_c		
	
	and #%00011100	;Multiply Ypos by 32 - Low byte
	asl
	asl
	asl
	adc z_b			;Add Xpos
	sta z_l		
	
	lda z_c
	and #%11100000	;Multiply Ypos by 32 - High Byte
	lsr
	lsr
	lsr
	lsr
	lsr
	sta z_h			
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	;BC=Bytes
	;DE=Destination Ram
	;HL=Source Bytes

DefineTilesCombo:
	lda #0					;Un X-flipped
	tay						;Zero Offset
	tax						;Zero Offset
	jsr DefineTilesX		;Unflipped
	
	ldx #<OffsetToXflipped	;Xflipped offset
	ldy #>OffsetToXflipped	;Xflipped offset
	lda #1					;Xflip
	jsr DefineTilesX		;Xflipped

	ldx #<OffsetToDoubled	;Doubled Offset
	ldy #>OffsetToDoubled	;Doubled Offset
	lda #0					;Un X-flipped
	jsr DefineTilesDoubled	;Double height
	
	ldx #<OffsetToYflipped	;Yflipped offset
	ldy #>OffsetToYflipped	;Yflipped offset
	lda #0					;Un X-flipped
	jsr DefineTilesY		;Ylfipped

	ldx #<OffsetToXYflipped	;XYflipped offset
	ldy #>OffsetToXYflipped	;XYflipped offset
	lda #1					;Xflip
							;XYflipped	
							
DefineTilesY:	
	sta z_iyl			;Flip mode
	
	pushpair z_de
	pushpair z_bc
	pushpair z_hl
		jsr CalcPatternDest	;Add the offset to DE
		
DefineTilesAgainY2:	
		ldy #14				;Start from last line (14+15)
DefineTilesAgainY:
		jsr DoSourcePatternByte
		iny
		sta $0102			;Store Low byte
		jsr DoSourcePatternByte
		dey					;Up 1 line (2 bitplanes)
		dey
		dey
		sta $0103			;Store High Byte

		jsr decbc
		jsr decbc
		
		cpy #254
		bne DefineTilesAgainY
				
	ifdef FourColorPatterns	
		ldx #8
DefineTilesYb2:		
		lda z_ixh			;write bitplane 2/3
		sta $0102			; (4 color mode)
		lda z_ixl
		sta $0103
		dex
		bne DefineTilesYb2
	endif 
		lda z_l
		clc
		adc #16				;Move to next tile / bitplane pair
		sta z_l
		bcc DefineTilesAgainY_NoH
		inc z_h
DefineTilesAgainY_NoH:
				
		lda z_b
		ora z_c
		bne DefineTilesAgainY2
		
DefineTilesAgainDoneY:
	pullpair z_hl
	pullpair z_bc
	pullpair z_de
	rts	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


DefineTilesX:		
	sta z_iyl			;Flip mode
	lda z_d
	pha
	lda z_b
	pha
	lda z_h
	pha
		jsr CalcPatternDest	;Add the offset to DE
		
		ldx z_C				;B=High byte of count - X=Low byte
		ldy #0	
DefineTilesAgain:
		jsr DoSourcePatternByte
		iny
		sta $0102			;Store Low byte
		jsr DoSourcePatternByte
		iny
		sta $0103			;Store High Byte
		bne DefineTilesAgainYok
		inc z_h				;INC High byte Y=low byte
DefineTilesAgainYok:		
		txa					;Is Low Byte Zero?
		bne DefineTilesDecBC_C
		lda z_B				;Are We done
		beq DefineTilesAgainDone
		DEC z_B				;DEC high byte (X is low byte)
DefineTilesDecBC_C:	
		DEx					;Subtract 2 
		DEX					;Since we did 2 bytes
		
	ifdef FourColorPatterns		
		txa					
		and #%00001111		;Have we done a full tile?
		bne DefineTilesAgain
		txa 
		pha
			ldx #8
DefineTilesXb2:		
			lda z_ixh		;4 color filler data
			sta $0102		;Yes, write bitplane 2/3
			lda z_ixl
			sta $0103
			dex
			bne DefineTilesXb2
		pla
		tax
	endif 
		
		jmp DefineTilesAgain
DefineTilesAgainDone:
	pla
	sta z_h
	pla 
	sta z_b
	pla 
	sta z_d
	rts

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DoSourcePatternByte:
	lda z_iyl			;Mode (0=normal 1=xflip)
	bne DoXFlipByte
	lda (z_HL),Y		;Load a byte
	rts
	
DoXFlipByte:
	lda (z_HL),Y		;Load a byte
	
	rol					;Xflip it
	ror z_d
	rol
	ror z_d
	rol
	ror z_d
	rol
	ror z_d
	rol
	ror z_d
	rol
	ror z_d
	rol
	ror z_d
	rol
	ror z_d
	
	lda z_d			
	rts	
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

CalcPatternDest: 		;Select VRAM $YYXX + z_DE
	sty z_as
	txa
	asl			;*2
	rol z_as 
	asl			;*4
	rol z_as 
	asl			;*8
	rol z_as 
	asl			;*16 (16 words per tile)
	rol z_as 
		
	clc
	adc z_e				;Add our base pattern
	st0 #0				;Select Memory Write Reg
	sta $0102 			;st1 - L address
	lda z_as 
	adc z_d
	sta $0103 			;st2 - H Address
	st0 #2				;Select Data reg
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

DefineTilesDoubled:		
	sta z_iyl			;Flip mode
	pushpair z_de
	pushpair z_bc
	pushpair z_hl
		jsr CalcPatternDest		
	
DefineTilesAgainD3:		
		ldy #0			
DefineTilesAgainDB:		
;Tile Half 1
		ldx #4					;Do First half tile (Bitplane 0/1)
DefineTilesAgainD:
		jsr DoDoubleLines			;Do 4 src lines -> 8 dest lines
				
		cpy #16
		bcs DefineTilesDnext		;Flip to 2nd bitplane pair
		
		ifdef FourColorPatterns		
			jsr DoDoubleEmptyLine	;Pad unused bitplanes
		else
			ldy #16
			jmp DefineTilesAgainDB	;Move to Bitplane 2/3
		endif		
DefineTilesDnext:		

;Tile Half 2
		ldy #8			;Do decond half of tile (Bitplane 0/1)
DefineTilesAgainDB2:		
		ldx #4
DefineTilesAgainD2:
		jsr DoDoubleLines			;Do 4 src lines -> 8 dest lines
				
		cpy #16+8
		bcs DefineTilesDnext2		;Flip to 2nd bitplane pair
		
		ifdef FourColorPatterns		
			jsr DoDoubleEmptyLine	;Pad unused bitplanes
		else
			ldy #16+8
			jmp DefineTilesAgainDB2	;Move to Bitplane 2/3
		endif
DefineTilesDnext2:	
		
		lda z_l
		clc
		ifdef FourColorPatterns
			adc #16				
		else
			adc #32
		endif	
		sta z_l						;Move to next tile
		bcc DefineTilesDnextNoH
		inc z_h
DefineTilesDnextNoH:			
			
		lda z_c
		sec
		ifdef FourColorPatterns
			sbc #16
		else
			sbc #32
		endif
		sta z_c						;Decrease total count by 1 tile
		bcs DefineTilesAgainDNOB
		dec z_b
DefineTilesAgainDNOB:
	
		lda z_b
		ora z_c
		bne DefineTilesAgainD3		;Any bytes left?
DefineTilesAgainDoneD:
	pullpair z_hl
	pullpair z_bc
	pullpair z_de
	rts
	
DoDoubleLines:
	jsr DoSourcePatternByte
	iny
	sta $0102			;Store Low byte
	jsr DoSourcePatternByte
	dey
	sta $0103			;Store High Byte
	jsr DoSourcePatternByte
	iny
	sta $0102			;Store Low byte
	jsr DoSourcePatternByte
	iny
	sta $0103			;Store High Byte
	dex 
	bne DoDoubleLines
	rts	
	
	ifdef FourColorPatterns
DoDoubleEmptyLine:	
		ldx #8
DefineTilesD2:		
		lda z_ixh		;write bitplane 2/3
		sta $0102
		lda z_ixl
		sta $0103
		dex
		bne DefineTilesD2
		rts
	endif
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DefineFills:		
	st0 #0				;Select Memory Write Reg
	lda z_e
	sta $0102 			;st1 - L address
	lda z_d
	sta $0103 			;st2 - H Address
	
	st0 #2				;Select Data reg
	ldx z_C				;B=High byte of count - X=Low byte
	
	ldy #0	
DefineTilesAgainF2:		
	ldx #8
	lda #0
	sta z_iyl			;Flip mode
	
DefineTilesAgainF:
	
	lda (z_HL),Y		;Load a byte
	iny
	sta $0102			;Store Low byte
	lda (z_HL),Y		;Load a byte
	sta $0103 			;st2 - H Address
	dey
	dex
	bne DefineTilesAgainF
	
	iny
	iny
	
	lda z_c
	sec
	sbc #2
	sta z_c
	bcs DefineTilesAgainFNOB
	dec z_b
DefineTilesAgainFNOB:		

	lda z_b
	ora z_c
	bne DefineTilesAgainF2
	rts	
	
;Get (and flip if required) a source byte




