
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


;HspriteNum

DrawTileH:	
	stz XShift				;Used for XY flip
	stz YShift

	;ldy #0	;-safe to assume Y=0
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		beq NotDrawTileAdvancedH
		jmp DrawTileAdvancedH
NotDrawTileAdvancedH
	endif
	asl
	sta (z_bcs),y	;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
	
	
DrawTileBasicOnlyH:
	and #%11110000	;nnnn---
	clc
	sta z_ls
	lda (z_bcs),y	;%NNNNNNNN
	sta z_hs
	
	lda #$0			;Flip mode
	
DrawTileBasicH:	
	sta z_b
	
	ifndef FourColorPatterns
		asl z_ls	;*32 (for 16 color)
		rol z_hs
	endif
	
	clc
	lda z_ls
	adc z_es		;Add DEs = Tile pattern base address 
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	
	
DrawTileBasicH2:	
	lda #$80	;Foreground sprite
	sta z_c
		
	lda HspriteNum
	cmp #64
	beq MaxTile_NoSpritesLeft
	
	jsr SpritePrep
	ldy #0
	jsr TransferSpriteTileBlockx2		;First 2 bitplanes
	
	ifdef FourColorPatterns
		ldx #32
SendZeroByteH:
		stz $0102 ;st1
		stz $0103 ;st2 
		dex
		bne SendZeroByteH
	else
		ldy #16
		jsr TransferSpriteTileBlockx2	;2nd 2 bitplanes
	endif
		
MaxTile_NoSpritesLeft:
	ldy #0
	jmp TileDoneBCs_Plus2H

	
	
; 
SpritePrep:
	pha
		asl						;4 bytes per sprite
		asl
		pha
;$7Fxx Sprite attribute table buffer(copy in ram) 
;4 bytes per sprite x 64 sprites
			st0 #0	  ;sta $0100	;Select Write Address ($00)		
			sta $0102 ;st1 			;Low Byte of address  (Sprite x 4)
			st2 #$7F  ;sta $0103	;High Byte of address ($7Fxx)
			
			st0 #2	  ;sta $0100	;Data Write ($02)
			
			lda z_l				;Ypos (64 is visible top left corner)
			adc YShift
			asl
			clc
			adc #64+24
			sta $0102 ;st1 
			txa ;lda #0
			adc #0
			sta $0103 ;st2
			
			lda z_h				;Xpos  (32 is visible top left corner)
			adc XShift
			asl
			clc
			adc #32-8
			sta $0102 ;st1 
			txa ;lda #0
			adc #0
			sta $0103 ;st2 
		pla						;Pattern Address (Bottom byte)
		sta $0102 ;st1
		lda #$40>>5				;Pattern Address (top byte)
		sta $0103 ;st2 
		
		lda z_c					;Sprite Attributes
		sta $0102 ;st1			F---PPPP... Layer and palette
		lda z_b
		sta $0103 ;st2 			Y-yyX--x... Flip and size
	
		inc HspriteNum
	pla
	sta z_b
	
;Select Sprite pattern address
	st0 #0				;Select Memory Write Reg
	txa ;lda #0
	lsr z_b				;128 bytes of pattern data per sprite
	ror 
	sta $0102 			;st1 - L address
	lda #$40			;Vram $4000 (tile 1024+)
	clc
	adc z_b
	sta $0103 			;st2 - H Address
	st0 #2				;Select Data reg
	rts	
	
; Sprite Format is different to Tile patterns:
; $TT 00 *8 lines
; $00 00 *8 lines
; 16 bits wide, 16 lines tall.
; T=source tile data... 0=unused part of sprite
	
	
TransferSpriteTileBlockx2:	
	jsr TransferSpriteTileBlock		;Bitplane 0/2
									
	iny								;Bitplane 1/3
	
TransferSpriteTileBlock:			
	phy
TransferSpriteTileAgain:
		ldx #8
TransferSpriteTile1:
		lda (z_hls),y
	;	lda HspriteNum
		iny						;Skip 2 bytes to next bitplane line
		iny
		sta $0102 ;st1
		stz $0103 ;st2 
		dex 
		bne TransferSpriteTile1
		
		ldx #8
TransferSpriteTile2:
		stz $0102 ;st1
		stz $0103 ;st2 
		dex 
		bne TransferSpriteTile2
	ply
	rts
	
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


DrawTileAdvancedH:	
	and #%00000110
	bne NotDrawTileCustomH
		jmp DrawTileCustomH
NotDrawTileCustomH:
	lda (z_bcs),y
	and #%11111110
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnlyH
	endif

	and #%11110000	;nnnn---
	sta z_ls

	lda (z_bcs),y	;NNNNNNNN
	sta z_hs
	dey		
	lda (z_bcs),y
	
	bit LookupBits+2	;Y flip flag
	beq DrawTileXflipH
		
	bit LookupBits+3	;X flip flag
	beq DrawTileYflipH

;DrawTileXYflipH
	lda #4
	sta XShift
	lda #-4
	sta YShift
	lda #$88
	jmp DrawTileBasicH
		
DrawTileYflipH:
	lda #-4
	sta YShift
	lda #$80
	jmp DrawTileBasicH
	
DrawTileXflipH:
	lda #4
	sta XShift

	lda #$08
	jmp DrawTileBasicH


	
	
	

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustomH:
		lda (z_bcs),y 			;NN------
		and #%11111110			;Clear update flag
		sta (z_bcs),y 
		rol
		rol	
		rol
		and #%00000011
		sta z_hs
		
		lda (z_bcs),y 		
		and #%00110000			;Cmd Bits
		bne NotDrawTileFillH
			jmp DrawTileFillH	;--00----
NotDrawTileFillH:
		cmp #%00110000			;--11----
		bne DrawTileDoubleH	

;DrawTileEmptyH
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTranspH
	dey
	jmp TileDoneBCs_Plus2H
	
DrawTileTranspH:;;;;;;;;;;;;;;;;;;Transparent
	asl 
	rol z_hs	;*2
	asl 
	rol z_hs	;*4
	asl 
	rol z_hs	;*8
	asl 
	rol z_hs	;*16
	ifndef FourColorPatterns
		asl 
		rol z_hs	;*32
	endif
	clc
	adc z_es	;z_DE pattern base
	sta z_ls
	lda z_hs
	adc z_ds
	sta z_hs

	stz z_b
	jmp DrawTileBasicH2	
		
	
	
DrawTileDoubleH:	
	lda #0		;Flip Attribute
	sta z_b
	
	iny 
	lda (z_bcs),y
	dey
	
	asl 
	rol z_hs	;*2
	asl 
	rol z_hs	;*4
	asl 
	rol z_hs	;*8
	ifndef FourColorPatterns
		asl 
		rol z_hs	;*16
		bit Bit_5
		beq DrawTileDoubleFirstHalf
		and #%11100000
		add #8			;4 lines down (16 color)
	else 
		bit Bit_4
		beq DrawTileDoubleFirstHalf
		and #%11110000
		add #8			;4 lines down (4 color)
	endif
DrawTileDoubleFirstHalf:		
	
	adc z_es	;Add source pattern data z_DE
	sta z_ls
	lda z_hs
	adc z_ds
	sta z_hs
		
	lda #$80	;Foreground sprite
	sta z_c
		
	lda HspriteNum
	cmp #64
	beq MaxTile_NoSpritesLeft2
	
	jsr SpritePrep
	ldy #0
	jsr TransferSpriteTileBlockDouble
		
	ifdef FourColorPatterns
		ldx #32
SendZeroByteHd:
		stz $0102 ;st1
		stz $0103 ;st2 
		dex
		bne SendZeroByteHd
	else
		ldy #16					;Shift to the 2nd block of pattern data
		jsr TransferSpriteTileBlockDouble
	endif
			
MaxTile_NoSpritesLeft2:
	ldy #0	
	jmp TileDoneBCs_Plus2H

Bit_4: db %00001000
Bit_5: db %00010000
	
MotMaxTile_NoSpritesLeft3:
	ldy #0	
	jmp TileDoneBCs_Plus2H

TransferSpriteTileBlockDouble:				
	jsr TransferSpriteTileBlockD		;Bitplane 0/2
						
	iny								;Bitplane 1/3
TransferSpriteTileBlockD:			
	phy
		ldx #4
TransferSpriteTile1D:
		lda (z_hls),y
		iny						;Skip 2 bytes to next bitplane line
		iny
		sta $0102 ;st1
		stz $0103 ;st2 
		sta $0102 ;st1
		stz $0103 ;st2 
		dex 
		bne TransferSpriteTile1D
		
		ldx #8
TransferSpriteTile2D:
		stz $0102 ;st1
		stz $0103 ;st2 
		dex 
		bne TransferSpriteTile2D
	ply
	rts
	
		
	
	; jsr TransferSpriteTileBlockx2
	
	; ifdef FourColorPatterns
		; ldx #32
; SendZeroByteH:
		; stz $0102 ;st1
		; stz $0103 ;st2 
		; dex
		; bne SendZeroByteH
	; else
		; ldy #16
		; jsr TransferSpriteTileBlockx2
	; endif
		

; MaxTile_NoSpritesLeft:
	; ldy #0
	; jmp TileDoneBCs_Plus2H

		
		
DrawTileFillH:
	lda #0			;Flip Attribute
	sta z_b
	
	iny 
	lda (z_bcs),y	;nnnnnnnn
	dey
	
	asl 
	rol z_hs	
	asl 
	rol z_hs	;*4 bytes per fill
	
	adc #<Fills
	sta z_ls
	
	lda z_hs
	adc #>Fills
	sta z_hs
		
	lda #$80	;Foreground sprite
	sta z_c
		
	lda HspriteNum
	cmp #64
	beq MaxTile_NoSpritesLeft3
	jsr SpritePrep
	
	ldy #0
TransferSpriteTileAgainf:
	ldx #8
	lda (z_hls),y
TransferSpriteTile1f:	
	sta $0102 ;st1			- Fill byte
	stz $0103 ;st2 
	dex 
	bne TransferSpriteTile1f
	
	ldx #8
TransferSpriteTile2f:
	stz $0102 ;st1
	stz $0103 ;st2 
	dex 
	bne TransferSpriteTile2f
	iny
	cpy #4
	bne TransferSpriteTileAgainf
	
MaxTile_NoSpritesLeft3:
	ldy #0	
	jmp TileDoneBCs_Plus2H


		

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ClearUnusedHsprites:
	lda HspriteNum
	tax
	asl						;4 bytes per sprite
	asl
	beq ClearUnusedHspritesDone

	st0 #0	  ;sta $0100	;Select Write Address ($00)		
	sta $0102 ;st1 			;Low Byte of address  (Sprite x 4)
	st2 #$7F  ;sta $0103	;High Byte of address ($7Fxx)
	
	st0 #2	  ;sta $0100	;Data Write ($02)
ClearUnusedHspritesAgain:		
	st1 #0
	st2 #0
	
	st1 #0
	st2 #0
	
	st1 #0
	st2 #0
	
	st1 #0
	st2 #0
	
	inx
	cpx #64
	bne ClearUnusedHspritesAgain
	
ClearUnusedHspritesDone:

;Update the STAB address to force a copy to the graphics hardware
	st0 #$13  ;sta $0100	;VRAM-SATB Block Transfer Source
	st1 #$00  ;sta $0102
	st2 #$7F  ;sta $0103
	
	stz HspriteNum
	rts


GetScreenPosH:	;Move to a memory address in VDP by BC cursor pos
	lda z_c
	sta z_l		;Transfer XY pos into z_HL (to maintain compatibility)
	
	lda z_b
	sta z_h
	rts
