
NativeSpr_DrawArrayReiKou:			
	jsr AddressRemapViaTableHL	;Used by VM for address remapping
	
NativeSpr_DrawArray:	;Draw Sprite Array (HL)
	ldx #0				;X=Zero throughout
	stx HspriteCount
			
	lda (z_hl,x)
	beq NativeSpr_ClearUnusedb ;We're done, so check any remaining
	jsr IncHL
	
NativeSpr_DrawArrayB:	
	pha					 
		ldy #0
		lda (z_hl),y	;Xpos (Pairs of pixels)
		sta z_c
		iny
		lda (z_hl),y	;Ypos (Pairs of pixels)
		sta z_b	
		iny
		lda (z_hl),y	;SpriteDef-L
		sta z_ls
		iny
		lda (z_hl),y	;SpriteDef-H
		sta z_hs
		iny
		tya
		clc
		adc z_l
		pha				;Backup HL+Y
		lda z_h
		adc #0
		pha		
			lda z_hs
			sta z_h
			lda z_ls
			sta z_l
			
			jsr NativeSpr_DrawExtra	;HL=sprite data  BC=XY pos
		pla
		sta z_h
		pla 			;Restore HL
		sta z_l
	pla
	sec
	sbc #1
	bne NativeSpr_DrawArrayB	;Repeat for next object
NativeSpr_ClearUnusedb2:
	;jmp NativeSpr_ClearUnused
	
	
NativeSpr_ClearUnused:
	ldy HspriteCount			;Currently used Hsprite
NativeSpr_ClearUnusedC:	
	cpy HspriteLimit
	bcs NativeSpr_ClearUnusedB
	tya
	jsr NativeSpr_Hide
	iny
	bpl NativeSpr_ClearUnusedC	;should always be true
	
NativeSpr_ClearUnusedB:	
	rts
	
	
NativeSpr_Hide:					;Hide Sprite A
	asl
	asl
	tax
	lda #240					;New Ypos
NativeSpr_HideAgainx2:
	sta SpriteBuffer,x			;Ypos offscreen
	inx
	rts
		
		
		
		
NativeSpr_InitReiKou:
	jsr AddressRemapViaTableHL	;Used by VM for address remapping
	
NativeSpr_Init:
	jsr NesDisableScreen

;Define the palette	
	
	lda #$3F		;Select Palette ram &3F11
	sta $2006		;PPUADDR H
	lda #$11
	sta $2006		;PPUADDR L
	
	ldx #4-1
SprPaletteAgain
	ifdef SpritePalette
		lda SpritePalette-1,x ;Get a palette entry (-1 as no color 0)
	else
		lda Palette-1,x 
	endif
	sta $2007		;PPUDATA
	dex 
	bpl SprPaletteAgain 	;Repeat until <0
	
	
;Send Tile pattern Data	

	lda #>NES_SpritePatternVram		;$1000 is suggested address
	sta $2006		;PPUADDR H
	lda #<NES_SpritePatternVram		
	sta $2006		;PPUADDR L
	
NativeSpr_Init_DefineSpriteTiles:
	lda (z_hl),y				;Get a pattern byte
	sta $2007					;Send to VRAM
	jsr IncHL
	jsr DecBC
	lda z_b
	ora z_c
	bne NativeSpr_Init_DefineSpriteTiles
	
	jsr NesEnableScreen
		
	lda #64
	sta HspriteLimit			;Max number of hsprites
	
	;jmp nativespr_hideAll		- Clear all sprites to start.
	
	
nativespr_hideAll_Reikou:
nativespr_hideAll:				;Remove all Hsprites from the screen
	ldy #0
	sty HspriteCount			;Set used Hsprites to zero
	beq NativeSpr_ClearUnusedC	;always EQ
			
	
	

	

NativeSpr_DrawExtra:
	lda HspriteCount		;Sprnum
	jsr NativeSpr_Draw
	sta HspriteCount		;Sprnum
	rts	

NativeSpr_DrawNoSprite:
	pla
	rts
	
NativeSpr_Draw:	;BC=XY in pairs of pixels	A=hspriteNum
	pha		 				;HL = Source Data
		ldx #0
		lda (z_hl,x)
		sta z_d			;W
		beq NativeSpr_DrawNoSprite
		jsr IncHL
		lda (z_hl,x)
		sta z_e			;H
		jsr IncHL
		
NativeSpr_DrawY:
		lda z_d
		sta z_cs
		lda z_b
		sta z_bs
		
NativeSpr_DrawX:
	pla
	pha
		cmp #64
		bcs NativeSpr_NoSpritesLeft
		asl						;4 bytes per sprite
		asl
		tay
		
		lda (z_hl,x)			;Tilenum %TTTTTTTT
		sta z_ixl
		jsr IncHL
		
		lda (z_hl,x)			;Attribs %VHB---PP
		sta z_ixh				;  Vflip  Hflip  Background priority  Palette
		jsr IncHL
		
		lda z_ixl
		ora z_ixh
		beq NativeSpr_NoSpritesLeft	;Empty sprite
		
		lda z_c
		ifdef VDPBuffer
			sbc #80-12
		else
			sbc #80-4
		endif
		asl 					;Logical Units->Pixels
		sta SpriteBuffer,y		;YYYYYYYY 	Ypos 
		iny
		
		lda z_ixl
		sta SpriteBuffer,y		;TTTTTTTT	Tilenum
		iny
		
		lda z_ixh
		sta SpriteBuffer,y		;VHB---PP
		iny					;Vflip  Hflip  Background priority  Palette
		
		lda z_bs
		sec
		sbc #64
		asl 					;Logical Units->Pixels
		sta SpriteBuffer,y		;XXXXXXXX 	Xpos 
		iny
	pla
	clc
	adc #1
	pha
NativeSpr_NoSpritesLeft:
		lda z_bs
		clc
		adc #4					;Across 8 pixels
		sta z_bs
		
		dec z_cs
		bne NativeSpr_DrawX
	
		lda z_c
		clc
		adc #4					;Sown 8 Pixels
		sta z_c
	
		dec z_e
		beq NotNativeSpr_DrawY
		jmp NativeSpr_DrawY
NotNativeSpr_DrawY
	pla
	rts

	
	
	

	; ifndef Nmihandler
; Nmihandler:					;Vblank Interrupt handler 
	; pha						;Defined by $FFFA - Interrupt handler
	; tya
	; pha
		; lda #SpriteBuffer/256	;Data to copy to sprites
		; sta $4014 				;Start Spirte DMA transfer to OAM
		
		; inc vblanked			;Alter Vblank Zero page entry
	; pla
	; tay
	; pla
; irqhandler:					;Dummy IRQ handler
								; Defined by $FFFE - IRQ Handler
	; rti						;Return from interrupt handler
	; endif
	
	