;Screen size 200*160 pixels (25x20 tiles)
;500 tiles total out of a maximum 512
	
	
MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 4
MPB_Pen5 equ 5
MPB_Pen6 equ 6
MPB_Pen7 equ 7
MPB_Pen8 equ 8
MPB_Pen9 equ 9
MPB_PenA equ 10
MPB_PenB equ 11
MPB_PenC equ 12
MPB_PenD equ 13
MPB_PenE equ 14
MPB_PenF equ 15

mpbitmap_tiletints:
	db 255

	
mpbitmap_getscreenposTile:	;DE=X,Y pos (Tiles)
	sta z_As		;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
	asl z_e			;Ypos to pixels
	asl z_d			;Xpos to pixels
	dex
	bne mpbitmap_getscreenposShift
	
	lda #0
	jmp mpbitmap_GetScreenPosB
	
	
mpbitmap_GetScreenPos:	;DE=X,Y pos (Pixels)
	lda z_e
	and #%00000111		;Ypos 0-7 (in pattern)
mpbitmap_GetScreenPosB:
	sta z_ls
	
	ldy #0
	
	lda #$60			;Using Ram area $6000+ as a cache
	sta z_hs
	
	lda z_e				;Ypos
	cmp #160
	bcs mpbitmap_GetScreenPos_Offscreen
	
	cmp #80				;lines >80 are in second pattern bank
	bcc ScreenFirstHalf2
	
	lda z_ls
	clc
	adc #$60			;Skip the unused 6 tiles
	sta z_ls
ScreenFirstHalf2:	

	sty z_b	;y=0		;Address=$6000 + (Ypos*25*16) + Xpos*16
	lda z_d
	cmp #200
	bcs mpbitmap_GetScreenPos_Offscreen
	
	and #%11111000		;Xpos *16 - 8 lines - 2 bitplanes per line
	asl
	rol z_b
	sta z_c
	jsr addhls_bc
	
	sty z_b	;y=0
	lda z_e				;Ypos
	and #%11111000		;Ypos in tiles *25*2 (25=1+8+16)
	asl
	rol z_b
	sta z_c
	jsr addhls_bc	;*2
	lda z_c
	asl
	rol z_b
	asl
	rol z_b
	asl
	rol z_b
	sta z_c
	jsr addhls_bc	;*8
	asl z_c
	rol z_b
	;jmp addhl_bc	;*16
AddHLs_BC:				;Add BC to HL
	clc
	lda z_c
	adc z_ls
	sta z_ls
	lda z_b
	adc z_hs
	sta z_hs
	
	clc 				;Carry Clear=Ok
	rts
		
mpbitmap_GetScreenPos_Offscreen:	
	sec					;Carry Set = Offscreen
mpbitmap_GettileAbort:
	rts
		
	
;HL = Destination Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile
	bcs mpbitmap_GettileAbort		;Offscreen?
	
	ldx #8				;Line count
	ldy #0
mpbitmap_gettile_nextline:
	lda z_As
	sta z_b				;Bitplane count
	
	lda (z_hls),y		;Get bitplane 0 (Y=0)
	sta z_e
	
	ldy #8
	lda (z_hls),y		;Get bitplane 1 (Y=8)
	sta z_d
	
	jsr IncHLs
	
	ldy #0
	lda z_e				;Bitplane 0
	sta (z_hl),y	
	jsr inchl
	dec z_b
	beq mpbitmap_gettile_loaddone
	
	lda z_d				;Bitplane 1
	sta (z_hl),y	
	jsr inchl
	dec z_b
	beq mpbitmap_gettile_loaddone

mpbitmap_gettile_loadagain:	
	txa	;x=0
	sta (z_hl),y		;Bitplane 2/3 (Store 0)
	jsr inchl
	dec z_b
	bne mpbitmap_gettile_loadagain

mpbitmap_gettile_loaddone:
	dex
	bne mpbitmap_gettile_nextline
mpbitmap_settileAbort:
	rts



;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile
	bcs mpbitmap_settileAbort		;Offscreen?
				
	ldx #8				;Linecount
	
mpbitmap_settile_yline:	
	ldy #0			
	
	ifdef mpbitmap_tiletints
		lda mpbitmap_tiletints
		sta z_ds		;Bitplane 1 tint
	else 
		stx z_ds		;Bitplane 1 default
	endif 
	
	lda z_As			;Bitplane count
	sta z_b
		
	lda (z_hl),y		;Get Bitplane 0
	jsr IncHL
	sta z_es
	dec z_b
	beq mpbitmap_settile_bitplanesdone
	
	lda (z_hl),y		;Get Bitplane 1
	sta z_ds	
	
mpbitmap_settile_skipbitplane:	
	jsr IncHL			;skip Bitplanes 2/3
	dec z_b
	bne mpbitmap_settile_skipbitplane
		
mpbitmap_settile_bitplanesdone:			
	
	lda z_es
	sta (z_hls),y		;Set bitplane 0 (Y=0)
	ldy #8
	lda z_ds
	sta (z_hls),y		;Set bitplane 1 (Y=8)
	
	jsr IncHLs
	dex
	bne mpbitmap_settile_yline
	rts

	
	
mpbitmap_setpixel:	;LD=Xpos E=Ypos A=Color
	sta z_iyh			;Color number

	jsr mpbitmap_getscreenpos	;Get VRAM Destination
	bcs mpbitmap_setpixelabort	;Offscreen?
	
	lda #%01111111		;Mask for pixels to keep
	sta z_c
	
	lda z_d	
	and #%00000111		;Xpos 0-3
	beq mpbitmap_setpixel_shiftdone
	tax
mpbitmap_setpixel_shiftagain:
	sec
	ror z_c				;Shift Mask
	dex 
	bne mpbitmap_setpixel_shiftagain
mpbitmap_setpixel_shiftdone:
	lda z_c
	eor #255
	sta z_b				;Mask for pixel to set
	
	ldy #0
	lda (z_hls),y		;Get Screen byte (Bitplane 0)
	and z_c				;Clear selected pixel
	ror z_iyh
	bcc mpbitmap_setpixel_Bit0
	ora z_b				;Set selected pixel according to bit 0
mpbitmap_setpixel_Bit0:
	sta (z_hls),y		;Save result
	
	ldy #8
	lda (z_hls),y		;Get Screen byte (Bitplane 0)
	and z_c				;Clear selected pixel
	ror z_iyh
	bcc mpbitmap_setpixel_Bit1
	ora z_b				;Set selected pixel according to bit 1
mpbitmap_setpixel_Bit1:
	sta (z_hls),y		;Save result
	
mpbitmap_setpixelabort:
	rts


mpbitmap_getpixel:	;LD=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos	;Get VRAM Source
	bcs mpbitmap_getpixeldone	;Offscreen?
		
	lda #%10000000		;Mask for pixels to keep
	sta z_c
	
	lda z_d	
	and #%00000111		;Xpos 0-3
	beq mpbitmap_getpixel_shiftdone
	tax
mpbitmap_getpixel_shiftagain:
	lsr z_c				;Shift screen byte
	dex
	bne mpbitmap_getpixel_shiftagain
mpbitmap_getpixel_shiftdone:
	
	ldx #0				;Resulting color
	
	ldy #0
	lda (z_hls),y		;Get Screen byte (Bitplane 0)
	and z_c
	beq mpbitmap_getpixel_Bit0	
	inx					;Set bit 0
mpbitmap_getpixel_Bit0:
		
	ldy #8
	lda (z_hls),y		;Get Screen byte (Bitplane 1)
	and z_c
	beq mpbitmap_getpixel_Bit1
	inx
	inx					;Set bit 1
mpbitmap_getpixel_Bit1:
	txa
mpbitmap_getpixeldone:
	rts
	
	
	
	