
NativeSpriteAddr: dw 0	

nativespriteactivebuffer:
    ds 32


;This version of nativesprite uses 6x6 blocks, to match PrintChar and MaxTile

	; ifndef z_ix

; z_ixl equ z_Regs+8
; z_ixh equ z_Regs+9
; z_ix equ z_Regs+8

; z_iyl equ z_Regs+10
; z_iyh equ z_Regs+11
; z_iy  equ z_Regs+10
	; endif

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
nativespr_drawone:
	pushpair z_de
	pushpair z_hl

		ldy #0
		lda (z_hl),y		;Ypos (Pairs of pixels)
		sta z_c

		iny
		lda (z_hl),y		;Xpos (Pairs of pixels)
		sta z_b

		iny
		lda (z_hl),y		;SpriteDef-L
		tax

		iny
		lda (z_hl),y		;SpriteDef-H
		sta z_h
		stx z_l

		lda z_b				;Zero pos?
		ora z_c
		beq nativespr_drawone_EmptySprite
		jsr nativespr_drawextra
nativespr_drawone_EmptySprite

	pullpair z_hl
	pullpair z_de
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
nativespr_drawextra:
nativespr_hide:
nativespr_draw:  ;bc=xy in pairs of pixels hl=spriteobject a=hspritenum 
	ldx #0
	lda (z_hl,x)
	bne lbl_8B4DxB0B8	;W=0?
	rts
lbl_8B4DxB0B8
	sta z_d			;Width
	jsr inchl

	lda (z_hl,x)
	sta z_e			;Height
	jsr inchl

	lda z_h
	sta z_iyh
	lda z_l
	sta z_iyl

drawnativespry:
	pushpair z_de
	pushpair z_bc
		lda z_d
		sta z_ixl		;Width for loop counter
drawnativesprx:

		ldx #0
		lda (z_iy,x)    ;0=empty sprite
		bne notdrawnativeskipx1
			jmp drawnativeskipx
notdrawnativeskipx1
		lda z_b

		sec
		sbc #vscreenminx
		cmp #vscreenwid
		bcc notdrawnativeskipx2
			jmp drawnativeskipx
notdrawnativeskipx2	
		;	clc
		;adc #2
		;and #%11111100 - Limit to whole tile/char movement
		sta z_b

drawnativeokx:
		lda z_c
		sec
		sbc #vscreenminy
		cmp #vscreenhei-2
		bcc notdrawnativeskipx3
			jmp drawnativeskipx
notdrawnativeskipx3
drawnativeoky:
		;clc
		;adc #2
		;and #%11111100 - Limit to whole tile/char movement
		sta z_c

;Calculate VRAM
;We scale co-ordinates down by 6/8ths (to match char size)
				
	lda z_c 		;Move Y into top byte 	= YYYYYYYY 00000000
	lsr				
	clc
	adc z_c			;+1/2 (6 lines per tile (4 Logical Units)
		
	stz z_c			;z_C=Lbyte A=High byte
	
	lsr				;Ypos *80 = (80=64+16)
	ror z_c
	lsr 
	ror z_c			;Shift Right Twice      = 00YYYYYY YY000000 
						;Y*64
	sta z_d			;Store High byte in total
	
	lda z_c			
	sta z_e			;Store Low byte in total
	
	lda z_d			;Shift Right Twice      = 0000YYYY YYYY0000
	lsr					;Y*16
	ror z_c
	lsr 
	ror z_c
	
	clc				;Add High byte to total
	adc z_d
	adc #$C0		;Screen base at &C000
	sta z_d
	
	lda z_c			;Add Low byte to total
	adc z_e
	sta z_e
	bcc GetScreenPos_NoHNS
	inc z_d			;Add any carry to the high byte
GetScreenPos_NoHNS:	
	
	clc				;Add the X pos 
	lda z_b
	lsr				;2 pixels per byte
	sta z_as
	lsr
	clc
	adc z_as		;+1/2 (3 bytes per tile (4 Logical Units))
	adc #1			;Center screen (add 1 byte)
		
	adc z_e
	sta z_e
	bcc GetScreenPos_NoH2NS
	inc z_d			;Add any carry to the high byte
GetScreenPos_NoH2NS:	
				
drawnativesprxfast:
		ldx #0
		lda (z_iy,x)      ;spritenum
		bne NOTdrawnativeskipf
			jmp drawnativeskipf
NOTdrawnativeskipf:
		ifdef LNX_NativeSprite_PatternOffset
			clc
			adc #LNX_NativeSprite_PatternOffset
		endif
		
		sta z_l
		stz z_h
		
;18 bytes per 6x6 sprite tile
		asl z_l		;*2
		rol z_h
		
		lda z_h
		sta z_as
		
		lda z_l
		asl 
		rol z_as	;*4
		asl 
		rol z_as	;*8
		asl 
		rol z_as	;*16
		
		adc z_l
		sta z_l
		
		
		lda z_as
		adc z_h
		sta z_h
		
		lda z_l
		clc
		adc nativespriteaddr
		sta z_l
		
		lda z_h
		adc nativespriteaddr+1
		sta z_h
		
;Transfer tile to screen
		lda z_d
		sta z_ds			;z_des is Dest used for this tile
		lda z_e
		sta z_es
		
		ldx #6				;Line
DrawTileMoreNS:		
		ldy #0
		lda (z_HL),y		;Get pattern byte
		eor (z_DEs),y	
		sta (z_DEs),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HL),y		;Get pattern byte
		eor (z_DEs),y	
		sta (z_DEs),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HL),y		;Get pattern byte
		eor (z_DEs),y	
		sta (z_DEs),y		;Write to screen
		iny					;Move to next byte
		
		tya
		clc
		adc z_L				;Update source pattern address
		sta z_L
		bcc DrawTileMoreCNS
		inc z_H
DrawTileMoreCNS:
		
		lda z_Es					
		clc
		adc #80				;Add 1 line to VRAM dest
		sta z_Es
		bcc DrawTileMoreBNS
		inc z_Ds			
DrawTileMoreBNS:				
		dex					;Repeat 6 times
		bne DrawTileMoreNS
				
drawnativeskipf:
		lda #3		;Across 3 bytes
		clc
		adc z_e
		sta z_e
		bcc drawnativeskipfDOK	
		inc z_d
drawnativeskipfDOK:
		
		lda z_b
		clc
		adc #4       ;6 pixels (8 on other systems)
		sta z_b

		cmp #4
		bcc drawnative_overrow		;Offscreen?
		cmp #104
		bcs drawnative_overrow

		jsr inciy

		dec z_ixl
		beq Notdrawnativesprxfast
			jmp drawnativesprxfast
Notdrawnativesprxfast:	
drawnative_overrowb:
drawnativeskip:
	pullpair z_bc
	pullpair z_de

	lda z_c
	clc
	adc #4       ;Down 6 pixels (8 on other systems)
	sta z_c

	dec z_e
	beq NOTdrawnativespry
	jmp drawnativespry
NOTdrawnativespry
	rts


drawnative_overrow:
drawnativeskipfb:
    jsr inciy		;We're offscreen so Skip a tile 
    dec z_ixl
	bne drawnativeskipfb
	jmp drawnative_overrowb
	
drawnativeskipx:
    jsr inciy
	
	lda z_b
	clc
	adc #4			;Across 6 pixels (8 on other systems)
	sta z_b

    dec z_ixl		;At end of line?
	beq NOTdrawnativesprx
	jmp drawnativesprx
NOTdrawnativesprx:
	jmp drawnativeskip

	


	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
;Draw Sprite Object Array (HL)

NativeSpr_DrawArrayReiKou:	
	jsr AddressRemapViaTableHL		;Used by ChibiVM for address remapping

nativespr_drawarray:
	;jsr updatexorbuffer
	loadpair z_de,nativespriteactivebuffer

nativespr_drawarrayalt:

	ldx #0
	lda (z_hl,x)      ;count
	sta (z_de,x)      ;Store in cache
	pha
		jsr incde
		jsr inchl	
	pla
nativespr_drawarrayb:
	beq nativespr_clearunused
	pha
		jsr nativespr_drawone_testone ;See if sprite needs redrawing
		bcc nativespr_nochange

		pushpair z_hl
			lda z_e
			sta z_l
			lda z_d
			sta z_h
			jsr nativespr_drawone	;Remove old sprite
		pullpair z_hl	
		jsr nativespr_drawone		;Draw New sprite

nativespr_nochange:
		ldy #4
		ldx #0
nativespr_nochangeAgain:	
		lda (z_hl,x)				;Copy New data into cache
		sta (z_de,x)
		jsr incHl
		jsr incde
		dey 
		bne nativespr_nochangeAgain
	pla
	sec
	sbc #1
	jmp nativespr_drawarrayb

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Compare sprite DE to HL, C=Different
; Used to decide if an XOR sprite needs redrawing

nativespr_drawone_testone:
	ldy #4-1			;We test 4 bytes total
	
nativespr_drawone_testoneb:
	
	lda (z_de),y		;Test this byte
	cmp (z_hl),y
	bne nativespr_drawone_fail	;Abort if mismatched
	
	dey
	bpl nativespr_drawone_testoneb
	
	clc					;CC=No Difference
	rts

nativespr_drawone_fail:
    sec					;CS=Difference 
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
NativeSpr_InitReiKou:
	jsr AddressRemapViaTableHL	;Used by ChibiVM for address remapping

nativespr_init:
	lda z_l
	sta nativespriteaddr		;Store the address of the pattern data
	lda z_h
	sta nativespriteaddr+1

nativespr_clearunused:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
		
nativespr_hideAll_Reikou:	
	
nativespr_hidearray:        ;for tilemap redraw
	loadpair z_hl,nativespriteactivebuffer	;Cache of what's onscreen

	ldx #0
	lda (z_hl,x)     	   ;count
	pha
		txa
		sta (z_hl,x)      ;Zero count (all sprites gone)
		jsr inchl
	pla
nativespr_drawarrayb2:
	beq nativespr_clearunused
	pha

		jsr nativespr_drawone	;Hide this sprite

nativespr_nochange2:
		ldy #4
		ldx #0
nativespr_nochangeAgain2:	
		txa
		sta (z_hl,x)			;Clear the 4 bytes in the cache
		jsr incHl
		dey 
		bne nativespr_nochangeAgain2
	pla
	sec
	sbc #1
	jmp nativespr_drawarrayb2 ;Repeat for the next sprite
	
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	
	
; AddHL_DE:				;Add DE to HL
	; clc
; AdcHL_DE				;Add DE to HL
	; lda z_e			;Add E to L
	; adc z_l
	; sta z_l
	; lda z_d			;Add D to H (with any carry)
	; adc z_h
	; sta z_h
	; jmp *
	; rts

	; ifndef IncIY
; IncIY:
	; INC z_IYL
	; BNE	IncIY_Done
	; INC	z_IYH
; IncIY_Done:
	; rts	
	; endif