MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 4
MPB_Pen5 equ 5
MPB_Pen6 equ 6
MPB_Pen7 equ 7
MPB_Pen8 equ 8
MPB_Pen9 equ 9
MPB_PenA equ 10
MPB_PenB equ 11
MPB_PenC equ 12
MPB_PenD equ 13
MPB_PenE equ 14
MPB_PenF equ 15

mpbitmap_tiletints:
	db 255,0,0

	
mpbitmap_getscreenposTile:	;D=Xpos E=Ypos (Tiles)
	sta z_As	;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
	asl z_d		;Tiles2Pixels
	asl z_e
	dex
	bne mpbitmap_getscreenposShift
		
	lda #8
	sta z_b	;Linecount
				
mpbitmap_GetScreenPos:		;D=Xpos E=Ypos (Pixels)
	sta z_iyh		;Color number
	
	lda z_d
	sta z_iyl		;Backup Xpos
	lsr
	sta z_d			;X pixels to bytes
	
	cmp #80			;Xpos OK?
	bcs mpbitmap_GetScreenPos_Offscreen
	lda z_e
	
	cmp #102		;Ypos OK?
	bcs mpbitmap_GetScreenPos_Offscreen

	ldx #0
	txa
	lsr z_e			;Y is top byte 		    = YYYYYYYY 00000000
	ror
	lsr z_e 		;			 80 bytes per line  =  01010000
	ror 			;Shift Right Twice      = 00YYYYYY YY000000
	tay
		adc z_d
		sta z_ls	;Store Low byte in total
	
		lda z_e
		adc #$C0	;Screen base at &C0000
		sta z_hs	;Store High byte in total	
	tya	 			;			 80 bytes per line  =  01010000
	lsr z_e			;Shift Right Twice      = 0000YYYY YYYY0000
	ror 
	lsr z_e
	ror 
	adc z_ls
	sta z_ls
	
	lda z_e			;Add High byte to total
	adc z_hs
	sta z_hs
	
	clc				;Clear Carry (Draw OK)
	rts
mpbitmap_GetScreenPos_Offscreen:
	
	sec				;Set Carry (Offscreen)
mpbitmap_gettileabort:
	rts
	
	
	

;HL = Destination Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile	;Get VRAM address
	bcs mpbitmap_gettileabort		;Offscreen?

mpbitmap_gettile_nextline:
	ldy #0				
	
mpbitmap_gettile_xbyte:
	lda (z_hls),y		;Load a byte4 from the screen
	iny
	
	rol
	rol z_bs			;Bitplane 3
	rol
	rol z_cs			;Bitplane 2
	rol
	rol z_ds			;Bitplane 1
	rol
	rol z_es			;Bitplane 0
	
	rol
	rol z_bs			;Bitplane 3
	rol
	rol z_cs			;Bitplane 2
	rol
	rol z_ds			;Bitplane 1
	rol
	rol z_es			;Bitplane 0
	
	cpy #4
	bne mpbitmap_gettile_xbyte

	ldy z_As			;Bitplane Count

	lda z_es			;Bitplane 0
	sta (z_hl,x)	
	jsr inchl			;Store result
	dey
	beq mpbitmap_gettile_loaddone
	
	lda z_ds			;Bitplane 1
	sta (z_hl,x)
	jsr inchl			;Store result
	dey
	beq mpbitmap_gettile_loaddone

	lda z_cs			;Bitplane 2
	sta (z_hl,x)
	jsr inchl			;Store result
	dey
	beq mpbitmap_gettile_loaddone
	
	lda z_bs			;Bitplane 3
	sta (z_hl,x)
	jsr inchl			;Store result
	dey

mpbitmap_gettile_loaddone:
	lda z_ls
	clc
	adc	#80				;Down a VRAM line
	sta z_ls	
	bcc mpbitmap_gettile_hok
	inc z_hs
mpbitmap_gettile_hok
	
	dec z_b
	bne mpbitmap_gettile_nextline

mpbitmap_settileabort:
	rts




;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile	;Get VRAM address
	bcs mpbitmap_settileabort		;Offscreen?
	
mpbitmap_settile_yline:	
	ldy #0
	ldx z_As		;Bitplane count
	
	ifdef MpBitmap_TileTints
		lda mpbitmap_tiletints
		sta z_ds
		lda mpbitmap_tiletints+1
		sta z_cs
		lda mpbitmap_tiletints+2
		sta z_bs
	else 
		sty z_ds	;Load Bitplane defaults
		sty z_cs
		sty z_bs
	endif
	
	lda (z_hl),y	;Bitplane 0
	jsr IncHL
	sta z_es
	dex
	beq mpbitmap_settile_bitplanesdone
	
	lda (z_hl),y	;Bitplane 1
	jsr IncHL
	sta z_ds
	dex
	beq mpbitmap_settile_bitplanesdone
	
	lda (z_hl),y	;Bitplane 2
	jsr IncHL
	sta z_cs
	dex
	beq mpbitmap_settile_bitplanesdone
	
	lda (z_hl),y	;Bitplane 3
	jsr IncHL
	sta z_bs
mpbitmap_settile_bitplanesdone:
	
mpbitmap_settile_xbyte:
	rol z_bs		;Bitplane 3
	rol
	rol z_cs		;Bitplane 2
	rol
	rol z_ds		;Bitplane 1
	rol
	rol z_es		;Bitplane 0
	rol
	
	rol z_bs		;Bitplane 3
	rol
	rol z_cs		;Bitplane 2
	rol
	rol z_ds		;Bitplane 1
	rol
	rol z_es		;Bitplane 1
	rol
	
	sta (z_hls),y
	iny			
	cpy #4		;4 Bytes per line 
	bne mpbitmap_settile_xbyte

	lda z_ls
	clc	
	adc	#80		;Down a VRAM line 
	sta z_ls	
	
	bcc mpbitmap_settile_hok
	inc z_hs
mpbitmap_settile_hok
	
	dec z_b
	bne mpbitmap_settile_yline
	rts

	
	
mpbitmap_setpixel:		;D=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos	;Get VRAM
	bcs mpbitmap_setpixelabort	;Offscreen?
	
	lda #%11110000				;Pixel
	sta z_c
	
	lsr z_iyl					;Test Xpos Bit 0
	bcs mpbitmap_setpixel_shiftdone
	ldx #4
mpbitmap_setpixel_shiftagain:
	lsr z_c						;Shift Mask
	asl z_iyh					;Shift Color
	dex 
	bne mpbitmap_setpixel_shiftagain
mpbitmap_setpixel_shiftdone:
	
	lda (z_hls,x)				;Load screen byte
	and z_c						;Mask pixel to keep
	ora z_iyh					;Set pixel to change
	sta (z_hls,x)				;Write resutlt to screen
mpbitmap_setpixelabort:
	rts


mpbitmap_getpixel:		;D=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos	;Get VRAM
	bcs mpbitmap_getpixeldone	;Offscreen?
	
	lda (z_hls,x)				;Get Byte
	
	lsr z_iyl					;Test Xpos Bit 0
	bcs mpbitmap_getpixeldone
	lsr							;Shift Right pixel -> Left
	lsr
	lsr
	lsr
mpbitmap_getpixeldone:

	and #%00001111				;Return Color 0-15
	rts
	
	