
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


DrawTile:	
	;ldx #0
	;ldy #0	;-safe to assume Y=0
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		beq NotDrawTileAdvanced
			jmp DrawTileAdvanced
NotDrawTileAdvanced:
	endif
	asl
	sta (z_bcs),y			;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
	
DrawTileBasicOnly:
	and #%11110000			;%nnnn----
	sta z_ls
	pha
		lda (z_bcs),y		;%NNNNNNNN 
		sta z_hs
		sta z_b
	pla
		
	lsr z_b	;Tiles are 6x6 pixels = 3*6 bytes (18 bytes= 16+2)	
	ror 		;*8
	lsr z_b
	ror 		;*4
	lsr z_b
	ror 		;*2
	clc
	adc z_ls	;Add to *16 value
	sta z_ls
	
	lda z_hs
	adc z_b
	sta z_hs	;HL=Bitmap Source

	lda z_ls
	clc
	adc z_es	;Add DE pattern base
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
			
	;jsr z_exx
	dey ;ldy #0
	
	lda z_h
	pha
	lda z_l
	pha
		ldx #6			;Lines
DrawTileMore:		
		ldy #0
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		tya
		clc
		adc z_Ls			;Update source pattern address
		sta z_Ls
		bcc DrawTileMoreC
		inc z_Hs
DrawTileMoreC:
		
		lda z_L					
		clc
		adc #80				;Add 1 line to VRAM dest
		sta z_L
		bcc DrawTileMoreB
		inc z_H			
DrawTileMoreB:				
		dex					;Repeat 6 times
		bne DrawTileMore
MaxTileFinish:
	pla
	sta z_l
	pla 
	sta z_h
	
	ldy #0
	jmp TileDoneBCs_Plus2


DrawTileAdvanced:	
	and #%00000110
	bne NotDrawTileCustom
		jmp DrawTileCustom
NotDrawTileCustom:
	lda (z_bcs),y
	and #%11111110
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnly
	endif

	and #%11110000	;nnnn---
	sta z_ls
	pha
		lda (z_bcs),y
		sta z_hs
		sta z_b
	pla
	
	
	lsr z_b	;Tiles are 6x6 pixels = 3*6 bytes (18 bytes= 16+2)	
	ror 		;*8
	lsr z_b
	ror 		;*4
	lsr z_b
	ror 		;*2
	clc
	adc z_ls
	sta z_ls
	
	lda z_hs
	adc z_b
	sta z_hs	;HL=Bitmap Source

	lda z_ls
	clc
	adc z_es	;Add DE pattern base
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	

	dey		
	lda (z_bcs),y

	bit LookupBits+2
	beq NotDrawTileYFlip
		jmp DrawTileYFlip
NotDrawTileYFlip:

;DrawTileXflip	
	lda z_h
	pha
	lda z_l
	pha
		lda #>FlipLUT	;X-Flip LUT
		sta z_b
	
		lda #6		;6 lines
DrawTileMoreRev:		
		ldy #2		;3 bytes per line
		pha
DrawTileMoreRevB:					
			lda (z_HLs,x) 	;Get pattern byte
			
			inc z_Ls		;Next Pattern Byte
			bne DrawTileMoreCRev
			inc z_Hs
DrawTileMoreCRev:				
			
			sta z_c			;Set LUT Entry 
			lda (z_bc,x)	;Read Xflipped from LUT
			sta (z_HL),y	;Write Xfliped byte
			
			dey				;Move to previous VRAM byte
			bpl DrawTileMoreRevB ;<0?
			
			lda z_L
			clc
			adc #80			;Down a line
			sta z_L
			bcc DrawTileMoreNoHRev
			inc z_H			
DrawTileMoreNoHRev:			
		pla
		sec
		sbc #1	;Decrease Line count
		bne DrawTileMoreRev
	
		jmp MaxTileFinish
	
	
	
DrawTileEmpty:
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTransp
	
	ldy #0
	jmp TileDoneBCs_Plus2

DrawTileTransp:;;;;;;;;;;;;;;;;;;Transparent
	asl 
	rol z_b		;*2
	
	sta z_ls
	pha 
		lda z_b
		sta z_hs
	pla 
	
	asl 
	rol z_b		;*4
	asl 
	rol z_b		;*8
	asl 
	rol z_b		;*16
	
	clc
	adc z_ls	;Add to *2
	sta z_ls
	
	lda z_hs
	adc z_b
	sta z_hs
		
	lda z_ls
	clc
	adc z_es	;Add DE pattern base
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
			
	dey ;ldy #0
	
	lda z_h
	pha
	lda z_l
	pha
		ldx #6			;Lines
DrawTileMoreT:		
		ldy #0
		lda (z_HLs),y		;Get pattern byte
		beq DrawTileMoreT1
		sta (z_HL),y		;Write to screen
DrawTileMoreT1:		
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		beq DrawTileMoreT2
		sta (z_HL),y		;Write to screen
DrawTileMoreT2:		
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		beq DrawTileMoreT3
		sta (z_HL),y		;Write to screen
DrawTileMoreT3:		
		iny					;Move to next byte
		
		tya
		clc
		adc z_Ls			;Update source pattern address
		sta z_Ls
		bcc DrawTileMoreCT
		inc z_Hs
DrawTileMoreCT:
	
		jsr DrawTileDownALine

		dex					;Repeat 6 times
		bne DrawTileMoreT
		jmp MaxTileFinish
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustom:
		lda (z_bcs),y 			;NN------ - top bits of tilenum
		and #%11111110
		sta (z_bcs),y 
		rol
		rol	
		rol
		and #%00000011			;------NN
		sta z_hs
		sta z_b
		
		lda (z_bcs),y ; ld a,(bc)
		and #%00110000			;Cmd Bits ;NNCC001-
		bne NotDrawTileFill
			jmp DrawTileFill	;--00----
NotDrawTileFill:
		cmp #%00110000			;--11----
		bne NotDrawTileEmpty	
			jmp DrawTileEmpty
NotDrawTileEmpty:
	
DrawTileDouble:	
	iny 
	lda (z_bcs),y
	sta z_ls	;We need to multiply by 9 (half 18)
	
	asl 
	rol z_b		;*2
	asl 
	rol z_b		;*4
	asl 
	rol z_b		;*8
	
	clc
	adc z_ls	;Add to *1
	sta z_ls
	lda z_b
	adc z_hs
	sta z_hs
	
	lda z_ls
	clc
	adc z_es	;Add DE pattern base
	sta z_ls
	lda z_hs
	adc z_ds
	sta z_hs
			
	dey ;ldy #0
	
	lda z_h
	pha
	lda z_l
	pha
		ldx #3			;Lines
		ldy #0
DrawTileMoreD:		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		jsr DrawTileDownALine
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		tya
		clc
		adc z_Ls			;Update source pattern address
		sta z_Ls
		bcc DrawTileMoreCD
		inc z_Hs
DrawTileMoreCD:
		jsr DrawTileDownALine
			
		dex					;Repeat 6 times
		bne DrawTileMoreD
		jmp MaxTileFinish
	
		
DrawTileFill:
	iny
	lda (z_bcs),y
	adc z_es
	sta z_ls

	lda z_hs
	adc z_ds
	sta z_hs
		
	dey ;ldy #0
	lda (z_HLs),y		;Read a source byte
	sta z_d
	iny					;Down a line 	+40
	lda (z_HLs),y		;Read a source byte
	sta z_e
	
	dey ;ldy #0
	lda z_h
	pha
	lda z_l
	pha
		ldx #3			;Lines
DrawTileMoreF:		
		ldy #0
		lda z_e
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		jsr DrawTileDownALine
	
		lda z_d
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		jsr DrawTileDownALine
		
		dex					;Repeat 6 times
		bne DrawTileMoreF	
		jmp MaxTileFinish

		
DrawTileDownALine:
	lda z_L					
	clc
	adc #80				;Add 1 line to VRAM dest
	sta z_L
	bcc DrawTileMoreBF
	inc z_H			
DrawTileMoreBF:
	ldy #0
	rts	
	
	
DrawTileXYflip:
	lda z_h
	pha
	lda z_l
	pha
		;lda z_l
		clc
		adc #$90			;Down 5 Lines
		sta z_l
		lda z_h
		adc #$1
		sta z_h
			
		lda #>FlipLUT	;X-Flip LUT
		sta z_b
	
		lda #6			;6 lines
DrawTileMoreRevXY:		
		ldy #2			;3 bytes per line
		pha
DrawTileMoreRevBXY:
			lda (z_HLs,x) 	;Get pattern byte
			
			inc z_Ls		;Next Pattern Byte
			bne DrawTileMoreCRevXY
			inc z_Hs
DrawTileMoreCRevXY:				
			
			sta z_c			;Set LUT Entry 
			lda (z_bc,x)	;Read Xflipped from LUT
			sta (z_HL),y	;Write Xfliped byte
			
			dey				;Move to previous VRAM byte
			bpl DrawTileMoreRevBXY ;<0?
			
			lda z_L
			sec
			sbc #80			;Up a line
			sta z_L
			bcs DrawTileMoreNoHRevXY
			dec z_H			
DrawTileMoreNoHRevXY:			
		pla
		sec
		sbc #1				;Decrease Line count
		bne DrawTileMoreRevXY
	
		jmp MaxTileFinish
	
	
DrawTileYflip:
	bit LookupBits+3
	beq NotDrawTileXYFlip
		jmp DrawTileXYFlip
NotDrawTileXYFlip:

	lda z_h
	pha
	lda z_l
	pha
		;lda z_l
		clc
		adc #$90			;Down 5 Lines
		sta z_l
		lda z_h
		adc #$1
		sta z_h
		
		ldx #6			;Lines
DrawTileMoreY:		
		ldy #0
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		lda (z_HLs),y		;Get pattern byte
		sta (z_HL),y		;Write to screen
		iny					;Move to next byte
		
		tya
		clc
		adc z_Ls			;Update source pattern address
		sta z_Ls
		bcc DrawTileMoreCY
		inc z_Hs
DrawTileMoreCY:
		
		lda z_L					
		sec
		sbc #80				;Subtract 1 line to VRAM dest
		sta z_L
		bcs DrawTileMoreBY
		dec z_H			
DrawTileMoreBY:		
		
		dex					;Repeat 6 times
		bne DrawTileMoreY

		jmp MaxTileFinish
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	;Vram= $C000 + YposInLines * 80 + Xpos in bytes
	

GetScreenPos:
	lda z_c 		;Move Y into top byte 	= YYYYYYYY 00000000
	
	and #%11111100		;Limit to whole tile movement
	sta z_c 			;Limit to whole tile movement
	
	lsr				
	clc
	adc z_c			;+1/2 (6 lines per tile (4 Logical Units)
		
	stz z_c			;z_C=Lbyte A=High byte
	
	lsr				;Ypos *80 = (80=64+16)
	ror z_c
	lsr 
	ror z_c			;Shift Right Twice      = 00YYYYYY YY000000 
						;Y*64
	sta z_h			;Store High byte in total
	lda z_c			
	sta z_l			;Store Low byte in total
	
	lda z_h			;Shift Right Twice      = 0000YYYY YYYY0000
	lsr					;Y*16
	ror z_c
	lsr 
	ror z_c
	
	clc			;Add High byte to total
	adc z_h
	adc #$C0	;Screen base at &C000
	sta z_h
	
	lda z_c			;Add Low byte to total
	adc z_l
	sta z_l
	
	bcc GetScreenPos_NoH
	inc z_h			;Add any carry to the high byte
GetScreenPos_NoH:	
	
	clc				;Add the X pos 
	lda z_b
	and #%11111100		;Limit to whole tile movement
	lsr				
	sta z_b
	lsr
	clc
	adc z_b			;+1/2 (3 bytes per tile (4 Logical Units))
	adc #1			;Center screen (add 1 byte)
		
	adc z_l 
	sta z_l
	
	bcc GetScreenPos_NoH2
	inc z_h			;Add any carry to the high byte
GetScreenPos_NoH2:	
	rts
	
	
