
;HL= Sprite Pattern data
;BC= Bytecount  (64 byte per pattern - 24x21 pixels)

NativeSpr_InitReiKou:
	jsr AddressRemapViaTableHL
NativeSpr_Init:

	lda #<(C64_SpritePatternVram)	;Will only work when scrBase@ $4000 due to chrom
	sta z_E							;Sprite settings at $47F8-$47FF
	lda #>(C64_SpritePatternVram)	;Sprites at $5000-$5FFF, screen at $6000
	sta z_D
	
	ldx #0
NativeSpr_Init_SendSprites:
	lda (z_hl,x)
	sta (z_de,x)
	jsr IncHL
	jsr IncDE
	jsr DecBC
	
	lda z_b
	ora z_c
	bne NativeSpr_Init_SendSprites
	
;Used by multicolor sprites
	ifdef C64_Multicolor1
		lda #C64_Multicolor1
		sta $D025	;Sprite extra color #1
	endif
	ifdef C64_Multicolor2
		lda #C64_Multicolor2
		sta $D026	;Sprite extra color #2
	endif
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
NativeSpr_Sizes:
	db 24,21		;0 Normal
	db 48,21		;1 DoubleWid
	db 24,42		;2 DoubleHei
	db 48,42		;3 DoubleHei+DoubleWid

NativeSpr_DrawExtra:
	lda HspriteCount		;Sprnum
	jsr NativeSpr_Draw
	sta HspriteCount		;Sprnum
	rts
	
NativeSpr_DrawNoSprite:
	pla
	rts

NativeSpr_Draw:	;BC=XY in pairs of pixels	A=hspriteNum   HL=Object def
	pha		 				
		ldx #0

		lda z_c			;Ypos
		sec
		sbc #80-(50/2)
		asl
		sta z_iyl		;Ypos
		
		
		stx z_c			;X=0
		lda z_b			;Xpos
		sec
		sbc #64-(24/2)
		asl 
		rol z_c			;Top bit of Xpos
		sta z_cs		;Xpos
			
			
		lda (z_hl,x)
		sta z_d			;W
		beq NativeSpr_DrawNoSprite
		jsr IncHL
		
		lda (z_hl,x)
		sta z_e			;H
		jsr IncHL
				
		lda (z_hl,x)
		sta z_ls		;AttribL
		asl
		tay				;Attrib->Y
		jsr IncHL
		
		lda NativeSpr_Sizes,y
		sta z_ds		;Wid
		lda NativeSpr_Sizes+1,y
		sta z_es		;Hei
		
NativeSpr_DrawY:
		lda z_d
		sta z_bs		;Width
		
		lda z_cs
		sta z_ixl		;Xpos
		lda z_c
		sta z_ixh		;8th bit of X
		
		
NativeSpr_DrawX:
	pla
	pha
		cmp #8
		bcc NotNativeSpr_NoSpritesLeft
			jmp NativeSpr_NoSpritesLeft
NotNativeSpr_NoSpritesLeft
		
		;ldx #0
		lda (z_hl,x)		;Attribs
		sta z_hs
		jsr IncHL
	pla
	pha
		tay					;Sprite Number
		lda $D015
		ora LookupBits,y	;Turn on Sprite Y
		sta $D015			;Sprite on
		
		ldx #$1C			;4 color
		lda #%00010000		;Want bit 4 form z_L
		and z_hs			;Mask one of the bits in z_ixh
		jsr C64SpriteConvertToMaskB
		
		ldx #$17			;DoubleHeight
		lda #%00000010		;Want bit  from z_hs
		jsr C64SpriteConvertToMask
				
		ldx #$1D			;DoubleWidth	
		lda #%00000001		;Want bit  from z_hs
		jsr C64SpriteConvertToMask
		
		lda (z_hl,x)		;Sprite VRAM Address >>5
		sta $47F8,y			;Pointer (ScrBase+$07F8)
		jsr IncHL
		
		lda z_hs			;Color
		and #%00001111
		sta $D027,y			;Color
		
		ldx #$10			;8th bit of X
		lda #%00000001
		and z_ixh			;8th bit of X
		jsr C64SpriteConvertToMaskB
		
		tya					
		asl					;SpriteNum *2
		tay	
		lda z_ixl
		sta $D000,y			;X-pos
		lda z_iyl
		sta $D001,y			;Y-pos
	pla
	;clc
	adc #1
	pha
NativeSpr_NoSpritesLeft:
		lda z_ixl
		clc
		adc z_ds			;Move one pattern across
		sta z_ixl
		
		dec z_bs
		beq NotNativeSpr_DrawX
		jmp NativeSpr_DrawX
NotNativeSpr_DrawX:		
		lda z_iyl
		clc
		adc z_es
		sta z_iyl
	
		dec z_e
		beq NotNativeSpr_DrawY
		jmp NativeSpr_DrawY
NotNativeSpr_DrawY
	pla
	rts
	
	
C64SpriteConvertToMask:		;Set $D000+X  for sprite Y
	and z_ls
C64SpriteConvertToMaskB:
	beq C64SpriteConvertToMaskZero ;Zero, so leave A=0
	lda LookupBits,y	;A= Bit Y=1
C64SpriteConvertToMaskZero:
	sta z_as
	eor #255
	;lda LookupMaskBits,y ;Mask to clear bit
	and $D000,X
	ora z_as
	sta $D000,X 			;8th bit of X
	ldx #0
	rts
		

LookupBits: 	db %00000001,%00000010,%00000100,%00001000
				db %00010000,%00100000,%01000000,%10000000

;LookupMaskBits: db %11111110,%11111101,%11111011,%11110111
;				 db %11101111,%11011111,%10111111,%01111111



	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	


NativeSpr_DrawArrayReiKou:			
	jsr AddressRemapViaTableHL
	
NativeSpr_DrawArray:	;Draw Sprite Array (HL)
	ldx #0				;X=Zero throughout
	stx HspriteCount
			
	lda (z_hl,x)
	beq NativeSpr_ClearUnusedb2 ;We're done, so check any remaining
	jsr IncHL
	
NativeSpr_DrawArrayB:	
	pha					 
		ldy #0
		lda (z_hl),y	;Xpos (Pairs of pixels)
		sta z_c
		iny
		lda (z_hl),y	;Ypos (Pairs of pixels)
		sta z_b	
		iny
		lda (z_hl),y	;SpriteDef-L
		sta z_ls
		iny
		lda (z_hl),y	;SpriteDef-H
		sta z_hs
		iny
		tya
		clc
		adc z_l
		pha				;Backup HL+Y
		lda z_h
		adc #0
		pha		
			lda z_hs
			sta z_h
			lda z_ls
			sta z_l
			
			jsr NativeSpr_DrawExtra	;HL=sprite data  BC=XY pos
		pla
		sta z_h
		pla 			;Restore HL
		sta z_l
	pla
	sec
	sbc #1
	bne NativeSpr_DrawArrayB	;Repeat for next object
NativeSpr_ClearUnusedb2:
	;jmp NativeSpr_ClearUnused
	
	
NativeSpr_ClearUnused:
	ldx HspriteCount
NativeSpr_ClearUnusedC:	
	cpx #8
	bcs NativeSpr_ClearUnusedB
	txa
	jsr NativeSpr_Hide
	inx
	bpl NativeSpr_ClearUnusedC	;should always be true
	
NativeSpr_ClearUnusedB:	
	rts
	
nativespr_hideAll_Reikou:
	ldx #0
	stx HspriteCount
	beq NativeSpr_ClearUnusedC	;Always EQ
	
	
NativeSpr_Hide:
	asl					;XY co-ordinate are pair of bytes
	tay
	lda #0
	sta $D000,y			;Xpos=0
	sta $D001,y			;Ypos=0
	rts
	
	
	
	