
	
	
MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 4
MPB_Pen5 equ 5
MPB_Pen6 equ 6
MPB_Pen7 equ 7
MPB_Pen8 equ 8
MPB_Pen9 equ 9
MPB_PenA equ 10
MPB_PenB equ 11
MPB_PenC equ 12
MPB_PenD equ 13
MPB_PenE equ 14
MPB_PenF equ 15

mpbitmap_tiletints:
	db 255

	
mpbitmap_getscreenposTile:
	sta z_As		;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
	asl z_e			;Ypos to pixels
	dex
	bne mpbitmap_getscreenposShift
	
	lda z_d			;Xpos
	ifndef C64_FourColor_HalfRes	
		asl
	endif
	jmp mpbitmap_GetScreenPosB
	
	
mpbitmap_GetScreenPos:	;LD=Xpos E=ypos
	ldx #0			
		
	ifdef C64_FourColor_HalfRes
		lsr z_l		
		ror z_d
	endif 
	lda z_d			;Xpos to bytes
	lsr				;4 pixels per byte
	lsr
mpbitmap_GetScreenPosB:	
	cmp #40
	bcs mpbitmap_GetScreenPos_Offscreen
	
	
	stx z_b			;X=0
	stx z_hs
	
	asl				;-------- XXXXXXXX
	rol z_hs
	asl
	rol z_hs
	asl
	rol z_hs		;-----XXX XXXXX---
	sta z_ls

;40 bytes per Yline =00000000 00101000
	lda z_e
	and #%11111000	;00000000 YYYYYyyy
	asl
	rol z_b
	asl
	rol z_b
	asl				;00000000 00101000
	rol z_b			;00000YYY YYyyy000
	tay 
		adc z_ls	;Add part to total L
		sta z_ls
		lda z_b		;Add part to total H
		adc z_hs
		sta z_hs
	tya 
	asl
	rol z_b
	asl				;00000000 00101000
	rol z_b			;000YYYYY yyy00000
	
	adc z_ls		;Add part to total L
	sta z_ls
	lda z_b			;Add part to total H
	adc z_hs
	adc #$60		;Screen Base $4000+$2000
	sta z_hs
	
	lda z_e
	and #%00000111	;00000000 YYYYYyyy
	clc
	adc z_ls
	sta z_ls	
		
	clc				;Carry Clear = OK to Draw
	rts
	
mpbitmap_GetScreenPos_Offscreen:	
	sec				;Carry Set = Offscreen
mpbitmap_GettileAbort:
	rts
		
	
;HL = Destination Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile
	bcs mpbitmap_GettileAbort		;Offscreen?
		
	ifndef C64_FourColor_HalfRes
		lda z_hs		;Second column address
		sta z_bs
		
		lda z_ls
		clc
		adc #8
		sta z_cs
	endif 
	
	ldy #0	
mpbitmap_gettile_nextline:
	lda z_As
	sta z_b			;Bitplane count
		
	lda (z_hls),y	;Column 0
	ldx #4
mpbitmap_gettile_nextpixel1:	
	rol 
	rol z_d			;Shift screen byte into bitplane 1
	rol 
	rol z_e			;Shift screen byte into bitplane 0
	ifdef C64_FourColor_HalfRes	
		asl z_d
		asl z_e
	endif
	dex 
	bne mpbitmap_gettile_nextpixel1
	
	ifndef C64_FourColor_HalfRes	
		lda (z_bcs),y	;Column 1
		ldx #4
mpbitmap_gettile_nextpixel2:	
		rol 
		rol z_d		;Shift screen byte into bitplane 1
		rol 
		rol z_e		;Shift screen byte into bitplane 0
		dex 
		bne mpbitmap_gettile_nextpixel2
	endif 
	
	lda z_e				;Bitplane 0
	sta (z_hl,x)	
	jsr inchl
	dec z_b
	beq mpbitmap_gettile_loaddone
	
	lda z_d				;Bitplane 1
	sta (z_hl,x)	
	jsr inchl
	dec z_b
	beq mpbitmap_gettile_loaddone

mpbitmap_gettile_loadagain:	
	txa	;x=0
	sta (z_hl,x)		;Bitplane 2/3
	jsr inchl
	dec z_b
	bne mpbitmap_gettile_loadagain

mpbitmap_gettile_loaddone:
	iny					;Down a line in VRAM
	cpy #8				;Done all lines?
	bne mpbitmap_gettile_nextline
mpbitmap_settileAbort:
	rts



;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile
	bcs mpbitmap_settileAbort		;Offscreen?
	
	ifndef C64_FourColor_HalfRes
		lda z_hs	;Second column address
		sta z_bs
		
		lda z_ls
		clc
		adc #8
		sta z_cs
	endif 
			
	ldy #0				;Linecount
mpbitmap_settile_yline:	
	
	ifdef mpbitmap_tiletints
		lda mpbitmap_tiletints
		sta z_ds		;Bitplane 1 tint
	else 
		stx z_ds
	endif 
	
	lda z_As			;Bitplane count
	sta z_b
		
	lda (z_hl,x)		;Bitplane 0
	jsr IncHL
	sta z_es

	dec z_b
	beq mpbitmap_settile_bitplanesdone
	
	lda (z_hl,x)		;Bitplane 1
	sta z_ds	
	
mpbitmap_settile_skipbitplane:	
	jsr IncHL			;skip Bitplanes 2/3
	dec z_b
	bne mpbitmap_settile_skipbitplane
		
mpbitmap_settile_bitplanesdone:			
	ifndef C64_FourColor_HalfRes	
		ldx #4			;Pixels to use
	else
		ldx #2
	endif
	
mpbitmap_settile_NextPixel:		
	rol z_ds			;Shift bitplane 1 into byte
	rol
	rol z_es			;Shift bitplane 0 into byte
	rol
	ifdef C64_FourColor_HalfRes	
		rol z_ds
		rol z_es
	endif 
	dex 
	bne mpbitmap_settile_NextPixel

	ifndef C64_FourColor_HalfRes	
		sta (z_hls),y	;Store Left Screen Byte
	
		ldx #4			;Pixels to use
	else
		ldx #2
	endif
mpbitmap_settile_NextPixel2:		
	rol z_ds			;Shift bitplane 1 into byte
	rol
	rol z_es			;Shift bitplane 0 into byte
	rol
	ifdef C64_FourColor_HalfRes	
		rol z_ds
		rol z_es
	endif 
	dex 
	bne mpbitmap_settile_NextPixel2
	
	ifndef C64_FourColor_HalfRes	
		sta (z_bcs),y	;Store Right Screen Byte
	else
		sta (z_hls),y	;Store Screen Byte (HalfWidth)
	endif 
			
	iny					;Next VRAM Line
	cpy #8				;Done all lines?
	bne mpbitmap_settile_yline
	rts

	
	
mpbitmap_setpixel:	;LD=Xpos E=Ypos A=Color
	and #%00000011
	sta z_iyh			;Color number

	jsr mpbitmap_getscreenpos	;Get VRAM Destination
	bcs mpbitmap_setpixelabort	;Offscreen?
	
	lda #%11111100		;Mask for pixels to keep
	sta z_c
	
	lda z_d	
	and #%00000011		;Xpos 0-3
	eor #%00000011
	beq mpbitmap_setpixel_shiftdone
	asl					;2 bits per pixel
	tax
mpbitmap_setpixel_shiftagain:
	sec
	rol z_c				;Slift Mask
	asl z_iyh			;Shift color
	dex 
	bne mpbitmap_setpixel_shiftagain
	
mpbitmap_setpixel_shiftdone:
	ldx #0
	lda (z_hls,x)		;Get Screen byte
	and z_c
	ora z_iyh
	sta (z_hls,x)
mpbitmap_setpixelabort:
	rts


mpbitmap_getpixel:	;LD=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos	;Get VRAM Source
	bcs mpbitmap_getpixeldone	;Offscreen?
	
	lda (z_hls,x)		;Get byte from screen
	sta z_c
	
	lda z_d
	and #%00000011		;Xpos 0-3
	eor #%00000011
	beq mpbitmap_getpixel_shiftdone
	asl					;2 bits per pixel
	tax
mpbitmap_getpixel_shiftagain:
	lsr z_c				;Shift screen byte
	dex
	bne mpbitmap_getpixel_shiftagain
mpbitmap_getpixel_shiftdone:
	lda z_c
	and #%00000011		;Return color 0-3
mpbitmap_getpixeldone:
	rts
	
	