
	
MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 4
MPB_Pen5 equ 5
MPB_Pen6 equ 6
MPB_Pen7 equ 7
MPB_Pen8 equ 8
MPB_Pen9 equ 9
MPB_PenA equ 10
MPB_PenB equ 11
MPB_PenC equ 12
MPB_PenD equ 13
MPB_PenE equ 14
MPB_PenF equ 15


mpbitmap_getscreenposTile: ;LD=Xpos E=ypos (Bytes)
	sta z_As	;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
	asl z_e
	dex
	bne mpbitmap_getscreenposShift
		
	lda z_d	;Xpos in bytes
	
	jmp mpbitmap_GetScreenPosB
				
				
mpbitmap_GetScreenPos:	;LD=Xpos E=ypos (Pixels)
	lda z_d			;Xpos
	
	ldx #3			;8 pixels per byte
mpbitmap_GetScreenPos_ShiftX:	
	lsr z_l
	ror				;Xpos Pixels-> Bytes
	dex	
	bne mpbitmap_GetScreenPos_ShiftX

mpbitmap_GetScreenPosB:	
	stx z_b			;X=0
	stx z_hs
	
	asl				;-------- XXXXXXXX
	rol z_hs
	asl
	rol z_hs
	asl
	rol z_hs		;-----XXX XXXXX---
	sta z_ls

;40 bytes per Yline =00000000 00101000
	lda z_e
	and #%11111000	;00000000 YYYYYyyy
	asl
	rol z_b
	asl
	rol z_b
	asl				;00000000 00101000
	rol z_b			;00000YYY YYyyy000
	tay 
		adc z_ls	;Add part to total L
		sta z_ls
		lda z_b		;Add part to total H
		adc z_hs
		sta z_hs
	tya 
	asl
	rol z_b
	asl				;00000000 00101000
	rol z_b			;000YYYYY yyy00000
	
	adc z_ls		;Add part to total L
	sta z_ls
	lda z_b			;Add part to total H
	adc z_hs
	adc #$60		;Screen Base $4000+$2000
	sta z_hs
	
	lda z_e
	and #%00000111	;00000000 YYYYYyyy
	clc
	adc z_ls
	sta z_ls	
	rts
	

;HL = Destination Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile
	ldy #0			;Y line / Offsaet
	
mpbitmap_gettile_nextline:
	lda z_As
	sta z_b			;Bitplane count
		
	lda (z_hls),y	;Load Bitplane 0
	sta (z_hl,x)	;Store Bitplane 0
	
	jsr inchl		
	dec z_b
	beq mpbitmap_gettile_loaddone

mpbitmap_gettile_loadagain:	
	txa	;x=0
	sta (z_hl,x)	;Bitplanes 1/2/3 to zero
	jsr inchl
	dec z_b
	bne mpbitmap_gettile_loadagain

mpbitmap_gettile_loaddone:
	iny				;VRAM down a line
	cpy #8			;Done all 8 lines
	bne mpbitmap_gettile_nextline
	rts




;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile

	ldy #0
mpbitmap_settile_yline:	
	lda z_As		;Bitplane count
	sta z_b
		
	lda (z_hl,x)	;Load Bitplane 0
	sta (z_hls),y	;Store Bitplane 0
	
mpbitmap_settile_skipbitplane:	
	jsr IncHL		;Skip Bitplane 1/2/3
	dec z_b
	bne mpbitmap_settile_skipbitplane
mpbitmap_settile_bitplanesdone:
		
	iny				;VRAM down a line
	cpy #8
	bne mpbitmap_settile_yline
	rts

	
	
mpbitmap_setpixel: ;D=Xpos E=Ypos A=Color
	and #%00000001
	sta z_iyh		;Color number

	jsr mpbitmap_getscreenpos	;Get VRAM destination
	
	lda #%11111110		;Mask for pixels to keep
	sta z_c
	
	lda z_d
	and #%00000111		;Xpos 0-7
	eor #%00000111
	beq mpbitmap_setpixel_shiftdone
	tax
mpbitmap_setpixel_shiftagain:
	sec
	rol z_c				;Shift Mask
	asl z_iyh			;Shift Color to set
	dex 
	bne mpbitmap_setpixel_shiftagain
	
mpbitmap_setpixel_shiftdone:
	ldx #0
	lda (z_hls,x)		;Get VRAM byte
	and z_c				;Mask pixels to keep
	ora z_iyh			;Set Pixel to change
	sta (z_hls,x)		;Store VRAM byte
	rts


mpbitmap_getpixel: ;D=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos	;Get VRAM Source
	
	lda (z_hls,x)		;Get Byte from screen
	sta z_c
	
	lda z_d
	and #%00000111		;Xpos 0-7
	eor #%00000111
	beq mpbitmap_getpixel_shiftdone
	tax
mpbitmap_getpixel_shiftagain:
	lsr z_c				;Shift mask
	dex
	bne mpbitmap_getpixel_shiftagain
mpbitmap_getpixel_shiftdone:
	lda z_c
	and #%00000001		;Return Result
	rts
	
	