

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


DrawTile:	
	;ldy #0	;-safe to assume Y=0
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		bne DrawTileAdvanced
	endif
	asl
	sta (z_bcs),y		;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
	
DrawTileBasicOnly:
	and #%11110000		;nnnn----
	sta z_ls
	lda (z_bcs),y		;%NNNNNNNN
	
	lsr 
	ror z_ls			;Tilenum *8
	sta z_hs
	
	lda z_ls
	clc
	adc z_es			;DEs = Tile pattern base address 
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
		
		
	dey ;ldy #0
		
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen

	ldy #0
	jmp TileDoneBCs_Plus2

	
DrawTileAdvanced:	
	and #%00000110		;YX flip
	bne NotDrawTileCustom
		jmp DrawTileCustom
		
NotDrawTileCustom:		;X/Y/XY Flip
	lda (z_bcs),y
	and #%11111110		;Clear Update Flag
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnly
	endif

	and #%11110000	;nnnn----
	sta z_ls

	lda (z_bcs),y	;%NNNNNNNN
	
	lsr 
	ror z_ls		;8 Bytes per pattern
	sta z_hs
	
	lda z_ls
	clc
	adc z_es		;DEs = Tile pattern base address 
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
		
	dey		
	lda (z_bcs),y
	
	bit LookupBits+2	;%----XYPU
	beq NotDrawTileYFlip
		jmp DrawTileYFlip
NotDrawTileYFlip:

;DrawTileXflip	
	lda #>FlipLUT
	sta z_b				;BC= Xflip LUT
		
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	
	ldy #0
	jmp TileDoneBCs_Plus2
	
	
	
DrawTileEmpty:
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTransp
	ldy #0
	jmp TileDoneBCs_Plus2
	

DrawTileTransp:;;;;;;;;;;;;;;;;;;Transparent
	asl 
	rol z_hs
	asl 
	rol z_hs
	asl 
	rol z_hs		;*8
	
	clc
	adc z_es			;DEs = Tile pattern base address 
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	
	dey ;ldy #0
	
	lda (z_HLs),y		;Read a source byte
	beq TileTransp1
	sta (z_HL),y		;Write to screen
TileTransp1:
	iny	
	lda (z_HLs),y		;Read a source byte
	beq TileTransp2
	sta (z_HL),y		;Write to screen
TileTransp2:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp3
	sta (z_HL),y		;Write to screen
TileTransp3:
	iny	
	lda (z_HLs),y		;Read a source byte
	beq TileTransp4
	sta (z_HL),y		;Write to screen
TileTransp4:
	iny	
	lda (z_HLs),y		;Read a source byte
	beq TileTransp5
	sta (z_HL),y		;Write to screen
TileTransp5:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp6
	sta (z_HL),y		;Write to screen
TileTransp6:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp7
	sta (z_HL),y		;Write to screen
TileTransp7:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp8
	sta (z_HL),y		;Write to screen
TileTransp8:

	ldy #0
	jmp TileDoneBCs_Plus2
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


DrawTileCustom:
	lda (z_bcs),y 		;NN------ - top bits of tilenum
	and #%11111110
	sta (z_bcs),y 
	rol
	rol
	rol
	and #%00000011		;------NN
	sta z_hs
	
	lda (z_bcs),y 
	and #%00110000		;Cmd Bits ;NNCC001-
	bne NotDrawTileFill
		jmp DrawTileFill ;--00----
NotDrawTileFill:
	cmp #%00110000		 ;--11----
	bne NotDrawTileEmpty	
		jmp DrawTileEmpty
NotDrawTileEmpty:
	
	
DrawTileDouble:	
	iny 
	lda (z_bcs),y
	asl 
	rol z_hs
	asl 
	rol z_hs			;*4

	adc z_es			;Add Pattern base DEs
	sta z_ls
	lda z_hs
	adc z_ds
	sta z_hs
	
	dey ;ldy #0

	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	inc z_Ls
	iny	
	
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	inc z_Ls
	iny	
	
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	inc z_Ls
	iny	
	
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	
	sta (z_HL),y		;Write to screen
	
	ldy #0
	jmp TileDoneBCs_Plus2
	
		
		
DrawTileFill:
	iny
	lda (z_bcs),y
	adc z_es			;Add Pattern base DEs
	sta z_ls

	lda z_hs
	adc z_ds
	sta z_hs
		
	dey ;ldy #0
	lda (z_HLs),y		;Read a source byte
	sta z_d
	iny		;1
	lda (z_HLs),y		;Read a source byte
	;sta z_e
	
	sta (z_HL),y		;Write to screen
	iny	;3
	iny
	sta (z_HL),y		;Write to screen
	iny	;5
	iny
	sta (z_HL),y		;Write to screen
	iny	;7
	iny
	sta (z_HL),y		;Write to screen
	
	dey	;6
	lda z_d
	sta (z_HL),y		;Write to screen
	dey	;4
	dey
	sta (z_HL),y		;Write to screen
	dey	;2
	dey
	sta (z_HL),y		;Write to screen
	dey	;0
	dey
	sta (z_HL),y		;Write to screen
	
	jmp TileDoneBCs_Plus2


DrawTileXYflip:
	lda #>FlipLUT
	sta z_b				;BC= Xflip LUT

	lda z_ls	
	adc #7				;Move to last byte
	sta z_ls
		
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	iny	
		
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	iny		

	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls			;Up a source line
	sta (z_HL),y		;Write to screen
	
	ldy #0
	jmp TileDoneBCs_Plus2
	
	
DrawTileYflip:
	bit LookupBits+3	;X-flip?
	beq NotDrawTileXYFlip
		jmp DrawTileXYFlip
NotDrawTileXYFlip:

	lda z_ls
	adc #7				;Move to last byte
	sta z_ls
			
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	
	ldy #0
	jmp TileDoneBCs_Plus2
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
	
;X in bytes, Y in lines	
;Address= (%XXXXXXXX * 8) + (%YYYYY--- * 40) + %-----YYY + $6000

GetScreenPos:
	ldx #0
	stx z_h
	
	lda z_b		;Multiple X (in bytes) by 8
	and #%11111100 ;Convert LU to bytes
	
	asl
	rol z_h			;-----XXX XXXXX---
	sta z_l

	stx z_b			;B=0
	
;40 bytes per Yline =00000000 00101000
	lda z_c
	asl 			;LU to lines 
	and #%11111000	;00000000 YYYYYyyy
	asl
	rol z_b
	asl
	rol z_b
	asl				;00000000 00101000
	rol z_b			;00000YYY YYyyy000
	tax 
		adc z_l		;Add part to total L
		sta z_l
		lda z_b		;Add part to total H
		adc z_h
		sta z_h
	txa 
	asl
	rol z_b
	asl				;00000000 00101000
	rol z_b			;000YYYYY yyy00000
	
	adc #$20		;Offset +4 blocks (Center 32 tile screen)
	adc z_l			;Add part to total L
	sta z_l
	
	lda z_b			;Add part to total H
	adc z_h
	adc #$60		;Screen Base $4000+$2000
	sta z_h
	rts
	
