	; ifndef z_ix

; z_ixl equ z_Regs+8
; z_ixh equ z_Regs+9
; z_ix equ z_Regs+8

; z_iyl equ z_Regs+10
; z_iyh equ z_Regs+11
; z_iy  equ z_Regs+10
	; endif


NativeSpriteAddr: dw 0		;Address of pattern base

nativespriteactivebuffer:	;Buffer for Xor drawing, 4 bytes per sprite
    ds 32

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
nativespr_drawone:
	pushpair z_de
	pushpair z_hl

		ldy #0
		lda (z_hl),y		;Ypos (Pairs of pixels)
		sta z_c

		iny
		lda (z_hl),y		;Xpos (Pairs of pixels)
		sta z_b

		iny
		lda (z_hl),y		;SpriteDef-L
		tax

		iny
		lda (z_hl),y		;SpriteDef-H
		sta z_h
		stx z_l

		lda z_b				;Zero pos?
		ora z_c
		beq nativespr_drawone_EmptySprite
		jsr nativespr_drawextra
nativespr_drawone_EmptySprite

	pullpair z_hl
	pullpair z_de
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
nativespr_drawextra:
nativespr_hide:
nativespr_draw:  ;bc=xy in pairs of pixels hl=spriteobject a=hspritenum 
	ldx #0
	lda (z_hl,x)
	bne lbl_8B4DxB0B8	;W=0?
	rts					;W=0 for emtpy sprite
lbl_8B4DxB0B8
	sta z_d				;Width
	jsr inchl

	lda (z_hl,x)
	sta z_e				;Height
	jsr inchl

	lda z_h
	sta z_iyh
	lda z_l
	sta z_iyl			;IY=Source Tilemap

drawnativespry:
	pushpair z_de
	pushpair z_bc
		lda z_d
		sta z_ixl		;Width of line

drawnativesprx:
		ldx #0
		lda (z_iy,x)    ;0=empty sprite
		bne notdrawnativeskipx1
			jmp drawnativeskipx		;Skip this 8x8 block
notdrawnativeskipx1

;Check if we're 'onscreen' (range 64-192 / 80-176 ... in pairs of pixels)
		lda z_b
		sec
		sbc #vscreenminx
		cmp #vscreenwid
		bcc notdrawnativeskipx2
			jmp drawnativeskipx
notdrawnativeskipx2	
		;lsr 
		sta z_b

drawnativeokx:
		lda z_c
		sec
		sbc #vscreenminy
		cmp #vscreenhei-2
		bcc notdrawnativeskipx3
			jmp drawnativeskipx
notdrawnativeskipx3
drawnativeoky:
		;asl 
		;and #%11111000
		sta z_c

		
;Calculate VRAM
		lda #0
		sta z_d
		
		lda z_b				;
		and #%11111110		;Xpos in bytes 
		;rol z_h			;2
		asl 
		;rol z_h			;4
		asl 
		rol z_d				;8 bytes per X line
		sta z_e
		
		;We have to work in 8 pixel tall strips on the BBC
		lda z_c
		and #%11111100		;Multiply Y strip num by $02
		lsr					;$02 00
		
		adc #$50			;Screen Offset $5000
		adc z_d				;Add to D
		sta z_d
				
				
;Get Source pattern
drawnativesprxfast:
		ldx #0
		lda (z_iy,x)      		;sprite pattern num
		bne NOTdrawnativeskipf	;0=Empty Sprite
			jmp drawnativeskipf
NOTdrawnativeskipf:
		ifdef BBC_NativeSprite_PatternOffset
			clc
			adc #BBC_NativeSprite_PatternOffset
		endif
	
		sta z_l
		
		txa ;lda #0
		asl z_l
		rol
		asl z_l
		rol
		asl z_l
		rol	
		asl z_l			;pattern *16
		rol
		sta z_h
			
		clc
		lda NativeSpriteAddr
		adc z_l
		sta z_l
		
		lda NativeSpriteAddr+1
		adc z_h
		sta z_h
		
		ldy #0
;Draw 1st column
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		
;Draw 2nd column
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
		iny	
		lda (z_HL),y		;Read a source byte
		eor (z_DE),y
		sta (z_DE),y		;Write to screen
			
drawnativeskipf:
		lda #16				;Across one tile 
		clc
		adc z_e
		sta z_e
		bcc drawnativeskipfDOK	
		inc z_d
drawnativeskipfDOK:
		
		lda z_b
		clc
		adc #4      		 ;Across 8 pixels
		sta z_b

		cmp #4
		bcc drawnative_overrow
		cmp #125			;Offscreen
		bcs drawnative_overrow

		jsr inciy

		dec z_ixl			;Repeat for next horizontal tile
		beq Notdrawnativesprxfast
			jmp drawnativesprxfast
Notdrawnativesprxfast:	
drawnative_overrowb:
drawnativeskip:
	pullpair z_bc
	pullpair z_de

	lda z_c
	clc
	adc #4       ;Down 8 pixels
	sta z_c

	dec z_e
	beq NOTdrawnativespry
	jmp drawnativespry
NOTdrawnativespry
	rts


drawnative_overrow:
drawnativeskipfb:
    jsr inciy		;We're offscreen so Skip a tile 
    dec z_ixl
	bne drawnativeskipfb
	jmp drawnative_overrowb
	
drawnativeskipx:
    jsr inciy
	
	lda z_b
	clc
	adc #4			;Across 8 pixels
	sta z_b

    dec z_ixl		;At end of line?
	beq NOTdrawnativesprx
	jmp drawnativesprx
NOTdrawnativesprx:
	jmp drawnativeskip



	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
;Draw Sprite Object Array (HL)

NativeSpr_DrawArrayReiKou:	
	jsr AddressRemapViaTableHL		;Used by ChibiVM for address remapping
nativespr_drawarray:
	;jsr updatexorbuffer
	loadpair z_de,nativespriteactivebuffer

nativespr_drawarrayalt:

	ldx #0
	lda (z_hl,x)      ;count
	sta (z_de,x)      ;Store in cache
	pha
		jsr incde
		jsr inchl	
	pla
nativespr_drawarrayb:
	beq nativespr_clearunused
	pha
		jsr nativespr_drawone_testone ;See if sprite needs redrawing
		bcc nativespr_nochange

		pushpair z_hl
			lda z_e
			sta z_l
			lda z_d
			sta z_h
			jsr nativespr_drawone	;Remove old sprite
		pullpair z_hl	
		jsr nativespr_drawone		;Draw New sprite

nativespr_nochange:
		ldy #4
		ldx #0
nativespr_nochangeAgain:	
		lda (z_hl,x)				;Copy New data into cache
		sta (z_de,x)
		jsr incHl
		jsr incde
		dey 
		bne nativespr_nochangeAgain
	pla
	sec
	sbc #1
	jmp nativespr_drawarrayb

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Compare sprite DE to HL, C=Different
; Used to decide if an XOR sprite needs redrawing

nativespr_drawone_testone:
	ldy #4-1			;We test 4 bytes total
	
nativespr_drawone_testoneb:
	
	lda (z_de),y		;Test this byte
	cmp (z_hl),y
	bne nativespr_drawone_fail	;Abort if mismatched
	
	dey
	bpl nativespr_drawone_testoneb
	
	clc					;CC=No Difference
	rts

nativespr_drawone_fail:
    sec					;CS=Difference 
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
NativeSpr_InitReiKou:
	jsr AddressRemapViaTableHL	;Used by ChibiVM for address remapping

nativespr_init:
	lda z_l
	sta nativespriteaddr		;Store the address of the pattern data
	lda z_h
	sta nativespriteaddr+1

nativespr_clearunused:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
		
nativespr_hideAll_Reikou:	
	
nativespr_hidearray:        ;for tilemap redraw
	loadpair z_hl,nativespriteactivebuffer	;Cache of what's onscreen

	ldx #0
	lda (z_hl,x)     	   ;count
	pha
		txa
		sta (z_hl,x)      ;Zero count (all sprites gone)
		jsr inchl
	pla
nativespr_drawarrayb2:
	beq nativespr_clearunused
	pha

		jsr nativespr_drawone	;Hide this sprite

nativespr_nochange2:
		ldy #4
		ldx #0
nativespr_nochangeAgain2:	
		txa
		sta (z_hl,x)			;Clear the 4 bytes in the cache
		jsr incHl
		dey 
		bne nativespr_nochangeAgain2
	pla
	sec
	sbc #1
	jmp nativespr_drawarrayb2 ;Repeat for the next sprite
	
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	

; AddHL_DE:				;Add DE to HL
	; cl ; AdcHL_DE				;Add DE to HL
	; lda z_e			;Add E to L
	; adc z_l
	; sta z_l
	; lda z_d			;Add D to H (with any carry)
	; adc z_h
	; sta z_h
	; jmp *
	; rts

	; ifndef IncIY
; IncIY:
	; INC z_IYL
	; BNE	IncIY_Done
	; INC	z_IYH
; IncIY_Done:
	; rts	
	; endif