;mpbitmap_setpixel_Reikou:
;mpbitmap_getpixel_Reikou:

;mpbitmap_gettile_Reikou:
;	rts
	
	
	
MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 1
MPB_Pen5 equ 2
MPB_Pen6 equ 3
MPB_Pen7 equ 1
MPB_Pen8 equ 2
MPB_Pen9 equ 3
MPB_PenA equ 1
MPB_PenB equ 2
MPB_PenC equ 3
MPB_PenD equ 1
MPB_PenE equ 2
MPB_PenF equ 3

mpbitmap_tiletints:
	db 255

	
mpbitmap_getscreenposTile: 	;D=Xpos E=Ypos (tiles)
	sta z_bs	;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
		asl z_d		;Tiles2Pixels
		asl z_e
	dex
	bne mpbitmap_getscreenposShift
		
	lda #8
	sta z_b			;Linecount
			
mpbitmap_getscreenpos: 	;D=Xpos E=Ypos (pixels)
	ldx #0
	lda z_d
	sta z_iyl
	
;Caclulate VRAM Dest
	lda z_e			;Ypos *$200
	and #%11111000
	lsr
	lsr
	sta z_as
	
	txa
	sta z_hs
	
	lda z_d
	and #%11111100
	asl
	rol z_hs		;Xpos * 8 
	sta z_ls
	
	lda z_e
	and #%00000111	;YLine
	clc
	adc z_ls
	sta z_ls
		
	lda z_hs
	clc
	adc z_as		;Add Ypos
	adc #$50		;Vram at $5000
	sta z_hs
	rts

	
mpbitmap_setpixel:	;D=Xpos E=Ypos A=Color
	sta z_iyh
	
	jsr mpbitmap_getscreenpos

	lda #%01110111	;Mask for pixels to keep
	sta z_c
	
	txa
	ror z_iyh		;Color to bbc format
	ror
	lsr
	lsr
	lsr
	ror z_iyh
	ror				
	sta z_b			;Bitplane Bits: %1---0---
	
	lda z_iyl
	and #%00000011	;Xpos 0-3
	beq mpbitmap_setpixel_shiftdone
	tay
mpbitmap_setpixel_shiftagain:
	sec
	ror z_c			;Shift mask
	lsr z_b			;Shift color
	dey
	bne mpbitmap_setpixel_shiftagain

mpbitmap_setpixel_shiftdone
	lda (z_hls,x)	;Get screen byte
	and z_c			;Clear pixel to change
	ora z_b			;Set pixel to change
	sta (z_hls,x)	;Save screen byte
	rts


mpbitmap_getpixel:	;D=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos
	
	lda (z_hls,x)
	sta z_c			;Screen byte
	
	lda z_iyl
	and #%00000011	;Xpos 0-3
	beq mpbitmap_getpixel_shiftdone

	tay
mpbitmap_getpixel_shiftagain:
    asl z_c			;Shift screen byte
	dey
	bne mpbitmap_getpixel_shiftagain

mpbitmap_getpixel_shiftdone:
	stx z_as		;z_as=0
	
	lda z_c			;Bitplane Bits: %1---0---
	rol 
	rol z_as		;Bit 1
	rol 
	rol 
	rol 
	rol 
	lda z_as		;Bitplane Bits: %------10
	rol 			;Bit 0
	rts
	


;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile

mpbitmap_settile_nextline:

;Load bitplanm
	ifdef mpbitmap_tiletints
		lda mpbitmap_tiletints
		sta z_ds
    else
		stx z_ds	;Load default for bitplane 1
	endif
	
	ldy z_bs		;Bitplane count

	lda (z_hl,x)
	sta z_es     	;bitplane 0
	
	jsr inchl
	dey				;More bitplanes?
	beq mpbitmap_settile_loaddone
		
	lda (z_hl,x)
	sta z_ds    	;bitplane 1
	
mpbitmap_settile_loadagain
	jsr inchl   	;unused bitplanes
	dey				;More bitplanes?
	bne mpbitmap_settile_loadagain 	;skip unneeded bitpanes
mpbitmap_settile_loaddone:
  
;Store data to VRAM
	ldy #0			;Left strip

	lda #2			 ;2 strips per 8x8 block
	sta z_c
	
mpbitmap_settile_nextpixel:
	ldx #4			;4 pixels per byte
mpbitmap_settile_nextpixelE:		
	rol z_ds		;Bitplane 1
	rol
	dex 
	bne mpbitmap_settile_nextpixelE
	
	ldx #4			;4 pixels per byte
mpbitmap_settile_nextpixelD:		
	rol z_es		;Bitplane 0
	rol
	dex 
	bne mpbitmap_settile_nextpixelD
	
	sta (z_hls),y	;Store result to screen

	ldy #8			;Right strip
	dec z_c
	bne mpbitmap_settile_nextpixel

	inc z_ls		;down one line

	dec z_b			;Repeat for next line
	bne mpbitmap_settile_nextline
	rts

	
	

;HL = Destination Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile
	
mpbitmap_gettile_nextline:

;Load data from VRAM
	lda #2			 ;2 strips per 8x8 block
	sta z_c
	
	ldy #0			;Left strip
	
mpbitmap_gettile_nextpixel:
	lda (z_hls),y
	
	ldx #4
mpbitmap_gettile_nextpixele:	
	rol
	rol z_ds		;Bitplane 1
	dex
	bne mpbitmap_gettile_nextpixele
	
	ldx #4
mpbitmap_gettile_nextpixeld:	
	rol
	rol z_es		;Bitplane 0
	dex
	bne mpbitmap_gettile_nextpixeld
	
	ldy #8			;Right strip

	dec z_c
	bne mpbitmap_gettile_nextpixel
        

;Store results to HL
	ldy z_bs		;Bitplane count

	lda z_es
	sta (z_hl,x)	;Bitplane 0
	jsr inchl
	dey
	beq mpbitmap_gettile_loaddone
	
	lda z_ds
	sta (z_hl,x)	;Bitplane 1
	jsr inchl
	dey
	beq mpbitmap_gettile_loaddone

mpbitmap_gettile_loadagain:
	txa
	sta (z_hl,x)     ;bitplane 3/4 always 0
	jsr inchl
	dey
	bne mpbitmap_gettile_loadagain

mpbitmap_gettile_loaddone:
	inc z_ls		;down one line

	dec z_b			;Repeat for next line
	bne mpbitmap_gettile_nextline
	rts
