;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


DrawTile:	
	;ldy #0	;-safe to assume Y=0
	bit LookupBits+0	;Check P flag (now bit 0)
	ifndef TileTest_BasicOnly		;For Minimal Testing
		bne DrawTileAdvanced
	endif
	asl
	sta (z_bcs),y		;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
DrawTileBasicOnly:


	and #%11110000		;%nnnn---
	clc
	adc z_es			;DEs = Tile pattern base address 
	sta z_ls
	lda (z_bcs),y		;%NNNNNNNN
	adc z_ds
	sta z_hs
		
	dey ;ldy #0
		
		
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs),y		;Read a source byte
	sta (z_HL),y		;Write to screen
	
	ldy #0
	jmp TileDoneBCs_Plus2

	
DrawTileAdvanced:	
	and #%00000110			;YX flip
	bne NotDrawTileCustom
		jmp DrawTileCustom
		
NotDrawTileCustom:			;X/Y/XY Flip
	lda (z_bcs),y
	and #%11111110			;Clear Update Flag
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnly
	endif

	and #%11110000		;nnnn---
	clc
	adc z_es
	sta z_ls

	lda (z_bcs),y		;%NNNNNNNN
	adc z_ds
	sta z_hs
	dey		
	lda (z_bcs),y

	bit LookupBits+2	;%----XYPU
	beq NotDrawTileYFlip
		jmp DrawTileYFlip
NotDrawTileYFlip:


DrawTileXflip:	
	lda #>FlipLUT
	sta z_b				;BC= Xflip LUT
	
	lda z_ls
	pha
		adc #8			;Move to RIGHT hand byte
		jsr DrawTileXflipPart
		iny
	pla		
	sec					;back to LEFT byte
	sbc #8				;Compensate for Y=8
	jsr DrawTileXflipPart
	ldy #0
	jmp TileDoneBCs_Plus2
	
DrawTileXflipPart:
	sta z_ls
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	iny
	
	lda (z_HLs),y		;Get source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	sta (z_HL),y		;Write to screen
	rts	
	
	
DrawTileEmpty:
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTransp
	dey ;ldy #0
	jmp TileDoneBCs_Plus2
	
	
DrawTileTransp:;;;;;;;;;;;;;;;;;;Transparent
	asl 
	rol z_hs			;*2
	asl 
	rol z_hs			;*4
	asl 
	rol z_hs			;*8
	asl 
	rol z_hs			;*16
	clc
	
	adc z_es			;+Pattern Base DEs
	sta z_ls		
	lda z_hs
	adc z_ds
	sta z_hs
	
	dey ;ldy #0
	jsr DrawTileTranspPart
	iny
	jsr DrawTileTranspPart
	ldy #0
	jmp TileDoneBCs_Plus2
	
DrawTileTranspPart:
	lda (z_HLs),y		;Read a source byte
	beq TileTransp1		;=0?
	sta (z_HL),y		;Write to screen
TileTransp1:
	iny	
	lda (z_HLs),y		;Read a source byte
	beq TileTransp2		;=0?
	sta (z_HL),y		;Write to screen
TileTransp2:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp3		;=0?
	sta (z_HL),y		;Write to screen
TileTransp3:
	iny	
	lda (z_HLs),y		;Read a source byte
	beq TileTransp4		;=0?
	sta (z_HL),y		;Write to screen
TileTransp4:
	iny	
	lda (z_HLs),y		;Read a source byte
	beq TileTransp5		;=0?
	sta (z_HL),y		;Write to screen
TileTransp5:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp6		;=0?
	sta (z_HL),y		;Write to screen
TileTransp6:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp7		;=0?
	sta (z_HL),y		;Write to screen
TileTransp7:
	iny
	lda (z_HLs),y		;Read a source byte
	beq TileTransp8		;=0?
	sta (z_HL),y		;Write to screen
TileTransp8:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustom:
		lda (z_bcs),y 			;NN------ - top bits of tilenum
		and #%11111110
		sta (z_bcs),y 
		rol
		rol	
		rol
		and #%00000011			;------NN
		sta z_hs
		
		lda (z_bcs),y 
		and #%00110000			;Cmd Bits ;NNCC001-
		bne NotDrawTileFill
			jmp DrawTileFill	;--00----
NotDrawTileFill:
		cmp #%00110000			;--11----
		bne NotDrawTileEmpty	
			jmp DrawTileEmpty
NotDrawTileEmpty:
	
	
DrawTileDouble:	
	iny 
	lda (z_bcs),y
	and #%11111110
	asl 
	rol z_hs		;*2
	asl 
	rol z_hs		;*4
	asl 
	rol z_hs		;*8
	asl 
	rol z_hs		;*16
	clc
	adc z_es
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	
	lda (z_bcs),y			;nnnnnnnn
	and #%00000001			;First 4 lines or 2nd?
	beq DrawTileDoubleFirstHalf
		lda z_ls
		clc
		adc #4				;2nd half of tile
		sta z_Ls
DrawTileDoubleFirstHalf:	
	dey ;ldy #0
	;ldx #0
	jsr DrawTileDoublePart
	iny	
	
	lda z_Ls
	clc
	adc #4+1
	sta z_Ls
	jsr DrawTileDoublePart

	ldy #0
	jmp TileDoneBCs_Plus2
	
DrawTileDoublePart:	
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	inc z_Ls
	iny	
	
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	inc z_Ls
	iny	
	
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	inc z_Ls
	iny	
	
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	iny	
	
	sta (z_HL),y		;Write to screen
	rts
		
		
DrawTileFill:
	iny
	lda (z_bcs),y
	
	adc z_es			;Add Pattern base
	sta z_ls

	lda z_hs
	adc z_ds
	sta z_hs
		
	dey ;ldy #0
	lda (z_HLs),y		;Read a source byte
	sta z_d
	iny
	lda (z_HLs),y		;Read a source byte
	sta z_e
	dey
	
	ldx #2
DrawTileFillAgain:	
	lda z_d
	sta (z_HL),y		;Write to screen
	iny	
	lda z_e
	sta (z_HL),y		;Write to screen
	iny
	lda z_d
	sta (z_HL),y		;Write to screen
	iny	
	lda z_e
	sta (z_HL),y		;Write to screen
	iny	
	lda z_d
	sta (z_HL),y		;Write to screen
	iny
	lda z_e
	sta (z_HL),y		;Write to screen
	iny
	lda z_d
	sta (z_HL),y		;Write to screen
	iny
	lda z_e
	sta (z_HL),y		;Write to screen
	iny
	
	dex 
	bne DrawTileFillAgain
	ldy #0
	jmp TileDoneBCs_Plus2




DrawTileXYflip:
	lda #>FlipLUT
	sta z_b					;BC= Xflip LUT
	lda z_ls
	adc #7+8				;Move to last byte
	sta z_ls
		
	jsr DrawTileXYflipPart	;Do Lrft half
	iny	
	jsr DrawTileXYflipPart 	;Do Right half
	ldy #0
	jmp TileDoneBCs_Plus2

DrawTileXYflipPart:
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
		
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny		

	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	
	lda (z_HLs,x)		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc,x)		;Get byte from Xflip LUT
	dec z_Ls
	sta (z_HL),y		;Write to screen
	rts	
	
	
DrawTileYflip:
	bit LookupBits+3
	beq NotDrawTileXYFlip
		jmp DrawTileXYFlip
NotDrawTileXYFlip:

	;ldy #0 ;ldx #0
	lda z_ls
	pha
		adc #7			;Move to last byte
		jsr DrawTileYflipPart
		iny
	pla		
	clc					;back to left byte
	adc #8+7			;Right hand side
	jsr DrawTileYflipPart
	
	ldy #0
	jmp TileDoneBCs_Plus2
	
DrawTileYflipPart:
	sta z_ls
			
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny	
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	dec z_Ls
	sta (z_HL),y		;Write to screen
	iny
	lda (z_HLs,x)		;Read a source byte
	sta (z_HL),y		;Write to screen
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;BBC type is odd - the first 8 screen bytes go DOWN... 
;the 9ths goes back to the top 
;Effectively we're filling in 8x8 character blocks in a zigzag pattern

GetScreenPos:
	lda #0
	sta z_h
	
	lda z_b				;Xpos
	and #%11111110
	;rol z_h			;2
	asl 
	;rol z_h			;4
	asl 
	rol z_h				;8 bytes per X line
	sta z_l
	
	;We have to work in 8 pixel tall strips on the BBC
	lda z_c
	and #%11111100		;Multiply Y strip num by $02
	lsr					;$02 00
	
	adc #$50			;Screen Offset $5000
	adc z_h				;Add to D
	sta z_h
	
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

