;Expanders expand (and optionally flip) a 1 byte per tile source tilemap
;into a 2 byte per tile destination (intended to be in temp ram)

;Example source tilemap (0=Transparent):
;	db 0,1,2,3,0
;	db 4,5,6,7,8
;	db 9,10,11,12,0
;	db 13,14,15,16,17
;	db 18,19,20,21,22
;	db 0,23,24,25,0
;	db 0,26,27,28,0
;	db 0,29,30,31,0

;Example Destination:
;	dw &FFF2,&8133,&0820,&0830,&8433
;	dw &8533,&0860,&0870,&0880,&8933
;	dw &8A33,&08B0,&08C0,&08D0,&8E33
;	dw &8F33,&0900,&0910,&0920,&9333
;	dw &9433,&0950,&0960,&0970,&9833
;	dw &9933,&09A0,&09B0,&09C0,&9D33
;	dw &FFF2,&9E33,&9F33,&A033,&FFF2
;	dw &FFF2,&A133,&A233,&A333,&FFF2

;Example Usage:
;	ld hl,TeplateYarita	;Source
;	ld de,tilePlayer	;Dest
;	ld ix,&1000+1		;Mask
;	ld iyh,5			;Width
;	ld iyl,8			;Height
;	call ExpandTilemap



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;IX=first Tile pattern num
;IY=WH
;HL=Source Tilemap (1 byte per tile)
;DE=TempTileMap (2 byte per tile)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;ix=first tile pattern num
;iy=wh
;hl=source tilemap (1 byte per tile)
;de=temptilemap (2 byte per tile)


ExpandTileMap:
	ldy #0
expandtilemapAgain:
	lda z_iyh
	sta z_b					;Tilemap Width
templatetileloop:
		jsr expandone
		iny					;Do one tile
	dec z_b
	bne templatetileloop
	
	dec z_iyl				;Tilemap height
	bne expandtilemapAgain
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


ExpandTilemapX:
	lda z_ixl
	ora #%00001010		;set xflip
	sta z_ixl

expandtilemapxloop:
	ldy z_iyh			;width in tiles
	dey					;Move to last tile on first line
	
templatetileloopx:
	jsr expandone		;expand a line
	dey
	bpl templatetileloopx	;>=0?
	
	lda z_iyh
	sta z_c
	jsr addhl_0c

	dec z_iyl			;height in lines
	bne expandtilemapxloop
	rts

	
	
ExpandTilemapA:	;a=mode (0/1/2/3 = normal/xflip/yflip/xyflip)
	php
		ldx #0
	plp
	beq expandtilemap
	cmp #1
	beq expandtilemapx
	cmp #2
	beq expandtilemapy

	
ExpandtilemapXY: ;A=3
	lda z_ixl
	ora #%00001110	;set xyflip
	sta z_ixl

	lda z_iyh		;width
	sta z_c
	stx z_b	;x=0
	
	ldx z_iyl		;height
	cpx #2			;<2 lines?
	bcc expandtilemapxyagain	;yes
	dex
	
expandtilemapxymult:
	jsr addhl_bc	;Move to end of source tilemap (last tile)
	dex
	bne expandtilemapxymult

	jsr dechl		;hl points to last tile
	
expandtilemapxyagain:
	ldy z_iyh		;width in tiles	
templatetileloopxy:
	jsr expandone	;expand a line
	dey
	bne templatetileloopxy
	
	lda z_iyh		;Width in tiles
	sta z_c
	
	jsr SubHL_BC
	dec z_iyl		;height in lines
	bne expandtilemapxyagain
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ExpandTilemapY:
	lda z_ixl
	ora #%00000110		;set xyflip
	sta z_ixl	
	
	lda z_iyh			;Width
	sta z_c
	stx z_b	;x=0
	
	ldx z_iyl			;height
	cpx #2				;<2 lines?
	bcc expandtilemapyagain	;yes
	dex
expandtilemapymult:
	jsr addhl_bc	;Move to end of source tilemap (last line)
	dex
	bne expandtilemapymult ;hl points to last line
	
expandtilemapyagain:
	ldy #0				;width in tiles
templatetileloopy:
	jsr expandone		;expand a line
	iny
	cpy z_iyh
	bne templatetileloopy
	
	lda z_iyh
	sta z_c
	jsr SubHL_BC		;Back one line
	
	dec z_iyl			;height in lines
	bne expandtilemapyagain
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;hl=tilemap source (1 byte per tile)
;de=tilemap destination (2 bytes per tile)
;ix=tile mask/offset... de=(hl)+ix


ExpandOne:	;expand 1 byte tile -> 2 byte

;	ldx #0	;X must equal 0!!!
	lda (z_hl),y
	bne templatetileloopok	;0=transparent
	
	lda #$f2			;0= transp = &fff2
	sta (z_de,x)
	jsr incde
	lda #$ff
	bne templatetileDone ;Always branch (A!=0)
	
templatetileloopok:	;>0 = Tile +z_ix
	stx z_c			;C=0
	
	asl 			
	rol z_c			
	asl 			
	rol z_c			
	asl 			
	rol z_c			
	asl 			;tile *16
	rol z_c			;&tt -> &0tt_
		
	clc
	adc z_ixl		;add ix tile mask/base
	sta (z_de,x)
	
	lda z_c
	adc z_ixh
	jsr incde
templatetileDone:
	sta (z_de,x)
	jmp incde

