
;DE'=Pattern Data
;HL=Screen Base
;IYH=Tilemap Width
;IXH/IXL=Draw Width / Height
	



DrawTilemap:			;Draw straight to VRAM
NextLineD:
	ldx #0
	
	lda z_d				;Tilemap Source
	sta z_bs
	lda z_e
	sta z_cs


	lda z_ixh			;Width 
	sta z_iyl
	pushpair z_hl
	pushpair z_de
		ifdef hiresy
			;ifdef buildcpc
				;lda z_h			;Example for systems which use
				;ora #%00100000		; an 'alternate' tile drawing 
				;bne dostriphalf	; routine depending on vram pos
			;endif
		endif
		ldy #0
nexttile:

		ifdef slowdowntest
			lda #0
slowdown:
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			sec
			sbc #1
			bne slowdown
		endif
		
		lda (z_bcs),y		;BC=Tilemap data

		ror					;get the 'needs update' bit
		ifdef doubleBuffered
			jmp drawtile		;update even if not needed!
		else
			bcs drawtile	;update if needed
		endif

TileDoneBCs_Plus2:
		inc z_Cs	;%nnnnXYPU	U=update P=Program YX=flip NN NN=Tile 
		inc z_Cs	;%NNNNNNNN
		BNE	IncBCs2_Done
		INC	z_Bs
IncBCs2_Done:
TileDone:


;Platform specific commands to move across 8 pixels (one tile)
		ifdef buildAP2
			inc z_l				;Across one tile
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildLNX
			lda z_l				;Across one tile
			clc
			adc #3
			sta z_l
			bcc TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef BuildPCE
			inc z_l				;Across one tile
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif 
		ifdef BuildSNS
			inc z_l				;Across one tile
			inc z_l
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif 
		ifdef buildBBC
			lda z_l				;Across one tile
			clc
			adc #16
			sta z_l	
			bcc TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildC64
			lda z_l				;Across one tile
			clc
			adc #$8	
			sta z_l	
			bcc TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildA52
			inc z_l				;Across one tile
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif		
		ifdef buildA80
			inc z_l				;Across one tile
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif		
		dec z_iyl				;Next H-Tile
		bne nexttile
tiledone2:
;		doei					;EI command if required
	pullpair z_de
	pullpair z_hl

	
;Platform specific commands to move down 8 pixels (one strip of tiles)

	ifdef buildBBC
		inc z_h					;Down one strip +$200
		inc z_h
	endif
	ifdef buildC64
			lda z_l
			clc
			adc #$40
			sta z_l				;down one strip +$140
			bcc TileDoneNoH2
			inc z_h
TileDoneNoH2:			inc z_h
	endif
	ifdef buildA52
		lda z_l
		clc
		adc #$40
		sta z_l					;down one strip +$140
		bcc TileDoneNoH2
		inc z_h
TileDoneNoH2:
		inc z_h
	endif
	ifdef buildA80
		lda z_l
		clc
		adc #$40
		sta z_l					;down one strip +$140
		bcc TileDoneNoH2
		inc z_h
TileDoneNoH2:
		inc z_h
	endif
	ifdef buildLNX	
		lda z_L
		clc
		adc #$E0
		sta z_L					;down one strip +$1E0
		lda z_H
		adc #$1
		sta z_H
	endif
	ifdef BuildAP2
		lda z_l
		clc
		adc #$80
		sta z_l
		bcc SpriteNextLine
		inc z_h					;Deal with strange AP2 vram
		lda z_h
		and #%00000011			
		bne SpriteNextLine
		lda z_h
		sec
		sbc #%00000100
		sta z_h
		lda z_l
		clc
		adc #$28
		sta z_l
SpriteNextLine:
	endif
	ifdef BuildPCE
		lda z_l
		clc
		adc #32				;down one strip +32
		sta z_l
		bcc SpriteNextLine
		inc z_h
SpriteNextLine:
	endif	
	ifdef BuildSNS
		lda z_l
		clc
		adc #64				;down one strip +64
		sta z_l
		bcc SpriteNextLine
		inc z_h
SpriteNextLine:
	endif	
	
	lda z_iyh
	clc
	adc z_e					;update tilemap source (add width)
	sta z_e
	bcc noupper2d
	inc z_d
noupper2d:

	dec z_ixl				;next v-line
	bne nextlined			; Repeat for next line
	rts

