
;Warning - Tile pattern address must not be &0000. 
;&00 00 will be mistaken as an end of cache command

CacheMaxBytes equ $E0			;Max Cache size
								;Leave at least 16 bytes!
								; (For overflow and end of stream)

CacheEntries equ 3				;Total Cache sections (1/3rds)
	
CacheEntryBytes equ 6			;Bytes per cache entry

Cache_AddrCur equ 1				;Address of the current working
								; Cache section (changes during draw)
								
Cache_AddrBak equ 3				;Unchanged Start of cache section
Cache_ScreenPos equ 5			;Top Byte of VRAM destination


	ifdef BuildBBC
CacheTableAddr: dw CacheTable	;Addr of current entry in cache table

CacheTable:
	db $50			;Last Vram Hbyte for section (&C200)
	dw CacheAddr1	;AddrCur (&FE00)
	dw CacheAddr1	;AddrBak (&FE00)
	db 3			;Raster Timing
	
	db $60			;Last Vram Hbyte for section (&C400)
	dw CacheAddr2	;AddrCur (&F600)
	dw CacheAddr2	;AddrBak (&F600)
	db 4			;Raster Timing
	
CacheTable_Last:
	db $FF			;Last Vram Hbyte for section (Rest of screen)
	dw CacheAddr3	;AddrCur (&EE00)
	dw CacheAddr3	;AddrBak (&EE00)
	db 5			;Raster Timing
CacheTable_End:
	endif 
	
	
	ifdef BuildC64
CacheTableAddr: dw CacheTable

CacheTable:
	db $6A		;Last Hbyte
	dw CacheAddr1; equ &FE00
	dw CacheAddr1; equ &FE00
	db 3
	db $74
	dw CacheAddr2; equ &F600
	dw CacheAddr2; equ &F600
	db 4
CacheTable_Last:
	db $FF
	dw CacheAddr3; equ &EE00
	dw CacheAddr3; equ &EE00
	db 5
CacheTable_End:
	endif 
	
	ifdef BuildAP2

CacheTableAddr: dw CacheTable

CacheTable:
	db $28		;Last Hbyte		;Compare L byte on Apple II
	dw CacheAddr1; equ &FE00
	dw CacheAddr1; equ &FE00
	db 3
	db $50
	dw CacheAddr2; equ &F600
	dw CacheAddr2; equ &F600
	db 4
CacheTable_Last:
	db $FF
	dw CacheAddr3; equ &EE00
	dw CacheAddr3; equ &EE00
	db 5
CacheTable_End:
	endif 
	
	
	ifdef BuildLNX

CacheTableAddr: dw CacheTable

CacheTable:
	db $C8		;Last Hbyte		;Compare L byte on Apple II
	dw CacheAddr1; equ &FE00
	dw CacheAddr1; equ &FE00
	db 3
	db $D0
	dw CacheAddr2; equ &F600
	dw CacheAddr2; equ &F600
	db 4
CacheTable_Last:
	db $FF
	dw CacheAddr3; equ &EE00
	dw CacheAddr3; equ &EE00
	db 5
CacheTable_End:
	endif 
	
	ifdef BuildPCE
T_CacheTable:
	db $01		;Last Hbyte
	dw CacheAddr1; equ &FE00
	dw CacheAddr1; equ &FE00
	db 3
	db $02
	dw CacheAddr2; equ &F600
	dw CacheAddr2; equ &F600
	db 4
T_CacheTable_Last:
	db $FF
	dw CacheAddr3; equ &EE00
	dw CacheAddr3; equ &EE00
	db 5
T_CacheTable_End:
	endif 
	
	ifdef BuildSNS
T_CacheTable:
	db >(SnesScreenBuffer+$200)	;Last Hbyte
	dw CacheAddr1; equ &FE00
	dw CacheAddr1; equ &FE00
	db 3
	db >(SnesScreenBuffer+$400)
	dw CacheAddr2; equ &F600
	dw CacheAddr2; equ &F600
	db 4
T_CacheTable_Last:
	db $FF
	dw CacheAddr3; equ &EE00
	dw CacheAddr3; equ &EE00
	db 5
T_CacheTable_End:
	endif 
	ifdef BuildA52
T_CacheTable:
	db $2A		;Last Hbyte
	dw CacheAddr1; equ &FE00
	dw CacheAddr1; equ &FE00
	db 3
	db $3A
	dw CacheAddr2; equ &F600
	dw CacheAddr2; equ &F600
	db 4
T_CacheTable_Last:
	db $FF
	dw CacheAddr3; equ &EE00
	dw CacheAddr3; equ &EE00
	db 5
T_CacheTable_End:
	endif 



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;From CacheList IY
;Return IX=CacheAddress Z=Cache Empty?
	
GetCacheIY:
	ldy #cache_addrbak
	lda (z_iy),y
	sta z_ixl
	iny			 ;ldy #cache_addrbak+1
	lda (z_iy),y
	sta z_ixh

	ldy #0
	lda (z_ix),y	;Is cache empty?
	iny
	ora (z_ix),y	;+1
	iny
	ora (z_ix),y	;+2
	rts


	
	

;DE=Source tilemap
;DEs=Pattern Data
;HL=Screen Base
;IYH=Tilemap Width
;IXH/IXL=Draw Width / Height
	
DrawTilemap:	;'Draw' a tilemap into the cache

	lda #<cachetable
	sta cachetableaddr
	lda #>cachetable
	sta cachetableaddr+1

	lda z_ixh
	sta z_b			;Width 
	lda z_ixl
	sta z_c			;Height

nextcache:
	loadpairfrom z_hls,cachetableaddr

	ldy #0
	lda (z_hls),y	;Cache End H VRAM byte
	sta z_iyl
	iny 

	lda (z_hls),y	;cache l
	sta z_ixl
	iny 
	lda (z_hls),y	;cache h
	sta z_ixh
	
	lda #0
	sta z_hs		;First tile flag
	sta z_ls		;z_ls=Spare for platform spec

	
NextLineC:
	ifdef buildAP2
		lda z_l
	else
		lda z_h
	endif
	;ifdef buildcpc
	;	res 5,a			;Example for systems where half tile shift
	;endif				; affects H address
	
	cmp z_iyl			;have we reached the end of this cache?
	bcc Notoverthiscache
		jmp overthiscache
Notoverthiscache:

	lda #0				;B=First Tile to draw, C= Last Tile of line
	sta z_bs
	sta z_cs
	
	pushpair z_bc
		pushpair z_de
		pushpair z_hl

		
NextTileC:
			ldx #0
			lda (z_de,x)		;BC=Tilemap data %NNCCXYPU	U=update
			ifndef doublebuffered
				ror 			;Get the 'needs update' bit
				bcc tileemptyc
			endif
			
			ldy z_b				;First tile
				lda z_bs			;Check if we already found a tile
				bne FirstTileFoundC	;jump if not first tile
			iny
			sty z_bs			;first tile+1

			lda z_hs
			bne notfirstctile	;Not First tile in this tilemap?

;Yes - First, so write Pattern settings			
			inc z_hs			;Set 'not first' flag (z_hs!=0)
			
			ldy #0
			tya
			sta (z_ix),y		;a=0 (command marker)
			
			iny
			lda z_es			;save pattern address
			sta (z_ix),y
			iny
			lda z_ds
			sta (z_ix),y
			
			ifdef tiletint
				lda tiletint	;some 16 color systems use a 1 byte 'tint'
				iny
				sta (z_ix),y
				lda #4
			else
				lda #3
			endif
			
			clc
			adc z_ixl			;INC z_IX
			sta z_ixl
			bcc notfirstctile
				inc z_ixh

				
NotFirstCTile:

;Platform specific commands to calculate first tile pos 
			ifdef buildbbc
				lda #0
				sta z_spec
				
				lda z_ls ;LS contains tilepos in tiles -convert VRAM
				asl
				rol z_spec	;*2
				asl
				rol z_spec	;*4
				asl
				rol z_spec	;*8
				asl 
				rol z_spec	;*16
				
				clc
				adc z_l
				sta z_l
				lda z_spec
				adc z_h
				sta z_h
			endif
			
			ifdef buildC64
				lda #0
				sta z_spec
				
				lda z_ls
				asl
				rol z_spec	;*2
				asl
				rol z_spec	;*4
				asl
				rol z_spec	;*8
				
				clc
				adc z_l
				sta z_l
				lda z_spec
				adc z_h
				sta z_h
			endif
		
			ldy #1
			
			lda z_l				;vram dest l
			sta (z_ix),y
			iny
			lda z_h				;vram dest h
			sta (z_ix),y
			iny
			lda z_e				;tilemap start l
			sta (z_ix),y
			iny
			lda z_d				;tilemap start h
			sta (z_ix),y	

			ldy z_b		
FirstTileFoundc:
			sty z_cs			;last tile num in strip	
			bpl CacheNextTile	;Always Plus
			
tileemptyc:

;commands to move across a tile
			ifdef buildbbc
				inc z_ls	;Ls=Tile Pos in tiles
			endif			; We calulate vram dest only if
							; this line is needed
			ifdef buildc64
				inc z_ls
			endif
			
			ifdef buildSNS
				inc z_l
				inc z_l
				bne TileDoneNoH2
				inc z_h
TileDoneNoH2
			endif
			ifdef buildPCE
				inc z_l
				bne TileDoneNoH2
				inc z_h
TileDoneNoH2
			endif
			ifdef buildAP2
				inc z_l
				bne TileDoneNoH2
				inc z_h
TileDoneNoH2
			endif
			ifdef buildLNX
				lda z_l
				clc
				adc #3
				sta z_l
				bcc TileDoneNoH
				inc z_h
TileDoneNoH:
			endif		
			ifdef buildA52
				inc z_l
				bne TileDoneNoH2
				inc z_h
TileDoneNoH2
			endif
			ifdef buildA80
				inc z_l
				bne TileDoneNoH2
				inc z_h
TileDoneNoH2
			endif
			
CacheNextTile:			


			inc z_e			;tilemap data %nnccxypu %nnnnnnnn
			inc z_e
			bne tileemptyc2
			inc z_d
tileemptyc2:			



			dec z_b
			bne NextTileC	;Next tile
			
;End of the line
			lda z_bs		;first tile (eg 11)
			sec
			sbc z_cs 		;last tile  (eg 5)
			
			beq lineemptyc	;no tiles to draw?
			
			ldy #0
			sta (z_ix),y	;write tile count
			
			lda #5
			sta z_c
			jsr AddIX_0C	;we wrote 5 bytes to cache 
							; (VramHL + TileMapHL + Count)
			lda z_ixl
			cmp #cachemaxbytes
			bcc lbl59733
				jsr cachefull	;is the cache full?
lbl59733:


LineEmptyC:
		pullpair z_hl		;Screen pos
		pullpair z_de		;Yilemap pos

;Platform specific commands to move down 8 pixels
	ifdef buildbbc
		inc z_h
		inc z_h
		lda #0
		sta z_ls
	endif
	ifdef buildC64
		lda z_l
		clc
		adc #$40
		sta z_l		;down one strip +$140
		bcc TileDoneNoH2
		inc z_h
TileDoneNoH2:
		inc z_h
		
		lda #0
		sta z_ls
endif
ifdef buildA52
		lda z_l
		clc
		adc #$40
		sta z_l		;down one strip +$140
		bcc TileDoneNoH22
		inc z_h
TileDoneNoH22:
		inc z_h
			
	endif
	ifdef buildLNX	
		lda z_L
		clc
		adc #$E0
		sta z_L
		lda z_H
		adc #$1
		sta z_H
	endif
	ifdef BuildPCE
		lda z_l
		clc
		adc #32
		sta z_l
		bcc SpriteNextLine
		inc z_h
SpriteNextLine:
	endif	
	ifdef BuildSNS
		lda z_l
		clc
		adc #64
		sta z_l
		bcc SpriteNextLine
		inc z_h
SpriteNextLine:
	endif	
	ifdef BuildAP2
		lda z_l
		clc
		adc #$80
		sta z_l
		bcc SpriteNextLine
		inc z_h
		lda z_h
		and #%00000011
		bne SpriteNextLine
		lda z_h
		sec
		sbc #%00000100
		sta z_h
		lda z_l
		clc
		adc #$28
		sta z_l
SpriteNextLine:
	endif
	ifdef buildA80
		lda z_l
		clc
		adc #$40
		sta z_l				;down one strip +$140
		bcc TileDoneNoH22
		inc z_h
TileDoneNoH22:
		inc z_h			
	endif
	
	

		lda z_iyh			;update tilemap source (add width)
		clc
		adc z_e
		sta z_e
		bcc noupper2c
		inc z_d
noupper2c:
	pullpair z_bc

	dec z_c
	beq Notnextlinec		;repeat for next line
		jmp nextlinec
Notnextlinec:



WriteCacheEnd2:
	loadpairfrom z_hl,cachetableaddr
	ldy #1
	lda z_ixl
	sta (z_hl),y			;write final address of cache data
	iny 
	lda z_ixh
	sta (z_hl),y

	lda #cacheentrybytes
	clc
	adc z_l
	sta z_l
	bcc writecacheend
	inc z_h
writecacheend:

	ldy #0
	tya
	sta (z_ix),y		;0 0 0 - end of cache marker
	iny
	sta (z_ix),y
	iny
	sta (z_ix),y
	rts					;return new cache address in hl

	
overthiscache:		;We're at the last line contained in this cache
	pushpair z_hl
		jsr writecacheend2		;write end of cache
		lda z_l
		sta cachetableaddr		;save cache address
		lda z_h
		sta cachetableaddr+1
	pullpair z_hl
	jmp nextcache				;start the next cache

	
;the cache has no more space 
;we'll flush it now, and start again

cachefull:
	jsr writecacheend			;complete the cache
	pushpair z_bc
	pushpair z_de
	pushpair z_hl
		pushpair z_bcs
		pushpair z_des
		pushpair z_hls
			pushpair z_iy
				loadpairfrom z_iy,cachetableaddr
				pushpair z_iy
					jsr getcacheiy			;z=empty
					beq CacheEmpty
						jsr processcache	;process the cache
CacheEmpty
				pullpair z_iy
				ldy #cache_addrbak
				lda (z_iy),y
				sta z_ixl
				iny
				lda (z_iy),y
				sta z_ixh
			pullpair z_iy
		pullpair z_hls
		pullpair z_des
		pullpair z_bcs
		lda #0
		sta z_hs				;force write of pattern addr
	pullpair z_hl
	pullpair z_de
	pullpair z_bc
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ResetCaches:
	ldx #cacheentries		;cache entry count
	
	loadpair z_ix,cachetable
ResetCachesAgain:
	ldy #cache_addrbak
	lda (z_ix),y			;Get Default Addr
	pha
		iny 
		lda (z_ix),y
		
		ldy #cache_addrcur+1 ;Set addr
		sta (z_ix),y
		dey
	pla
	sta (z_ix),y
	
	lda #cacheentrybytes 	;Move to next entry
	sta z_c
	jsr AddIX_0C
		
	dex
	bne ResetCachesAgain 
	rts

	
processcache:
	ifdef doublebuffered
		rts
	endif

	pushpair z_ix
processcacheagain:

		ldy #0
		lda (z_ix),y			;cache 1: line length
		beq processcachezero	;0=special action
		sta z_iyl
		
		iny
		lda (z_ix),y			;cache 2+3: vram dest
		sta z_l
		iny
		lda (z_ix),y			
		sta z_h
		
		iny
		lda (z_ix),y			;cache 4+5: tilemap src
		sta z_cs
		iny
		lda (z_ix),y		
		sta z_bs
		

		ifdef hiresy
			;ifdef buildcpc
				;lda z_h
				;ora #%00100000		;Example for half offset
				;bne dostriphalf
			;endif
		endif
		
		ldy #0
nexttile:

		ifdef slowdowntest
	;                                      			ld a,0	
			lda #0
slowdown:
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			sec
			sbc #1
			bne slowdown
		endif
		
		
		lda (z_bcs),y		;Tilenumber

		ror	;rra			;get the 'needs update' bit
		ifdef nodrawcache
			jmp drawtile		;update even if not needed!
		else
			bcs drawtile	;update if needed
		endif

TileDoneBCs_Plus2:
		inc z_Cs
		inc z_Cs
		BNE	IncBCs2_Done
		INC	z_Bs
IncBCs2_Done:


TileDone:
		ifdef buildBBC
			lda z_l
			clc
			adc #16
			sta z_l		;across one tile
			bcc TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildC64
			lda z_l
			clc
			adc #$8	
			sta z_l		;across one tile
			bcc TileDoneNoH
			inc z_h
TileDoneNoH:
			
		endif
		ifdef buildAP2
			inc z_l
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildPCE
			inc z_l
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildSNS
			inc z_l
			inc z_l
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildLNX
			lda z_l
			clc
			adc #3
			sta z_l
			bcc TileDoneNoH2
			inc z_h
TileDoneNoH2:
		endif
		
		ifdef buildA52
			inc z_l
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		ifdef buildA80
			inc z_l
			bne TileDoneNoH
			inc z_h
TileDoneNoH:
		endif
		dec z_iyl
		bne nexttile
		

		
tiledone2:
		;doei				;ei command if required
		
		lda #5		;5 bytes per cache entry 
		clc
		adc z_ixl
		sta z_ixl
		bcc tiledone2ixh
			inc z_ixh
tiledone2ixh:
		jmp processcacheagain

		
		
processcachezero:		;zerobyte read
		ldy #1
		lda (z_ix),y			;>0 pattern address
		sta z_es
		iny
		lda (z_ix),y			
		sta z_ds
		
		ora z_es
		beq processcachedone	;==0 end of cache
		
		ifdef tiletint
			iny
			lda (z_ix),y		;extra byte for 16 color tint 
			sta tiletint
		endif
		
		ifdef tiletint
			lda #4				;extra byte for 16 color tint 
		else
			lda #3
		endif		
		sta z_c
		jsr AddIX_0C

		jmp processcacheagain
processcachedone:

	pullpair z_ix
	jmp writecacheend

; IncIX:
		; INC z_IXL
		; BNE	IncIX_Done
		; INC	z_IXH
; IncIX_Done:
		; rts