
	ifndef Spr_XY
	
;Pointers to sprite 0bject parameters
spr_xy equ 0
spr_wh equ 2
spr_tilemaphl equ 4
spr_patternhl equ 6
spr_cropcache equ 8
spr_cropcache_back equ 18
	endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;HL=BGTilemap, DE=Width/Height ;C=BG TilemapWidth

GetTilemapUnderSprite:
	ldy #crop_f		
	lda (z_ix),y	;Crop declared sprite offscreen?
	beq lbl26768	;return if not onscreen	
	clc				;Flag Failure
	rts
lbl26768

	ldy #crop_y
	lda (z_ix),y
	sta z_c
	
	iny ;ldy #crop_x
	lda (z_ix),y
	sta z_b

	ldy #crop_h
	lda (z_ix),y
	sta z_l
	
	iny ;ldy #crop_w
	lda (z_ix),y
	sta z_h
	
	jsr docroplogicaltotile	;Convert to tile co-ords (/4)
	bne lbl25966			;return if zero tiles
		clc					;Flag Failure
		rts
lbl25966

	pushpair z_hl
		jsr shifttilemap	;C=Ypos B=Xpos... Returns HL address
	pullpair z_de			;Width/Height
	sec						;Flag Success
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Convert logical pos to tilemap tile pos 
; z=true if size is zero

docroplogicaltotile:	;BC=Xypos HL= WH
	lsr z_b				;Z= invalid width/height
	lsr z_b		;xpos /4
	
	lsr z_c
	lsr z_c		;ypos /4
	
	lsr z_l
	lsr z_l		;height /4
	
	lsr z_h
	lsr z_h 	;width /4
	
	
	lda z_h		;is width or height zero?
	beq MaxTileDoRet
	lda z_l
MaxTileDoRet:
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;redraw the background under a sprite

removesprite:		;BC= X,Y pos   DE=Wid/Hei
	jsr gettilemapundersprite
	bcc MaxTileDoRet	;carry=something to draw (c=tilemap width)
	
updatetilecacheb:
	ldx z_d			;Width
	ldy #0
flagcacheagain:
	lda (z_hl),y
	ora #%00000001	;Set 'Redraw' flag of background tile
	sta (z_hl),y
	iny
	iny
	dex
	bne FlagCacheAgain
updatetilecachea:
	jsr AddHL_0C	;C=tilema[p width

	dec z_e			;Height
	bne updatetilecacheb
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	ifndef doublebuffered

FlagSpriteForRedraw:		;Flag sprite IX tiles for redraw
		lda #0
		sta z_h
		sta z_l
		
		ldy #spr_wh+1
		lda (z_ix),y		;Width
		lsr
		lsr 				;Logical->tiles
		sta z_c
		
		ldy #spr_wh
		lda (z_ix),y		;height
		lsr 
		lsr 				;Logical->tiles
		tax
	
FlagSpriteforredraw_Mult:	;Calculate tile count
			jsr AddHL_0C	;Width
		dex					;*Height
		bne FlagSpriteforredraw_Mult
		
		lda z_h
		sta z_b				
		lda z_l
		sta z_c
		
		ldy #spr_tilemaphl
		lda (z_ix),y	
		sta z_l
			
		ldy #spr_tilemaphl+1
		lda (z_ix),y	
		sta z_h
			
ResetTilemapSprite:		;HL=Tilemap BC=Tilecount
		ldy #0
		lda (z_hl),y
		and #%11111110
		cmp #$f2			;transparent
		bne resettilemapdoit
		iny ;jsr inchl

		lda (z_hl),y		;255=empty tile
		cmp #255
		beq resettilemapskip
		dey ;jsr dechl
resettilemapdoit:
		lda (z_hl),y
		ora #%00000001
		sta (z_hl),y		;Set tile to redraw
				
resettilemapskip:
		jsr IncHLx2
		jsr decbc

		lda z_b
		ora z_c
		bne resettilemapsprite
		rts

		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ResetTilemap:			;reset bc tiles of tilemap hl
		ldx #0
		lda (z_hl,x)	;flag tile to redraw
		ora #%00000001
		sta (z_hl,x)		

		jsr IncHLx2
		jsr decbc
		
		lda z_b
		ora z_c
		bne resettilemap
		rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Flag a rectangular area in the tilemap HL

ResetTilemapPart:		;DE=WH C=TileMapwidth HL=Tile src
		ldx z_d
		sta z_b			;Width

		ldy #0
resettilemappartb:
			
		lda (z_hl),y
		ora #%00000001	;flag tile to redraw
		sta (z_hl),y	

		iny				;Across one tile
		iny

		dex
		bne resettilemappartb

		lda z_c			;Down one line
		clc
		adc z_l
		sta z_l
		bcc resettilemapparttok
		inc z_h
resettilemapparttok:

		dec z_e			;Height
		bne resettilemappart
		rts
	endif


	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		
AddHL_0C:		;Add C to HL
		clc
		lda z_c
		adc z_l
		sta z_l
		bcc AddHL_0C_Done
		inc z_h
AddHL_0C_Done:
MaxTileDoRet2:
		rts
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Force refresh of sprite if background changed

ResetDirtySpriteIX:		;IX=Sprite object data
	ldy #spr_cropcache+crop_f
	lda (z_ix),y
	bne MaxTileDoRet2
	
	jsr AddIX_spr_cropcache	;Move to Crop cache

	ldy #crop_y
	lda (z_ix),y
	sta z_c
	iny ;ldy #crop_x
	lda (z_ix),y
	sta z_b
	
	ldy #crop_h
	lda (z_ix),y
	sta z_l
	iny ;ldy #crop_w
	lda (z_ix),y
	sta z_h
	
	lda backgroundtilemapscrolly
	and #%00000010			;%????TTHH
	beq dirty_nohalfy	
	inc z_c					;Increase width 1/2 tile
	inc z_c
dirty_nohalfy:

	lda backgroundtilemapscrollx
	and #%00000010			;%????TTHH
	beq dirty_nohalfx
	inc z_b					;increase height 1/2 tile
	inc z_b
dirty_nohalfx:
	jsr docroplogicaltotile ;convert to tile co-ords
	beq MaxTileDoRet2
	
	inc z_h					;Increase size 1 tile
	inc z_l
	lda z_h
	sta z_iyh
	lda z_l
	sta z_iyl

	jsr shifttilemap

	ldy #crop_sl			;Source Sprite Tilemap Address 
	lda (z_ix),y
	sta z_e
	iny ;ldy #crop_sh
	lda (z_ix),y
	sta z_d
	
updatetilecachebb:
	pushpair z_hl
	pushpair z_de
		lda z_iyh			;Width
		sta z_b
flagcacheagainb:
		ldx #0
		lda (z_hl,x)
		and #%00000001		;Test background tilemap for redraw
		beq cacheclean
			ldy #0
	
		lda (z_de),y
		ora #%00000001		;set background tilemap for redraw
		sta (z_de),y		;set center sprite tile
		iny ;jsr incde
		iny ;jsr incde
		
		lda (z_de),y
		ora #%00000001		;set background tilemap for redraw
		sta (z_de),y		;set right sprite tile
		dey ;jsr decde
		dey ;jsr decde
					
		ldy #crop_stilew
		lda (z_ix),y 		;Width
		asl					;2 bytes per tile
		tay
		
		lda (z_de),y
		ora #%00000001		;set background tilemap for redraw
		sta (z_de),y		;set right sprite tile
		
		iny
		iny
		lda (z_de),y
		ora #%00000001		;set background tilemap for redraw
		sta (z_de),y		;set right sprite tile

cacheclean:
		jsr IncDEx2			;across one sprite tile
		jsr IncHLx2			;across one background tile
		dec z_b
		bne flagcacheagainb	;repeat for width
	pullpair z_de
	pullpair z_hl

	ldy #crop_stilew
	lda (z_ix),y			;tilemap width
	asl 
	clc
	adc z_e					;down one tilwmap line
	sta z_e
	bcc dirtydeok
	inc z_d
dirtydeok:
	jsr addhl_bc

	dec z_iyl				;repeat for height
	beq updatetilecachebbDone
		jmp updatetilecachebb
updatetilecachebbDone:
MaxTileDoRet3:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Set tiles in background cache that will be overlapped by next sprite draw

ZeroSpriteinCache:	;IX=Sprite object data
	jsr AddIX_spr_cropcache
	
	ldy #crop_f
	lda (z_ix),y	
	bne MaxTileDoRet3		;nz - all offscreen
	

	ldy #crop_y
	lda (z_ix),y	
	sta z_c
	iny ;ldy #crop_x
	lda (z_ix),y	
	sta z_b
	
	ifdef hiresx
		inc z_b			;xpos + 1/2 tile
		inc z_b
	endif
	ifdef hiresy
		inc z_c			;ypos +1/2 tile
		inc z_c
	endif
	
	ldy #crop_h
	lda (z_ix),y	
	sta z_l
	dec z_l				;round down H	
	iny ;ldy #crop_w
	lda (z_ix),y	
	sta z_h
	dec z_h				;round down W

	jsr docroplogicaltotile	;convert to tile co-ords
	beq MaxTileDoRet3			;ret z

	lda z_h
	sta z_iyh
	lda z_l
	sta z_iyl
	
	;loadpairfrom z_hl,backgroundtilemapbase - done by shifttilemap
	jsr ShiftTilemap
	
	lda z_l
	sta z_e
	lda z_h
	sta z_d				;DE= Source Tilemap
		
	ldy #crop_sl
	lda (z_ix),y	
	sta z_l
	iny 				;crop_sh
	lda (z_ix),y	
	sta z_h				;HL=Crop Source tilemap
	
;If any of 4 tiles is partially transparent we need to update this tilemap

updatetilecachez:
	pushpair z_hl
	pushpair z_de
		lda z_iyh		;width
		sta z_b
	
flagcacheagainz:
		ldy #0
		
		lda (z_hl),y	;A-
		and #%00111110
		cmp #$32		;Transp Tile?
		beq cachecleanz

		iny ;jsr inchl	;-B
		iny ;jsr inchl

		lda (z_hl),y
		and #%00111110
		cmp #$32			;Transp Tile?
		beq cachecleanz

		ifdef hiresy
			ldy #crop_stilew
			lda z_ix,y
			asl
			tay
			
			lda (z_hl),y		;C-
			and #%00111110
			cmp #$32			;Transp Tile?
			beq abandonchangez
			iny ;jsr dechl
			iny ;jsr dechl

			lda (z_hl),y		;-D
			and #%00111110
			cmp #$32			;Transp Tile?
			beq abandonchangez
			
			jmp dochange

abandonchangez:
			jmp cachecleanz
dochange:
		endif
		ldx #0
		lda (z_de,x)	;ld a,(de)
		and #%11111110	;this tile doesn't need update
		sta (z_de,x)	;ld (de),a
cachecleanz:
		jsr IncHLx2
		jsr IncDEx2

		dec z_b
		bne flagcacheagainz	;repeat for width
	pullpair z_de
	pullpair z_hl

	ldy #crop_stilew
	lda (z_ix),y		;hl (sprite) down a line
	asl 	
	clc
	adc z_l
	sta z_l
	bcc dirtydeokz
		inc z_h
dirtydeokz:
	jsr AddDE_BC		;de (tilemap)+width
		
	dec z_iyl			;Height
	bne updatetilecachez
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;ld hl,PatternData
;ld de,(BackgroundTilemapBase)

Cache_TilemapCls:		;HL=Pattern Sata / DE=Tilemap

	ifdef hspritenumz		
		lda #0
		sta hspritenum
	endif

	lda z_h
	sta z_ds			;DEs = Pattern Data
	lda z_l
	sta z_es

	loadpair z_hl,screenbase	;&vram base

	lda #backgroundtilemapwidthv*2;tilemap width (bytes)
	sta z_iyh

	lda #vscreenwid/4	;draw width (tiles)
	sta z_ixh

	lda #vscreenhei/4	;draw height (tiles)
	sta z_ixl

;DE=Tilemap DE'=Pattern data IX=WH IYH=Tilemap Width HL=Vram Dest
;BC=Cache

	ifdef allowhalftilescroll
		ifdef hiresy
			lda backgroundtilemapscrolly
			ifdef allowquartertilescroll
				eor #255
				and #%00000011		;%????tthq
				beq cls_nohalfy
				dec z_ixl
				and #%00000010		;%????tthq
				beq cls_nohalfy
			else
				and #%00000010		;%????tthq
				bne cls_nohalfy	
				dec z_ixl
			endif

			ifdef buildcpc			;Just an example!
				lda #$e0
				sta z_h
			endif
CLS_NoHalfY:
		endif
		lda backgroundtilemapscrollx
		ifdef allowquartertilescroll
			eor #255
			and #%00000011		;%????tthq
			beq cls_nohalfx
			dec z_ixh
			and #%00000010		;%????tthq
			beq cls_nohalfx
		else
			and #%00000010		;%????tthq
			bne cls_nohalfx
			dec z_ixh
		endif

		ifdef buildcpc
			inc z_l
		endif
CLS_NoHalfX:
	endif

	ifdef allowquartertilescroll
		ifdef hiresy
			lda backgroundtilemapscrolly
			and #%00000001		;%????TTHQ
			bne cls_noquartery
			ifdef buildsam
				inc z_h
			endif
cls_noquartery:
		endif

		lda backgroundtilemapscrollx
		and #%00000001			;%????tthq
		bne cls_noquarterx
		ifdef buildsam
			inc z_l
		endif
cls_noquarterx:
	endif
	jmp drawtilemap
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

						;c=ypos b=xpos
ShiftTilemap:			;hardcoded to 32/36 wide tilemap
	loadpairfrom z_hl,backgroundtilemapbase	
	lda #0
	sta z_d
	
	lda z_c			;Ypos
	asl 
	rol z_d	;2 48
	asl 
	rol z_d	;4 96
	asl 
	rol z_d	;8 192
		
	sta z_e
	ifndef backgroundtilemapwidth32
		jsr addhl_de	;hardcoded to 36*2 wide tilemap
	endif
	
	asl z_e
	rol z_d	;16 384
	asl z_e
	rol z_d	;32 768
	asl z_e
	rol z_d	;64 1536
	jsr addhl_de	;add ypos to hl

	lda #backgroundtilemapwidthv*2
	sta z_c
	
	lda z_b			;Xpos
	asl
	clc
	adc z_l			;add xpos b to hl
	sta z_l
	bcc DoRet2
	inc z_h
DoRet2:
	rts
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


Cache_DrawSprite:
DrawSpriteIX:	;IX=Sprite object data

	ldy #spr_patternhl	;Pattern Source
	lda (z_ix),y
	sta z_es
	iny ;ldy #spr_patternhl+1
	lda (z_ix),y
	sta z_ds

	jsr AddIX_spr_cropcache	;Move to Crop cache

	ldy #crop_f
	lda (z_ix),y
	bne DoRet2			;Return on NZ

	ldy #crop_vraml
	lda (z_ix),y		;Vram dest
	sta z_l
	iny ;ldy #crop_vramh
	lda (z_ix),y		
	sta z_h
	
	ldy #crop_sl		;source tilemap
	lda (z_ix),y
	sta z_e
	iny ;ldy #crop_sh	
	lda (z_ix),y
	sta z_d
		
	ldy #crop_h
	lda (z_ix),y
	lsr 
	lsr 				;convert to tile height
	pha	
		ldy #crop_stilew
		lda (z_ix),y	;source tilemap width
		asl
		sta z_iyh		;tilemap width
		
		ldy #crop_w
		lda (z_ix),y
		lsr
		lsr
		sta z_ixh		;convert to Tile width
	pla
	sta z_ixl			;Tile Height
	
	ifdef drawtilemaph
		jmp drawtilemaph	;hardware sprites
	else
		jmp drawtilemap		;regular
	endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Crop_X equ 1		;XY pos
Crop_Y equ 0		
Crop_W equ 3		;Width Height
Crop_H equ 2
Crop_SL equ 4		;Source Tilemap HL
Crop_SH equ 5
Crop_F equ 6		;Flags 1=offscreen
Crop_STileW equ 7	;SourceTileWidth
Crop_VramL equ 8	;Sprite VRAM Not used by background
Crop_VramH equ 9	;Sprite VRAM Not used by background


calccrop:
	lda z_h				;width
	lsr
	lsr
	ldy #crop_stilew	;width in tiles
	sta (z_ix),y
	
	jsr docrop
	bcs calccropabort
	
	ldy #crop_y
	lda z_c				;XY-pos
	sta (z_ix),y
	iny ;ldy #crop_x
	lda z_b
	sta (z_ix),y
		
	ldy #crop_h
	lda z_l				;WidthHeight
	sta (z_ix),y	
	iny ;ldy #crop_w
	lda z_h
	sta (z_ix),y	
		
	ldy #crop_sl
	lda z_iyl			;Source Tilemap HL
	sta (z_ix),y	
	iny ;ldy #crop_sh
	lda z_iyh
	sta (z_ix),y	
		
	lda #0				;Flag (Onscreen)
	beq calccropdone
	
calccropabort:
	lda #1				;Flag (offscreen)
calccropdone:
	ldy #crop_f
	sta (z_ix),y		
	rts

docrop_alloffscreen2:
	sec					;set carry (nothing to draw)
	rts


;X,Y pos = BC   Width+Height = HL   IY=Source Tilemap
	
docrop:	
	ldy #0				;Y=0 throughout this routine
	sty z_d
	sty z_e				;e=top d=bottom crop

	
;Crop top side
	lda z_c
	sec
	sbc cropyh+1 ;z_ixh	 ;VscreenMinY - Logical top of the screen
	bcs notcrop
	
	jsr neg
	clc
	adc #3
	sta z_e				;Top Crop
	and #%11111100
	cmp z_l				;No pixels onscreen?
	bcs docrop_alloffscreen2	;All Offscreen

;height calculations split and moved so we can
; draw sprites taller than draw area
	jsr neg
	clc
	adc z_l
	sta z_l

	lda z_e
	and #%00000011
	eor #%00000011		;Shift amount
notcrop:
	sta z_c
	
	
;crop bottom side
	clc
	adc z_l
	sec
	sbc cropyh			;z_ixl - logical height of screen
	bcc nobcrop
	and #%11111100
	cmp z_l				;no pixels onscreen?
	bcs docrop_alloffscreen2	;all offscreen
	sta z_d				;bottom crop

	
;Calculate New Height
	lda z_l
	sec
	sbc z_d				;Fix height
	sta z_l

;Calculate new IY Start
nobcrop:
	lda z_e
	lsr
	lsr					;Lines to remove from top
	beq novclip
	tax
					
	lda z_h				;Bytes per line	
	lsr 
	sta z_d

	lda z_iyl
	clc

;remove lines from the top (start pos of source data)
movedownaline:
	adc z_d 
	bcc movedownalineB	
	inc z_iyh			;Update Start Byte
	clc
movedownalineB:		
	dex
	bne movedownaline
	sta z_iyl	

	
NoVClip:
	sty z_d				;X=0
	sty z_e				;e=top d=bottom crop

;crop left hand side
	lda z_b
	sec
	sbc cropxw+1 ;z_ixh - vscreenminx  64 = leftmost visible tile
	bcs nolcrop
	jsr neg
	clc
	adc #3
	sta z_e
	and #%11111100
	cmp z_h				;no pixels onscreen?
	bcs docrop_alloffscreen
	jsr neg
	clc
	adc z_h
	sta z_h

	lda z_e
	and #%00000011		;X shift 
	eor #%00000011
nolcrop:
	sta z_b

	
;Crop Right hand side
	clc
	adc z_h
	sec
	sbc cropxw			;z_ixl vscreenwid-vscreenwidclip	
						;logical width of screen
	bcc norcrop
	and #%11111100
	cmp z_h	;no pixels onscreen?
	bcs docrop_alloffscreen	;offscreen
	sta z_d
	
	
;Calculate new width
	lda z_h
	sec
	sbc z_d
	sta z_h				;fix width

;Calculate new IY start	
norcrop:
	lda z_e				;amount to subtract from left
	lsr					;convert to tile count (/4)
	and #%11111110
	clc
	adc z_iyl
	sta z_iyl
	bcc nohclip
	inc z_iyh
nohclip:
	clc
	rts

docrop_alloffscreen:
	sec					;set carry (nothing to draw)
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

neg:
	eor #255
	clc
	adc #1
	rts


		
AddIX_spr_cropcache:		;Move IX to the Cropcache part
	lda #spr_cropcache
	sta z_c

AddIX_0C:					;Add C to IX
		clc
		lda z_c
		adc z_ixl
		sta z_ixl
		bcc AddIX_0C_Done
		inc z_ixh
AddIX_0C_Done:
		rts

AddIY_0C:					;Add C to IY
		clc
		lda z_c
		adc z_iyl
		sta z_iyl
		bcc AddIY_0C_Done
		inc z_iyh
AddIY_0C_Done:
		rts
		
AddIX_BC:			;Add BC to HL
	clc
	lda z_c
	adc z_ixl
	sta z_ixl
	lda z_b
	adc z_ixh
	sta z_ixh
	rts
	
AddIY_BC:			;Add BC to HL
	clc
	lda z_c
	adc z_iyl
	sta z_iyl
	lda z_b
	adc z_iyh
	sta z_iyh
	rts
	
	
IncDEx2:
		INC z_E
		;BNE	IncDE
		;INC	z_D
IncDE:
		INC z_E
		BNE	IncDE_Done
		INC	z_D
IncDE_Done:
		rts
		
IncHLx2:
		INC z_L
;		BNE	IncHL
		;INC	z_H	
IncHL:
		INC z_L
		BNE	IncHL_Done
		INC	z_H
IncHL_Done:
		rts
		