;See Z80 version for documentation


VM_fHalt  equ  %10000000	;HALT ocurred (Set Automatically)
VM_fSleep equ  %01000000	;Sleep (Set Manually)
VM_fTrap  equ  %00100000	;Trap Running (Set Manually)
VM_fError equ  %00010000	;Unknown Opcode (Set Automatically) \ Syscall function \ Trap function
VM_fIntDis equ  %00001000	;Interrupts disabled (Set Manually)
VM_fTrace equ  %00000100	;Trace enabled (monitor after each command)
VM_fZero equ  %00000010		;Last command resulted in Zero
VM_fCarry equ  %00000001		;Last command resulted in Carry


VM_rR0 equ 0	;Accumulator A - 16 bit AK pair  (Default Destination for ops)
VM_rR1 equ 1	;K (Counter?)
VM_rR2 equ 2	;Accumulator B  - 16 bit UB Pair  (Default parameter for ops)
VM_rR3 equ 3	;U
VM_rR4 equ 4	;E - 16 bit DE pair 
VM_rR5 equ 5	;D
VM_rR6 equ 6	;L - 16 bit HL Pair
VM_rR7 equ 7	;H

VM_rR8 equ 16	;Zero page entries 
VM_rR9 equ 17
VM_rR10 equ 18
VM_rR11 equ 19
VM_rR12 equ 20
VM_rR13 equ 21
VM_rR14 equ 22
VM_rR15 equ 23

VM_rR16 equ 24	;Zero page entries 
VM_rR17 equ 25
VM_rR18 equ 26
VM_rR19 equ 27
VM_rR20 equ 28
VM_rR21 equ 29
VM_rR22 equ 30
VM_rR23 equ 31

R0 equ 0
R1 equ 1
R2 equ 2
R3 equ 3
R4 equ 4
R5 equ 5
R6 equ 6
R7 equ 7


R8 equ 16	;Zero page entries 
R9 equ 17
R10 equ 18
R11 equ 19
R12 equ 20
R13 equ 21
R14 equ 22
R15 equ 23

R16 equ 24	;Zero page entries 
R17 equ 25
R18 equ 26
R19 equ 27
R20 equ 28
R21 equ 29
R22 equ 30
R23 equ 31


VM_rF equ  8	;Flags %HSTEItZC (Halted) (Halted -Sleeping) (Trap running) (Error - unknown opcode) (Interrupt disabled) (Zero) (Carry) (t=trace)
VM_rFU equ 9	;Flags User (unused by cpu - backed up with PHF / PLF) 
VM_rPC equ 10	;Program Counter
VM_rSP equ 12	;Stack pointer
VM_rVB equ 14	;Vblanks (0-65535)

vm_rBank0 equ 32	;&0000-&3FFF 
vm_rBank1 equ 36	;&4000-&7FFF
vm_rBank2 equ 40	;&8000-&BFFF
vm_rBank3 equ 44	;&C000-&FFFF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;%-PPPFFF-
;Prep: (tasks run before command)
prp_Nothing equ 0*16
prp_VM_GetAddress_Branch  equ 1*16
prp_VM_GetAddress equ 2*16
prp_VM_GetAddress_VM_GetFlagC  equ 3*16
prp_VM_GetAddress16 equ 4*16	
prp_VM_GetAddressPrep_ZPDest equ 5*16	;Patched for INC ZP (Dest=Param)
prp_VM_GetAddressPrep_ZPDest_GetFlagC equ 6*16

;Finishers: (tasks run after command)
fin_Nothing equ 0*2
fin_VM_PC_Store equ 1*2
fin_VM_PCINC equ 2*2
fin_VM_PCINC_FZ equ 3*2
fin_VM_PCINC_FZ_LD_IX_E equ 4*2
fin_VM_PCINC_FZ_LD_IX_DE equ 5*2
fin_VM_PCINC_LD_IX_E equ 6*2
fin_VM_PCINC_LD_IX_DE equ 7*2

;WE Subtract 1 to make the 6502 RET command work the same as the Z80 1.

	;align 2
vm_ParameterAddressingModes:						;Subtract 5
	dw VM_GetAddress_R6-1							;vm_pR6 equ 5	;Param R6
	dw VM_GetAddress_ByteParam_Indir16_R2_BaseImm-1	;vm_PB2 equ 6 	;Indirect 16 bit pointer R2 (16 bit to anywhere) - Base+imm8 offset
	dw VM_GetAddress_ByteParam_Indir16_R4_BaseImm-1	;vm_PB4 equ 7 	;Indirect 16 bit pointer R4 (16 bit to anywhere) - Base+imm8 offset
	dw VM_GetAddress_ByteParam_Indir16_R2_PostInc-1	;vm_PU2 equ 8 	;Indirect 16 bit pointer R2 (16 bit to anywhere) - PostInc
	dw VM_GetAddress_ByteParam_Indir16_R6_PostInc-1	;vm_PU6 equ 9 	;Indirect 16 bit pointer R6 (16 bit to anywhere) - PostInc
	dw VM_GetAddress_ByteParam_Indir16_R4-1			;vm_PQ4 equ 10 	;Indirect 16 bit pointer R4 (16 bit to anywhere)
	dw VM_GetAddress_ByteParam_Indir16_R6-1			;vm_PQ6 equ 11 	;Indirect 16 bit pointer R6 (16 bit to anywhere)
	dw VM_GetAddress_ByteParam_ImmAddr16-1			;vm_pA6 equ 12	;Address 16
	dw VM_GetAddress_ByteParam_ImmAddr8-1			;vm_pA8 equ 13	;Address 8 (ZeroPage)
	dw VM_GetAddress_ByteParam_Imm16-1				;vm_pI6 equ 14	;Immediate 16 - Source only
	dw VM_GetAddress_ByteParam_Imm8-1				;vm_pI8 equ 15	;Immediate 8 - Source only


vm_PrepVectors:				;Subtract 1 - Zero is nothing
	dw VM_GetAddress_Branch-1 				;1 - Branches
	dw VM_GetAddressPrep-1					;2 - Basic
	dw VM_GetAddress_VM_GetFlagC-1			;3 - Get Carry Flag
	dw VM_GetAddressPrep16-1				;4 - Patch for 16 bit imm
	dw VM_GetAddressPrepZPDest-1			;5 - Patch for INC ZP
	dw VM_GetAddressPrepZPDest_GetFlagC-1	;6 patch for ROLz RORz
	
vm_FinVectors:				;Subtract 1 - Zero is nothing
	dw VM_PC_Store-1			;1 store PC
	dw VM_PCINC-1				;2 INC PC
	dw VM_PCINC_FZ-1			;3 store flags
	dw VM_PCINC_FZ_LD_IX_E-1	;4 store flags
	dw VM_PCINC_FZ_LD_IX_DE-1	;5 store flags and save 16 bit
	dw VM_PCINC_LD_IX_E-1 		;6 save
	dw VM_PCINC_LD_IX_DE-1 		;7 save 16 bit

	
vm_DecoderMatrix:
	dwb cmd_NOP-1,		0
	dwb cmd_PSH-1,		fin_VM_PCINC
	dwb cmd_PUL-1,		fin_VM_PCINC
	dwb cmd_PHF-1,		fin_VM_PCINC
	dwb cmd_BRA-1,		prp_VM_GetAddress_Branch+fin_VM_PC_Store
	dwb cmd_BSR-1,		prp_VM_GetAddress_Branch+fin_VM_PC_Store
	dwb cmd_BEQ-1,		prp_VM_GetAddress_Branch+fin_VM_PC_Store
	dwb cmd_BNE-1,		prp_VM_GetAddress_Branch+fin_VM_PC_Store
	dwb cmd_BCS-1,		prp_VM_GetAddress_Branch+fin_VM_PC_Store
	dwb cmd_BCC-1,		prp_VM_GetAddress_Branch+fin_VM_PC_Store
	dwb cmd_ADD-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_SUB-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_CMP-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ
	dwb cmd_MOV-1,		prp_VM_GetAddress+fin_VM_PCINC_LD_IX_E
	dwb cmd_STO-1,		prp_VM_GetAddress+fin_VM_PCINC
	dwb cmd_LEA-1,		prp_VM_GetAddress+fin_VM_PCINC_LD_IX_DE
	dwb cmd_NEG-1,		prp_VM_GetAddressPrep_ZPDest+fin_VM_PCINC_FZ_LD_IX_E
	
	dwb cmd_ROL-1,		prp_VM_GetAddressPrep_ZPDest_GetFlagC+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_ROR-1,		prp_VM_GetAddressPrep_ZPDest_GetFlagC+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_ASL-1,		prp_VM_GetAddressPrep_ZPDest_GetFlagC+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_ASR-1,		prp_VM_GetAddressPrep_ZPDest_GetFlagC+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_LSR-1,		prp_VM_GetAddressPrep_ZPDest_GetFlagC+fin_VM_PCINC_FZ_LD_IX_E
	
	dwb cmd_INC-1,		prp_VM_GetAddressPrep_ZPDest+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_DEC-1,		prp_VM_GetAddressPrep_ZPDest+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_AND-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_ORR-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_XOR-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_TRP-1,		prp_VM_GetAddress+fin_VM_PC_Store
	dwb cmd_SYS-1,		prp_VM_GetAddress
	dwb cmd_MOV16-1,	prp_VM_GetAddress16+fin_VM_PCINC_LD_IX_DE
	dwb incde-1,		prp_VM_GetAddressPrep_ZPDest+fin_VM_PCINC_FZ_LD_IX_DE
	dwb decde-1,		prp_VM_GetAddressPrep_ZPDest+fin_VM_PCINC_FZ_LD_IX_DE
	dwb AddDE_BC-1,		prp_VM_GetAddress16+fin_VM_PCINC_FZ_LD_IX_DE
	dwb cmd_SUB16-1,	prp_VM_GetAddress16+fin_VM_PCINC_FZ_LD_IX_DE
	dwb cmd_SWP16-1,	prp_VM_GetAddress16+fin_VM_PCINC_LD_IX_DE
	dwb cmd_STO16-1,	prp_VM_GetAddress16+fin_VM_PCINC
	dwb cmd_BRA16-1,	prp_VM_GetAddress16+fin_VM_PC_Store	
	dwb cmd_BSR16-1,	prp_VM_GetAddress16+fin_VM_PC_Store	
	dwb cmd_TST-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ
	dwb cmd_CMP16-1,	prp_VM_GetAddress16+fin_VM_PCINC_FZ
	dwb cmd_CLR-1,		prp_VM_GetAddressPrep_ZPDest+fin_VM_PCINC_LD_IX_E
	dwb cmd_CLR-1,		prp_VM_GetAddressPrep_ZPDest+fin_VM_PCINC_LD_IX_DE
	dwb cmd_TOR-1,		prp_VM_GetAddress+fin_VM_PCINC_FZ
	dwb cmd_ADC-1,		prp_VM_GetAddress_VM_GetFlagC+fin_VM_PCINC_FZ_LD_IX_E
	dwb cmd_SBC-1,		prp_VM_GetAddress_VM_GetFlagC+fin_VM_PCINC_FZ_LD_IX_E
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Instruction Set

vm_NOP equ %00000000	;No-Operation
vm_RET equ %00000001	;Return from sub
vm_HLT equ %00000010	;Stop Processor
vm_SEC equ %00000011	;Set Carry

vm_PH0 equ %00000100
vm_PH2 equ %00000101
vm_PH4 equ %00000110
vm_PH6 equ %00000111

vm_PL0 equ %00001000
vm_PL2 equ %00001001
vm_PL4 equ %00001010
vm_PL6 equ %00001011

vm_PHF equ %00001100
vm_PLF equ %00001101

vm_BRA equ %00010000
vm_BSR equ %00010100
vm_BEQ equ %00011000
vm_BNE equ %00011100
vm_BCS equ %00100000
vm_BCC equ %00100100
vm_ADD equ %00101000
vm_SUB equ %00101100
vm_CMP equ %00110000
vm_MOV equ %00110100			;Move Param to Dest
vm_STO equ %00111000			;Store Dest To Param
vm_LEA equ %00111100			;Load Effective address
vm_NEG equ %01000000
vm_ROL equ %01000100			;Rotate with carry
vm_ROR equ %01001000
vm_ASL equ %01001100
vm_ASR equ %01010000
vm_LSR equ %01010100
vm_INC equ %01011000
vm_DEC equ %01011100
vm_AND equ %01100000
vm_ORR equ %01100100
vm_XOR equ %01101000
vm_TRP equ %01101100			;Trap #PARAM
vm_SYS equ %01110000			;Syscall #PARAM
vm_MOV16 equ %01110100
vm_INC16 equ %01111000
vm_DEC16 equ %01111100
vm_ADD16 equ %10000000
vm_SUB16 equ %10000100
vm_SWP16 equ %10001000			;Swap 2 16 bit values
vm_STO16 equ %10001100

vm_BRA16 equ %10010000			;Branch To 16 bit Relative offset PARAM
vm_BSR16 equ %10010100			;Branch To Sub 16 bit Relative offset PARAM
vm_TST   equ %10011000
vm_CMP16 equ %10011100
vm_CLR equ   %10100000
vm_CLR16 equ %10100100
vm_TOR equ   %10101000			;Test OR
vm_ADC equ   %10101100	
vm_SBC equ    %10110000	
;Reserved for future use!
;vm_CMD equ   %10110100			;Command switch
;vm_ADR equ   %10111000			;Address switch
;vm_CPU equ   %10111100			;Cpu switch
vm_LastComamnd equ %10110100

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Addressing Modes Branch:
 
vm_b2B equ 0 	;Branch PC+2 
vm_bI8 equ 1	;Branch PC+Imm8 (Signed relative)
vm_bI6 equ 2	;Branch PC+Imm16 (Absolute addr)
vm_bR6 equ 3	;Branch R6/R7 (Absolute addr in R6/7)

;Addressing Modes Command:

vm_aAB equ 0	;AB Accumulator
vm_aIM equ 1	;Immediate
vm_aZP equ 2	;ZeroPage
vm_aBP equ 3	;ByteParam  %PARAM/DEST

;Addressing Modes Parameter:

;Syntax is z80 style eg:
;XOR A,B		A is destination B is parameter

vm_pR0 equ 0	;Param R0
vm_pR1 equ 1	;Param R1
vm_pR2 equ 2	;Param R2
vm_pR3 equ 3	;Param R3
vm_pR4 equ 4	;Param R4
;vm_pR5 equ 5	;Param R5 - Not available use zeropage
vm_pR6 equ 5	;Param R6
;vm_pR7 equ 7	;Param R7 - Not available - use zeropage
vm_PB2 equ 6 	;Indirect 16 bit pointer R2 (16 bit to anywhere) - Base+imm8 offset
vm_PB4 equ 7 	;Indirect 16 bit pointer R4 (16 bit to anywhere) - Base+imm8 offset
vm_PU2 equ 8 	;Indirect 16 bit pointer R2 (16 bit to anywhere) - PostInc
vm_PU6 equ 9 	;Indirect 16 bit pointer R6 (16 bit to anywhere) - PostInc
vm_PQ4 equ 10 	;Indirect 16 bit pointer R4 (16 bit to anywhere)
vm_PQ6 equ 11 	;Indirect 16 bit pointer R6 (16 bit to anywhere)
vm_pA6 equ 12	;Address 16
vm_pA8 equ 13	;Address 8 (ZeroPage)
vm_pI6 equ 14	;Immediate 16 - Source only
vm_pI8 equ 15	;Immediate 8 - Source only

vm_pRF equ 15	;Flags Reg - Dest only
vm_pQS equ 14	;Indirect 16 bit pointer SP - Dest Only

;vm_PP2 equ 8 	;Indirect 8 bit pointer R0 (8 bit to zeropage)
;vm_PP3 equ 9 	;Indirect 8 bit pointer R2 (8 bit to zeropage)

vm_Ppr equ 16	;Parameter 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Friendly names

Param_R0 equ vm_pR0*vm_Ppr
Param_R1 equ vm_pR1*vm_Ppr
Param_R2 equ vm_pR2*vm_Ppr
Param_R3 equ vm_pR3*vm_Ppr
Param_R4 equ vm_pR4*vm_Ppr
Param_R6 equ vm_pR6*vm_Ppr
Param_Imm8 equ vm_pI8*vm_Ppr
Param_Imm16 equ vm_pI6*vm_Ppr
Param_Addr8 equ vm_pA8*vm_Ppr
Param_ZeroPg equ vm_pA8*vm_Ppr
Param_Addr16 equ vm_pA6*vm_Ppr
Param_AtR4 equ vm_PQ4*vm_Ppr
Param_AtR6 equ vm_PQ6*vm_Ppr
Param_AtR2Inc equ vm_PU2*vm_Ppr
Param_AtR6Inc equ vm_PU6*vm_Ppr
Param_AtR2PlusImm8 equ vm_PB2*vm_Ppr
Param_AtR4PlusImm8 equ vm_PB4*vm_Ppr


Dest_R0 equ vm_pR0
Dest_R1 equ vm_pR1
Dest_R2 equ vm_pR2
Dest_R3 equ vm_pR3
Dest_R4 equ vm_pR4
Dest_R6 equ vm_pR6
Dest_Addr8 equ vm_pA8
Dest_ZeroPg equ vm_pA8
Dest_Addr16 equ vm_pA6
Dest_AtR4 equ vm_PQ4
Dest_AtR6 equ vm_PQ6
Dest_AtR2Inc equ vm_PU2
Dest_AtR6Inc equ vm_PU6
Dest_AtR2PlusImm8 equ vm_PB2
Dest_AtR4PlusImm8 equ vm_PB4
Dest_RF equ vm_pRF			;rF
Dest_AtSP equ vm_pQS			;rStackTop



BranchPlus2 equ vm_b2B				;Skip 2 bytes (equivalent of BRAi 2)
BranchImm8 equ vm_bI8
BranchImm16 equ vm_bI6
BranchR6 equ vm_bR6

;Addressing Modes Command:

ParamAB equ vm_aAB					;AK=Dest BC=Param
ParamImm8 equ vm_aIM				;Param= Immediate 8 bit (16 bit for 16 bit commands)
;ParamAddr8 equ vm_aZP ;ZeroPage
ParamZeroPg equ vm_aZP ;ZeroPage	;Param in zero page (Dest for INC/DEC)
ParamExtByt equ vm_aBP ;ByteParam  %PARAM/DEST - Advanced Addressing 16 options for SRC DEST


	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                      


Vm_Tick:
	loadpairfrom z_hl,vm_rambase+vm_rpc
	ifdef vm_usevmem
		jsr vm_virmemgethlbytea		;Get a byte via VirMemoryMapper
	else
		ldx #0
		lda (z_hl,x)				;Get a command from the program
	endif
	sta z_d
	and #%11111100
	cmp #vm_lastcomamnd
	bcs cmd_error					;Command not recognized

	;sta z_c
	
	
;find the command in the decoder matrix
	lsr 		;*2
	sta z_c		
	lsr 		;*1
	clc
	adc z_c
	tax			;Offset in decoder
	
	
;Calculate our Finisher
	lda vm_decodermatrix+2,x		;Offset +2 = %-pppfff-
	sta z_e
	and #%00001110
	beq vm_nofinish

	tay				;0=No finisher - Move to 2nd byte of address
	
	lda vm_finvectors-1,y	;H - Run this after the actual command
	pha
	lda vm_finvectors-2,y	;L
	pha
vm_nofinish:


;calculate our comamnd job

	lda vm_decodermatrix+1,x	;Offset 1 H - The actual command
	pha
	lda vm_decodermatrix,x	;Offset 0 L
	pha
	
;calculate our prep job

	lda z_e		;%-pppfff-
	and #%01110000
	beq vm_noprep

	lsr				;%00001000
	lsr				;%00000100
	lsr				;%00000010
	tay				;No Entry for 0 - Move to 2nd byte of address
	lda vm_prepvectors-1,y	;H - Run this before the actual command
	pha
	lda vm_prepvectors-2,y	;L
	pha
vm_noprep:
	rts									;run the command list


cmd_error:
	lda #vm_ferror			;set error flag.
	jsr vm_setflaga
	jmp vm_pcinc		 	;unknown

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;command processors - push/pull has special rules


cmd_PHF:
	lda #8
	jsr cmd_stack_getrega	;IY=stack pointer IX points to reg D
	lda z_d
	ror ;and #%00000001
	bcs cmd_pultoix ;bne cmd_pultoix
	bcc cmd_pshfromix	;JMP

cmd_PSH:
	jsr cmd_stack_getreg

cmd_PSHfromIX:
	jsr deciy			;Stack pointer -2
	jsr deciy
	
	ldy #0
	lda (z_ix),y		;Get value to store (from IX)
	sta z_e
	iny
	lda (z_ix),y
	sta z_d
		
	jsr SaveStackPointer
cmd_sto16:
vm_ld_iy_de:		;save 8 bit results, set flags and inc pc
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIY
			ldy #0
			lda z_e
			sta (z_hl),y
			iny
			lda z_d
			sta (z_hl),y
		pullpair z_hl
		rts
	else
		lda z_d
		ldy #1
		sta (z_iy),y
	endif
cmd_sto:
vm_ld_iy_e:			;save 8 bit results, set flags and inc pc
	ifdef vm_usevmem
		pushpair z_hl
		jsr vm_virmemgetphysicalIY
			ldx #0
			lda z_e
			sta (z_hl,x)
		pullpair z_hl
	else
		lda z_e
		ldy #0
		sta (z_iy),y
	endif
	rts
	
cmd_PUL:
	jsr cmd_stack_getreg	
cmd_PULtoIX:
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIY
			ldy #0
			lda (z_hl),y
			sta z_e
			iny
			lda (z_hl),y
			sta z_d
		pullpair z_hl
	else
		ldy #0
		lda (z_iy),y
		sta (z_ix),y	;(IY)->(IX)
		iny
		lda (z_iy),y
		sta (z_ix),y	
	endif
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIX
			ldy #0
			lda z_e
			sta (z_hl),y
			iny
			lda z_d
			sta (z_hl),y
		pullpair z_hl
	endif
	jsr inciy				;Stack pointer +2
	jsr inciy
	
SaveStackPointer:
	lda z_iyl
	sta vm_rambase+vm_rsp	;Store Stack pointer
	lda z_iyh
	sta vm_rambase+vm_rsp+1
	rts
		
cmd_Stack_GetReg:		;D=Regnum
	lda z_d
	and #%00000011
	asl
cmd_Stack_GetRegA:		;A=Regnum
	clc
	adc #<vm_rambase
	sta z_ixl
	lda #>vm_rambase
	adc #0
	sta z_ixh
	LoadPairFrom z_iy,vm_rambase+vm_rsp	;IY=Top of stack
	rts


;command processors - general commands

cmd_LEA:
	lda z_iyl
	sta z_e
	lda z_iyh
	sta z_d
	rts

cmd_swp16:
	jsr vm_ld_iy_de
cmd_mov16:
	lda z_b
	sta z_d
cmd_mov:
	lda z_c
	sta z_e
	rts

cmd_sub16:
	sec
	lda z_e
	sbc z_c
	sta z_e
	lda z_d
	sbc z_b
	sta z_d
	jmp vm_FlipFlag;rts
		
cmd_add:
	clc
cmd_adc:
	lda z_e
	adc z_c
	sta z_e
	rts

cmd_SBC:
	bcc cmd_sub	  ;flip carry
	clc
	bcc cmd_subb ;always clear
	
cmd_cmp16:
	lda z_d
	sec
	sbc z_b
	beq cmd_cmp
	bne vm_FlipFlag		;Always NE
	
cmd_cmp:
cmd_sub:
	sec
cmd_subb:
	lda z_e
	sbc z_c
	sta z_e
	
vm_FlipFlag:			;Swap C to maintain Z80 flag style
	bcc vm_FlipFlagSet
	clc
	rts
vm_FlipFlagSet:	
	sec
	rts
	
cmd_rol:
	rol z_e
	rts
	
cmd_asl:
	asl z_e
	rts

cmd_asr:
	lda z_e
	bpl cmd_asrP
    SEC        ;(Top bit 1)
cmd_asrP:
cmd_ror:
    ror z_e
	rts

cmd_lsr:
	lsr z_e
	rts

cmd_neg:			;Flip bits and add 1
	lda z_e
	eor #255
	sta z_e
cmd_inc:
	inc z_e
	rts
	
cmd_dec:
	dec z_e
	rts

cmd_tst:
cmd_and:
	lda z_e
	and z_c
	sta z_e
	rts

cmd_tor:	
cmd_orr:
	lda z_e
	ora z_c
	sta z_e
	rts

cmd_xor:
	lda z_e
	eor z_c
	sta z_e
	rts
	
cmd_CLR:
	lda #0
	sta z_e
	sta z_d
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
; Finishing Routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

VM_PCINC_LD_IX_DE:	;Save 16 bit results,  and INC PC
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIX
			ldy #0
			lda z_e
			sta (z_hl),y
			iny
			lda z_d
			sta (z_hl),y
		pullpair z_hl
		jmp vm_pcinc
	else
		lda z_d
		ldy #1
		sta (z_ix),y
	endif

VM_PCINC_LD_IX_E:	;Save 8 bit results, and INC PC
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIX
			ldx #0
			lda z_e
			sta (z_hl,x)
		pullpair z_hl
	else
		lda z_e
		ldy #0
		sta (z_ix),y
	endif
	jmp vm_pcinc
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

VM_PCINC_FZ_LD_IX_DE:	;Save 16 bit results, set flags and INC PC
	php
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIX
			ldy #0
			lda z_e
			sta (z_hl),y
			iny
			lda z_d
			sta (z_hl),y
		pullpair z_hl
		plp
		jmp vm_pcinc_fz
	else
		lda z_d
		ldy #1
		sta (z_ix),y
	endif
	plp

	
VM_PCINC_FZ_LD_IX_E:	;Save 8 bit results, set flags and INC PC
	php
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIX
			ldx #0
			lda z_e
			sta (z_hl,x)
		pullpair z_hl
	else
		lda z_e
		ldy #0
		sta (z_ix),y
	endif
	plp

	
VM_PCINC_FZ:
	php
		lda VM_RamBase+VM_rF	;Set flags and INC PC
		and #%11111100
	plp
	php
		bcc vm_pcinc_ff2b
		ora #%00000001			;-C
vm_pcinc_ff2b:
	plp
	bne vm_pcinc_ff2c
	ora #%00000010				;Z-
vm_pcinc_ff2c:
	sta VM_RamBase+VM_rF
	
	
VM_PCINC:
	jsr inchl			;Program Counter
	
VM_PC_Store:
	lda z_l
	sta vm_rambase+vm_rpc
	lda z_h
	sta vm_rambase+vm_rpc+1
	
VM_PC_NoStore:	
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;command processors - general commands

	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;command processors - these commands share the same 6 bit code 

cmd_nop:
	ldx z_d
	beq vm_pcinc	;NOP	   0
	dex
	beq cmd_ret		;cp vm_RET 1
					;cp vm_HLT 2	
	sec
	dex				; 3=SEC 
	bne VM_PCINC_FZ
	
cmd_hlt:
	lda #vm_fhalt 			;set halt flag.
	jsr vm_setflaga
	jmp vm_pc_store

cmd_ret:					;Also called RTS
	lda #vm_rpc
	jsr cmd_stack_getrega
	jmp cmd_pultoix			;Get back PC from stack
	;jmp vm_pc_nostore
	
;set bits in vm f to the cpu A
vm_setflaga:
	ora vm_rambase+vm_rf
	sta vm_rambase+vm_rf
	rts
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;command processors - branch commands have special addressing

cmd_beq:
	and #%00000010
	bne cmd_bra
	rts
	
cmd_bne:
	and #%00000010
	beq cmd_bra
	rts

cmd_bcs:
	ror
	bcs cmd_bra
	rts

cmd_bcc:
	ror
	bcc cmd_bra
	rts

cmd_bra16:
	jsr inchl
	jmp addhl_bc

cmd_bra:
	lda z_ixh
	sta z_h
	lda z_ixl
	sta z_l
	rts
	
	
vm_GetVector:		;Get BC from table HL offset C
	lda #0
	tay		;ldy #0
	asl z_c
	rol
	sta z_b
	jsr AddIX_BC
	
	lda (z_ix),y
	sta z_c
	iny
	lda (z_ix),y
	sta z_b
	rts
	
vm_causetrapfromoutsidevm:		;c=trap number
	loadpairfrom z_hl,vm_rambase+vm_rpc
	jmp cmd_trp2
	
cmd_trp:
	jsr inchl
cmd_trp2:
	loadpair z_ix,vm_traps
	jsr vm_getvector
	lda z_b
	pha
	lda z_c
	pha
	jmp cmd_call

cmd_SYS:
	jsr vm_pcinc
	loadpair z_ix,vm_syscalls
	jsr vm_getvector
	jsr DecBC		;Fix PC for 6502 PC
	lda z_b
	pha
	lda z_c
	pha
	rts

cmd_BSR16:				;Branch to relative sub offset BC
	jsr inchl
	jsr VM_GetAddress_BranchGetF2	;HL->IX   ADD BC to IX
		
cmd_BSR:	
	lda z_ixh
	pha
	lda z_ixl
	pha
cmd_call:
		jsr vm_pc_store			;Point A to progaram counter
		lda #vm_rpc
		jsr cmd_stack_getrega
		jsr cmd_pshfromix		;push pc onto stack
	pla
	sta z_l
	pla
	sta z_h
	rts			;hl=new pc
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Preparation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

VM_GetAddressPrepZPDest_GetFlagC:
	jsr VM_GetAddressPrepZPDest	;Get a zeropage destination
	jmp VM_GetFlagC				;Get the flag C

VM_GetAddress_VM_GetFlagC:
	jsr vm_getaddressprep		;Get the address

VM_GetFlagC:					;Set the CPU C flag to the VM one
	lda vm_rambase+vm_rf
	ror
	rts

	
VM_GetAddressPrep16:			;Patched 16 bit immediate
	lda z_d
	pha
		jsr vm_getaddressprep
	pla
	and #%00000011
	cmp #%00000001 				;(imm8 mode)
	bne lbl31757
	jmp inchl					;Extra byte of source data for imm16


VM_GetAddressPrepZPDest:		;patched for zeropage dest (inc zp)
	lda z_d
	pha
		jsr vm_getaddressprep
	pla
	and #%00000011		;zeropage?
	cmp #%00000010
	bne lbl31757
	
	lda z_iyl			;move param->dest
	sta z_ixl
	lda z_iyh
	sta z_ixh
	lda z_c
	sta z_e
	lda z_b
	sta z_d
lbl31757
	rts
	
	
VM_GetAddressPrep:
	loadpair z_ix,vm_rambase		;Dest	R0
	loadpair z_iy,(vm_rambase+2)	;Param2	R2

	lda z_d
	and #%00000011
	beq lbl39573
	jsr vm_getaddress
lbl39573
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysicalIY
			ldy #0
			lda (z_hl),y
			sta z_c
			iny
			lda (z_hl),y
			sta z_b
					
			jsr vm_virmemgetphysicalIX
			ldy	#0			;bc=param (iy) / e=low byte of dest (ix) 
			lda (z_hl),y	;  / d=command byte
			sta z_e
			
			lda z_d
			and #%11111100
			tax
			iny
			lda (z_hl),y
			sta z_d			;BC=PARAM (IY) / DE=Dest (IX) / 
		pullpair z_hl
		txa
	else
		ldy #0
		lda (z_iy),y 		;BC=PARAM (IY) / E=Low byte of Dest (IX)
		sta z_c				;  / D=Command Byte
		lda (z_ix),y
		sta z_e
		iny 
		lda (z_iy),y
		sta z_b
		
		lda z_d
		and #%11111100		;Command Num
		tax
			lda (z_ix),y	;BC=PARAM (IY) / DE=Dest (IX) / 
			sta z_d
		txa					;A = Command byte
	endif
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Addressing mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
		
VM_GetAddress_IMM:		;8 bit immediate source (after HL / PC)
	lda z_l
	sta z_iyl
	lda z_h
	sta z_iyh
	rts
	
VM_GetAddress_ByteAddr: ;Zeropage source
	ifdef vm_usevmem
		jsr vm_virmemgethlbytea
	else
		ldx #0
		lda (z_hl,x)	;Get A byte from the Program (Zero Page address)
	endif
	sta z_iyl			;IY= parameter in RAM
	rts
	
VM_GetAddress:
	tax
	jsr inchl ;call vm_pcinc
	
	dex							;1
	beq VM_GetAddress_IMM
	dex							;2
	beq VM_GetAddress_ByteAddr
	
	;VM_GetAddress_ByteParam	;3
						
						
VM_GetAddress_ByteParam:
	lda z_ixh		;Top byte of Dest
	sta z_b

	ifdef vm_usevmem
		jsr vm_VirMemGetHLByteA
	else
		ldx #0
		lda (z_hl,x)	;get a command from the program
	endif
	pha ;sta z_e
	
		jsr VM_GetAddress_ByteParam2_Dest	;----DDDD
		lda z_b
		sta z_ixh
		lda z_c
		sta z_ixl
	
		lda z_iyh		;Top byte of param
		sta z_b			
	
	pla ;lda z_e	;PPPP----
	lsr
	lsr
	lsr
	lsr				;----PPPP
	jsr VM_GetAddress_ByteParam2
	lda z_b
	sta z_iyh
	lda z_c
	sta z_iyl
	rts
	

VM_GetAddress_ByteParam_Indir16_RSP:
	lda vm_rambase+vm_rsp
	sta z_c
	lda vm_rambase+vm_rsp+1
	sta z_b
	rts
	
VM_GetAddress_RF:
	lda #vm_rf			;address of flag register 
	sta z_c
	rts
	
;Imm8 Imm16 dest don't make sense for destination, here are some alternatives
VM_GetAddress_ByteParam2_Dest:
	and #%00001111
	cmp #vm_prf
	beq VM_GetAddress_RF
	cmp #vm_pqs
	beq VM_GetAddress_ByteParam_Indir16_RSP
	
	
VM_GetAddress_ByteParam2:
	and #%00001111	;Param
	sta z_c
	cmp #vm_pr6		;0-4=Direct register R0-R4
	bcc lbl65454
	sec
	sbc #5	;vm_pr6
	asl
	tay
	lda vm_parameteraddressingmodes+1,y		;H
	pha
	lda vm_parameteraddressingmodes,y		;L
	pha
lbl65454
	rts				;Subroutine address on stack

	
VM_GetAddress_R6:
	lda #6
	sta z_c			;R6 = Address
	rts
	
VM_GetAddress_ByteParam_Imm8:
	jsr inchl	
	lda z_h
	sta z_b
	lda z_l
	sta z_c			;PC=Address
	rts
	
VM_GetAddress_ByteParam_Imm16:
	jsr vm_getaddress_byteparam_imm8	;PC=Address
	jmp inchl							;Inc PC one more byte
	
	
	
	
VM_GetAddress_ByteParam_ImmAddr8:	;Zero page addressing
	jsr inchl
	ifdef vm_usevmem
		jsr vm_virmemgethlbytea
		sta z_c
	else
		ldx #0
		lda (z_hl,x)
		sta z_c						;Next byte is address
	endif
	rts

VM_GetAddress_ByteParam_ImmAddr16:
	ifdef vm_usevmem
		jsr inchl
		pushpair z_hl
			jsr vm_virmemgetphysical
			ldy #0
			lda (z_hl),y
			sta z_c
			iny
			lda (z_hl),y
			sta z_b
		pullpair z_hl
		jsr inchl
	else
		ldx #0
		jsr inchl
		lda (z_hl,x)
		sta z_c					;Two byte address
		jsr inchl
		lda (z_hl,x)
		sta z_b
	endif
	rts
	

VM_GetAddress_ByteParam_Indir16_R6:
	ldx #vm_rr6
	bne VM_GetAddress_ByteParam_Indir16_Rx	;always NE
	
VM_GetAddress_ByteParam_Indir16_R4:	;Indirect register pair addressing 
	ldx #vm_rr4
VM_GetAddress_ByteParam_Indir16_Rx
	lda vm_rambase,x		;R4/R5
	sta z_c
	lda vm_rambase+1,x
	sta z_b
	rts



VM_GetAddress_ByteParam_Indir16_R6_PostInc:
	ldx #vm_rr6
	bne VM_GetAddress_ByteParam_Indir16_Rxb	;always NE
	
VM_GetAddress_ByteParam_Indir16_R2_PostInc:
	ldx #vm_rr2
VM_GetAddress_ByteParam_Indir16_Rxb:
	lda vm_rambase,x
	sta z_c
	clc
	adc #1
	sta vm_rambase,x
	
	lda vm_rambase+1,x
	sta z_b
	bcc	VM_GetAddress_ByteParam_PostIncDone
	inc vm_rambase+1,x
VM_GetAddress_ByteParam_PostIncDone:
	rts

	
VM_GetAddress_ByteParam_Indir16_R4_BaseImm:	
	ldy #vm_rr4
	bne VM_GetAddress_ByteParam_Indir16_Rx_BaseImm	;always NE
	
VM_GetAddress_ByteParam_Indir16_R2_BaseImm:	;(IX+n) type addressing
	ldy #vm_rr2
VM_GetAddress_ByteParam_Indir16_Rx_BaseImm:
	jsr getsignextendedimm8IncHl
	jsr DecHL
	lda vm_rambase,y
	ldx vm_rambase+1,y
vm_getaddress_byteparam_indir16_r2_baseimmb:	
	clc
	adc z_c
	sta z_c
	txa
	adc z_b
	sta z_b
	rts
		
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Branch addressing
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

VM_GetAddress_Branch:
	jsr inchl
	lda z_d
	and #%00000011
	beq VM_GetAddress_Branch2			;0
	tax
	dex
	beq VM_GetAddress_Branch8imm		;1
	dex 
	beq VM_GetAddress_Branch16imm		;2
	
	loadpairfrom z_ix,vm_rambase+vm_rr6	;3
	jmp vm_getaddress_branchgetf
		
VM_GetAddress_Branch16imm:
	ifdef vm_usevmem
		pushpair z_hl
			jsr vm_virmemgetphysical
			ldy #0
			lda (z_hl),y
			sta z_ixl
			
			iny
			lda (z_hl),y
			sta z_ixh
		pullpair z_hl
		jsr inchl
		jsr inchl
	else
		;ldx #0
		lda (z_hl,x)
		sta z_ixl
		jsr inchl
		lda (z_hl,x)
		sta z_ixh
		jsr inchl
	endif
	jmp VM_GetAddress_BranchGetF
	
getsignextendedimm8IncHl:
	jsr inchl
GetSignExtendedImm8:
	lda #0
	sta z_b

	ifdef vm_usevmem
		jsr vm_virmemgethlbytea
		sta z_c
	else
		tax ;ldx #0
		lda (z_hl,x)
		sta z_c
	endif

	jsr inchl
	lda z_c
	and #%10000000
	beq lbl49267
	dec z_b
lbl49267
	rts
	
VM_GetAddress_Branch8imm:
	jsr getsignextendedimm8
VM_GetAddress_BranchGetF2:
	lda z_h
	sta z_ixh
	lda z_l
	sta z_ixl
	jsr AddIX_BC

vm_getaddress_branchgetf:
	lda vm_rambase+vm_rf
	rts

VM_GetAddress_Branch2:
	lda z_l
	clc 
	adc #2
	sta z_ixl		;jsr IncIX *2
	lda z_h
	adc #0
	sta z_ixh
	jmp VM_GetAddress_BranchGetF
	
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 	Virtual Memory addressing (optional)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
		
	
	ifdef vm_usevmem

vm_virmemgethlbytea:
	pushpair z_hl
		jsr vm_virmemgetphysical
		ldx #0
		lda (z_hl,x)
		tax	
	pullpair z_hl
	txa
	rts

vm_virmemgetphysicaliy:
	lda z_iyh
	sta z_h
	lda z_iyl
	sta z_l
	jmp vm_virmemgetphysical

vm_virmemgetphysicalix:
	lda z_ixh
	sta z_h
	lda z_ixl
	sta z_l
	
vm_virmemgetphysical:	;HL = BBAAAAAA AAAAAAAA B=Bank A=Address
	lda z_h				; 2 bit bank number
	ror	
	ror
	ror
	ror					;%00001100 - 32 bits per bank register
	and #%00001100
	tay
	
	lda z_h
	and #%00111111	;these 6 bits are the actual address offset
	pha
		lda z_l
		clc
		adc vm_rambase+vm_rbank0,y	;First bank register
		sta z_l
	pla
	adc vm_rambase+vm_rbank0+1,y
	sta z_h	
	rts
	endif

	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; End of VM code

;Z80 simulation functions


AddIX_0C:		
	lda #0
	sta z_b
AddIX_BC:			;Add BC to HL
	clc
	lda z_c
	adc z_ixl
	sta z_ixl
	lda z_b
	adc z_ixh
	sta z_ixh
	rts

	
DecIY:	
	lda z_IYl		;WARNING! This version does not push A
	bne DecIY_b
	DEC z_IYh
DecIY_b:	
	DEC z_IYl
	rts		
	
IncIY:
	INC z_IYL
	BNE	IncIY_Done
	INC	z_IYH
IncIY_Done:
	rts	

IncIX:
	INC z_IXL
	BNE	IncIX_Done
	INC	z_IXH
IncIX_Done:
	rts	