
	; ifndef z_ix

; z_ixl equ z_Regs+8
; z_ixh equ z_Regs+9
; z_ix equ z_Regs+8

; z_iyl equ z_Regs+10
; z_iyh equ z_Regs+11
; z_iy  equ z_Regs+10
	; endif

	

NativeSpriteAddr: dw 0		;Address of pattern base

nativespriteactivebuffer:	;Buffer for Xor drawing, 4 bytes per sprite
    ds 32

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
nativespr_drawone:
	pushpair z_de
	pushpair z_hl

		ldy #0
		lda (z_hl),y		;Ypos (Pairs of pixels)
		sta z_c

		iny
		lda (z_hl),y		;Xpos (Pairs of pixels)
		sta z_b

		iny
		lda (z_hl),y		;SpriteDef-L
		tax

		iny
		lda (z_hl),y		;SpriteDef-H
		sta z_h
		stx z_l

		lda z_b				;Zero pos?
		ora z_c
		beq nativespr_drawone_EmptySprite
		jsr nativespr_drawextra
nativespr_drawone_EmptySprite

	pullpair z_hl
	pullpair z_de
	rts
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
nativespr_drawextra:
nativespr_hide:
nativespr_draw:  ;bc=xy in pairs of pixels hl=spriteobject a=hspritenum
	ldx #0
	lda (z_hl,x)
	bne lbl_8B4DxB0B8	;W=0?
	rts					;W=0 for emtpy sprite
lbl_8B4DxB0B8
	sta z_d				;Width
	jsr inchl

	lda (z_hl,x)
	sta z_e				;Height
	jsr inchl

	lda z_h
	sta z_iyh
	lda z_l
	sta z_iyl			;IY=Source Tilemap

drawnativespry:
	pushpair z_de
	pushpair z_bc
		lda z_d
		sta z_ixl		;Width of line

drawnativesprx:
		ldx #0
		lda (z_iy,x)    ;0=empty sprite
		bne notdrawnativeskipx1
			jmp drawnativeskipx	;Skip this 8x8 block
notdrawnativeskipx1:

;Check if we're 'onscreen' (range 64-192 / 80-176 ... in pairs of pixels)
		lda z_b
		sec
		sbc #vscreenminx
		cmp #vscreenwid
		bcc notdrawnativeskipx2
			jmp drawnativeskipx
notdrawnativeskipx2	
		sta z_b

drawnativeokx:
		lda z_c
		sec
		sbc #vscreenminy
		cmp #vscreenhei-2
		bcc notdrawnativeskipx3
			jmp drawnativeskipx
notdrawnativeskipx3
drawnativeoky:
		;sta z_c
		
		
;Calculate VRAM Dest
		stz z_e	;=0		
		;lda z_c			;Ypos
		asl 				;2 Lines per LU
		tay 				;--BBB---	Multiply by $0080
			and #%00111000  ;-----CCC   is unused here, but would
			lsr				;           multiply by $0400
			lsr
			lsr					
			lsr				;Shift 1 bit right 
			ror z_e
			adc #$40		;Screen base $4000
			sta z_d
		tya					;AA------		;multiply by $0028
		rol 				;Get 1st A from AA------ 
		bcc GetScreenPos_SecondThirdNS
		
GetScreenPos_ThirdThirdNS:
		lda z_e
		clc
		adc #$50			;3/3 = Add $0050 to address
		jmp GetScreenPos_ThirdDoneNS
		
GetScreenPos_SecondThirdNS:
		rol 				;Get 2nd A from AA------ 
		bcc GetScreenPos_FirstThirdNS
		lda z_e
		clc
		adc #$28			;2/3 = Add $0028 to address
		
GetScreenPos_ThirdDoneNS:	
		sta z_e
		
GetScreenPos_FirstThirdNS:;1/3 = Add nothing to addreess
		lda z_b				;Xpos
		lsr 
		lsr 				;4 LU per tile
		
		clc
		adc #4				;Center 32 tile screen
		adc z_e				;Add X to calculated address
		sta z_e
						
						
;Calculate source pattern
drawnativesprxfast:
		ldx #0
		lda (z_iy,x)      ;Pattern Num
		bne NOTdrawnativeskipf
			jmp drawnativeskipf
NOTdrawnativeskipf:
		ifdef AP2_NativeSprite_PatternOffset
			clc
			adc #AP2_NativeSprite_PatternOffset
		endif
		stz z_h
				
		asl 		;*2
		rol z_h
		asl 		;*4
		rol z_h
		asl 		;*8
		rol z_h
		
		clc
		adc nativespriteaddr
		sta z_l
		
		lda z_h
		adc nativespriteaddr+1
		sta z_h
		
;Transfer tile to VRAM
		ldx #4
		ldy #0				;Count/Source offset
		
DrawTileMoreNS:		
		lda (z_HL),y		;Read a source byte
		eor (z_DE-4,x)
		sta (z_DE-4,x)		;Write to screen

		txa
		adc z_D				;Down &0400 (1 line)
		sta z_D
		iny 
		
		lda (z_HL),y		;Read a source byte
		eor (z_DE-4,x)
		sta (z_DE-4,x)		;Write to screen

		txa
		adc z_D				;Down &0400 (1 line)
		sta z_D
		iny 
		
		lda (z_HL),y		;Read a source byte
		eor (z_DE-4,x)
		sta (z_DE-4,x)		;Write to screen

		txa
		adc z_D				;Down &0400 (1 line)
		sta z_D
		iny 
		
		lda (z_HL),y		;Read a source byte
		eor (z_DE-4,x)
		sta (z_DE-4,x)		;Write to screen

		txa
		adc z_D				;Down &0400 (1 line)
		sta z_D
		iny 
		
		cpy #8				;We did 4 lines, repeat twice
		bne DrawTileMoreNS

		sec
		sbc #32				;Back up 8 lines
		sta z_D
			
drawnativeskipf:
		inc z_e
		
		lda z_b
		clc
		adc #4       ;8 pixels
		sta z_b

		cmp #4
		bcc drawnative_overrow

		cmp #124
		bcs drawnative_overrow

		jsr inciy

		dec z_ixl
		beq Notdrawnativesprxfast
			jmp drawnativesprxfast
Notdrawnativesprxfast:	
drawnative_overrowb:
drawnativeskip:
	pullpair z_bc
	pullpair z_de


	lda z_c
	clc
	adc #4       ;Down 8 pixels
	sta z_c

	dec z_e
	beq NOTdrawnativespry
	jmp drawnativespry
NOTdrawnativespry
	rts


drawnative_overrow:
drawnativeskipfb:
    jsr inciy
    dec z_ixl
	bne drawnativeskipfb
	jmp drawnative_overrowb
	
drawnativeskipx:
    jsr inciy
	
	lda z_b
	clc
	adc #4
	sta z_b

    dec z_ixl
	beq NOTdrawnativesprx
	jmp drawnativesprx
NOTdrawnativesprx:
	jmp drawnativeskip

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
;Draw Sprite Object Array (HL)

NativeSpr_DrawArrayReiKou:	
	jsr AddressRemapViaTableHL		;Used by ChibiVM for address remapping
nativespr_drawarray:
	;jsr updatexorbuffer
	loadpair z_de,nativespriteactivebuffer

nativespr_drawarrayalt:

	ldx #0
	lda (z_hl,x)      ;count
	sta (z_de,x)      ;Store in cache
	pha
		jsr incde
		jsr inchl	
	pla
nativespr_drawarrayb:
	beq nativespr_clearunused
	pha
		jsr nativespr_drawone_testone ;See if sprite needs redrawing
		bcc nativespr_nochange

		pushpair z_hl
			lda z_e
			sta z_l
			lda z_d
			sta z_h
			jsr nativespr_drawone	;Remove old sprite
		pullpair z_hl	
		jsr nativespr_drawone		;Draw New sprite

nativespr_nochange:
		ldy #4
		ldx #0
nativespr_nochangeAgain:	
		lda (z_hl,x)				;Copy New data into cache
		sta (z_de,x)
		jsr incHl
		jsr incde
		dey 
		bne nativespr_nochangeAgain
	pla
	sec
	sbc #1
	jmp nativespr_drawarrayb

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Compare sprite DE to HL, C=Different
; Used to decide if an XOR sprite needs redrawing

nativespr_drawone_testone:
	ldy #4-1			;We test 4 bytes total
	
nativespr_drawone_testoneb:
	
	lda (z_de),y		;Test this byte
	cmp (z_hl),y
	bne nativespr_drawone_fail	;Abort if mismatched
	
	dey
	bpl nativespr_drawone_testoneb
	
	clc					;CC=No Difference
	rts

nativespr_drawone_fail:
    sec					;CS=Difference 
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
NativeSpr_InitReiKou:
	jsr AddressRemapViaTableHL	;Used by ChibiVM for address remapping

nativespr_init:
	lda z_l
	sta nativespriteaddr		;Store the address of the pattern data
	lda z_h
	sta nativespriteaddr+1

nativespr_clearunused:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
		
nativespr_hideAll_Reikou:	
	
nativespr_hidearray:        ;for tilemap redraw
	loadpair z_hl,nativespriteactivebuffer	;Cache of what's onscreen

	ldx #0
	lda (z_hl,x)     	   ;count
	pha
		txa
		sta (z_hl,x)      ;Zero count (all sprites gone)
		jsr inchl
	pla
nativespr_drawarrayb2:
	beq nativespr_clearunused
	pha

		jsr nativespr_drawone	;Hide this sprite

nativespr_nochange2:
		ldy #4
		ldx #0
nativespr_nochangeAgain2:	
		txa
		sta (z_hl,x)			;Clear the 4 bytes in the cache
		jsr incHl
		dey 
		bne nativespr_nochangeAgain2
	pla
	sec
	sbc #1
	jmp nativespr_drawarrayb2 ;Repeat for the next sprite
	
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	

; AddHL_DE:				;Add DE to HL
	; clc
; AdcHL_DE				;Add DE to HL
	; lda z_e			;Add E to L
	; adc z_l
	; sta z_l
	; lda z_d			;Add D to H (with any carry)
	; adc z_h
	; sta z_h
	; jmp *
	; rts

	; ifndef IncIY
; IncIY:
	; INC z_IYL
	; BNE	IncIY_Done
	; INC	z_IYH
; IncIY_Done:
	; rts	
	; endif