;mpbitmap_setpixel_Reikou:
;mpbitmap_getpixel_Reikou:

;mpbitmap_gettile_Reikou:
;	rts
	
	
	
MPB_Pen0 equ 0
MPB_Pen1 equ 1
MPB_Pen2 equ 2
MPB_Pen3 equ 3
MPB_Pen4 equ 4
MPB_Pen5 equ 5
MPB_Pen6 equ 6
MPB_Pen7 equ 7
MPB_Pen8 equ 8
MPB_Pen9 equ 9
MPB_PenA equ 10
MPB_PenB equ 11
MPB_PenC equ 12
MPB_PenD equ 13
MPB_PenE equ 14
MPB_PenF equ 15


	
mpbitmap_getscreenposTile: ;D=Xpos E=ypos (Tiles)
	sta z_As	;Bitplanes
		
	ldx #3
mpbitmap_getscreenposShift:	
	asl z_e		;Tiles to pixels
	asl z_d	
	dex
	bne mpbitmap_getscreenposShift
		
				
mpbitmap_GetScreenPos:	;D=Xpos E=ypos (Pixels)
	ldx #0
	stx z_ls
	
	lda z_e 			;--BBB---	;Multiply Y by $0080
	tay
		and #%00111000
		lsr
		lsr
		lsr					
		lsr					;Shift 1 bit right 
		ror z_ls
		adc #$40			;Screen base
		sta z_hs
		tya 				;AA------		;multiply by $0028
		rol 				;Get 1st A from AA------ 
		bcc GetScreenPos2_SecondThird
GetScreenPos2_ThirdThird:
		lda z_ls
		clc
		adc #$50			;3/3 = Add $0050 to address
		jmp GetScreenPos2_ThirdDone
GetScreenPos2_SecondThird:
		rol 				;Get 2nd A from AA------ 
		bcc GetScreenPos2_FirstThird
		lda z_ls
		clc
		adc #$28			;3/2 = Add $0028 to address
GetScreenPos2_ThirdDone:	
		sta z_ls
GetScreenPos2_FirstThird:	;1/3 = Add nothing to addreess
	tya  			;-----CCC	;Multiply by 4
	and #%00000111
	asl
	asl
	adc z_hs
	sta z_hs
	
	lda z_d			;Process X
	lsr
	lsr
	lsr				;X in bytes
	clc
	adc z_ls		;Add X to calculated address
	sta z_ls	
	
	ldy #0			;Line counter (Tiles)
	rts
		

	
mpbitmap_DownALine:	;VRAM +$0400
	lda z_hs
	clc
	adc #4			;Down one Line 
	sta z_hs
	
	iny
	cpy #8			;Line count=8?
	rts
		
		
;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_gettile:
	jsr mpbitmap_getscreenposTile

mpbitmap_gettile_nextline:
	lda z_As
	sta z_b				;Bitplane count
		
	lda (z_hls,x)		;Load Bitplane 0 from screen
	sta z_es
	jsr mpbitmap_Bitflip
	
	sta (z_hl,x)		;Stroe bitplane 0
	jsr inchl
	dec z_b
	beq mpbitmap_gettile_loaddone

mpbitmap_gettile_loadagain:	
	txa	;x=0
	sta (z_hl,x)		;Store Zero in bitplane 1/2/3
	jsr inchl
	dec z_b
	bne mpbitmap_gettile_loadagain

mpbitmap_gettile_loaddone:
	jsr mpbitmap_DownALine		;Move down 1 VRAM line
	bne mpbitmap_gettile_nextline
	rts



;HL = Source Pattern D=Xpos (tiles) E=Ypos (Tiles) A=Bitplane count
mpbitmap_settile:
	jsr mpbitmap_getscreenposTile
	
mpbitmap_settile_yline:	
	lda z_As				;Bitplane count
	sta z_b
	
	lda (z_hl,x)			;Load Bitplane 0
	sta z_es
	
mpbitmap_settile_skipbitplane:	
	jsr IncHL				;Skip bitplanes 1/2/3
	dec z_b
	bne mpbitmap_settile_skipbitplane
	
mpbitmap_settile_bitplanesdone:
	jsr mpbitmap_Bitflip		
	sta (z_hls,x)			;Store bitplane 0 to screen
		
	jsr mpbitmap_DownALine	;Move down 1 VRAM line
	bne mpbitmap_settile_yline	
	rts
	
	

mpbitmap_Bitflip:			;Swap L<->R bit orientation
	ldx #8
mpbitmap_Bitflipb:
	rol z_es				;Bits are backwards on the AP2
	ror
	dex
	bne mpbitmap_Bitflipb
	rts

	
;We can't use bit 7 of a byte for pixels as it's a color bit
;So we shift read/write from bit 7 to bit 6	
mpbitmap_FixBit7:	
	sta z_c

	lda z_d
	and #%00000111
	cmp #7					;Bit 7 is color
	bne	mpbitmap_FixBit7done			
	lda #6					;Use bit 6 if asked for bit 7
mpbitmap_FixBit7done:
	and #%00000111			;Xpos 0-6
	rts
		
		
mpbitmap_setpixel: ;D=Xpos E=Ypos A=Color
	and #%00000001
	sta z_iyh				;Color number

	jsr mpbitmap_getscreenpos
	
	lda #%11111110			;Bit mask
	jsr mpbitmap_FixBit7
	beq mpbitmap_setpixel_shiftdone
	tax						;Xpos 0-6
mpbitmap_setpixel_shiftagain:
	sec
	rol z_c					;Shift the mask
	asl z_iyh				;Shift the pixel
	dex 
	bne mpbitmap_setpixel_shiftagain
	
mpbitmap_setpixel_shiftdone:
	ldx #0
	lda (z_hls,x)			;Load from screen
	and z_c					;Mask pixels to keep
	ora z_iyh				;Set pixel to change
	sta (z_hls,x)			;Write back to the screen
	rts


mpbitmap_getpixel: ;D=Xpos E=Ypos A=Color
	jsr mpbitmap_getscreenpos
	lda (z_hls,x)			;Get screen byte
	
	jsr mpbitmap_FixBit7
	beq mpbitmap_getpixel_shiftdone
	tax						;Xpos 0-6
mpbitmap_getpixel_shiftagain:
	lsr z_c					;Shift the pixel
	dex
	bne mpbitmap_getpixel_shiftagain
mpbitmap_getpixel_shiftdone:
	lda z_c
	and #%00000001			;Resulting pixel
	rts
	
	