
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Safe to assume X,Y=0
;X+Y must =0 at end of this routine!


DrawTile:	
	ldx #4
	;ldx #0
	;ldy #0	;-safe to assume Y=0
	bit LookupBits+0
	ifndef TileTest_BasicOnly		;For Minimal Testing
		bne DrawTileAdvanced
	endif
	asl
	sta (z_bcs),y		;%NNBBXYP0 ... Update flag cleared (bit 0)
	iny
DrawTileBasicOnly:

	and #%11110000		;%nnnn----
	sta z_ls
	lda (z_bcs),y		;%NNNNNNNN
	
	lsr 
	ror z_ls			;/2 (effectively *8)
	sta z_hs
	
	lda z_ls
	clc
	adc z_es			;DEs = Tile pattern base address 
	sta z_ls

	lda z_hs
	adc z_ds
	sta z_hs
		
	dey ;ldy #0
	
DrawTileMore:		
	lda (z_HLs),y		;Read a source byte
	sta (z_HL-4,x)		;Write to screen

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	iny 
	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL-4,x)		;Write to screen

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	iny 
	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL-4,x)		;Write to screen

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	iny 
	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL-4,x)		;Write to screen

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	iny 
	
	cpy #8				;We did 4 lines, repeat twice
	bne DrawTileMore
MaxTileFinish:
	sec
	sbc #32				;Back up 8 lines
	sta z_h	
	
	ldx #0
	ldy #0
	jmp TileDoneBCs_Plus2



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


DrawTileAdvanced:	
	and #%00000110
	bne NotDrawTileCustom
		jmp DrawTileCustom
NotDrawTileCustom:
	lda (z_bcs),y
	and #%11111110		;Clear update flag
	sta (z_bcs),y
	iny

	ifdef TileTest_NoFlip	;For Minimal Testing
		jmp DrawTileBasicOnly
	endif

	and #%11110000		;nnnn---
	sta z_ls

	lda (z_bcs),y		;%NNNNNNNN
		
	lsr 
	ror z_ls			;8 bytes per pattern
	sta z_hs
	
	lda z_ls
	clc
	adc z_es			;DEs = Tile pattern base address 
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
		
	dey		;Y=0
	lda (z_bcs),y		;NNBBXYP0
	
	bit LookupBits+2	;Yflip?
	beq NotDrawTileYFlip
		jmp DrawTileYFlip
NotDrawTileYFlip:


;DrawTileXflip	
	lda #>FlipLUT
	sta z_b				;BC= Xflip LUT
	
	clc
DrawTileMoreX:	
	lda (z_HLs),y		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc-4,x)		;Get byte from Xflip LUT
	sta (z_HL-4,x)		;Write to screen

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H

	iny 
	cpy #8				;All lines done?
	bne DrawTileMoreX
	jmp MaxTileFinish
	
	
DrawTileEmpty:
	iny 
	lda (z_bcs),y
	cmp #255
	bne DrawTileTransp
	dey ;ldy #0
	jmp TileDoneBCs_Plus2
	
	
DrawTileTransp:;;;;;;;;;;;;;;;;;;Transparent

	asl 
	rol z_hs
	asl 
	rol z_hs
	asl 
	rol z_hs	;*8
	
	clc
	adc z_es			;Add Pattern base
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	
	dey ;ldy #0
		
DrawTileMoreT:	
	lda (z_HLs),y		;Read a source byte
	beq DrawTileByteTransp
	sta (z_HL-4,x)		;Write to screen
DrawTileByteTransp:	
	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H

	iny 
	cpy #8
	bne DrawTileMoreT
	jmp MaxTileFinish
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DrawTileCustom:
		lda (z_bcs),y 			;NN------ - top bits of tilenum
		and #%11111110
		sta (z_bcs),y 
		rol
		rol	
		rol
		and #%00000011			;------NN
		sta z_hs
		
		lda (z_bcs),y 
		and #%00110000			;Cmd Bits ;NNCC001-
		bne NotDrawTileFill
			jmp DrawTileFill	;--00----
NotDrawTileFill:
		cmp #%00110000			;--11----
		bne NotDrawTileEmpty	
			jmp DrawTileEmpty
NotDrawTileEmpty:
	
	
DrawTileDouble:	
	iny 
	lda (z_bcs),y
	asl 
	rol z_hs
	asl 
	rol z_hs			;*4 (4 lines)
	
	clc
	adc z_es			;Add Tile Pattern base
	sta z_ls
	
	lda z_hs
	adc z_ds
	sta z_hs
	
	dey ;ldy #0
		
DrawTileMoreD:	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL-4,x)		;Write to screen (1st)

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	
	sta (z_HL-4,x)		;Write to screen (2nd)

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	
	iny 
	cpy #4
	bne DrawTileMoreD
	jmp MaxTileFinish
	
		
		
DrawTileFill:
	iny
	lda (z_bcs),y
	
	adc z_es			;Add Tile Pattern base
	sta z_ls

	lda z_hs
	adc z_ds
	sta z_hs
		
	dey ;ldy #0
	lda (z_HLs),y		;Read a source byte 
	sta z_d
	iny					;Down a line 	+40
	lda (z_HLs),y		;Read a source byte
	sta z_e
	dey
		
DrawTileMoreF:	
	lda z_d
	sta (z_HL-4,x)		;Write to screen	D
	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	
	lda z_e
	sta (z_HL-4,x)		;Write to screen	E
	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	iny 
	
	lda z_d
	sta (z_HL-4,x)		;Write to screen	D
	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	
	lda z_e
	sta (z_HL-4,x)		;Write to screen	E
	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H
	iny 
	
	cpy #4
	bne DrawTileMoreF
	jmp MaxTileFinish


DrawTileXYflip:
	lda #>FlipLUT
	sta z_b				;BC= Xflip LUT

	ldy #7
DrawTileMoreXY:	
	lda (z_HLs),y		;Read a source byte
	sta z_c				;Set LUT pointer
	lda (z_bc-4,x)		;Get byte from Xflip LUT

	sta (z_HL-4,x)		;Write to screen

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H

	dey
	bpl DrawTileMoreXY	;>-1?
	jmp MaxTileFinish
	
	
DrawTileYflip:
	bit LookupBits+3
	beq NotDrawTileXYFlip
		jmp DrawTileXYFlip
NotDrawTileXYFlip:

	ldy #7				;Start from bottom
DrawTileMoreY:	
	lda (z_HLs),y		;Read a source byte
	sta (z_HL-4,x)		;Write to screen

	txa
	adc z_H				;Down &0400 (1 line)
	sta z_H

	dey
	bpl DrawTileMoreY 	;>-1?
	jmp MaxTileFinish
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
	;Screen layout is split in 3 parts according to Y line
	;AABBBCCC - AA*$0028  BBB*$0080  CCC*$0400
	
GetScreenPos:
	lda #0
	sta z_l
	
	lda z_c				;Ypos
	asl 				;2 Lines per LU
	tay 				;--BBB---	;Multiply by $0080
		and #%00111000
		lsr
		lsr
		lsr					
		lsr				;Shift 1 bit right 
		ror z_l
		adc #$40		;Screen base $4000
		sta z_h
	tya					;AA------		;multiply by $0028
	rol 				;Get 1st A from AA------ 
	bcc GetScreenPos_SecondThird
	
GetScreenPos_ThirdThird:
	lda z_l
	clc
	adc #$50			;3/3 = Add $0050 to address
	jmp GetScreenPos_ThirdDone
	
GetScreenPos_SecondThird:
	rol 				;Get 2nd A from AA------ 
	bcc GetScreenPos_FirstThird
	lda z_l
	clc
	adc #$28			;2/3 = Add $0028 to address
	
GetScreenPos_ThirdDone:	
	sta z_l
	
GetScreenPos_FirstThird:;1/3 = Add nothing to addreess

	lda z_b				;Xpos
	lsr 
	lsr 				;4 LU per tile
	
	clc
	adc #4				;Center 32 tile screen
	adc z_l				;Add X to calculated address
	sta z_l
	rts
	
	
	
	