

	
	ifdef BuildPCE
uservars equ $2400
PCErelocateStart equ 1		;Load cart into $4000 +
	endif
	ifdef BuildNES
uservars equ $200
	endif
	ifdef BuildBBC
uservars equ $3800
	endif
	ifdef BuildC64
uservars equ $5800
	endif
	ifdef BuildLNX
uservars equ $E000
	endif
	ifdef BuildA52
uservars equ $200
BuildAxx equ 1
	endif
	ifdef BuildA80
uservars equ $200
BuildAxx equ 1
	endif
	
	include "..\SrcALL\V1_Header.asm"
	include "\SrcAll\BasicMacros.asm"


HLSwitchToggle equ Uservars			;Used by the ?. pitch shifter
RawStringpos equ HLSwitchToggle+1	;The string before convertion to phonetics
ConvAddr equ RawStringpos+2 		;Temp addr used during conversion
CharFromString equ ConvAddr+2		;A character from the string during coversion
SpeechDelay	equ CharFromString+1	;Speed during playback
SpeechSpeed equ SpeechDelay+1		;The default speed setting
TranslatedStringAddr equ SpeechSpeed+1	;Current pos in string for playback
TranslatedStringAddr2 equ TranslatedStringAddr+2 ;Current pos in string for playback #2
												; (for pitch shiffts)

AltOffset1 equ TranslatedStringAddr2+2	;3 offsets used for Alt sound samples
AltOffset2 equ AltOffset1+1 			; (short'wavy' sound)
AltOffset3 equ AltOffset2+1

HLSwitchAddr1 equ AltOffset3+1 			;Used to calculate point for .? pitch
HLSwitchAddr2 equ HLSwitchAddr1+2 		;Used to calculate point for .? pitch

LastChar equ HLSwitchAddr2+2			;Remember if last char is .?
TxtRawString equ LastChar+1				;Memory for the Uppercase+phonetic conversion


	SEI			;Stop interrupts
	jsr ScreenInit
	
loop:
	sei
	loadpair z_hl,mystring	;Zero terminated string to play
	lda #6					;Speed
	jsr saystringfromhl		;hl=string a=speed (0-15)
	jmp loop

mystring:
	ifdef BuildBBC
		db "I am a BBC, you are a worm."
	endif
	ifdef BuildPCE
		db "I am a Pee Sea Engin , you are a worm."
	endif
	ifdef BuildNES
		db "I am a NESS, you are a worm."
	endif
	ifdef BuildC64
		db "I am a Sea Sixty Four, you are a worm."
	endif
	db "You will bow to my 65 owh 2 superiority."
	db 0
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

playwavhl_5times_alt:
	lda #5
playwavhl_atimes_alt:		;ss / h type sounds 
	asl		;*2
	asl		;*4
	asl		;*8
	jsr soundinit
	
playwavhl_alt_again:

	lda altoffset1				;'random' offset
	eor #$65
	adc #$25
		
	rol 
	sta altoffset1				;Shift offset bytes
	rol altoffset2
	rol altoffset3
	
	and #%00001111
	tay
	
	lda #8
	sta z_e
soundplaysampleagain:
	jsr soundplaysample
	iny
	dec z_e						;8 samples
	bne soundplaysampleagain
	dec z_d						;Repeat count
	bne playwavhl_alt_again
	rts
	


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


playspeechpartfromtext:
	lda speechspeed
	sta speechdelay				;Reset default pause between samples

	loadpairxy table_all
	jsr tablescansimple			;Use table DE to find a match

	jsr inchl
	jsr translatedstringaddrHLsave
	
	lda #4						;Failed to find a match? Play silence!
	
	
playwavsilent_atimes:
	pha
		loadpair z_hl,l9863_silence
	pla
playwavhl_atimes_onebyte
	jsr soundinit
	
playwavhl_again_onebyte
	lda #$3f					;63 sample bytes
	sta z_e

soundplaysampleagainc:
	jsr soundplaysample
	dec z_e						;Sample loop
	bne soundplaysampleagainc
	dec z_d						;Repeat '63 bytes' loop
	bne playwavhl_again_onebyte
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



	ifdef buildLNX		;NOT WORKING
soundplaysample:
		lda (z_hl),y	;low nibble
		jsr setvolumewav

		lda (z_hl),y	;high nibble
		lsr 
		lsr
		lsr
		lsr
			
setvolumewav:
		and #$0f
		rol
		rol
		rol
		sta $fd20		;Volume (127=max 0=min)	
		
		ldx speechdelay
soundplaysample_pause
		pha
		pla
		dex
		bne soundplaysample_pause		
		rts

soundinit:			;Need to set Y=0
		sta z_d		;Delay/Speed
		ldy #0
		
			
		lda #1
		sta $fd24			;Timer Backup Value 
		
		lda #%01010000			;1= Good Tone
		;lda #%00010000			;1= Good Tone
		
		sta $fd21				;FFFFFFFF	Effective sound of instrument
		
		stz $fd23				;SSSSSSSS	Shift Regsiter L
		stz $fd27				;SSSS-CBB	S=Shift Register H, 
											;C=Clock state B=Borrow
		stz $Fd50				;LLLLRRRR	LR Vol - 0=all on 255=all off

		lda #$80				;Silent
		sta $fd22				;Reset Audio Output Value 
		
		lda #%00011110 			;FTIRCKKK	F=Feedback bit 7 , reset Timer done, 
								;enable Integrate, enable Reload enable Count,
								;clocK select
		sta $fd25				;Audio Control bits
		
		stz $Fd50				;LLLLRRRR	LR Vol - 0=all on 255=all off
		rts
	endif 
	
	ifdef BuildAxx ;DOESN't WORK
soundplaysample:
		lda (z_hl),y	;low nibble
		jsr setvolumewav

		lda (z_hl),y
		lsr 
		lsr
		lsr
		lsr
			
setvolumewav:
		and #$0f
		ora #%00000000
		sta  POKEY+$01			;NNNNVVVV	N=Noise V=Volume
		
		ldx speechdelay
soundplaysample_pause
		dex
		bne soundplaysample_pause		
		rts

soundinit:			;Need to set Y=0
		sta z_d		;Delay/Speed
		ldy #0
		
		;lda #0			;Reset POKEY sound Control
		lda #0
		sty  POKEY+$08	;N1234HHS	N=Noise bit depth 1234=Channel Clocks 
		
		lda #255
		sta POKEY+$00		;FFFFFFFF	F=Frequency
	
	
		rts
	endif 
	
	

	ifdef buildNES
soundplaysample:
		lda (z_hl),y	;low nibble
		jsr setvolumewav

		lda (z_hl),y
		lsr 
		lsr
		lsr
		lsr
			
setvolumewav:
		and #$0f
		sta $4011
		
		ldx speechdelay
soundplaysample_pause
		nop
		nop
		dex
		bne soundplaysample_pause		
		rts

soundinit:			;Need to set Y=0
		sta z_d		;Delay/Speed
		ldy #0
		rts
	endif 
	
	
	ifdef buildPCE
soundplaysample:
		lda (z_hl),y	;Low nibble
		jsr setvolumewav

		lda (z_hl),y	;High nibble
		lsr 
		lsr
		lsr
		lsr
			
setvolumewav:
		and #$0f
		asl
		sta $0806		;%---VVVVV Volume
		
		ldx speechdelay
soundplaysample_pause
		pha
		pla			;Slow down to match other systems
		pha
		pla
		pha
		pla
		pha
		pla
		pha
		pla
		dex
		bne soundplaysample_pause		
		rts

soundinit:			
		sta z_d		;z_D= Delay/Speed
		ldy #0		;Need to set Y=0 for other code
					
		lda #5
		sta $0800		;Channel Select (0)
		
		lda #%11011111
		sta $0804		;Channel Select (0)

		lda #255
		sta $0801		;Main Amplitude Level
		sta $0805		;LR Volume
		
		rts
	endif 
	

	ifdef buildC64
soundplaysample:
		lda (z_hl),y	;low nibble
		jsr setvolumewav

		lda (z_hl),y
		lsr 
		lsr
		lsr
		lsr
			
setvolumewav:
		and #$0f
		sta $D418			;MHBLVVVV	Volume and filter modes - Mute3 / Highpass / Bandpass / Lowpass / Volume (0=silent)	
		
		ldx speechdelay
soundplaysample_pause
		dex
		bne soundplaysample_pause		
		rts

soundinit:			;Need to set Y=0
		sta z_d		;Delay/Speed
		ldy #0
		rts
	endif 
	
	
	ifdef buildbbc
	
soundplaysample:
		lda (z_hl),y			;low nibble first
		jsr setvolumewav

		lda (z_hl),y			;high nibble 2nd
		lsr 
		lsr
		lsr
		lsr
			
setvolumewav:
		and #$0f
		ora #%11010000			;set volume %1101vvvv
		sta $FE41
		
		ldx speechdelay
soundplaysample_pause
		nop						;Delay to balence speed
		nop
		dex
		bne soundplaysample_pause		
		rts

soundinit:			
		sta z_d				;Delay/Speed
		ldy #0				;Need to set Y=0 during soundinit
	
		lda #255			;Set all bits to write
		sta $FE43 			;Data direction port

		lda #%11000000		; low tone
		sta $FE41
		;lda #%00000000
		sty $FE41
		
		rts
	endif 
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
ProcessDigitDelays:			;Digits are an additional delay
	ldx #0					; to the playback speed
	jsr subtractswtichers
	
	lda (z_hl,x)
	cmp #$31		;<1?
	bcc DoReturn
	
	cmp #$39		;>9?
	bcs DoReturn

	;sec			;We know carry is clear, so one extra will be subtracted
	sbc #$34-1				;Convert to digit from ascii
	clc
	adc speechdelay			;Add to current delay
	sta speechdelay			;Delay change is effectively -4 to +5

	jmp tablescansaveIncHL
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
tablescaninchl:
	jsr tablescanprep	;Get z_b = next char in string + INCHL
	jsr processdigitdelays
	jsr tablescan	;wont return if matches (also consumes caller to tablescan)
	
tablematchfailed:
	jsr dechl
	jmp tablescansave

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	

playwavhl_atimes:
	jsr soundinit			;Setup sound hardware

playwavhl_again
	lda #$3f
	sta z_e
	ldy #0
soundplaysampleagainb:
	jsr soundplaysample
	iny
	dec z_e				;Play next sample loop
	bne soundplaysampleagainb
	dec z_d				;repeat 63 bytes loop
	bne playwavhl_again
DoReturn:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
tablescansimple:
	savepairxy z_de		;z_de=Address of table to scan
	jsr translatedstringaddrLoadHL
	
	jsr tablescanprep	;Get z_b = next char in string + INCHL
	jsr tablescan		;wont return if matches (also consumes caller to tablescan)	
	jmp tablematchfailed

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
tablescanprep
	ldx #0
	lda (z_hl,x)		;z_b = char to find 
	sta z_b
tablescansaveIncHL:		
	jsr inchl
tablescansave:
translatedstringaddrHLsave:
	lda z_l
	sta translatedstringaddr
	lda z_h
	sta translatedstringaddr+1
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
tablescan:	
	ldy #0
tablescanAgain:	
	lda (z_de),y			;Get next char in table
	beq DoReturn			;0= end of table
	iny

	cmp z_b
	beq tablescanfound
	iny		;com
	iny		;addrl
	iny  	;addrh
	bne tablescanAgain		;Will always be NE!
	
tablescanfound:
	pla						;consume Table Launcher
	pla		
	pla						;consume return addr
	pla
		
	lda (z_de),y
	pha
		iny
		lda (z_de),y		;Get address -> z_hl
		sta z_l
		iny
		lda (z_de),y
		sta z_h
	pla		
	beq tablescanfoundjump	;0=jump to addr
	cmp #255
	beq playsequence		;255=sequence
	
	bit lookupbits+4		;+16 for ALT player
	beq playwavhl_atimes
notplaywavhl_atimes

	and #%00001111			;Get loop count
	jmp playwavhl_atimes_alt

tablescanfoundjump:
	jsr DEChl				;Compensate for 6502 PC+1
		
	lda z_h					;Push call address onto stack
	pha
	lda z_l
	pha
translatedstringaddrLoadHL	
	loadpairfrom z_hl,translatedstringaddr
DoReturn2:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

playsequencexy:
	savepairxy z_hl
playsequence:
	ldy #0
playsequenceagain:
	lda (z_hl),y			;Count / +16 =alt +32 = onebyte
	beq DoReturn2			;0 = Sequence end
	
	sta z_as				;Loop count
	iny
	
	lda (z_hl),y			;L byte of sequence
	tax
	iny
	pushpair z_hl
		tya
		pha
			lda (z_hl),y	;H byte of sequence
			stx z_l
			sta z_h
			
			lda z_as
			bit lookupbits+4	;+16 = Alt player
			bne playsequencealt
			bit lookupbits+5	;+32= OneByte player
			bne playsequenceonebyte
			
			jsr playwavhl_atimes ;Play the sample
playsequenceContinue:			
		pla
		tay
		iny
	pullpair z_hl
	jmp playsequenceagain

playsequencealt:
		and #%00001111	;PlayCount
		jsr playwavhl_atimes_alt
	jmp playsequenceContinue
	
playsequenceonebyte:
		and #%00001111	;PlayCount
		jsr playwavhl_atimes_onebyte
	jmp playsequenceContinue
		
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;WE use BNE below to save a byte over JMP
; so long as table_a isn't in the zero page it will work!	
process_a
	loadpairxy table_a
	bne tablescaninchlret	;consumes return address on sucess
	
process_e
	loadpairxy table_e
	bne tablescaninchlret	;consumes return address on sucess
	
process_i
	loadpairxy table_i
	bne tablescaninchlret

process_o
	loadpairxy table_o
	bne tablescaninchlret
	
process_u
	loadpairxy table_u
;	jmp tablescaninchlret
	
tablescaninchlret:
	SavePairXY z_de
	jsr tablescaninchl
	rts	;ret will be consumed on success - dummy ret on failure so we can jp here

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

process_slash
	loadpairxy table_slash
	jmp tablescaninchlret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

process_d
	loadpairxy table_d
	jsr tablescansimple	;consumes return address on sucess
	
	loadpairxy sequence_d
	jmp playsequencexy
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

process_c
	loadpairxy table_c
	jsr tablescansimple
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

process_t
	loadpairxy table_t
	jsr tablescansimple

	loadpairxy sequence_t
	jmp playsequencexy
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

process_z:
	loadpairxy table_z
	jsr tablescansimple		;consumes return address on sucess

	loadpair z_hl,l9142_m	;Failed? Play M then Z
	lda #5
	jsr playwavhl_atimes

	loadpair z_hl,l95d0_z
	jmp playwavhl_5times_alt
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

process_s:
	loadpairxy table_s
	jsr tablescansimple		;consumes return address on sucess
	
	dec speechdelay			;Faliled? alter pitch and play Z sample
	dec speechdelay
	
	loadpair z_hl,l95d0_z
	jmp playwavhl_5times_alt
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

process_n
	loadpairxy table_n
	jsr tablescansimple
	
	loadpairxy sequence_n
	jmp playsequencexy
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

subtractswtichers:
	ldy #1	;Shift

	ldx hlswitchaddr1+1			;2nd to last vowel?
	lda hlswitchaddr1
	jsr SubtractSwitcherOne
			
	iny 	;ldy #2	;shift
		
	ldx hlswitchaddr2+1			;Last Vowel?
	lda hlswitchaddr2
	jsr SubtractSwitcherOne

	rts

SubtractSwitcherOne:	
	sec 
	sbc translatedstringaddr2
	sta z_ls
	txa
	sbc translatedstringaddr2+1
	ora z_ls 
	beq pitchshiftapply			;do pitch shift	
	rts
	
pitchshiftapply:
	pla							;Consume return address
	pla
	sty z_c
	ldx speechdelay
	
	lda lastchar
	cmp #$3f		;?
	beq pitchquestion
	cmp #$2e		;.
	beq pitchstatement
	rts

pitchquestion	
	txa
	sec
	sbc z_c						;Pitch shift up
	sta speechdelay	
	rts

pitchstatement
	txa
	clc
	adc z_c						;Pitch shift down
	sta speechdelay
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

saystringfromhl: 	;d=count a=speed
	eor #255			;Convert the speed into something we can use
	clc
	adc #$1a
	sta speechspeed		;Speed

	
	
	loadpair z_de,txtrawstring	;temp store
	ldx #0
	ldy #0
	lda #' '
	sta (z_de),y
	iny

copystringagain:
	lda (z_hl,x)			;copy char from src to dest
	beq copystringdone
	sta z_b					;laschar
	sta (z_de),y
	jsr inchl
	iny
	bne copystringagain		;repeat until all chars copied (always NE)

copystringdone:
	lda z_b
	sta lastchar			;Remember last char (for ? . pitch change)

	ldx #0
	lda #' '				;store a space
	sta (z_de),y
	iny
	
	lda #13
	sta (z_de),y			;store an endline
	
	jsr charfix				;fix case and non pronouncable
	
	

	iny
	tya						;Store phonetic version immedately
	clc						; after fixed version
	adc z_e			
	sta z_l
	lda z_d
	adc #0
	sta z_h					;HL now points to DE+Y

	pushpair z_hl
		jsr converttophonetics
		
	;Show the phonetics for debugging
	;jsr MemDump			;Show Some Ram to screen
    ;word Uservars+64      		;Address to show
    ;byte $16         		;Lines
	
	pullpair z_hl

	
speakpart:
	jsr translatedstringaddrHLsave

	;Used by the ALT player to select offsets
	lda #$65		;01100101
	sta altoffset1
	lda #$25
	sta altoffset2	;00100101
	lda #$63
	sta altoffset3	;01100011
	
	;sei
speakpart_again:
	jsr translatedstringaddrLoadHL

	lda z_l
	sta translatedstringaddr2		;Next Part
	lda z_h
	sta translatedstringaddr2+1

	ldx #0
	lda (z_hl,x)
	cmp #13							;End of string?
	beq DoReturn3
	jsr playspeechpartfromtext		;Play this bit
	jmp speakpart_again

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
converttophonetics:
	lda #<txtrawstring 			;temp store (raw string)
	sta rawstringpos
	lda #>txtrawstring
	sta rawstringpos+1

	lda #0
	ldy #4
converttophoneticsZero:
	sta hlswitchaddr1,y			;Reset the switchpos (4 bytes)
	dey
	bpl converttophoneticsZero	

	jsr translatedstringaddrHLsave

	jsr translatetophonetics	;translate to phonetics
	
	jsr translatedstringaddrLoadHL

	ldx #0
	lda #13
	sta (z_hl,x)				;End the string with a 13
DoReturn3:
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
LoadHLwithRawstringpos:
	loadpairfrom z_hl,rawstringpos
	ldx #0
	rts
	

translatetophonetics:
	jsr LoadHLwithRawstringpos
	ldx #0
	lda (z_hl,x)
	cmp #13						;atendofstring?
	beq DoReturn3

	jsr phoneticlookupentry		;lookup entry
	jsr phonetictransferentry	;build translated string
	jmp translatetophonetics

	
phoneticlookupentry:
	jsr LoadHLwithRawstringpos
	
	lda (z_hl,x)				;We need to calculate a LUT offset
	cmp #'A'
	bcc lookupnonletter
	cmp #'['
	bcs lookupnonletter
	;sec						;we know carry is clear
	sbc #'A'-1
	asl	;*2
	tay
	
	ldx alphabetpointers,y		;L address
	lda alphabetpointers+1,y	;H Address
scanforaphoneticmatchb:
	stx convaddr
	sta convaddr+1				;store address of conversion
	
	
scanforaphoneticmatch:
	jsr phoneticmatchtest		;get a phonetic?
	bcs DoReturn3
	
;Skip 2 zero terminated entries

	loadpairfrom z_hl,convaddr
	ldy #0
	ldx #2
ScanAgain:	
	lda (z_hl),y				;scan for two 0s
	pha
		jsr inchl
	pla
	bne ScanAgain				;Scan for a zero.
	dex							;Matched, but we're looking for a pair!
	bne ScanAgain

	ldx z_l						;New address
	lda z_h
	bne scanforaphoneticmatchb ;(always NE)
	
	
lookupnonletter:
	loadpairxy l9e89_spc		;space list
	cmp #' '					;space ?
	beq phoneticlookupselectcustom
	loadpairxy la68d_numbers

phoneticlookupselectcustom:
	stx convaddr
	sty convaddr+1
	jmp scanforaphoneticmatch

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PhoneticMatchTest_Question:	;?
	ldx #0
	lda (z_hl,x)
	cmp #13
	beq phoneticnomatch
	sta charfromstring
	bne PhoneticMatchTest_MoveToNext	;move to next (Always NE)

PhoneticMatchTest_Space: 	;space in converter
	ldx #0
	lda (z_hl,x)
	jsr validphentest		;a-z, 0-9? (all we can convert)
	bcs PhoneticMatchTest_MoveToNext

phoneticnomatch				;no match
SaveConvAddrBC:
	lda z_c
	sta convaddr
	lda z_b
	sta convaddr+1
	clc						;clear carry=nomatch
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


phoneticmatchtest:			;Source
	jsr LoadHLwithRawstringpos
	
	lda convaddr			;converter
	sta z_c
	lda convaddr+1
	sta z_b
	
	;ldx #0	
PhoneticMatchTestRepeat:
	lda (z_bc,x)			;get an entry in coversion
	cmp #' '				;Space?
	beq PhoneticMatchTest_Space	
	cmp #'?'				;Wildcard
	beq PhoneticMatchTest_Question
	cmp (z_hl,x)
	bne phoneticnomatch		;no - clear carry and return
PhoneticMatchTest_MoveToNext:
	jsr incbc				;move to next
	jsr inchl
	lda (z_bc,x)			;Nonzero?
	beq phoneticfoundmatch
	;ldx #0
	lda (z_hl,x)			;yes! get a source char
	cmp #13					;give up if end of source
	beq phoneticnomatch
	bne PhoneticMatchTestRepeat	;repeat (Always NE)

	
phoneticfoundmatch:
	jsr incbc				;next entry
	jsr dechl				;walk back through string
	
	jsr SaveConvAddrBC

	jsr SaveRawStringPosFromHL

	;ldx #0
	lda (z_hl,x)
	jsr validphentest		;a-z 0-9? in source (all we can convert)
	bcc PhoneticMatchTest_Skip	;skip source char	
		
	lda z_bc
	;sec					;we know carry is set from BCC
	sbc #3
	sta z_bcs
	lda z_b					; decbcs *3
	sbc #0
	sta z_bs
	
	lda (z_bcs,x)			;get 3 chars back
	bne SaveRawStringPosFromHL	;zero? yes? then forward 1 char
PhoneticMatchTest_Skip
	jsr inchl
SaveRawStringPosFromHL
	lda z_l
	sta rawstringpos
	lda z_h
	sta rawstringpos+1
	sec			;carry=matched
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


phonetictransferentry:
	lda convaddr
	sta z_c
	lda convaddr+1
	sta z_b
	jsr translatedstringaddrLoadHL

phonetictransferentryagain
	ldx #0
	lda (z_bc,x)				;Get a phonetic
	beq phonetictransferentrydone	;phonetic 0?= end of phonetic
	cmp #'?'					;? = copy char from string?
	bne phonetictransferentry_noqm
	lda charfromstring

phonetictransferentry_noqm
	jsr vowelswitcher
	sta (z_hl,x)				;store the phonetic
	jsr inchl
	jsr incbc
	jmp phonetictransferentryagain

phonetictransferentrydone
	jmp translatedstringaddrHLsave

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

validphentest:
	cmp #'0'		;<0?
	bcc validphentest_ng
	cmp #'['		;>Z?
	bcs validphentest_ng		; J NC
	cmp #'A'		;<a?
	bcs validphentest_ok		;Ret NC
	cmp #':'		;>9?
	bcs validphentest_ng		;JR NC

validphentest_ok
	clc 	;nc=ok
	rts

validphentest_ng
	sec			;c=no good
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

vowelswitcher:					;used to remember last two vowels
	cmp #'E'					; for ?. pitch change
	beq hlswitcher
	cmp #'A'
	beq hlswitcher
	cmp #'O'
	beq hlswitcher
	cmp #'I'
	beq hlswitcher
	cmp #'U'
	beq hlswitcher
	pha
hlswitcherb:
		lda #0
hlswitcherc:
		sta hlswitchtoggle
	pla
DoReturn4:
	rts

hlswitcher
	pha
		lda hlswitchtoggle
		bne hlswitcherb

		lda hlswitchaddr2	;first pitch shift point
		sta hlswitchaddr1
		lda hlswitchaddr2+1
		sta hlswitchaddr1+1
		
		lda z_l				;2nd pitch shift point
		sta hlswitchaddr2
		lda z_h
		sta hlswitchaddr2+1
		
		lda #1
		jmp hlswitcherc
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
		
charfix:			;first stage - fix chars in string
	;loadpair z_hl,txtrawstring
	ldy #0
charfixagain
	lda (z_de),y	
	cmp #13				;CR= Done?
	beq DoReturn4

	cmp #'/'
	beq charfix_space	;(* = - space
	cmp #'a'
	bcc charfix_ok		;upper case?
	cmp #'{'
	bcs charfix_ok
	;sec				;We know carry is clear from bcs so -1
	sbc #$20-1			;convert lower case
charfix_Apply:
	sta (z_de),y
charfix_ok
	iny
	bne charfixagain	;Repeat. (Always NE)

charfix_space
	;ldx #0
	lda #' '			;Store a space!
	bne charfix_Apply	;Always NE
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
	

AlphabetPointers:	;26 entries, 2 bytes per entry
;Pointers to data
	dw la17c_a	;A
	dw la2f0_b	;B
	dw la475_c	;C
	dw la5ff_d	;D
	dw la3ad_e	;E
	dw la38e_f	;F
	dw la0f4_g	;G
	dw la5ba_h	;H
	dw l9df2_i	;I
	dw la6f2_j	;J
	dw la42c_k	;K
	dw la626_l	;L
	dw la314_m	;M
	dw la136_n	;N
	dw l9C90_O	;O
	dw la5d3_p	;P
	dw la683_q	;Q
	dw la5a6_r	;R
	dw la4cf_s	;S
	dw la332_t	;T
	dw la529_u	;U
	dw la6f6_v	;V
	dw la637_w	;W
	dw la43f_x	;X
	dw la44a_y	;Y
	dw la674_z	;Z

l9E89_spc:
	db ' ','D','A','V','I','D',' '     ;391  - Ofst.$1870
        DB 000,' ','D','A','Y','V','I','H','D',000,' ','P','S','Y',000,' '     ;392  - Ofst.$1880
        DB 'S','I','Y',000,' ','G','I','V','E',000,' ','G','I','H','V',000     ;393  - Ofst.$1890
        DB ' ','Y','O','U','R',' ',000,' ','Y','A','O','R',000,' ','C','H'     ;394  - Ofst.$18A0
        DB 'A','I','R',' ',000,' ','C','H','A','I','R',000,' ','W','H','Y'     ;395  - Ofst.$18B0
        DB ' ',000,' ','W','I','Y',000,' ','E',' ',000,' ','E','E',000,' '     ;396  - Ofst.$18C0
        DB '?','E','R','E',000,' ','?','E','E','3','E','R',000,' ','O','U'     ;397  - Ofst.$18D0
        DB 'G','H','T',000,' ','A','O','2','T',000,' ','C','O','U','G','H'     ;398  - Ofst.$18E0
        DB ' ',000,' ','K','O','O','F',000,' ','?','O','U','G','H',' ',000     ;399  - Ofst.$18F0
        DB ' ','?','A','H','F',000,' ','S','C','I',000,' ','S','I','Y',000     ;400  - Ofst.$1900
        DB ' ','Y','E','S',' ',000,' ','Y','E','H','3','S',000,' ','?','I'     ;401  - Ofst.$1910
        DB 'E',000,' ','?','I','Y',000,' ','A','B','L','E',000,' ','A','Y'     ;402  - Ofst.$1920
        DB '3','B','L',000,' ','G','E','T',000,' ','G','E','H','T',000,' '     ;403  - Ofst.$1930
        DB 'A','N','Y',000,' ','E','H','2','N','E','E',000,' ','U','?','E'     ;404  - Ofst.$1940
        DB 000,' ','Y','U','X','W','?',000,' ','O','U','R',000,' ','A','W'     ;405  - Ofst.$1950
        DB '3','R',000,' ','O','N','E',000,' ','W','O','O','N',000,' ','T'     ;406  - Ofst.$1960
        DB 'O',' ',000,' ','T','U','X','3',000,' ','B','E',' ',000,' ','B'     ;407  - Ofst.$1970
        DB 'E','E','3',000,' ','O','F',' ',000,' ','O','O','3','V',000,' '     ;408  - Ofst.$1980
        DB 'A',' ',000,' ','A','E',000,' ','A','R','E',' ',000,' ','A','A'     ;409  - Ofst.$1990
        DB '3','R',000,' ','W','O','R',000,' ','W','E','R','3',000,' ','M'     ;410  - Ofst.$19A0
        DB 'E',' ',000,' ','M','E','E','3',000,' ','G','I',000,' ','J','I'     ;411  - Ofst.$19B0
        DB 'Y',000,' ','M','Y',' ',000,' ','M','I','Y',000,' ','I','S',' '     ;412  - Ofst.$19C0
        DB 000,' ','I','X','4','S',000,' ','S','C',000,' ','S','K',000,' '     ;413  - Ofst.$19D0
        DB 'A','S',' ',000,' ','A','E','S',000,' ','W','I','T','H',' ',000     ;414  - Ofst.$19E0
        DB ' ','W','I','X','3','D','H',000,' ','H','A','V','E',' ',000,' '     ;415  - Ofst.$19F0
        DB '/','H','A','E','3','V',000,' ','B','Y',' ',000,' ','B','I','Y'     ;416  - Ofst.$1A00
        DB '1',000,' ','T','H','I','S',' ',000,' ','D','H','I','X','S',000     ;417  - Ofst.$1A10
        DB ' ','W','E',' ',000,' ','W','E','E','3',000,' ','T','H','E','Y'     ;418  - Ofst.$1A20
        DB ' ',000,' ','D','H','A','Y','2',000,' ','H','A','S',' ',000,' '     ;419  - Ofst.$1A30
        DB '/','H','A','E','S',000,' ','T','H','E','I','R',' ',000,' ','D'     ;420  - Ofst.$1A40
        DB 'H','A','I','2','R',000,' ','T','H','A','N',' ',000,' ','D','H'     ;421  - Ofst.$1A50
        DB 'A','E','4','N',000,' ','O','N','L','Y',' ',000,' ','O','W','3'     ;422  - Ofst.$1A60
        DB 'N','L','E','E',000,' ','P','E','O',000,' ','P','E','E','2',000     ;423  - Ofst.$1A70
        DB ' ','S','H','E',' ',000,' ','S','H','E','E','3',000,' ','S','A'     ;424  - Ofst.$1A80
        DB 'I','D',' ',000,' ','S','A','I','4','D',000,' ','S','O','M','E'     ;425  - Ofst.$1A90
        DB ' ',000,' ','S','A','H','3','M',000,' ','T','H','E','N',' ',000     ;426  - Ofst.$1AA0
        DB ' ','D','H','E','H','3','N',000,' ','M','E',' ',000,' ','M','E'     ;427  - Ofst.$1AB0
        DB 'E',000,' ','G','O','T','O',' ',000,' ','G','O','W','T','U','W'     ;428  - Ofst.$1AC0
        DB 000,' ','M','O','S','T',' ',000,' ','M','O','W','2','S','T',000     ;429  - Ofst.$1AD0
        DB ' ',000,' ',000

l9C90_O: ;Phonetic conversions
	DB 'O','U','S',' ',000,'U','U','3','S',000,'O','C','A',000,'O','W'     ;360  - Ofst.$1680
        DB '2','K','A','H',000,'O','C','O',' ',000,'O','W','K','O','W',000     ;361  - Ofst.$1690
        DB 'O','C','O',000,'O','W','K',000,'O','C','U',000,'O','W','K','U'     ;362  - Ofst.$16A0
        DB 'U',000,'O','Q','U',000,'O','W','K',000,'O','X','U',000,'O','O'     ;363  - Ofst.$16B0
        DB 'K','S','U','U',000,'O','?','U',000,'O','W','3','?',000,'O','U'     ;364  - Ofst.$16C0
        DB 'G','H',' ',000,'O','H','3','W',000,'O','G','Y',000,'O','J','E'     ;365  - Ofst.$16D0
        DB 'E',000,'O','U','G','H',000,'A','H',000,'O','L','E',' ',000,'O'     ;366  - Ofst.$16E0
        DB 'W','2','L',000,'O','E',000,'O','W','3',000,'O','U','L','D',' '     ;367  - Ofst.$16F0
        DB 000,'U','H','3','D',000,'O','X','O',000,'O','O','K','S','O','W'     ;368  - Ofst.$1700
        DB 000,'O','?','O',' ',000,'O','W','?','O','W',000,'O','?','O',000     ;369  - Ofst.$1710
        DB 'O','W','2','?',000,'O','X','A',000,'O','O','K','S','A','E',000     ;370  - Ofst.$1720
        DB 'O','?','A',000,'O','W','2','?',000,'O','C','E',000,'O','W','S'     ;371  - Ofst.$1730
        DB 'H',000,'O','X','E',000,'O','O','K','S',000,'O','?','E',000,'O'     ;372  - Ofst.$1740
        DB 'W','3','?',000,'O','O','K',000,'U','H','3','K',000,'O','U',000     ;373  - Ofst.$1750
        DB 'A','E','2','U','X',000,'O','U','R',000,'A','O','3','R',000,'O'     ;374  - Ofst.$1760
        DB 'I','C',000,'O','Y','S',000,'O',' ',000,'O','W',000,'O','A',000     ;375  - Ofst.$1770
        DB 'O','H','3','W',000,'O','R','E',' ',000,'A','O','2','R',000,'O'     ;376  - Ofst.$1780
        DB 'W',000,'O','W',000,'O','R','I',000,'A','O','R','I','X','2',000     ;377  - Ofst.$1790
        DB 'O','O',000,'U','X',000,'O','R',000,'A','O','R',000,'O','H',000     ;378  - Ofst.$17A0
        DB 'O','H',000,'O','O','R',000,'A','O','3','R',000,'O','I',000,'O'     ;379  - Ofst.$17B0
        DB 'Y','3',000,'O','Y',000,'O','Y',000,'O','T','H','E','R',000,'A'     ;380  - Ofst.$17C0
        DB 'H','D','H','E','R',000,'O','R','R',000,'O','R',000,'O',000,'O'     ;381  - Ofst.$17D0
        DB 'O',000
l9df2_i
	db 'I','C','E',000,'I','Y','S',000,'I','C','Y',000,'I','Y'     ;382  - Ofst.$17E0
        DB 'S','E','E','4',000,'I','X','Y',000,'I','H','K','S','E','E',000     ;383  - Ofst.$17F0
        DB 'I','?','Y',000,'I','Y','?','E','E',000,'I','R','O',000,'I','Y'     ;384  - Ofst.$1800
        DB 'R','O','O',000,'I','Y',000,'I','Y',000,'I','T','L','E',000,'I'     ;385  - Ofst.$1810
        DB 'Y','T','U','U','L',000,'I','E','D',000,'A','Y','3','D',000,'I'     ;386  - Ofst.$1820
        DB 'X','E',000,'I','H','K','S',000,'I','?','E',000,'I','Y','3','?'     ;387  - Ofst.$1830
        DB 000,'I','E',000,'E','E',000,'I','G','I',000,'I','X','2','J','I'     ;388  - Ofst.$1840
        DB 'H',000,'I',' ',000,'I','Y','4',000,'I','S','M',000,'I','X','3'     ;389  - Ofst.$1850
        DB 'S','U','U','M',000,'I','G','H',000,'I','Y','2',000,'I','R',000     ;390  - Ofst.$1860
        DB 'E','R','4',000,'I',000,'I','H',000

la0f4_g
	db 'G','T','H',' ',000,'T','H',000,'G','H','O','T'     ;430  - Ofst.$1AE0
        DB 'I',000,'F','I','H','4','S','H',000,'G','U','E',' ',000,'G',000     ;431  - Ofst.$1AF0
        DB 'G','O','O',000,'G','U','H','2',000,'G','E','N',000,'J','E','H'     ;432  - Ofst.$1B00
        DB '3','N',000,'G','H','O',000,'G','O','H','2','W',000,'G','G',000     ;433  - Ofst.$1B10
        DB 'G',000,'G',000,'G',000
la136_n:
	db 'N','G','E','R',000,'N','X','G','E','R'     ;434  - Ofst.$1B20
        DB 000,'N','G','S',' ',000,'N','X','Z',000,'N','O','W',000,'N','A'     ;435  - Ofst.$1B30
        DB 'W',000,'N','G','E',000,'N','J',000,'N','I','O','N',000,'N','I'     ;436  - Ofst.$1B40
        DB 'X','U','U','N',000,'N','N',000,'N',000,'N','G',' ',000,'N','X'     ;437  - Ofst.$1B50
        DB 000,'N','G',000,'N','X','G',000,'N',000,'N',000
la17c_a
	db 'A','G','E',' '     ;438  - Ofst.$1B60
        DB 000,'A','Y','J',000,'A','U','G','H',000,'A','A','3','F',000,'A'     ;439  - Ofst.$1B70
        DB 'I','G','H',000,'A','Y',000,'A','B','L','E',000,'A','H','B','U'     ;440  - Ofst.$1B80
        DB 'U','L',000,'A','C','I',000,'A','E','S','I','H',000,'A','X','I'     ;441  - Ofst.$1B90
        DB 000,'A','E','K','S','I','H',000,'A','?','I',000,'A','Y','3','?'     ;442  - Ofst.$1BA0
        DB 000,'A','R','E',000,'A','I','3','R',000,'A',' ',000,'A','H',000     ;443  - Ofst.$1BB0
        DB 'A','N','G','E',' ',000,'A','Y','2','N','J',000,'A','N','G','E'     ;444  - Ofst.$1BC0
        DB 000,'A','Y','2','N','J','U','U',000,'A','L','L','Y',000,'A','E'     ;445  - Ofst.$1BD0
        DB '2','L','E','E',000,'A','X','A',000,'A','E','K','S','A','E',000     ;446  - Ofst.$1BE0
        DB 'A','C','A',000,'A','E','K','A','E',000,'A','?','A',000,'A','Y'     ;447  - Ofst.$1BF0
        DB '?',000,'A','C','E',000,'A','Y','S',000,'A','X','E',000,'A','E'     ;448  - Ofst.$1C00
        DB 'K','S',000,'A','?','E',000,'A','Y','4','?',000,'A','C','Y',000     ;449  - Ofst.$1C10
        DB 'A','Y','S','E','E',000,'A','C','H',000,'A','E','C','H',000,'A'     ;450  - Ofst.$1C20
        DB 'C','K',000,'A','E','K',000,'A','C','C',000,'A','E','K',000,'A'     ;451  - Ofst.$1C30
        DB 'C',000,'A','E','K',000,'A','X','O',000,'A','E','K','S','O','W'     ;452  - Ofst.$1C40
        DB 000,'A','?','O',000,'A','Y','?',000,'A','U',000,'A','O','3',000     ;453  - Ofst.$1C50
        DB 'A','V','I',000,'A','Y','2','V','I','X',000,'A','L','K',000,'A'     ;454  - Ofst.$1C60
        DB 'O','R','K',000,'A','R',000,'A','A','3',000,'A','F',000,'A','A'     ;455  - Ofst.$1C70
        DB '2','F',000,'A','Z','Y',000,'A','Y','3','Z','E','E',000,'A','L'     ;456  - Ofst.$1C80
        DB 'L',000,'A','O','2','L',000,'A','X','Y',000,'A','E','K','S','E'     ;457  - Ofst.$1C90
        DB 'E',000,'A','?','Y',000,'A','I','I','X','?','E','E',000,'A','W'     ;458  - Ofst.$1CA0
        DB 000,'A','W',000,'A','I',000,'A','Y','2',000,'A','I','R',000,'A'     ;459  - Ofst.$1CB0
        DB 'I','R',000,'A','Y',000,'A','Y',000,'A','R',' ',000,'A','A','3'     ;460  - Ofst.$1CC0
        DB 'R',000,'A','R','R',000,'A','E','3','R',000,'A',000,'A','E',000     ;461  - Ofst.$1CD0
la2f0_b
        DB 'B','B','C',000,'B','E','E','%','%','B','E','E','%','S','E','E'     ;462  - Ofst.$1CE0
        DB 000,'B','B',000,'B',000,'B','E','Y',' ',000,'B','E','E','Y',000     ;463  - Ofst.$1CF0
        DB 'B',000,'B',000
la314_m
	db 'M','I','C','R','O',000,'M','I','Y','3','K','R'     ;464  - Ofst.$1D00
        DB 'O','W',000,'M','B',' ',000,'M',000,'M','M',000,'M',000,'M',000     ;465  - Ofst.$1D10
        DB 'M',000
la332_t
	db 'T','W','O',000,'T','U','W',000,'T','H','R','E','E',000     ;466  - Ofst.$1D20
        DB 'T','H','R','E','E',000,'T','C','H',000,'C','H',000,'T','L','E'     ;467  - Ofst.$1D30
        DB 000,'T','L',000,'T','U','?','E',000,'C','H','U','W','?',000,'T'     ;468  - Ofst.$1D40
        DB 'I','O',000,'S','H','A','H',000,'T','I','A',000,'S','H','I','X'     ;469  - Ofst.$1D50
        DB 'U','U',000,'T','H','E',' ',000,'D','H','U','U','%',' ',000,'T'     ;470  - Ofst.$1D60
        DB 'H',000,'T','H',000,'T','T',000,'T',000,'T',000,'T',000
la38e_f:
	db 'F','O'     ;471  - Ofst.$1D70
        DB 'U','R',000,'F','A','O','3','R',000,'F','O','O','T',000,'F','U'     ;472  - Ofst.$1D80
        DB 'H','2','T',000,'F','F',000,'F',000,'F',000,'F',000
la3ad_e:
	db 'E','I','G'     ;473  - Ofst.$1D90
        DB 'H','T',000,'A','Y','T','E',000,'E','R','Y',' ',000,'E','H','2'     ;474  - Ofst.$1DA0
        DB 'R','E','E',000,'E','R','R',000,'E','H','2','R',000,'E','S',' '     ;475  - Ofst.$1DB0
        DB 000,'S',000,'E','F','U','L',' ',000,'F','U','U','L',000,'E','A'     ;476  - Ofst.$1DC0
        DB 'S','E',' ',000,'E','E','Z',000,'E',' ',000,'%',000,'E','W',000     ;477  - Ofst.$1DD0
        DB 'I','H','U','W',000,'E','U',000,'I','H','U','H','2',000,'E','E'     ;478  - Ofst.$1DE0
        DB 000,'E','E','4',000,'E','R','E',000,'A','I','R',000,'E','R',000     ;479  - Ofst.$1DF0
        DB 'E','R',000,'E','Y',000,'A','Y',000,'E','A',000,'E','E','3',000     ;480  - Ofst.$1E00
        DB 'E','D',' ',000,'%','D',000,'E',000,'E','H',000
la42c_k
	db 'K','N',000,'N'     ;481  - Ofst.$1E10
        DB 000,'K','E','Y',' ',000,'K','E','E','Y',000,'K',000,'K',000
la43f_x
	db 'X','C',000,'K','S',000,'X',000,'K','S',000
la44a_y:
	db 'Y','S',000,'I','H','2'     ;483  - Ofst.$1E30
        DB 'S',000,'Y','P','E',000,'I','Y','2','P',000,'Y','E',' ',000,'I'     ;484  - Ofst.$1E40
        DB 'Y',000,'Y',' ',000,'E','E',000,'Y','O','U',' ',000,'Y','U','W'     ;485  - Ofst.$1E50
        DB 000,'Y',000,'Y',000
la475_c:
	db 'C','H','N',000,'K','N',000,'C','I',000,'S'     ;486  - Ofst.$1E60
        DB 'I','H',000,'C','H','R',000,'K','R',000,'C','O','M','E',' ',000     ;487  - Ofst.$1E70
        DB 'K','A','H','M',000,'C','O','W',000,'K','A','W',000,'C','E',' '     ;488  - Ofst.$1E80
        DB 000,'S',000,'C','E',000,'S','E','H','2',000,'C','H',000,'C','H'     ;489  - Ofst.$1E90
        DB 000,'C','C',000,'K',000,'C','K',000,'K',000

	db 'C','P','C',000,'S','E','E',' ','P','E','E',' ','S','E','E',000 ;Speccy fans won't want this!

	db 'C',000,'K',000
la4cf_s:
	db 'S','U','P','E','R','I','O','R',000,'S','U','X','2','P','E','E','3'     ;492  - Ofst.$1EC0
        DB 'R','I','H','A','O','R',000,'S','H','A','L','L',000,'S','H','A'     ;493  - Ofst.$1ED0
        DB 'E','L',000,'S','T','I','O','N',000,'S','%','C','H','U','U','N'     ;494  - Ofst.$1EE0
        DB 000,'S','E','S',' ',000,'S','I','X','Z',000,'S','S',000,'S',000     ;495  - Ofst.$1EF0
        DB 'S','I','O',000,'Z','H','U','U',000,'S','H',000,'S','H',000,'S'     ;496  - Ofst.$1F00
        DB 'C',000,'S','K',000,'S',000,'S',000
la529_u
	db 'U','E',' ',000,'U','W','6'     ;497  - Ofst.$1F10
        DB 000,'U','R','E',' ',000,'U','H','3','R',000,'U','Y',000,'I','Y'     ;498  - Ofst.$1F20
        DB '3',000,'U','C','E',000,'U','W','S',000,'U','?','E',000,'Y','U'     ;499  - Ofst.$1F30
        DB 'W','3','?',000,'U','?','A',000,'U','X','W','?',000,'U','C','I'     ;500  - Ofst.$1F40
        DB 000,'U','W','S','I','H',000,'U','?','I',000,'Y','U','X','W','?'     ;501  - Ofst.$1F50
        DB 000,'U','L','L',000,'U','H','3','L',000,'U','H',000,'U','H',000     ;502  - Ofst.$1F60
        DB 'U','L',' ',000,'U','U','L',000,'U','A','L',000,'Y','U','U','L'     ;503  - Ofst.$1F70
        DB 000,'U','R',000,'E','R','3','R',000,'U','R','R',000,'A','H','R'     ;504  - Ofst.$1F80
        DB 000,'U',000,'A','H',000
la5a6_r
	db 'R','E','A','T',000,'R','A','Y','3','T'     ;505  - Ofst.$1F90
        DB 000,'R','R',000,'R',000,'R',000,'R',000
la5ba_h
	db 'H','O','W',000,'/','H'     ;506  - Ofst.$1FA0
        DB 'A','W','2',000,'H','E',' ',000,'/','H','E','E','4',000,'H',000     ;507  - Ofst.$1FB0
        DB '/','H',000
la5d3_p:
	db 'P','O','W',000,'P','A','W','3',000,'P','R','O','G'     ;508  - Ofst.$1FC0
        DB 000,'P','R','O','W','2','G',000,'P','H',000,'F',000,'P','P',000     ;509  - Ofst.$1FD0
        DB 'P',000,'P','L','Y',000,'P','L','I','Y',000,'P',000,'P',000
la5ff_d
	db 'D'     ;510  - Ofst.$1FE0
        DB 'O','W',000,'D','A','W','2',000,'D','O',' ',000,'D','U','H','4'     ;511  - Ofst.$1FF0
        DB 'W',000,'D','G',000,'J',000,'D','H',000,'D','H',000,'D','D',000     ;512  - Ofst.$2000
        DB 'D',000,'D',000,'D',000,'L','E',' ',000,'U','U','L',000
la626_l
	db 'L','L'     ;513  - Ofst.$2010
        DB 000,'L',000,'L',000,'L',000
la637_w
	db 'W','H','O',000,'/','H','U','H','W'     ;514  - Ofst.$2020
        DB 000,'W','A','S',' ',000,'W','O','O','Z',000,'W','H','A',000,'W'     ;515  - Ofst.$2030
        DB 'O','O','3',000,'W','A','T',000,'W','A','O','4','T',000,'W','H'     ;516  - Ofst.$2040
        DB 000,'W',000,'W','R',000,'R',000,'W','O','O',000,'W','U','H',000     ;517  - Ofst.$2050
        DB 'W',000,'W',000
la674_z:
	db 'Z','Z',000,'Z',000,'Z','H',000,'Z','H',000     ;518  - Ofst.$2060
        DB 'Z','8','0',000,'Z','A','Y','D',' ','A','Y','3','T',' ','I','Y',' ',000
        DB 'Z',000,'Z',000
la683_q:
	db 'Q','U',000,'K','W',000,'Q',000,'K',000
la68d_numbers:
	db '0',000,'Z'     ;519  - Ofst.$2070
        DB 'I','H','5','R','O','W','2',' ',000,'1',000,'W','O','O','3','N'     ;520  - Ofst.$2080
        DB ' ',000,'2',000,'T','U','H','2','W',' ',000,'3',000,'T','H','R'     ;521  - Ofst.$2090
        DB 'E','E','3',' ',000,'4',000,'F','A','O','3','R',' ',000,'5',000     ;522  - Ofst.$20A0
        DB 'F','I','Y','3','V',' ',000,'6',000,'S','I','H','4','K','S',' '     ;523  - Ofst.$20B0
        DB 000,'7',000,'S','E','H','3','V','U','U','N',' ',000,'8',000,'A'     ;524  - Ofst.$20C0
        DB 'Y','3','T',' ',000,'9',000,'N','I','Y','3','N',' ',000,'?',000     ;525  - Ofst.$20D0
        DB '?',000
la6f2_j:
	db 'J',000,'J',000
la6f6_v
	db 'V',000,'V',000

;TxtRawString = Temp Store (unaltered)


;First byte = Comparison, 2nd=Repeat/command, 3rd/4th=addr
;255=Sequence ; 0=call ; all other=single sample  1-15 = loop  16-31 = LoopAlt 32-47 = LoopSingleByte

Table_All:	
	db 'A',0
	 dw Process_A
	db 'U',0
	 dw Process_U
	db 'I',0
	 dw Process_I
	db 'E',0
	 dw Process_E
	db 'O',0
	 dw Process_O
	db 'S',0
	 dw Process_S
	db '/',0
	 dw Process_Slash
	db 'D',0
	 dw Process_D
	db 'C',0
	 dw Process_C
	db 'T',0
	 dw Process_T
	db 'N',0
	 dw Process_N
	db 'Z',0
	 dw Process_Z
	db 'B',255
	 dw Sequence_B ;l8e1b
	db 'F',5
 	 dw l9618_F	;l8ec4
	db 'G',255
	 dw Sequence_G ;l8ed1
	db 'J',255
	 dw Sequence_J ;l8e9f
	db 'K',255
	 dw Sequence_K ;l8e6a
	db 'L',7
	 dw l90c3_L ;l8e3b
	db 'M',7
	 dw l9142_M	;l8e48
	db 'P',255
	 dw Sequence_P ;l8e7d
	db 'R',7
	 dw l8fc3_R	;l8e2e
	db 'V',255
	 dw Sequence_V ;l8e55
	db 'W',7
	 dw l92d2_W ;l8e92
 	db 'Y',7
	 dw l9353_Y	;l8eb7
	db '%',255
 	 dw Sequence_Percent ;l8ad2
	db 0


Table_A:
	db 'Y',255
	 dw Sequence_AY ;l8b22
	db 'E',7
	 dw l8958_A
	db 'A',9
	 dw l8f43_AA
	db 'W',255
	 dw Sequence_AW ;l8b3b
	db 'H',7
	 dw l9182_AH
	db 'O',9
	 dw l9043_AO
	db 'I',9
	 dw l8f83_AI
	db 0

Table_E:
	db 'E',7
	 dw l9083_EE
	db 'H',7
	 dw l97e3_EH
	db 'R',9
	 dw l9510_ER
	db 0



Table_I:
	db 'Y',255
	 dw Sequence_IY ;l8bb8
	db 'X',5
	 dw l9392_IH
	db 'H',7
 	 dw l9392_IH
	db 0

Table_O:
	db 'W',255
	 dw Sequence_OW ;l8bfa
	db 'Y',255
	 dw Sequence_OY ;l8c0b
	db 'H',8
 	 dw l94d0_OH
	db 'O',8
	 dw l94d0_OO
	db 0


Table_U:
	db 'X',8
	 dw l9003_U
	db 'W',255
	 dw Sequence_UW ;l8c5e
	db 'H',7
  	 dw l9823_UH
	db 'U',8
  	 dw l9761_UU
	db 0

Table_Slash:
	db 'H',4+16
 	 dw l9252_slashH
	db 0

Table_D:
	db 'H',255
	 dw Sequence_DH ;l8cb7
	db 'R',255
	 dw Sequence_DR ;l8ccc
	db 'U',255
 	 dw Sequence_DU ;l8ce9
	db 0

Table_C
	db 'H',255
	 dw Sequence_CH;l8d3b
	db 'T',255
	 dw Sequence_CT ;l8d1a
  	db 0

Table_T:
	db 'H',5+16
	 dw l96e0_TH
	db 'R',255
	 dw Sequence_TR ;l8d7f
	db 0

Table_Z:
	db 'H',255
	 dw Sequence_ZH ;l8db6
	db 0

Table_S
	db 'H',6+16
	 dw l9550_SH
	db 0

Table_N:
	db 'X',7
	 dw l9450_NX
	db 0



;First byte = Repeat, 2nd/3rd addr
;Repeat 0=End of sequence  1-15 = loop  16-31 = LoopAlt 32-47 = LoopSingleByte

Sequence_Percent:
	db 2+32
	dw l9863_Silence
	db 0


Sequence_AY
	db 9
	 dw l9311_A
	db 5
	 dw l9392_IH
	db 2
	 dw l9353_Y
	db 0
Sequence_AW:
	db 9
	 dw l8958_A
	db 6
 	 dw l92d2_W
	db 0


Sequence_IY
	db 9
	 dw l8f43_AA
	db 6
	 dw l9392_IH
	db 0

Sequence_OW
	db 9
	 dw l94d0_OH
	db 5
 	 dw l92d2_W
	db 0

Sequence_OY
	db 9
	 dw l9043_AO
	db 4
	 dw l9392_IH
	db 2
 	 dw l9353_Y
	db 0 

Sequence_UW
	db 7
	 dw l9003_U
	db 6
 	 dw l92d2_W
	db 0

Sequence_D:
	db 3+32
 	 dw l9863_Silence
	db 1
	 dw l9410_D
	db 3+32
 	 dw l9863_Silence
	db 0

Sequence_DH:
	db 4
	 dw l9720_DH
	db 1+16
	 dw l9252_slashH
	db 0

Sequence_DR
	db 2+32
	 dw l96a0_T
	db 3
	 dw l93d0_D
	db 7
  	 dw l8fc3_R
	db 0

Sequence_DU
	db 5+32
	 dw l96a0_T
	db 2
	 dw l93d0_D
	db 8
	 dw l9003_U
 	db 0




Sequence_CT
	db 2+32
	 dw l96a0_T
	db 1
	 dw l8997_K
	db 1+32
  	 dw l96a0_T
	db 1
 	 dw l89d7_T
	db 0



Sequence_CH
	db 6+32
	 dw l96a0_T
	db 3
	 dw l9550_SH
	db 1
	 dw l8958_A
	db 0






Sequence_T:
	db 3+32
 	 dw l9863_Silence
	db 1
	 dw l89d7_T
	db 3+32
 	 dw l9863_Silence
	db 0

Sequence_TR
	db 4+32
	 dw l96a0_T
	db 3
  	 dw l9550_SH
	db 7
	 dw l8fc3_R
	db 0


Sequence_ZH
	db 3
	 dw l9353_Y
	db 3+16
 	 dw l9550_SH
	db 0


Sequence_N
	db 1+32
	 dw l9863_Silence
	db 7
	 dw l9103_N
	db 1+32
	 dw l9863_Silence
	db 0


Sequence_B:
	db 3+32
 	 dw l9863_Silence
	db 1
	 dw l9212_B
	db 3+32
 	 dw l9863_Silence
	db 0

Sequence_V:
	db 5
	 dw l91c2_V
	db 1+16
 	 dw l9252_slashH
	db 0

Sequence_K
	db 3+32
	 dw l9863_Silence
	db 1
	 dw l8997_K
	db 3+32
	 dw l9863_Silence
	db 0

Sequence_P
	db 3+32
	 dw l9863_Silence
	db 1
	 dw l9292_P
	db 3+32
	 dw l9863_Silence
	db 0

Sequence_J
	db 3+32
	 dw l9863_Silence
	db 1
	 dw l9410_D
	db 4+16
	 dw l9550_SH
	db 0


Sequence_G
	db 3+32
	 dw l9863_Silence
	db 1
	 dw l9590_G
	db 3+32
	 dw l9863_Silence
;	 db 0
		
l9863_Silence:					;Silence
	db $00






;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

l9392_IH
	db $a4,$58,$d5,$1f,$d7,$8f
	db $a5,$88,$84,$34,$8b,$34,$b6,$5a
	db $b7,$6c,$89,$89,$87,$55,$67,$44
	db $87,$58,$99,$89,$99,$99,$88,$86
	db $88,$65,$88,$98,$89,$ab,$9b,$b9
	db $89,$86,$58,$65,$55,$54,$55,$67
	db $66,$88,$66,$87,$55,$56,$64,$46
	db $75,$46,$84,$59,$75,$89,$74,$67
	;db $74
l8958_A:
	db $74,$ff,$ff,$04,$30,$fb,$cf,$88
	db $88,$78,$45,$95,$cd,$6a,$44,$85
	db $aa,$68,$65,$76,$88,$88,$88,$68
	db $55,$86,$a9,$8a,$56,$65,$87,$a8
	db $cb,$8a,$56,$85,$ba,$8a,$78,$87
	db $88,$88,$66,$55,$76,$88,$56,$54
	db $65,$65,$56,$55,$44,$54,$66,$56
	db $55,$65,$56,$54,$86,$46;,$44
	
l9003_U:
	db $44,$54,$55,$55,$76
	db $b9,$fd,$ff,$ff,$ee,$de,$cd,$ab
	db $68,$45,$23,$32,$44,$44,$55,$76
	db $a9,$ba,$bb,$ab,$aa,$9a,$89,$68
	db $55,$44,$44,$54,$65,$66,$87,$98
	db $a9,$aa,$aa,$9a,$a9,$aa,$aa,$9a
	db $89,$88,$88,$88,$88,$66,$55,$55
	db $55,$55,$45,$44,$54,$55,$55,$45
	db $44;,$44
l9450_NX
	db $44,$a6,$aa,$bb,$cb,$bd,$bd,$ab
	db $aa,$ba,$9a,$89,$88,$88,$88,$66
	db $66,$66,$66,$67,$87,$78,$88,$88
	db $88,$66,$87,$77,$77,$77,$77,$88
	db $88,$88,$99,$aa,$aa,$aa,$aa,$99
	db $99,$99,$88,$88,$66,$66,$55,$55
	db $55,$55,$55,$55,$55,$55,$55,$55
	db $55,$55,$65,$56,$55;,$55,$55
l90c3_L
	db $55,$55,$75,$a8,$db
	db $fe,$ef,$be,$8b,$68,$55,$54,$54
	db $55,$55,$66,$87,$99,$aa,$ab,$aa
	db $89,$66,$55,$55,$55,$65,$76,$87
	db $88,$99,$99,$99,$9a,$99,$99,$98
	db $88,$88,$68,$67,$67,$77,$76,$66
	db $66,$66,$66,$66,$66,$66,$66,$66
	db $66,$66,$66,$66,$66,$66,$66,$66
	;db $66,$66
	
l94d0_OH
	db $66,$66,$f7,$ff,$9e,$5b,$74
	db $88,$56,$54,$75,$db,$bd,$88,$46
	db $b1,$58,$45,$65,$b7,$cb,$8a,$68
	db $56,$76,$56,$54,$87,$ba,$ab,$78
	db $77,$66,$66,$56,$96,$da,$bd,$8b
	db $56,$75,$67,$76,$98,$9a,$88,$66
	db $65,$77,$66,$56,$66,$87,$66,$55
	db $65,$66,$56,$65,$66,$77,$88;,$67
	
l9720_DH
	db $67,$98,$99,$a9,$aa,$9a,$aa,$89
	db $88,$78,$67,$76,$67,$76,$87,$88
	db $99,$9a,$a9,$aa,$99,$99,$89,$77
	db $77,$77,$66,$76,$77,$77,$88,$88
	db $a9,$aa,$a9,$aa,$89,$88,$78,$77
	db $77,$66,$76,$77,$87,$99,$99,$a9
	db $aa,$99,$9a,$89,$88,$77,$66,$87
	db $99,$99,$aa,$aa,$a9,$9a;,$88
	

l96a0_T
	;db $88
l96e0_TH
	db $88,$88,$87,$88,$79,$86,$88,$76
	db $86,$86,$66,$66,$76,$78,$98,$88
	db $8a,$99,$88,$89,$79,$7a,$8a,$99
	db $89,$a8,$98,$98,$68,$88,$89,$79
	db $78,$78,$88,$86,$88,$67,$68,$87
	db $87,$85,$67,$7a,$88,$8a,$8b,$9a
	db $a9,$99,$a9,$98,$a9,$a9,$a8,$98
	db $a8,$96,$86,$76,$76,$78;,$76

	
l93d0_D
	db $76,$66,$67,$66,$77,$87,$77,$89
	db $88,$89,$89,$89,$a8,$99,$9a,$a9
	db $9a,$ba,$9a,$9a,$a9,$89,$89,$88
	db $79,$87,$77,$67,$66,$67,$76,$76
	db $67,$77,$77,$88,$97,$89,$99,$99
	db $aa,$a9,$9a,$aa,$a9,$9a,$99,$89
	db $99,$87,$78,$77,$67,$77,$12,$66
	db $67,$66,$77,$87,$77,$89;,$88

l9292_P
	db $88,$99,$99,$a9,$da,$bc
	db $ed,$cd,$bb,$cc,$dc,$fd,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$8c,$04,$00,$00
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $10,$32,$45,$13,$00,$00,$00,$00
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $10,$11,$10,$11,$11,$32,$54,$55
	;db $76
	
l9590_G	;G
	db $76,$87,$88,$98,$99,$aa,$aa,$aa
	db $aa,$99,$89,$88,$88,$77,$66,$66
	db $55,$45,$41,$b7,$dc,$be,$99,$b9
	db $bb,$8a,$45,$43,$54,$55,$24,$42
	db $65,$76,$56,$54,$65,$77,$66,$86
	db $cb,$ed,$ce,$bb,$ba,$ab,$99,$68
	db $65,$66,$76,$86,$77,$87,$88,$89
	db $88,$78,$99,$99,$99,$98;,$99


l8997_K
	db $99
	db $58,$65,$88,$48,$a3,$ab,$76,$c9
	db $4a,$21,$84,$69,$44,$c7,$4a,$52
	db $a9,$48,$72,$ed,$8b,$78,$55,$24
	db $32,$f4,$cf,$10,$fb,$4f,$54,$98
	db $68,$74,$88,$56,$85,$89,$56,$87
	db $78,$76,$98,$99,$99,$89,$68,$76
	db $67,$65,$98,$78,$44,$54,$b8,$ab
	db $69,$55,$76,$88,$56;,$65
	
l9618_F
	db $65,$66,$6a,$66,$a7,$98,$66,$6a
	db $66,$a7,$a6,$67,$66,$68,$a6,$6a
	db $67,$a7,$98,$66,$66,$a7,$9a,$a5
	db $86,$66,$77,$68,$a6,$9a,$59,$66
	db $89,$a7,$89,$65,$68,$86,$a6,$76
	db $68,$86,$66,$aa,$68,$6a,$76,$86
	db $76,$7a,$66,$a6,$6a,$7a,$66,$a6
	db $8a,$76,$7a,$8a,$95,$6a,$a6


l92d2_W:
	db $44,$55,$76,$b9,$dc,$fe
	db $ff,$de,$cd,$ab,$9a,$88,$56,$45
	db $23,$22,$43,$54,$86,$98,$a9,$aa
	db $9a,$99,$99,$89,$88,$56,$45,$44
	db $54,$55,$66,$76,$87,$88,$98,$99
	db $99,$a9,$aa,$aa,$aa,$9a,$89,$78
	db $66,$66,$66,$66,$56,$55,$55,$55
	db $66,$66,$66,$56,$55,$55,$55,$55
;	db $55

l9353_Y
	db $55,$95,$54,$5c,$87
	db $a9,$a8,$ad,$bb,$bd,$9d,$9f,$ab
	db $ab,$8a,$8b,$88,$88,$46,$47,$44
	db $55,$44,$55,$40,$65,$55,$87,$86
	db $97,$88,$99,$98,$a9,$99,$9a,$98
	db $99,$98,$9a,$99,$99,$98,$8a,$88
	db $88,$78,$68,$66,$56,$55,$45,$54
	db $44,$54,$44,$55,$54,$55,$44,$64
	db $54,$47
	


l9761_UU
	db $d6,$fc,$cd,$9c,$88,$88,$56
	db $44,$76,$ba,$ab,$99,$89,$78,$56
	db $44,$65,$98,$99,$99,$99,$89,$56
	db $45,$64,$87,$88,$98,$99,$99,$68
	db $55,$65,$86,$a9,$bb,$ab,$8a,$68
	db $56,$66,$87,$88,$88,$78,$56,$55
	db $55,$55,$65,$66,$66,$56,$66,$55
	db $55,$56,$45,$65,$87,$88,$66;,$55


l97e3_EH
	db $55,$87,$f4,$8f,$95
	db $8f,$23,$67,$86,$75,$fb,$79,$b8
	db $29,$53,$76,$66,$b8,$9c,$78,$88
	db $45,$65,$87,$97,$aa,$89,$87,$56
	db $55,$76,$88,$99,$8a,$68,$66,$55
	db $76,$ab,$98,$ba,$58,$65,$56,$76
	db $99,$89,$88,$68,$55,$66,$66,$98
	db $88,$77,$66,$55,$56,$66,$66,$86
	db $57,$87

l8fc3_R:
	db $44,$75,$ea,$ff,$ac
	db $da,$ee,$5a,$32,$65,$56,$55,$76
	db $ba,$cd,$8b,$87,$99,$48,$22,$53
	db $77,$66,$97,$aa,$ab,$8a,$66,$76
	db $57,$44,$75,$98,$88,$98,$aa,$bb
	db $ab,$89,$87,$88,$56,$75,$88,$88
	db $88,$88,$68,$56,$55,$55,$55,$55
	db $55,$66,$56,$66,$56,$55,$55,$44
	db $65;,$66


l8f83_AI:		
	db $66,$96,$b8,$ff,$cb
	db $fb,$9a,$85,$73,$78,$58,$ba,$9d
	db $99,$89,$88,$44,$64,$58,$86,$a9
	db $aa,$88,$86,$58,$54,$76,$87,$88
	db $99,$9a,$78,$88,$67,$66,$86,$88
	db $9a,$ca,$aa,$a8,$88,$86,$76,$88
	db $89,$88,$89,$67,$66,$65,$65,$65
	db $66,$66,$66,$56,$55,$55,$55,$44
	db $77,$68
	

l9103_N
	db $55,$66,$66,$76,$9a
	db $a6,$bb,$cb,$bb,$de,$ed,$dd,$dd
	db $bc,$bc,$ba,$9a,$99,$78,$68,$66
	db $56,$55,$55,$55,$55,$55,$66,$65
	db $66,$76,$77,$88,$88,$88,$98,$99
	db $aa,$aa,$aa,$ba,$ba,$ab,$aa,$aa
	db $99,$89,$88,$68,$66,$55,$55,$44
	db $44,$44,$44,$44,$44,$44,$54,$45
	;db $55,$65

l9043_AO:
	db $55,$65,$66,$67,$87
	db $b9,$ec,$ff,$ff,$cf,$8a,$24,$01
	db $31,$75,$da,$fe,$ff,$ce,$8a,$56
	db $44,$54,$65,$88,$99,$aa,$aa,$bb
	db $bb,$aa,$89,$57,$45,$54,$75,$a8
	db $cb,$dd,$dd,$bc,$9a,$68,$56,$55
	db $65,$87,$a9,$bb,$bb,$9a,$88,$66
	db $55,$55,$66,$87,$98,$99,$99,$88
	db $67,$56	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

l89d7_T
	db $96
	db $78,$78,$b9,$b8,$78,$89,$76,$65
	db $78,$4b,$87,$75,$8b,$b5,$76,$a8
	db $a9,$44,$5d,$49,$8b,$83,$95,$78
	db $1a,$6c,$7a,$c2,$b4,$55,$7b,$85
	db $a8,$78,$98,$85,$87,$c4,$85,$85
	db $3b,$b8,$47,$78,$a4,$94,$68,$87
	db $66,$7a,$7a,$89,$67,$c8,$a6,$83
	db $7b,$c5,$c1,$b4,$98,$87

l8f43_AA:
	db $96,$ee,$ff,$ed,$44
	db $10,$52,$d9,$ef,$bd,$58,$45,$66
	db $86,$88,$77,$a8,$ba,$9b,$48,$44
	db $53,$a7,$cb,$ab,$68,$55,$65,$87
	db $99,$89,$88,$88,$a9,$99,$88,$78
	db $98,$a9,$99,$78,$66,$87,$98,$88
	db $68,$66,$76,$88,$88,$78,$67,$66
	db $66,$66,$66,$66,$76,$77,$66,$67
	db $67,$87
	


l9083_EE
	db $35,$43,$07,$e1,$a4
	db $79,$bd,$e8,$fd,$da,$cf,$db,$fb
	db $9a,$ab,$68,$96,$45,$54,$25,$52
	db $44,$54,$56,$65,$87,$76,$9a,$98
	db $aa,$99,$aa,$89,$a9,$89,$88,$68
	db $86,$68,$65,$67,$85,$77,$79,$a9
	db $87,$aa,$aa,$9a,$a9,$98,$88,$88
	db $67,$66,$55,$55,$55,$54,$55,$44
	db $45,$54



l9142_M
	db $32,$43,$34,$43,$44,$55
	db $55,$65,$76,$b9,$a8,$9a,$bb,$cd
	db $dd,$dd,$ee,$ed,$dd,$dc,$bb,$ab
	db $99,$89,$88,$66,$56,$55,$45,$44
	db $54,$55,$55,$55,$65,$66,$87,$88
	db $88,$99,$99,$aa,$aa,$ba,$ab,$bb
	db $ab,$bb,$bb,$aa,$9a,$89,$88,$78
	db $66,$56,$55,$44,$44,$34,$33,$33
	db $34

l9182_AH:
	db $55,$d7,$ff,$bf,$49,$33
	db $67,$68,$89,$a9,$dd,$8b,$24,$22
	db $95,$aa,$9a,$89,$99,$58,$34,$54
	db $a7,$bb,$8a,$68,$66,$66,$65,$97
	db $ba,$ab,$68,$55,$76,$98,$89,$98
	db $88,$68,$56,$75,$88,$89,$68,$66
	db $66,$66,$66,$76,$88,$67,$56,$55
	db $76,$67,$76,$66,$77,$66,$66,$56
	db $66

l91c2_V:
	db $99,$99,$99,$78,$77,$77
	db $67,$66,$77,$77,$77,$98,$99,$99
	db $a9,$aa,$99,$99,$99,$78,$77,$77
	db $67,$66,$77,$77,$77,$98,$99,$99
	db $a9,$aa,$89,$99,$99,$99,$aa,$9a
	db $99,$99,$89,$77,$77,$77,$66,$76
	db $77,$77,$87,$99,$99,$99,$aa,$9a
	db $99,$99,$89,$77,$77,$77,$66,$76
	db $77

l9212_B	;B
	db $86,$88,$98,$88,$88,$88
	db $99,$89,$88,$88,$88,$88,$99,$88
	db $88,$98,$99,$88,$88,$88,$88,$88
	db $88,$88,$88,$88,$88,$78,$88,$87
	db $77,$77,$88,$88,$77,$87,$88,$88
	db $77,$66,$66,$66,$56,$55,$55,$55
	db $66,$b8,$fe,$ff,$ce,$9a,$89,$48
	db $24,$01,$20,$55,$66,$56,$55,$55
	db $24

l9252_slashH
	db $88,$88,$68,$86,$78,$97
	db $89,$88,$76,$76,$88,$89,$99,$88
	db $68,$56,$87,$99,$a9,$89,$66,$56
	db $76,$88,$88,$89,$78,$77,$88,$88
	db $99,$88,$68,$55,$75,$a9,$9a,$89
	db $68,$55,$66,$86,$a9,$9a,$88,$56
	db $86,$88,$88,$68,$75,$77,$98,$aa
	db $98,$89,$58,$55,$66,$b9,$ab,$8a
	db $58

	
l9311_A
	db $45,$b6,$ff,$a5,$fb,$6a,$84
	db $95,$56,$73,$d9,$69,$b8,$8c,$56
	db $66,$67,$44,$a6,$8a,$96,$aa,$68
	db $65,$76,$46,$75,$99,$88,$a9,$8a
	db $67,$76,$67,$65,$97,$88,$d2,$9a
	db $a9,$a9,$59,$65,$89,$55,$98,$88
	db $67,$66,$46,$54,$66,$55,$66,$55
	db $86,$56,$76,$56,$55,$56,$65,$45


	
l9410_D
	db $3a,$fb,$98,$6c,$a9,$a5,$5a,$89
	db $a8,$58,$67,$67,$55,$55,$66,$56
	db $76,$88,$76,$86,$87,$54,$55,$47
	db $55,$85,$65,$66,$88,$8a,$a8,$aa
	db $89,$98,$89,$67,$88,$89,$98,$ba
	db $ab,$ba,$bc,$ab,$aa,$aa,$78,$87
	db $78,$66,$86,$88,$87,$98,$88,$77
	db $78,$56,$55,$56,$44,$54,$45


l94d0_OO
	db $95,$db,$ff,$ff,$4a,$02,$00,$73
	db $fb,$ff,$af,$48,$23,$42,$75,$88
	db $99,$98,$aa,$aa,$68,$25,$22,$53
	db $b8,$ed,$bd,$69,$24,$32,$75,$a9
	db $ab,$9a,$88,$88,$a9,$89,$67,$66
	db $87,$89,$89,$69,$67,$66,$66,$66
	db $55,$66,$86,$78,$66,$55,$55,$55
	db $66,$66,$66,$66,$66,$66,$56

l9510_ER
	db $67,$d7,$ff,$ab,$cb,$ac,$89,$26
	db $52,$87,$56,$86,$ba,$cb,$8b,$76
	db $88,$48,$44,$55,$76,$89,$88,$b9
	db $ab,$88,$67,$66,$66,$45,$75,$98
	db $99,$99,$99,$ba,$8a,$87,$88,$78
	db $77,$76,$98,$89,$87,$88,$78,$66
	db $55,$65,$66,$65,$66,$66,$66,$56
	db $65,$56,$55,$65,$56,$66,$66

l9550_SH
	db $8b,$43,$97,$3b,$93,$4c,$55,$3f
	db $74,$59,$58,$c8,$03,$c7,$26,$c3
	db $18,$77,$7a,$34,$c9,$82,$a1,$2b
	db $81,$2d,$76,$a8,$38,$78,$7a,$e0
	db $48,$a6,$83,$47,$3b,$a5,$3a,$85
	db $3b,$98,$64,$89,$56,$b8,$88,$83
	db $67,$87,$27,$77,$0d,$73,$5e,$72
	db $cc,$70,$d8,$44,$47,$59,$98

l95d0_Z
	db $b6,$75,$5a,$4b,$99,$b5,$58,$5b
	db $89,$a6,$96,$68,$88,$a6,$78,$4a
	db $8b,$a5,$a5,$4a,$4b,$b7,$b4,$7a
	db $4c,$87,$c3,$78,$2c,$4b,$c5,$a4
	db $3a,$5b,$99,$95,$88,$49,$b7,$b4
	db $68,$8a,$a7,$b5,$78,$4c,$9a,$a5
	db $78,$5a,$87,$b5,$78,$5c,$6b,$a6
	db $78,$5a,$a7,$b3,$58,$2d,$89

l9823_UH
	db $21,$32,$44,$44,$64
	db $86,$aa,$9a,$77,$b9,$fd,$ff,$cd
	db $ba,$cb,$cb,$8a,$55,$65,$a7,$aa
	db $89,$98,$b9,$cc,$ab,$68,$66,$88
	db $78,$57,$55,$97,$ba,$ab,$9a,$99
	db $aa,$9a,$68,$66,$86,$98,$99,$db
	db $fd,$ff,$df,$ab,$89,$88,$68,$55
	db $55,$76,$88,$78,$56,$66,$66,$56
	db $34,$22
	
	ifdef PCErelocateStart
PCErelocate_ResetVector equ 1
		org $5ffe
		dw $E000			;Reset Vector 
	endif	
	

Bitmapfont:
	;incbin "\ResALL\Font96.FNT"		;Not used by the VIC due to memory limitations
	;include "\SrcAll\monitor.asm"
	
	include "..\SrcALL\V1_Functions.asm"
	
	include "\SrcAll\BasicFunctions.asm"
	include "\SrcAll\V1_BitmapMemory.asm"
	include "\SrcAll\V1_VdpMemory.asm"		;VRAM functions for Tilemap Systems
	

	include "..\SrcALL\V1_Footer.asm"
		