
z_Regs 		equ $40		

z_HL equ z_Regs			;Zero page entries used by our code
z_L  equ z_Regs
z_H  equ z_Regs+1

z_BC equ z_Regs+2
z_C  equ z_Regs+2
z_B  equ z_Regs+3

z_DE equ z_Regs+4
z_E  equ z_Regs+4
z_D  equ z_Regs+5

vblanked 	equ $7F		;Zero page address of Vblank count

	org $BFF0

	db "NES",$1a		;ID
	db $01				;Rom pages (16k each - our program)
	db $01				;CHR-ROM pages (8k each - Tile pattern rom)
	db %00000000		;mmmmFTBM		mmmm = mapper no bottom 4 bits , Four screen vram layout, Trainer at &7000, Battery ram at &6000, Mirror (0=horiz, 1=vert)
	db %00000000		;mmmm--PV 		mapper (top 4 bits...  Pc10 arcade, Vs unisystem )
	db 0				;Ram pages
	db 0,0,0,0,0,0,0
	
;We selected Mapper 0 (Basic only)

;ROM FORMAT:
;	Bytes		Usage
;	16 Bytes	Header
;	512bytes	Trainer (Usually none)
;	16k * ?		Program ROM Banks (our code)
;	8K * ?		Character ROM banks (pattern rom)

	

nmihandler:		;This procuedure runs after each frame - see footer
	php
	inc vblanked		;Alter Vblank Zero page entry
	plp
irqhandler:	;Do nothing
	rti

ProgramStart:
	sei					;Interrupts off
	cld					;Clear Decimal flag
	
	ldx #$ff			;Set up stack
	txs
	
;Palette
	lda #$3F		;Select Palette ram &3F00
	sta $2006		;PPUADDR H
	lda #0
	sta $2006		;PPUADDR L
	
	ldx #4
PaletteAgain
	lda Palette-1,x 
	sta $2007		;PPUDATA
	dex 
	bne PaletteAgain

;Turn ON the screen
;(Sprite enable/back enable/Sprite leftstrip / backleftstrip)
	lda #%00011110 	
	sta $2001		;PPUMASK
	
	lda #$80		;NMI enable (Vblank)
	sta $2000		;PPUCTRL - VPHB SINN

	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	

;Draw our mascot
	lda #3					;Start SX
	sta z_b
	lda #3					;Start SY
	sta z_c
	
	ldx #6					;Width in tiles
	ldy #6					;Height in tiles
	
	lda #128				;TileStart
	jsr FillAreaWithTiles	;Draw the tiles to screen
	
;Draw our font
	lda #0					;Start SX
	sta z_b
	lda #16					;Start SY
	sta z_c
	
	ldx #32					;Width in tiles
	ldy #4					;Height in tiles
	
	lda #0					;TileStart
	jsr FillAreaWithTiles	;Draw the tiles to screen
	
	jmp *					;Infinite loop


		
Palette:  
; 	Color   3   2   1  0
		db $30,$21,$14,$0D

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
waitframe:
	pha
		lda #$00
		sta vblanked		;Zero Vblanked
waitloop:
		lda vblanked		;Wait for the interrupt to change it
		beq waitloop
	pla
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	


GetVDPScreenPos:			;BC=XYpos	
		lda z_c
		;and #%00000111		;Ypos * 32 tiles per line
		asl
		asl
		asl
		asl
		asl
		ora z_b				;Add Xpos
		sta z_l				;Store in L byte
		lda z_c
		and #%11111000		;Other bits of Ypos for H byte
		lsr
		lsr
		lsr
		clc
		adc #$20			;$2000 ofset for base of tilemap
		jsr waitframe		;Wait for Vblank
		sta $2006			;PPUADDR
		lda z_L
		sta $2006			;PPUADDR
	rts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
		
FillAreaWithTiles:
	sta z_d					;Backup tilenum
FillAreaWithTiles_Yagain:
	txa
	pha
		jsr GetVDPScreenPos	;Calculate Tilemap mempos
	
		lda z_d
FillAreaWithTiles_Xagain:
		sta $2007			;PPUDATA - Save Tile selection to Vram
		clc
		adc #1				;Move to next tile
		dex 
		bne FillAreaWithTiles_Xagain
		sta z_d
		inc z_c				;INC Ypos
	pla
	tax
	dey
	bne FillAreaWithTiles_Yagain
						
	jmp resetscroll			;Need to reset scroll after writing to VRAM

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	


prepareVram:			;Select destination address z_DE

	lda z_d				;MSB - DEST ADDR
	sta $2006			;PPUADDR
	lda z_e				;LSB - Dest ADDR
	sta $2006			;PPUADDR
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	



ResetScroll:	
	lda #0					;Scroll X
	sta $2005				;PPUSCROLL
	lda #0-8				;Scroll y
	sta $2005				;PPUSCROLL
	rts	
	
;Cartridge Footer	
	org $FFFA
	dw nmihandler			;FFFA - Interrupt handler
	dw ProgramStart			;FFFC - Entry point
	dw irqhandler			;FFFE - IRQ Handler
	
;;;;;;;;;;;;;;;;;
;CHR ROM appears after the program code

CHRROM_START:
		
	incbin "\ResAll\Font\FontNES.RAW"	;96 tile font
	
	ds (16*128)-(*-CHRROM_START)		;Pad to tile 128

	incbin "\ResALL\Sprites\RawNES.RAW"	
	
CHRROM_END:	

;Pad CHR ROM to 8k (to make valid file)
	ds 8192-(CHRROM_END-CHRROM_START)	
	
	
	
	