
z_Regs 		equ $20			;Fake Registers
SPpage 		equ $0100		;Stackpointer Address


opotx 		equ $60			;Old PotX value
opoty		equ $61			;Old PotY value

newvalue	equ $62			;TempVar used by interrupt handler
oldvalue	equ $63			;TempVar used by interrupt handler
	
xposL equ $D000		;Sprite 0 xpos
xposH equ $D010		;Sprite 0 xpos H bit (bit 0 of D010 only)
ypos equ $D001		;Sprite 0 ypos 



	;Basic macros for ASM tasks
	include "\SrcAll\BasicMacros.asm"
	

   ; CRT format cartridge header
   org $7FB0						  
   byte "C64 CARTRIDGE   "	   		; Cartridge Signature
   byte $00,$00,$00,$40			   	; Header length $00000040
   byte $01,$00					    ; Version (1.00)
   byte $00,$00 				 	; Cartridge Type... $0000 = normal
   byte $00						   	; Exrom Status... $00 = none
   byte $00 					   	; Game Line Status... $00 = none
   byte $00,$00,$00,$00,$00,$00    	; Unused
   ;     12345678901234567890123456789012
   byte "CHIBIAKUMAS.COM                 "	; 32 byte cartridge name

   ;******************************
   ; Chip Packet Header ($10)
   ;******************************

   org $7FF0
   byte "CHIP"
   byte $00,$00,$40,$10		;Chip Packet Length $00002010
   byte $00,$00				;Chip type 0 = ROM, 1 = RAM
   byte $00,$00				;Bank Location $0000 = normal cartridge
   byte $80,$00				;Load location $8000
   byte $40,$00				;Rom image size $4000

   org $8000				;Start of ROM
   
   word Startup				;Startup Vector
   word Startup				;Restore Vector
   byte $C3,$C2,$CD,$38,$30	

Startup:

   jsr $FF84		;IOINIT. Initialize CIA's, SID volume; setup memory configuration; set and start interrupt timer.
   jsr $FF87		;RAMTAS. Clear memory addresses $0002-$0101 and $0200-$03FF; run memory test and set start 
						;and end address of BASIC work area accordingly; set screen memory to $0400 and datasette buffer to $033C.
   jsr $FF8A		;RESTOR. Fill vector table at memory addresses $0314-$0333 with default values.
   jsr $FF81		;SCINIT. Initialize VIC; restore default input/output to keyboard/screen; clear screen; set PAL/NTSC switch and interrupt timer.

;Your Program Starts Here!


;Set up our interrupts

	lda #<InterruptHandler
	sta $314
	lda #>InterruptHandler
	sta $315
	
	LDA #%01111111      ;switch off interrupt signals from CIA-1
    STA $DC0D
	
    LDA #0             	;Line 0
    STA $D012			;Raster line of IRQ
	
		 ;----LSBR		;R=Raster line / B=Sprite Background
	LDA #%00000001     	;S=Sprite coll / L=LightPen
	STA $D01A		 	;Interrupt control register.
	
	cli
	
	
;Turn on Hsprite 0.

	lda #%0000001		;%76543210 (bit= sprite num)
	sta $d015			;Sprite 0 ON
	
	lda #00000000
	sta $d01c			;Multicolor
	sta $d017			;Double Height
	sta $d01d			;Double Width
	sta $D010			;Xposh (bit 0 only)
	
	lda #128 
	sta $D000			;Xpos
	sta $D001			;Ypos
	
	lda #%00001111		;Color
	sta $d027
	
	lda #($2000/64)		;Sprite pointers (default $7F8)
						; (will change if screen moved)
	sta $07F8			; SSSSSSSS 	s*64=memory address
	
	ldy #63-1			;3 bytes *21 lines = 63 bytes
SendBitmap	
		lda Cursor,y	;Source pattern
		sta $2000,y		;Destination sprite ram
	dey 
	bpl SendBitmap		;>-0?
	
	jsr $e544			;CLS
	
	
	
infloop:
	jsr $E566			;Cursor Home
	
	;lda $DC00			;Read in Joystick 2 (Ctrl Port A)
	lda $DC01			;Read in Joystick 1 (Ctrl Port B)
	
	ldx $D419			;Paddle X
	ldy $D41A			;Paddle Y
	jsr Monitor			
	
	ldx #%00001111		;Color
			
	lda $DC01			;%---L---R ... Mouse buttons
	and #%00010000		;%---L---R ... Mouse buttons
	bne NotLmouse
		txa
		and #%00001110	;Clear bit 0
		tax
NotLmouse:	

	lda $DC01
	and #%0000001		;%---L---R ... Mouse buttons
	bne NotRmouse
		txa
		and #%00001101	;Clear bit 1
		tax
NotRmouse:	
	stx $d027			;Set sprite color
	
	lda xposH			;AX= Sprite Xpos
	ldx xposL
	ldy ypos			; Y= Sprite Ypos
	jsr Monitor			
    
	jmp infloop
	
	
NewLine:
	lda #13
	jmp PrintChar
	
PrintChar:	;DefaultFont
	cmp #96					;Check if character >96
	bcc	PrintCharOK
	and #%11011111			;Convert to uppercase
PrintCharOK:
	jmp $ffd2				;CHROUT - Output a character  
	

PrintChar2:	;Upper+LowerCase Font
	cmp #64					;Check if character >96
	bcc	PrintCharOKB
	eor #%00100000			;Convert to uppercase
PrintCharOKB:	
	jmp $ffd2				;CHROUT - Output a character  
		
Cursor:
	incbin "\ResAll\Sprites\SpriteC64.raw"
Cursor_End:		


;Based on example pg 85 : 
;Commodore_1351_Mouse_Users_Manual_1986_Commodore.pdf

;$DC01	CIA1: Port B, keyboard matrix rows and joystick #1	%---FRLDU 	For mouse:  %---L---R


;$D419	Paddle X value (Mouse)	xPPPPPPn	x=dont care (ignored) / P=Mouse Pos MOD 64 / n=noise bit
;$D41A	Paddle Y value (Mouse)	xPPPPPPn	x=dont care (ignored) / P=Mouse Pos MOD 64 / n=noise bit


InterruptHandler:			
		lda $D419			;Current Pot value potx
		ldy opotx			;Old Pot Value
		jsr movchk			;Calculate X shift
		sty opotx
		
		clc
		adc xposL			;Shift X Low byte
		sta xposL			;Update Xpos Low byte
		
		txa 				;Shift X High byte
		adc #0				;Pass any carry
		and #%00000001
		eor xposH
		sta xposH			;Update Xpos High byte
		
		lda $D41A			;Current Pot value poty
		ldy opoty			;Old Pot Value
		jsr movchk			;Calculate Y shift
		sty opoty
		
		eor #$FF			;Flip Y axis
		sec
		adc ypos			;Shift Y Low byte
		sta ypos			;Update Ypos Low byte
	
	    LDA $DC0D           ;Clear CIA-1 interrupts
        LDA $DD0D			;Clear CIA-2 interrupts
		ASL $D019  			;Clear bit 7 (any interrupt)
	pla
	tay
	pla
	tax
	pla
	rti
	
	
;Pass: 		A=NewVal 		  Y=OldVal
;Returns: 	XA=16 bit value   Y=NewVal

movchk:	
	sty oldvalue		;LastPos
	sta newvalue		;NewPos
	ldx #0				;H byte of 16 bit result
	
	sec 
	sbc oldvalue		;Difference between Newpos and LastPos
	
	and #%01111111		;Top bit unused
	cmp #%01000000		;Negative?
	bcs movchkNeg
	lsr					;Least significant bit = Noise
	beq movchkZero
	ldy newvalue		;New value for saving to OldVal
	rts

movchkNeg:
	ora #%11000000		;Top bit unused - convert to negative
	cmp #$FF			;Least significant bit = Noise
	beq movchkZero		;Rounding error?
	sec
	ror 
	ldx #$FF			;H=negative
	ldy newvalue		;New value for saving to OldVal
	rts
	
movchkZero:
	lda #0				;Return shift=0
	rts
	

	include "\SrcAll\monitor.asm"			;Debugging tools
	include "\SrcAll\BasicFunctions.asm"	;Basic commands for ASM tasks
	