;TwoColor equ 1		;Color left and right
;halfdraw equ 1		;No mid raster change
;Threebyte equ 1		;Fill entire screen with 3 byte PFs

    ORG $F000       ;Start of program cartridge
ProgStart:
	
	ifd TwoColor
		lda #2		;2 color - Normal (repeat)
		;lda #3		;2 color - Mirror playfield
		sta $0A		;CTRLPF	--SS-PCR	Playfield Control S=Ball
					; Size P=Playfield/ball priority
					; C=score Color / R=Relfection
	else
		lda #0		;Normal (repeat)
		;lda #1		;Mirror playfield
		sta $0A		;CTRLPF	--SS-PCR	Playfield Control S=Ball
					; Size P=Playfield/ball priority
					; C=score Color / R=Relfection
	endif
	
	ifd Threebyte
		lda #%00110000
		sta $0D 	;PF0 - Playfield 0 %4321---- (Right->Left)
		
		lda #%10111001 
		sta $0E 	;PF1 - Playfield 1 %12345678 (Left->Right)
		
		lda #%01011111
		sta $0F 	;PF2 - Playfield 2 %87654321 (Right->Left)
	endif
	
DoFrame:
    lda #%00000010  ;%------V-
    sta $00			;VSYNC - Start vsync
    	
    sta $02 		;WSYNC - wait for leading edge of horizontal blank
	sta $02 		;wsync x3 lines
	sta $02 		;wsync
	
    lda #0			
    sta $00 		;VSYNC - End Vsync

	lda #43			;76 ticks per line *37 lines /64 ticks per timer
	sta $296		;TIM64T - 64 clock interval
	
	jsr DoGameTasks	;Nows a good time to do any calculations
	
	jsr WaitTimer	;Wait for the timer to end
    
	lda #0          
	sta $01 		;VBLANK - end vblank

	
	
DoScanLine:
	ifndef Threebyte
		lda PlayfieldDataL+1,y  	;lLlrrr
		sta $0E 	;PF1 - Playfield 1 %12345678 (Left->Right)
			
		lda PlayfieldDataL+2,y 		;llLrrr
		sta $0F 	;PF2 - Playfield 2 %87654321 (Right->Left)
	endif 
	
	ifndef halfdraw
		lda PlayfieldDataR+0,y   	;lllRrr
		sta $0D 	;PF0 - Playfield 0 %4321---- (Right->Left)
		
		lda PlayfieldDataR+1,y   	;lllrRr
		sta $0E 	;PF1 - Playfield 1 %12345678 (Left->Right)
	endif
	
	ifd TwoColor
		lda PlayfieldDataL+3,y   
		sta $06		;COLUP0 - player 0 color %CCCCLLLL
	
		lda PlayfieldDataR+3,y   
		sta $07		;COLUP1 - player 1 color %CCCCLLLL
	else 
		lda PlayfieldDataR+3,y   
		txa		;Rainbow!!!!
		
		sta $08		;COLUPF - Playfield Foreground %CCCCLLLL
		
		;lda PlayfieldDataL+3,y 
		;sta $09	;COLUBK - Playfield Background %CCCCLLLL
	endif
	
	ifndef halfdraw
		lda PlayfieldDataR+2,y  	;lllrrR
		sta $0F 	;PF2 - Playfield 2 %87654321 (Right->Left)
	endif
	
	txa        
	and #%11111100	;Get offset for next line
    tay        
	
	ifndef Threebyte
		lda PlayfieldDataL+0,y   	;Lllrrr
		sta $0D 	;PF0 - Prep 0 for next wsync/hblank
	endif
	
	sta $02 		;WSYNC - wait for leading edge of horizontal blank
	
    inx       
    cpx #191
    bne DoScanLine
	
	
;Overscan
	lda #35			;76 ticks per line *30 lines /64 ticks per timer
	sta $296		;TIM64T - 64 clock interval
	
	lda #%01000010  ;iI----V-	vertical blank set-clear V=vblank
					; i=INPT0-3 I=INPT4-5 coltrol

    sta $01 		;VBLANK - Start vblank
	
	jsr WaitTimer	
	
    jmp DoFrame 	;Next frame

	

DoGameTasks:
	lda #0
	ifndef Threebyte
		sta $0D 	;PF0 - Playfield 0 %4321---- (Right->Left)
		sta $0E 	;PF1 - Playfield 1 %12345678 (Left->Right)
		sta $0F 	;PF2 - Playfield 2 %87654321 (Right->Left)
	endif 
	
	sta $06			;COLUP0 - player 0 color %CCCCLLLL
	sta $07			;COLUP1 - player 1 color %CCCCLLLL
	sta $08			;COLUPF - Playfield Foreground %CCCCLLLL
	sta $09			;COLUBK - Playfield Background %CCCCLLLL
	
	ldy #0			;bitmap offset
	ldx #0			;Scanline
	rts
	
	
WaitTimer:			;Wait for timer to end, and do a wsync
	lda $285		;INSTAT - %Tt------	Timer Status 
					; T=1=Timer overflow since set
	bpl WaitTimer
	sta $02 		;WSYNC - wait for leading edge of horizontal blank
	rts
	
	
	
	
	
	align 8			;Solves timing problems 
					;(else bottom of screen is corrupted)
	
PlayfieldDataL: 
  ;  PF0       PF1        PF2     COL
 db %00000000,%00100000,%01000000,$4E
 db %00000000,%00100000,%10000000,$4F
 db %00000000,%00100000,%10000000,$4E
 db %00000000,%10100000,%10010000,$4D
 db %00000000,%10100000,%11111000,$4C
 db %10000000,%10000000,%00000110,$4B
 db %10000000,%01001000,%00010010,$4A
 db %10000000,%00001000,%11101001,$49
 db %01000000,%00011001,%00000000,$48
 db %00000000,%00001010,%00110000,$47
 db %01000000,%00001010,%00000100,$46
 db %01010000,%00001100,%11011000,$45
 db %10000000,%00000110,%11111101,$44
 db %00000000,%10000011,%11111111,$43
 db %00000000,%00000011,%01110001,$42
 db %00000000,%10000011,%01101101,$41
 db %01010000,%01000000,%01101111,$42
 db %11110000,%00001000,%11111111,$43
 db %01110000,%01001000,%11111111,$44
 db %01110000,%00100000,%00011110,$45
 db %01110000,%11111100,%00111110,$46
 db %00110000,%01111111,%10111011,$47
 db %00000000,%10011111,%11100001,$48
 db %10000000,%00000011,%00100000,$49
 db %00000000,%00001001,%01000000,$4A
 db %10000000,%00000000,%10010111,$4B
 db %01000000,%10000000,%10001110,$4C
 db %00000000,%00000100,%11000101,$4D
 db %01000000,%10000100,%10000100,$4E
 db %00000000,%00000101,%00000010,$4F
 db %10000000,%10001100,%00110010,$4E
 db %00000000,%10100110,%11000010,$4D
 db %10000000,%11000100,%00000001,$4C
 db %00000000,%01000100,%00000001,$4B
 db %10000000,%01000100,%00011001,$49
 db %00000000,%01000000,%00000010,$48
 db %10000000,%00000000,%11111110,$47
 db %00000000,%10000000,%00011110,$46
 db %00000000,%00000000,%00001100,$45
 db %00000000,%01000000,%00001110,$44
 db %10000000,%00100000,%00011110,$43
 db %00100000,%00000000,%00011110,$42
 db %10010000,%00010000,%00011110,$41
 db %00000000,%00000000,%00011111,$42
 db %00010000,%00010001,%00001111,$43
 db %00000000,%00001001,%00000111,$44
 db %00100000,%00000001,%00000111,$45
 db %01000000,%00000100,%00000011,$46
 
PlayfieldDataR: 
 db %00000000,%00000000,%00000000,$CF
 db %00000000,%00000000,%00010000,$CE
 db %00000000,%00000000,%00010100,$CD
 db %00000000,%00000000,%00010100,$CC
 db %00000000,%00000000,%00011100,$CB
 db %01110000,%00000000,%00111110,$CA
 db %10000000,%00000001,%00110110,$C9
 db %01000000,%10000001,%00101111,$C8
 db %01010000,%01100001,%01011111,$C7
 db %00000000,%00100001,%00011111,$C6
 db %00000000,%00011011,%01011111,$C5
 db %00010000,%10001011,%10011111,$C4
 db %11110000,%00001111,%01011111,$C3
 db %00110000,%11101111,%00011111,$C2
 db %00000000,%11111111,%01011111,$C1
 db %10110000,%11111111,%10011111,$C2
 db %11110000,%11101011,%00001111,$C3
 db %11110000,%11001011,%10000111,$C4
 db %11010000,%11001111,%01000001,$C5
 db %11110000,%10101111,%10000100,$C6
 db %11110000,%11111100,%01000000,$C7
 db %11110000,%00111101,%10000000,$C8
 db %01110000,%00110100,%01000000,$C9
 db %00100000,%00010101,%10000000,$CA
 db %00010000,%00110000,%01000000,$CB
 db %11000000,%11110100,%00100000,$CC
 db %01100000,%11011110,%01100001,$CD
 db %01010000,%10000101,%00110010,$CE
 db %01000000,%00100110,%00110100,$CF
 db %10000000,%00010110,%00010000,$CE
 db %10000000,%00000010,%00011000,$CD
 db %10000000,%00000010,%00010110,$CC
 db %00000000,%10000010,%00010000,$CB
 db %00100000,%10000010,%00000000,$CA
 db %00010000,%10000100,%10000000,$C9
 db %10000000,%00000000,%01000000,$C8
 db %01110000,%00000010,%01101100,$C7
 db %01110000,%00000010,%00111100,$C6
 db %11100000,%00010000,%00101101,$C5
 db %11100000,%00011001,%00001111,$C4
 db %11100000,%00001101,%00011111,$C3
 db %11110000,%00000101,%10011111,$C2
 db %11110000,%11000001,%01001111,$C1
 db %11110000,%11000011,%01000111,$C2
 db %11100000,%11000100,%01000000,$C3
 db %11000000,%11000100,%00010000,$C4
 db %10000000,%11000101,%11111111,$C5
 db %00000000,%00001101,%00000100,$C6

;Cartridge footer

    ORG $FFFC 
    dw ProgStart	;Reset
    dw ProgStart	;Break

	
; Type_______NTSC__PAL/SECAM______
; V-Sync      3     3    scanlines
; V-Blank     37    45   scanlines (upper border)
; Picture     192   228  scanlines
; Overscan    30    36   scanlines (lower border)
; Frame Rate  60    50   Hz
; Frame Time  262   312  scanlines	


; Blanking  22.6 machine clocks (68 color clocks)
; Picture   53.3 machine clocks (160 color clocks) (160 pixels)
; Total     76.0 machine clocks (228 color clocks)
	