
chibisoundram equ $1100		;Chibitracks needs 128 bytes of ram

SongOffset equ ChibiSoundRam+ChannelDataLengthTotal 
;Remap internal addresses in song (eg compiled for &8000,
;loaded to &2000 = offsets of -&6000
SongBase  equ SongOffset+2 ; dw Song1
Instrumentlist equ SongBase+2 ;
Patternlist equ Instrumentlist+2
SongChannels equ Patternlist+2 ; db 0
SongSpeed equ  SongChannels+1 ; db 0
RepPoint equ  SongSpeed+1 ; db 0


ChibiTracks_AllowRelocation equ 1
ChibiTracks_AllowSpeedChange equ 1



;Current player pos
PlayerX 	equ $80	
PlayerY 	equ PlayerX+1

;Last player pos (For clearing sprite)
PlayerX2 	equ PlayerX+2
PlayerY2 	equ PlayerX+3


TileSmoothXmove equ 1	;move in blocks <8 pixels
;TileSmoothYmove equ 1	;This would just waste cpu power

VscreenMinX equ 84		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

;LIMITATION.. The Virtual screen cannot be smaller than the sprite or 
;the crop will malfunction! (It can be the same size)

VscreenWid equ 88		;Visible Screen Size in logical units
VscreenHei equ 92

	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0




TileCache equ $1200


offset equ TileCache-2
offset2 equ TileCache-1
TileClear equ TileCache-3
spritehclip equ TileCache-4
striproutine equ TileCache-5
	 
ChibikoDef equ $10C0
ChibicloneDef equ $10D0

z_Regs 		equ $20

ScreenBase equ $1E00


	include "\SrcAll\BasicMacros.asm"
	
	


;* = $1001
		; BASIC program to boot the machine language code
;		db $0b, $10, $0a, $00, $9e, $34, $31, $30, $39, $00, $00, $00


* = $A000
		dw ProgramStart
		dw ProgramStart
		db $41,$30,$C3,$C2,$CD		;ROM Header
ProgramStart:


;Screen Init
	ldx #16					;We're going to copy 16 registers 
ScreenInitAgain:	

	sei             ;Disable interrupts
	
	dex
	lda VicScreenSettings,x	;Get A parameter
	sta $9000,X				;Store to the video registers at $9000
	txa
	bne ScreenInitAgain

	loadpair z_hl,$9600
	loadpair z_bc,$0200
	lda #1				;Space character
	jsr cldir				;Clear screen bytes
		
	loadpair z_hl,(TileCache-8)
	loadpair z_bc,$400
	jsr cldir0
		
  
	
	lda #24
	sta z_ixl
	loadpair z_hl,TileMap2
	loadpair z_de,TileCache
FillYAgain:
	loadpair z_bc,32
	jsr ldir
	loadpair z_bc,4
	jsr addhl_bc
	
	dec z_ixl
	bne FillYAgain

	loadpair z_hl,xChibicloneDef
	loadpair z_de,ChibicloneDef
	loadpair z_bc,16
	jsr ldir
	
	loadpair z_hl,xChibikoDef
	loadpair z_de,ChibikoDef
	loadpair z_bc,16
	jsr ldir
	
	
	
	
	
	loadpair z_hl,TestSprite
	loadpair z_de,TileCache
	jsr cls
	

	loadpair z_ix,ChibikoDef
	jsr DrawSpriteAlways	;Draw Player Sprite

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	jsr ChibiSoundPro_Init
	
	lda #<Song1
	sta SongBase	;address of song.
	lda #>Song1
	sta SongBase+1	;address of song.
	
	jsr ChibiTracks_StartSong

	
	
	

	
	
;Only need this for BREAK command
	;lda #<IntEmpty
	;sta $0316			;BRK
	;lda #>IntEmpty
	;sta $0317
		
		; EIIIIIII E=Enable/Disable
	;lda #%01111111
	;sta $911E   	;Disable All NMIs
	
	
;NMI Ver
	;lda #%01000000 	;Enable Timer A
	;sta $911B
  
	;lda #$0
	;sta $9114		;Time L	(60 hz)
	;lda #$80
	;sta $9115		;Time H
		
		; EIIIIIII E=Enable/Disable
	;lda #%11000000
	;sta $911E	

;VIA 1 will cause an NMI, so to use $9110-$911F regs enable this
	lda #<IntNMIMus
	sta $0318			;NMI
	lda #>IntNMIMus
	sta $0319
	
;IRQ Ver
	lda #%01000000 	;Enable Timer A
	sta $912b
  
	lda #$0
	sta $9124		;Time L	(60 hz)
	lda #$60
	sta $9125		;Time H
		
	; 	  EIIIIIII E=Enable/Disable
	lda #%11000000
	sta $912E
	

;VIA 2 will cause an IRQ, so to use $9120-$912F regs enable this
	lda #<InterruptHandler
	sta $0314
	lda #>InterruptHandler
	sta $0315
		
	cli				;Turn on interrupts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
;LAB_911B	= $911B		; VIA 1 ACR
					; bit	function
					; ---	--------
					;  7	T1 PB7 enabled/disabled
					;  6	T1 free run/one shot
					;  5	T2 clock PB6/ﾘ2
					; 432	function
					; ---	--------
					; 000	shift register disabled
					; 001	shift in, rate controlled by T2
					; 010	shift in, rate controlled by ﾘ2
					; 011	shift in, rate controlled by externak clock
					; 100	shift out, rate controlled by T2, free run mode
					; 101	shift out, rate controlled by T2
					; 110	shift out, rate controlled by ﾘ2
					; 111	shift out, rate controlled by externak clock
					;  1	PB latch enabled/disabled
					;  0	PA latch enabled/disabled	
	
	
	; If enable/disable bit is a zero during a write to this register, each 1 in bits 0-6
; clears the corresponding bit in the IER. if this bit is a one during a write to this
; register, each 1 in bits 0-6 will set the corresponding IER bit

;LAB_911E	= $911E		; VIA 1 IER
					; bit	function
					; ---	--------
					;  7	enable/disable
					;  6	T1 interrupt
					;  5	T2 interrupt
					;  4	CB1 transition
					;  3	CB2 transition
					;  2	8 shifts done
					;  1	CA1 transition
					;  0	CA2 transition
		
	

	loadpair z_bc,$6060
infloop:
	pushpairsafe z_bc
		jsr readjoystick
	pullpairsafe z_bc
startdraw:
	pha
		bit lookupbits+4
		bne joynotfire
		inc offset

joynotfire:
		pushpair z_bc

			lda offset
			sta z_c
			lda offset+1
			sta z_b
			cmp z_c
			bne scrollchange
				jmp noscrollchange
scrollchange
			pushpair z_bc
				lda #$24
				sta z_iyh

				lda #$20
				sta z_iyl

				lda #32
				sta z_ixh
				
				lda #24
				sta z_ixl

				loadpair z_de,tilecache

				lda z_b
				pha
					loadpair z_hl,tilemap2
					lda z_c
					and #%00000011
					sta z_c

					lda #0
					sta z_b
					jsr addhl_bc
				pla
				and #%00000011
				sta z_c
				pushpair z_hl
					loadpair z_hl,tilemap2
					;lda #0
					;sta z_b
					jsr addhl_bc
				pullpair z_bc
				jsr changescroll
			pullpair z_bc
		
			lda z_c
			sta offset
			sta offset+1
		
			loadpair z_ix,chibikodef
			ldy #spr_flags
			
			lda (z_ix),y
			clc
			adc #1
			sta (z_ix),y
			
			;loadpair z_hl,$4180		;Screen Offset $4180
			;loadpair z_bc,(80*200)	;Screen Offset $4180
			;jsr cldir0				;Clear screen bytes
	
			jsr flagspriteforrefresh
noscrollchange:
	
		loadpair z_ix,chibikodef
		pullpair z_bc
	pla
	sta z_d

	and #%00000001
	bne joynotup
	dec z_c
	jsr flagspriteforrefresh
joynotup:
	lda z_d
	and #%00000010
	bne joynotdown
	inc z_c
	jsr flagspriteforrefresh
joynotdown:
	lda z_d
	and #%00000100
	bne joynotleft
	dec z_b
	jsr flagspriteforrefresh
joynotleft:
	lda z_d
	and #%00001000
	bne joynotright
	inc z_b
	jsr flagspriteforrefresh
joynotright:

joydone:

	pushpair z_bc
		loadpair z_ix,chibikodef
		ldy #spr_xpos
		lda z_b
		sta (z_ix),y
		
		ldy #spr_ypos
		lda z_c
		sta (z_ix),y
		pushpair z_ix
			jsr removesprite
		pullpair z_ix
		jsr zerospriteincache
		
		loadpair z_ix,chibiclonedef
		jsr flagspriteforrefresh
		pushpair z_ix
			jsr removesprite
		pullpair z_ix
		ldy #spr_xpos
		
		lda (z_ix),y
		clc
		adc #1
		sta (z_ix),y
		jsr zerospriteincache
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		lda #$02
		sta tileclear
		loadpair z_hl,testsprite
		loadpair z_de,tilecache
		jsr cls
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		lda #0
		sta tileclear
		loadpair z_ix,chibiclonedef
		jsr drawsprite
		loadpair z_ix,chibikodef
		jsr drawspritealways
		
		;jsr ChibiTracks_Play
		
	pullpair z_bc
	jmp infloop
		
	
	
	;40 bytes per line = * %00000000 00101000
	;We shift our Ypos 3 to the right, add it, then another 2, eg
	
	;%00000000 00101000	=40 (32+8)
	;%YYYYYYYY 00000000
	;%000YYYYY YYY00000	= Y*32
	;%00000YYY YYYYY000 = Y*8
GetScreenPos:

	
	lda #$1e			;Screen base is $1E00
	sta z_h					;Colors at $9600 (add $7800 offset)

	lda z_b				;Xpos
	lsr
	lsr
	sta z_l

	lda z_c				;Ypos
	lsr
	lsr
	tay
	beq GetVDPScreenPos_YZero
GetVDPScreenPos_Addagain:	;Repeatedly add screen width (22) Y times 
	clc
	lda z_l
	adc #22			;22 bytes per line
	sta z_l
	lda z_h
	adc #0			;Add Carry
	sta z_h
	
	dey
	bne GetVDPScreenPos_Addagain
GetVDPScreenPos_YZero:
	rts
		;We Return ---FRLDU in z_h for Player 0, and z_L for Player 1


ReadJoystick:	;Returns %--21RLDU
	
	lda #%01111111
	sta $9122	;Set Data Direction of port B to READ (0=read)
	sta z_h
;	lda #%11000011
;	sta $9113	;Set Data Direction of port A to READ (0=read)
	
	lda $9120	;Port B (R------- Switch)
	sta z_as
	
	;lda #255	;Set all buttons to unpressed
	;sta z_l
	
	
	lda $911F	;Port A (--FLDU-- Switches)
	rol
	rol
	rol
	rol z_h		;Shift in Fire
	rol z_as		
	rol z_h		;Shift in Right
	rol
	rol z_h		;Shift in Left
	rol
	rol z_h		;Shift in Down
	rol
	rol z_h		;Shift in Up
	
	lda z_h
	
	;lda #255
	;sta $9122	;Reset port B (for Keyb col scan)
	
	rts
	
	
	
PrintChar:
	Rts


DoStrip:
	ldx #0
NextTile:
DrawTile:
		lda (z_bcs,x)	;BC=Tilemap data
		
		beq CustomTileDone	;EmptyTile
		sta z_hs
		
		lda TileClear

		beq NoClear
		txa
		sta (z_bcs,x)
		
NoClear:
		
		
		ldy Z_hs
		lda (z_DEs),y
		sta (z_HL,x)
		
CustomTileDone:
		INC z_Cs
		BNE	CustomTileDoneC
		INC	z_Bs
CustomTileDoneC:
		inc z_l
		bne CustomTileDoneB
		inc z_h
CustomTileDoneB:
		dec z_iyl
		beq TileDone2
			jmp	NextTile
TileDone2:
	rts




DoStripRev:
	lda #>FlipLUT
	sta z_b
	lda #<FlipLUT
	sta z_c
	ldx #0
NextTileRev:
DrawTileRev:
		lda (z_bcs,x)	;BC=Tilemap data
		
		bne NotCustomTileDoneRev
		jmp CustomTileDoneRev	;EmptyTile
NotCustomTileDoneRev:
		sta z_hs
		
		lda TileClear

		beq NoClearRev
		txa
		sta (z_bcs,x)
		
NoClearRev:
		ldy Z_hs
		lda (z_DEs),y
		sta z_hs

		ldy #0
LookUpAgain:		
		lda (z_bc),y
		beq LookUpNotFound
		iny
		cmp z_hs
		beq LookUpFound1
		
		lda (z_bc),y
		iny
		cmp z_hs
		bne LookUpAgain
;LookUpFound2		
		dey
		dey
		lda (z_bc),y
		jmp LookUpFound
LookUpFound1:		
		lda (z_bc),y
		jmp LookUpFound
LookUpNotFound:
		lda z_hs
LookUpFound:		
		sta (z_HL,x)	
		
		
		
CustomTileDoneRev:
		lda z_Cs
		bne CustomTileDoneCRev
		dec	z_Bs
CustomTileDoneCRev:
		dec z_Cs
		
		inc z_l
		bne CustomTileDoneBRev
		inc z_h
CustomTileDoneBRev:
		dec z_iyl
		beq TileDone2Rev
			jmp	NextTileRev
TileDone2Rev:
	rts
	
	

		
FlipLUT: 				;Src,Dest Substitution list
	db $3C,$3E	;<>
	db $1C,$2F	;/
	db $1B,$1D  ;[]
	db $28,$29	;()
	
	db $7E,$7C	;TopLeft
	db $7B,$6C	;BottomLeft
	db $61,$E1	;Left
	
	db $FF,$7F ;Checkerboard
	
	db $EC,$FB ; BottomLeft Inv
	db $FC,$FE ; TopLeft Inv
	
	db 0
	
	
	;Bitmap Data
TestSprite:
	db $80,$81,$82,$83,$84,$85,$86,$87,$88
TestChibiko:
	incbin "\ResAll\MinTile\TileTestPET.raw"
	db 0,$2F,$45,$45,$1C,$42,$20,$57,$57,$42,$42,11,12,13,$42,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,$42,$42,$30,$3E,$3E,$20,36,37

xChibicloneDef:
	dw TestSpriteList	;Tilemap
	dw TestChibiko		;Pattern Data
	db 20,32		;Width,Height
	db 64,128		;X,Y
	db 1,1			;RefreshTile,Sprite
	db 64,128		;X,Y
	db 0,0			;Flags
xChibikoDef:
	dw TestSpriteList	;Tilemap
	dw TestChibiko		;Pattern Data
	db 20,32		;Width,Height
	db 96,96		;X,Y
	db 1,1			;RefreshTile,Sprite
	db 64,128		;X,Y
	db 0,0			;Flags

	
	
	


TestSpriteList:
Sprite_1:
  db 0,1,2,3,4
  db 5,6,7,8,9
  db 10,11,12,13,14
  db 15,16,17,18,19
  db 20,21,22,23,24
  db 25,26,27,28,29
  db 0,30,31,32,0
  db 0,33,34,35,0
  
Tilemap2
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
		
		
	
	include "/srcALL/V1_MinimalTile.asm"
	
	
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	include "\SrcALL\Multiplatform_ChibiSoundPro.asm"

	include "\SrcALL\Multiplatform_ChibiTracks_Tweener.asm"
	include "\SrcALL\Multiplatform_Fraction16.asm"
	include "\SrcAll\Multiplatform_ChibiTracks.asm"
	
Song1:
	;include "\ResALL\ChibiSoundPro\CBT1.asm"
	;include "\ResALL\ChibiSoundPro\CBT2.asm"
	;incbin  "\ResALL\ChibiSoundPro\song.cbt"
	;incbin  "\ResALL\ChibiSoundPro\song2.cbt"
	incbin  "\ResALL\ChibiSoundPro\ChibiAkumasTheme.cbt"
	
IntNMIMus:				;NMI VIA1
	pha
	txa
	pha
	tya 
	pha
	
	lda #%11111111
	sta $911D			;Clear VIA1 interrupt
	
InterruptHandler:		;IRQ VIA2
	
	lda #%11111111
	sta $912D			;Clear VIA2 interrupt
	
		pushpair z_hl
		pushpair z_de
		pushpair z_bc
		pushpair z_ix
			jsr ChibiTracks_Play
		pullpair z_ix
		pullpair z_bc
		pullpair z_de
		pullpair z_hl
IntEmpty:	
	pla
	tay
	pla
	tax
	pla
IntNMI:
	rti
	

; the status bit is a not normal flag. it goes high if both an interrupt flag in the IFR
; and the corresponding enable bit in the IER are set. it can be cleared only by clearing
; all the active flags in the IFR or disabling all active interrupts in the IER

;LAB_911D	= $911D		; VIA 1 IFR
					; bit	function		cleared by
					; ---	--------		----------
					;  7	interrupt status	clearing all enabled interrupts
					;  6	T1 interrupt	read T1C_l, write T1C_h
					;  5	T2 interrupt	read T2C_l, write T2C_h
					;  4	CB1 transition	read or write port B
					;  3	CB2 transition	read or write port B
					;  2	8 shifts done	read or write the shift register
					;  1	CA1 transition	read or write port A
					;  0	CA2 transition	read or write port A	
		
	
	include "\SrcAll\BasicFunctions.asm"
		
		

VicScreenSettings:
	db $0C		;$9000 - horizontal centering
	db $26		;$9001 - vertical centering
	db $96		;$9002 - set # of columns / 
					;Bit7 = screen base bit ($16 for screen at $1000)
	db $AE		;$9003 - set # of rows
	db $7A		;$9004 - TV raster beam line
	db $F0		;$9005 - bits 0-3 start of character memory /  
					;bits 4-7 is rest of video address 
					;$(CF for screen at $1000)
	db $57		;$9006 - horizontal position of light pen
	db $EA		;$9007 - vertical position of light pen
	db $FF		;$9008 - Digitized value of paddle X
	db $FF		;$9009 - Digitized value of paddle Y
	db $00		;$900A - Frequency for oscillator 1 (low)
	db $00		;$900B - Frequency for oscillator 2 (medium)
	db $00		;$900C - Frequency for oscillator 3 (high)
	db $00		;$900D - Frequency of noise source
	db $00		;$900E - bit 0-3 sets volume of all sound / 
					;bits 4-7 are auxiliary color information
	db $00+8 	;$900F - Screen and border color register
	
	
	;org $FFFE
	;dw InterruptHandler