


ChibiTracks_AllowRelocation equ 1		;Allow Alt Load address
ChibiTracks_AllowSpeedChange equ 1		;Allow SongSpeed

SmsTranspose equ 1		;Pitchshift low values


;We need to allocate about 128 bytes for ChibiSound
chibisoundram equ $900

SongOffset equ ChibiSoundRam+ChannelDataLengthTotal 
; Dw 0	;Remap internal addresses in song (eg compiled for &8000, 
;	loaded to &2000 = offsets of -&6000
SongBase  equ SongOffset+2 ; dw Song1
Instrumentlist equ SongBase+2 ;
Patternlist equ Instrumentlist+2
SongChannels equ Patternlist+2 ; db 0
SongSpeed equ  SongChannels+1 ; db 0
RepPoint equ  SongSpeed+1 ; db 0


ScreenBase equ $0000+VDPBuffer


	include "\SrcAll\BasicMacros.asm"
		
TileSmoothXmove equ 1	;move in blocks <8 pixels
;TileSmoothYmove equ 1	;This would just waste cpu power

VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

;LIMITATION.. The Virtual screen cannot be smaller than the sprite or 
;the crop will malfunction! (It can be the same size)

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96

	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0


vblanked 	equ $7F		;Zero page address of Vblank count
VDP_L equ z_Regs+18	;Position of next Tile in buffer
VDP_H equ z_Regs+19	;Position of next Tile in buffer
VDP_Update equ z_Regs+20	;Position of next Tile in buffer
VDPBuffer equ $200		;Tilemap Buffer
VDPNextSprite equ z_Regs+21		;Tilemap Buffer
SpriteBuffer equ VDPBuffer+$400	;SpriteBuffer

FlipLut equ 0

TileCache equ $6300


offset equ TileCache-2
offset2 equ TileCache-1
TileClear equ TileCache-3
spritehclip equ TileCache-4
striproutine equ TileCache-5
TileTint equ TileCache-6

ChibikoDef equ $60C0
ChibicloneDef equ $60D0


TestSprite equ $0000
TestChibiko equ $0011

;Current player pos
;PlayerX 	equ $60		
;PlayerY 	equ PlayerX+1



z_Regs 		equ $40


	org $BFF0

	db "NES",$1a		;ID
	db $01				;Rom pages (16k each)
	db $0				;CHR-ROM pages
	db %01000010		;mmmmFTBM		mmmm = mapper no bottom 4 bits , Four screen vram layout, Trainer at &7000, Battery ram at &6000, Mirror (0=horiz, 1=vert)
	db %00000000		;mmmm--PV 		mapper (top 4 bits...  Pc10 arcade, Vs unisystem )
	db 0				;Ram pages
	db 0,0,0,0,0,0,0
						;We selected Mapper 4 - it has 8k VRAM , 8K Sram and 128k rom
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
;ScreenInit


ProgramStart:
	sei					;Interrupts off
	cld					;Clear Decimal flag
	ldx #$ff			;Set up stack
	txs
	
;Palette
	lda #$3F		;Select Palette ram &3F00
	sta $2006		;PPUADDR H
	lda #0
	sta $2006		;PPUADDR L
	
	ldx #4*8
PaletteAgain
	lda Palette-1,x 
	sta $2007		;PPUDATA
	dex 
	bne PaletteAgain
	
	
;Define patterns
	loadpair z_hl,Bitmap	;Source Bitmap Data
	loadpair z_bc,(BitmapEnd-Bitmap);Bitmap Data Length
	loadpair z_de,0	;Tile 0 (16 bytes per tile)
	jsr DefineTiles	;Define the tile patterns

	

	lda #%10000000	;Turn on extra ram at $6000-%7FFF
	sta $A001
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
				
;Clear Game Data
	loadpair z_hl,$6000	;Start
	loadpair z_bc,$1000		;Bytes
	jsr cldir0				;Zero Range

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
	lda #$40 
	sta VDP_L			;0240
	lda #$02
	sta VDP_H
	 	
	lda #24
	sta z_ixl
	loadpair z_hl,TileMap2
	loadpair z_de,TileCache
FillYAgain:
	loadpair z_bc,32
	jsr ldir
	loadpair z_bc,4
	jsr addhl_bc
	
	dec z_ixl
	bne FillYAgain

	
	loadpair z_hl,xChibicloneDef
	loadpair z_de,ChibicloneDef
	loadpair z_bc,16
	jsr ldir
	
	loadpair z_hl,xChibikoDef
	loadpair z_de,ChibikoDef
	loadpair z_bc,16
	jsr ldir
	
	
	
	
	
	loadpair z_hl,TestSprite
	loadpair z_de,TileCache
	jsr cls
	

	loadpair z_ix,ChibikoDef
	jsr DrawSpriteAlways	;Draw Player Sprite

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	jsr ChibiSoundPro_Init		;Init the sound hardware
	
	lda #<Song1
	sta SongBase				;address of song.
	lda #>Song1
	sta SongBase+1				;address of song.
	
	jsr ChibiTracks_StartSong	;Init the music player
		
	lda #6
	sta SongSpeed				;Change song speed
	
		
;Turn ON the screen

;CCC=Color emphasis B=Background on S=Sprite on s=sprite clip
;b=back clip M=monochrome

		 ;CCCSBsbM
	lda #%00011110 	
	sta $2001				;PPUMASK
;(Sprite enable/back enable/Sprite leftstrip / backleftstrip)
	

;N=NMI on vblank S=Sprite size B=Back Pattern Table (0/1) 
;P=sprite Pattern table I=Increment vram address AA=Name Table address 
	
		; N-SBPIAA	
	lda #%10000000			;NMI enable (Vblank)
	sta $2000				;PPUCTRL - VPHB SINN
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	loadpair z_bc,$6060
infloop:
	pushpairsafe z_bc
	
		jsr readjoystick
	pullpairsafe z_bc
startdraw:
	pha
		bit lookupbits+4
		bne joynotfire
		inc offset

joynotfire:
		pushpair z_bc

			lda offset
			sta z_c
			lda offset+1
			sta z_b
			cmp z_c
			bne scrollchange
				jmp noscrollchange
scrollchange
			pushpair z_bc
				lda #$24
				sta z_iyh

				lda #$20
				sta z_iyl

				lda #32
				sta z_ixh
				
				lda #24
				sta z_ixl

				loadpair z_de,tilecache

				lda z_b
				pha
					loadpair z_hl,tilemap2
					lda z_c
					and #%00000011
					sta z_c

					lda #0
					sta z_b
					jsr addhl_bc
				pla
				and #%00000011
				sta z_c
				pushpair z_hl
					loadpair z_hl,tilemap2
					;lda #0
					;sta z_b
					jsr addhl_bc
				pullpair z_bc
				jsr changescroll
			pullpair z_bc
		
			lda z_c
			sta offset
			sta offset+1
		
			loadpair z_ix,chibikodef
			ldy #spr_flags
			
			lda (z_ix),y
			clc
			adc #1
			sta (z_ix),y
			
			;loadpair z_hl,$4180		;Screen Offset $4180
			;loadpair z_bc,(80*200)	;Screen Offset $4180
			;jsr cldir0				;Clear screen bytes
	
			jsr flagspriteforrefresh
noscrollchange:
	
		loadpair z_ix,chibikodef
		pullpair z_bc
	pla
	sta z_d

	and #%00000001
	bne joynotup
	dec z_c
	jsr flagspriteforrefresh
joynotup:
	lda z_d
	and #%00000010
	bne joynotdown
	inc z_c
	jsr flagspriteforrefresh
joynotdown:
	lda z_d
	and #%00000100
	bne joynotleft
	dec z_b
	jsr flagspriteforrefresh
joynotleft:
	lda z_d
	and #%00001000
	bne joynotright
	inc z_b
	jsr flagspriteforrefresh
joynotright:

joydone:

	pushpair z_bc
		loadpair z_ix,chibikodef
		ldy #spr_xpos
		lda z_b
		sta (z_ix),y
		
		ldy #spr_ypos
		lda z_c
		sta (z_ix),y
		pushpair z_ix
			jsr removesprite
		pullpair z_ix
		jsr zerospriteincache
		
		loadpair z_ix,chibiclonedef
		jsr flagspriteforrefresh
		pushpair z_ix
			jsr removesprite
		pullpair z_ix
		ldy #spr_xpos
		
		lda (z_ix),y
		clc
		adc #1
		sta (z_ix),y
		jsr zerospriteincache
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		lda #0
		sta TileTint
		
		lda #$02
		sta tileclear
		loadpair z_hl,testsprite
		loadpair z_de,tilecache
		jsr cls
	
	
	
	
		lda #0
		sta VDP_Update ;Enable Tilecopy

		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
		lda #%01010101
		sta TileTint
		
		lda #0
		sta VDPNextSprite
		sta tileclear
		loadpair z_ix,chibiclonedef
		
		lda #%1010101
		sta TileTint
		
		jsr drawsprite
		loadpair z_ix,chibikodef
		jsr drawspritealways
		
		lda #0
		ldy VDPNextSprite		
ClearMoreSprites:
		sta SpriteBuffer,y
		iny
		bne ClearMoreSprites
		
	pullpair z_bc
	jmp infloop
	
	
		
	
	
		

DoStrip:
	ldx #0
NextTile:
		lda (z_bcs,x)	;BC=Tilemap data
		beq CustomTileDone	;EmptyTile
		sta z_hs
		
		lda TileClear
		beq NoClear
		txa
		sta (z_bcs,x)
NoClear:
		tay	;=0

DrawTileMore:	
		lda z_hs
		clc
		adc z_es
		sta (z_hl),y	  ;VMDATAL - were set to Autoinc address
		
;Do the color attributes
		lda TileTint
		sta z_ls
		
		lda z_l
		and #%00000010
		ror
		tax					;0/1
		
		lda z_l
		and #%01000000
		beq DrawTileTopColorLine
		inx					;3/4
		inx
DrawTileTopColorLine:
		lda ColorMask,x
		sta z_ls
				
		lda z_h
		sec
		sbc #>VDPBuffer
		sta z_d
			
		lda z_l
		rol
		rol z_d			;Top bit into D
		ror
		
		and #%00011100
		ror
		ror 
		sta z_e			;%-----lll
				
		lda z_d
		and #%00000111
		rol
		rol
		rol				;%--hhh---
		ora z_e
		ora #$C0		;%11000000
		sta z_e
		
		lda #(VDPBuffer/256)+$3		;$23C0 - Color attribs
		sta z_d
		
		ldx #0
		lda z_ls
		eor #%11111111
		and (z_de,x)				;Mask out this attrib
		sta (z_de,x)
		
		lda TileTint
		and z_ls
		ora (z_de,x)				;OR in new color attrib
		sta (z_de,x)
		
		
CustomTileDone:
		inc z_l
		bne CustomTileDoneB
		inc z_h
CustomTileDoneB:
		INC z_Cs
		BNE	CustomTileDoneC
		INC	z_Bs
CustomTileDoneC:

		dec z_iyl
		bne NextTile
	rts
	
ColorMask: db %00000011,%00001100,%00110000,%11000000
	
DoStripRev:

		lda z_b
		sta z_d
		
		ldx #0
		ldy VDPNextSprite
NextTileRev:
		
		lda (z_bcs,x)	;BC=Tilemap data
		beq CustomTileDoneRev	;EmptyTile
		sta z_hs
		
		lda TileClear
		beq NoClearRev
		txa
		sta (z_bcs,x)
NoClearRev:
		
		
DrawTileMoreRev:	
		lda z_c			;Ypos	YYYYYYYY 
		asl
		asl
		asl
		clc
		adc #8
		sta SpriteBuffer,y
		iny
	
		
		lda z_hs
		clc
		adc z_es
		sta SpriteBuffer,y	;Tilenum	TTTTTTTT 
		iny
		
		lda TileTint
		and #%00000011
		ora #%01000000
		sta SpriteBuffer,y	;Attribs 	VHB---PP	Vflip  Hflip  Background priority  Palette
		iny
		
		lda z_d
		asl
		asl
		asl
		sta SpriteBuffer,y	;Xpos	XXXXXXXX 
		iny
		
		lda #0
		sta (z_hl,x)	  ;VMDATAL - were set to Autoinc address
CustomTileDoneRev:
		inc z_d

		inc z_l
		bne CustomTileDoneBRev
		inc z_h
CustomTileDoneBRev:
		lda z_Bs
		bne CustomTileDoneCRev
		DEC	z_Bs
CustomTileDoneCRev:
		DEC z_Cs

		dec z_iyl
		bne NextTileRev

		inc z_C
		sty VDPNextSprite
		clc
	rts
	
	
PrintChar:
	rts	


TestSpriteList:
Sprite_1:
  db 0,1,2,3,4
  db 5,6,7,8,9
  db 10,11,12,13,14
  db 15,16,17,18,19
  db 20,21,22,23,24
  db 25,26,27,28,29
  db 0,30,31,32,0
  db 0,33,34,35,0
  
Tilemap2
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
;BBC type is odd - the first 8 screen bytes go DOWN... 
;the 9ths goes back to the top 
;Effectively we're filling in 8x8 character blocks in a zigzag pattern

GetScreenPos:
		lda z_b
		lsr 
		lsr 
		sta z_b
		
		
		lda z_c
		lsr
		lsr
		sta z_c
		;clc
		;adc #2
		sta z_h		;32 tiles per Y line
		
		lda #0		
		lsr z_h
		ror 
		lsr z_h
		ror 
		lsr z_h
		ror 
		
		adc z_b 	;Add X line
		sta z_l
		
		lda #>VDPBuffer
		adc z_h
		sta z_h
		
	rts

	

readjoystick:
Player_ReadControlsDual:
	;Strobe joysticks to reset them
	ldx #$01				;Send a 1 to joysticks (strobe reset)
	stx $4016				;JOYPAD1 port
	
	dex 					;Send a 0 to joysticks (read data)
	stx $4016				;JOYPAD1 port

	ldx #8					;Read in 8 bits from each joystick
Player_ReadControlsDualloop:
	lda $4016				;JOYPAD1
	lsr 	   				; bit0 -> Carry
	ror z_h  				;Add carry to Joy1 data
  
	lda $4017				;JOYPAD2
	lsr 	   				; bit0 -> Carry
	ror z_l  				;Add carry to Joy2 data
  
	dex 
	bne Player_ReadControlsDualloop
  
	lda z_h
	jsr Player_ReadControlsCorrectOrder
	sta z_h 
	
	rts
    
	;Convert: Right Left Down Up Start Select B A
	;To:	  Start Select B A Right Left Down Up 
Player_ReadControlsCorrectOrder:
	eor #255				;Flip bits so unpressed=1
	jsr SwapNibbles
	rts
	
    
; $4016/$4017 - 1=Pressed / 0=NotPressed

; Read  1 - B
; Read  2 - Y
; Read  3 - Select
; Read  4 - Start
; Read  5 - Up
; Read  6 - Down
; Read  7 - Left
; Read  8 - Right
; Read  9 - A
; Read 10 - X
; Read 11 - L
; Read 12 - R
; Read 13 - Zero
; Read 14 - Zero
; Read 15 - Zero
; Read 16 - Zero

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Nmihandler:
	pha			;PHA/PLA happens automatically
	tya
	pha
		ldy #0		;Buffer offset
		
CustomNmihandlerAgain:	
		lda VDP_Update
		beq CustomNmihandlerAgainB
			jmp  CustomNmihandlerDone	;Nothing to do?
CustomNmihandlerAgainB:			
		
		lda VDP_H
		clc
		adc #($20-$02)
		sta $2006	;PPUADDR 	Destination address - H
		
		lda VDP_L
		sta $2006	;PPUADDR 	Destination address - L
SendAgain:		
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny		
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny
		lda (VDP_L),y
		sta $2007 	;PPUDATA
		iny		
		cpy #$C0
		bcc SendAgain 
				
		lda #0				;Scroll X
		sta $2005
		lda #0-8			;Scroll y
		sta $2005
		inc vblanked		;Alter Vblank Zero page entry
		
		clc
		tya
		adc VDP_L
		sta VDP_L
		
		lda VDP_H
		adc #0
		cmp #$06
		bcc VDP_NoOverFlow
		lda #$40
		sta VDP_L
		
		lda #$02
		sta VDP_Update
VDP_NoOverFlow:				
		sta VDP_H

		lda #SpriteBuffer/256	;Data to copy to sprites
		sta $4014 				;Start Spirte DMA transfer to OAM


CustomNmihandlerDone:		;No graphics to do?

		txa
		pha
			pushpair z_hl
			pushpair z_de
			pushpair z_bc
			pushpair z_ix
				jsr ChibiTracks_Play	;Update sound
			pullpair z_ix
			pullpair z_bc
			pullpair z_de
			pullpair z_hl
		pla
		tax
	pla
	tay
	pla
irqhandler:					;Do nothing on IRQ

	rti						;Return from interrupt handler



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	


prepareVram:				;Select a destination address
	lda z_d					;MSB - DEST ADDR
	sta $2006				;PPUADDR
	lda z_e					;LSB - Dest ADDR
	sta $2006				;PPUADDR
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

waitframe:
	pha
		lda #$00
		sta vblanked		;Zero Vblanked
waitloop:
		lda vblanked		;Wait for the interrupt to change it
		beq waitloop
	pla
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
	
	;BC=Bytes
	;DE=Destination Ram
	;HL=Source Bytes		
DefineTiles:				;Send Data to tile definitions
	ldx z_C					;B=High byte of count - X=Low byte
	ldy #0
	jsr NesDisableScreen
	jsr prepareVram			;Calculate destination address
		
DefineTilesAgain	
	lda (z_HL),Y		
	sta $2007 				;PPUDATA - Write data to data-port
	iny
	bne DefineTilesAgainYok
	
	inc z_h					;INC High byte Y=low byte
DefineTilesAgainYok:		
	txa						;Is Low Byte Zero
	bne DefineTilesDecBC_C
	lda z_B					;Is High Byte Zero (Are We done?)
	beq DefineTilesAgainDone
	DEC z_B					;DEC Count High byte (X is low byte)
DefineTilesDecBC_C:	
	DEx						;Decrease Count Low Byte
	jmp DefineTilesAgain
DefineTilesAgainDone:
	rts

	

NesDisableScreen:			;Turn OFF the screen
;(Sprite enable/back enable/Sprite leftstrip / backleftstrip)
	lda #%00000000	
	sta $2001				;PPUMASK
	;lda #$00				;NMI disable (Vblank)
	sta $2000				;PPUCTRL - VPHB SINN
	rts	
		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

	
	include "/srcALL/V1_MinimalTile.asm"
	include "\SrcAll\BasicFunctions.asm"
	
	
xChibicloneDef:
	dw TestSpriteList	;Tilemap
	dw TestChibiko		;Pattern Data
	db 20,32		;Width,Height
	db 64,128		;X,Y
	db 1,1			;RefreshTile,Sprite
	db 64,128		;X,Y
	db 0,0			;Flags
xChibikoDef:
	dw TestSpriteList	;Tilemap
	dw TestChibiko		;Pattern Data
	db 20,32		;Width,Height
	db 96,96		;X,Y
	db 1,1			;RefreshTile,Sprite
	db 64,128		;X,Y
	db 0,0			;Flags

	
Bitmap:
	ds 16
	incbin "\ResAll\Yquest\NES_YQuest.RAW"

	incbin "\ResALL\MinTile\Chibiko2TilesNES.RAW"
BitmapEnd
	
	
	
Palette:
; 	Color   3   2   1  0
		db $3A,$2A,$1A,$0D	;Sprites 3
		db $3C,$2C,$1C,$0D	;Sprites 2
		db $35,$25,$15,$0D	;Sprites 1
		db $30,$2B,$13,$0D	;Sprites 0
		
		db $3A,$2A,$1A,$0D	;Tiles 3
		db $3C,$2C,$1C,$0D	;Tiles 2
		db $35,$25,$15,$0D	;Tiles 1
		db $30,$2B,$13,$0D	;Tiles 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	include "\SrcALL\Multiplatform_ChibiSoundPro.asm"
	include "\SrcALL\Multiplatform_ChibiTracks_Tweener.asm"
	include "\SrcALL\Multiplatform_Fraction16.asm"
	include "\SrcAll\Multiplatform_ChibiTracks.asm"
	


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;
Song1:
	;include "\ResALL\ChibiSoundPro\CBT1.asm"
	;include "\ResALL\ChibiSoundPro\CBT2.asm"
	;incbin  "\ResALL\ChibiSoundPro\song.cbt"
	;incbin  "\ResALL\ChibiSoundPro\song2.cbt"
	incbin  "\ResALL\ChibiSoundPro\ChibiAkumasTheme.cbt"
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
;	Footer
	org $FFFA
	dw nmihandler		;$FFFA - Interrupt handler (Vblank)
	dw ProgramStart		;$FFFC - Entry point
	dw irqhandler		;$FFFE - IRQ Handler
	
	