
ChibiTracks_AllowRelocation equ 1
ChibiTracks_AllowSpeedChange equ 1

chibisoundpro_FastSilent equ 1	;We don'need any delay when silent
;chibisoundpro_singlechannel	equ 1	;Don't try to play multiple channels

SmsTranspose equ 1			;Pitchshift +1 octave

z_Regs 		equ $30

;TileSmoothXmove equ 1	;move in blocks <8 pixels
;TileSmoothYmove equ 1	;This would just waste cpu power

VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

;LIMITATION.. The Virtual screen cannot be smaller than the sprite or 
;the crop will malfunction! (It can be the same size)

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96

	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0



;Current player pos
spritehclip equ $60


	include "\SrcAll\BasicMacros.asm"
	

FlipLut equ $400

ScreenBase equ $4000+4


chibisoundram equ $3000			;Chibisound needs 128 bytes of ram

SongOffset equ ChibiSoundRam+ChannelDataLengthTotal 
; Dw 0	;Remap internal addresses in song (eg compiled for &8000, 
;	loaded to &2000 = offsets of -&6000
SongBase  equ SongOffset+2 		; dw Song1
Instrumentlist equ SongBase+2 	; dw 0
Patternlist equ Instrumentlist+2 ; dw 0
SongChannels equ Patternlist+2	; db 0
SongSpeed equ  SongChannels+1 	; db 0
RepPoint equ  SongSpeed+1 		; db 0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

	ORG $0C00	;Program Start
ProgramStart:
	sei 		;Disable interrupts
	
	lda $C050 	;TXTCLR:   Display Graphics
	lda $C052 	;MIXCLR:   Display Full Screen
	lda $c057 	;HIRES:    Display HiRes Graphics
	lda $C055 	;TXTPAGE2: If 80STORE Off: Display Page 2
	
	loadpair z_hl,$4000
	loadpair z_bc,$1F00
	jsr cldir0			;Clear Screen
	
	
	loadpair z_hl,$3000
	loadpair z_bc,$100
	jsr cldir0			;Clear Screen
	
	lda #24
	sta z_ixl
	loadpair z_hl,TileMap2
	loadpair z_de,TileCache
FillYAgain:
	loadpair z_bc,32
	jsr ldir
	loadpair z_bc,4
	jsr addhl_bc
	
	dec z_ixl
	bne FillYAgain

	
		
	ldy #0
		loadpair z_hl,FlipLUT
FillLutAgain:
		tya
		rol
		rol z_c
		
		tya
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		lda z_c
		sta (z_hl),y

		iny
	bne FillLutAgain
	
	
	
	loadpair z_hl,TestSprite
	loadpair z_de,TileCache
	jsr cls
		
	loadpair z_ix,ChibikoDef
	jsr DrawSpriteAlways	;Draw Player Sprite

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
			
	jsr ChibiSoundPro_Init
	
	lda #<Song1
	sta SongBase	;address of song.
	lda #>Song1
	sta SongBase+1	;address of song.
	
	lda #4			;Longer=better sound, but slower
	jsr ChibiSoundPro_SetBeeperLength	
		
	jsr ChibiTracks_StartSong
		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

	loadpair z_bc,$6060
infloop:


	pushpairsafe z_bc
		jsr readjoystick
	pullpairsafe z_bc
startdraw:
	pha
		bit lookupbits+4
		bne joynotfire
		inc offset

joynotfire:
		pushpair z_bc

			lda offset
			sta z_c
			lda offset+1
			sta z_b
			cmp z_c
			bne scrollchange
				jmp noscrollchange
scrollchange
			pushpair z_bc
				lda #$24
				sta z_iyh

				lda #$20
				sta z_iyl

				lda #32
				sta z_ixh
				
				lda #24
				sta z_ixl

				loadpair z_de,tilecache

				lda z_b
				pha
					loadpair z_hl,tilemap2
					lda z_c
					and #%00000011
					sta z_c

					lda #0
					sta z_b
					jsr addhl_bc
				pla
				and #%00000011
				sta z_c
				pushpair z_hl
					loadpair z_hl,tilemap2
					;lda #0
					;sta z_b
					jsr addhl_bc
				pullpair z_bc
				jsr changescroll
			pullpair z_bc
		
			lda z_c
			sta offset
			sta offset+1
		
			loadpair z_ix,chibikodef
			ldy #spr_flags
			
			lda (z_ix),y
			clc
			adc #1
			sta (z_ix),y
			
			;loadpair z_hl,$4180		;Screen Offset $4180
			;loadpair z_bc,(80*200)	;Screen Offset $4180
			;jsr cldir0				;Clear screen bytes
	
			jsr flagspriteforrefresh
noscrollchange:
	
		loadpair z_ix,chibikodef
		pullpair z_bc
	pla
	sta z_d

	and #%00000001
	bne joynotup
	dec z_c
	jsr flagspriteforrefresh
joynotup:
	lda z_d
	and #%00000010
	bne joynotdown
	inc z_c
	jsr flagspriteforrefresh
joynotdown:
	lda z_d
	and #%00000100
	bne joynotleft
	dec z_b
	jsr flagspriteforrefresh
joynotleft:
	lda z_d
	and #%00001000
	bne joynotright
	inc z_b
	jsr flagspriteforrefresh
joynotright:

joydone:

	pushpair z_bc
		loadpair z_ix,chibikodef
		ldy #spr_xpos
		lda z_b
		sta (z_ix),y
		
		ldy #spr_ypos
		lda z_c
		sta (z_ix),y
		pushpair z_ix
			jsr removesprite
		pullpair z_ix
		jsr zerospriteincache
		
		loadpair z_ix,chibiclonedef
		jsr flagspriteforrefresh
		pushpair z_ix
			jsr removesprite
		pullpair z_ix
		ldy #spr_xpos
		
		lda (z_ix),y
		clc
		adc #1
		sta (z_ix),y
		jsr zerospriteincache
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		lda #$02
		sta tileclear
		loadpair z_hl,testsprite
		loadpair z_de,tilecache
		jsr cls
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		lda #0
		sta tileclear
		loadpair z_ix,chibiclonedef
		jsr drawsprite
		loadpair z_ix,chibikodef
		jsr drawspritealways
	pullpair z_bc
	
	;jsr InterruptHandler
	
	jmp infloop
	
	 	
	
	
TileCache:
	ds 24*32

offset: db 0
offset2: db 0
TileClear: db 0
	

	

PrintChar:
	rts	

DoStrip:
	lda $C019 				;Test VBL - bit 7=1 Vblank off on E
	bmi NoVbl				; (IIc is opposite!)
	jsr VblankHandler
NoVbl:

	ldx #0
NextTile:
DrawTile:
		lda (z_bcs,x)	;BC=Tilemap data
		;lda #3
		beq CustomTileDone	;EmptyTile
		sta z_hs
		
		lda TileClear

		beq NoClear
		txa
		sta (z_bcs,x)
		
NoClear:
		txa	;=0
		tay	;=0

		lsr z_hs
		ror
		lsr z_hs
		ror
		lsr z_hs
		ror
		lsr z_hs
		ror
		lsr z_hs
		ror
		
		
		;clc
		adc z_es
		sta z_ls
		
		lda z_hs
		adc z_ds
		sta z_hs	;HL=Bitmap Sourc
		

		lda z_h
		pha
DrawTileMore:		
			lda (z_HLs),y
			sta (z_HL,x)
			inc z_H
			inc z_H
			inc z_H
			inc z_H
			iny
			
			cpy #8
			bne DrawTileMore
	
		pla 
		sta z_h
CustomTileDone:
		INC z_Cs
		BNE	CustomTileDoneC
		INC	z_Bs
CustomTileDoneC:
		inc z_l
		bne CustomTileDoneB
		inc z_h
CustomTileDoneB:
		dec z_iyl
		beq TileDone2
			jmp	NextTile
TileDone2:

	rts




DoStripRev:
	lda #>FlipLUT
	sta z_b

	ldx #0
NextTileRev:
DrawTileRev:
		lda (z_bcs,x)	;BC=Tilemap data
		bne NotCustomTileDoneRev
		jmp CustomTileDoneRev	;EmptyTile
NotCustomTileDoneRev:
		sta z_hs
		
		lda TileClear

		beq NoClearRev
		txa
		sta (z_bcs,x)
		
NoClearRev:
		txa	;=0
		tay

		lsr z_hs
		ror
		lsr z_hs
		ror
		lsr z_hs
		ror
		lsr z_hs
		ror
		lsr z_hs
		ror
		;clc
		adc z_es
		sta z_ls
		
		lda z_hs
		adc z_ds
		sta z_hs	;HL=Bitmap Sourc
	
		lda z_h
		pha
DrawTileMoreRev:		
			lda (z_HLs),y
			sta z_c
			lda (z_BC,x)
			sta (z_HL,x)
			inc z_H
			inc z_H
			inc z_H
			inc z_H
			iny
			
			cpy #8
			bne DrawTileMoreRev
	
		pla 
		sta z_h
CustomTileDoneRev:
		lda z_Cs
		bne CustomTileDoneCRev
		DEC z_Bs
CustomTileDoneCRev:
		DEC z_Cs

		inc z_l
		bne CustomTileDoneBRev
		inc z_h
CustomTileDoneBRev:
		dec z_iyl
		beq TileDone2Rev
			jmp	NextTileRev
TileDone2Rev:
	rts

	

	
	align 4
TestSprite:
	ds 8
		incbin "\ResAll\Yquest\AP2_YQuest.raw"
TestChibiko:
	incbin "\ResALL\MinTile\Chibiko2TilesAP2.RAW"


ChibicloneDef:
	dw TestSpriteList	;Tilemap
	dw TestChibiko		;Pattern Data
	db 20,32		;Width,Height
	db 64,128		;X,Y
	db 1,1			;RefreshTile,Sprite
	db 64,128		;X,Y
	db 0,0			;Flags
ChibikoDef:
	dw TestSpriteList	;Tilemap
	dw TestChibiko		;Pattern Data
	db 20,32		;Width,Height
	db 96,96		;X,Y
	db 1,1			;RefreshTile,Sprite
	db 64,128		;X,Y
	db 1,1			;Flags

	
	
	


TestSpriteList:
Sprite_1:
  db 0,1,2,3,4
  db 5,6,7,8,9
  db 10,11,12,13,14
  db 15,16,17,18,19
  db 20,21,22,23,24
  db 25,26,27,28,29
  db 0,30,31,32,0
  db 0,33,34,35,0
  
Tilemap2
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,1,2,1,1
	db 2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,3 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,1,2,1,1
	db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
	db 1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4 ,1,2,1,1
	db 4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1 ,2,1,1,1
		
		

	include "/srcALL/V1_MinimalTile.asm"
		
	include "\SrcAll\BasicFunctions.asm"
		
	
	;Screen layout is split in 3 parts according to Y line
	;AABBBCCC - AA*$0028  BBB*$0080  CCC*$0400
GetScreenPos:
	lda #0
	sta z_l
	
	lda z_c
	and #%11111100
	asl 
	tay 				;--BBB---	;Multiply by $0080
	and #%00111000
	lsr
	lsr
	lsr					
	lsr					;Shift 1 bit right 
	ror z_l
	adc #$40			;Screen base
	sta z_h
	tya					;AA------		;multiply by $0028
	rol 				;Get 1st A from AA------ 
	bcc GetScreenPos_SecondThird
GetScreenPos_ThirdThird:
	lda z_l
	clc
	adc #$50			;3/3 = Add $0050 to address
	jmp GetScreenPos_ThirdDone
GetScreenPos_SecondThird:
	rol 				;Get 2nd A from AA------ 
	bcc GetScreenPos_FirstThird
	lda z_l
	clc
	adc #$28			;3/2 = Add $0028 to address
GetScreenPos_ThirdDone:	
	sta z_l
GetScreenPos_FirstThird:;1/3 = Add nothing to addreess
	;tya 			;-----CCC	;Multiply by 4
	;and #%00000111
	;asl
	;asl
	;adc z_h
	;sta z_h
	
	lda z_b				;Process X
	lsr 
	lsr 
	
	clc
	adc #4
	adc z_l			;Add X to calculated address
	sta z_l
	rts
	

	
;Apple Joysticks are annoying!
;they are analog... we have to strobe the port 
;then read from the X and Y ports, and count up until the top bit changes
;this is a 'timer'...using just 1 bit (the top one) 
;it effectively returns an 'analog' value from about 0-100
	
ReadJoystick:	;---FRLDU
	lda $C061			;Fire 1
	and #%10000000
	rol	;Move in the fire button
	rol z_h
	
	lda $C070			;Strobe Joypads
	ldy #0
	ldx #0 
Joy_ReadAgain:
	pha
	pla					;delay
Joy_gotPDL1:			;Jump backhere when we get X
Joy_ChkPDl0:
	lda	$C064 			;<--SM ***   Y
JoySelfModAA_Plus2:
	bpl Joy_gotPDL0		;Have we got Y?
	nop
	iny	
	lda $C065			;<--SM ***   X
JoySelfModB_Plus2:
	bmi Joy_nogots		;Have we got X?
	bpl Joy_gotPDL1
Joy_nogots:
	inx
	jmp Joy_ChkPdl0
Joy_gotPDL0:			;We've Got Tpos - just waiting for X
	lda  $C065			;<--SM ***   X
JoySelfModBB_Plus2:
	bmi Joy_Nogots
	
	tya
	jsr JoyConvertAnalog;Convert Y
	txa
						;Convert X
	jsr JoyConvertAnalog;Convert Y
	lda z_h
	eor #%11111111
	sta z_h
	rts
	
JoyConvertAnalog:	;covert analog from 0-100 into L/R or U/D
	cmp #$66
	bcs Joy_Rbit
	cmp #$33
	bcc Joy_Lbit
	clc 
	bcc Joy_Cbit
Joy_Rbit:
	sec 
Joy_Cbit:
	rol z_h
	clc
	rol z_h
	rts
	
Joy_Lbit:
	clc
	rol z_h
	sec 
	rol z_h
	rts
	
	

	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	include "\SrcALL\Multiplatform_ChibiSoundPro.asm"
	
	include "\SrcALL\Multiplatform_ChibiTracks_Tweener.asm"
	include "\SrcALL\Multiplatform_Fraction16.asm"
	include "\SrcAll\Multiplatform_ChibiTracks.asm"
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
Song1:
	;include "\ResALL\ChibiSoundPro\CBT1.asm"
	;include "\ResALL\ChibiSoundPro\CBT2.asm"
	;incbin  "\ResALL\ChibiSoundPro\song.cbt"
	;incbin  "\ResALL\ChibiSoundPro\song2.cbt"
	incbin  "\ResALL\ChibiSoundPro\ChibiAkumasTheme.cbt"
	
	
VblankHandler:
		pushpair z_hl
		pushpair z_de
		pushpair z_bc
		pushpair z_ix
			jsr ChibiTracks_Play
		pullpair z_ix
		pullpair z_bc
		pullpair z_de
		pullpair z_hl
Invbl:						;Wait for vblank to end
	lda $C019 				;Test VBL - bit 7=1 Vblank off on E
	bpl Invbl				; (IIc is opposite!)
	rts
	
	
	
	
	