
;FourColorPatterns equ 1

ScreenBase equ $0080+SnesScreenBuffer

SnesScreenBuffer equ $200 	;Tilemap buffer at $0200+ 
							;(32x32x2 = $800 bytes total)
							
PatternData equ $0001	;Start at tile 1 (0 won't work)
OffsetToDoubled equ 512	;Tile offset for DoubleData

FillData equ 768	;Tile offset for DoubleData

CacheAddr1 equ $1000
CacheAddr2 equ $1100
CacheAddr3 equ $1200

RunFromRom equ 1

Vline equ CacheAddr3+256;  db 0		;For Screen Draw Sync to crt line
CropYH	equ Vline+1;: dw 0
CropXW equ CropYH+2 ;: dw 0

BackgroundTilemapBase equ CropXW+2;: dw BackgroundTilemap2+2
BackgroundTilemapWidth equ BackgroundTilemapBase+2;:	db 36*2
BackgroundTilemapScrollX equ BackgroundTilemapWidth+1;: db 0
BackgroundTilemapScrollY equ BackgroundTilemapScrollX+1;: db 0
TileTmpW equ BackgroundTilemapScrollY+1 ;: dw 0
SPrestore equ TileTmpW+2
CacheTableAddr equ  SPrestore+2 ;: dw CacheTable
FlipMode equ CacheTableAddr+2	;db 0 
TileTint equ FlipMode+1	;db 0 	
		
	ifndef DoubleBuffered
CacheTable equ CacheAddr3+384 ;CacheTableAddr+2
CacheTable_Last equ T_CacheTable_Last-T_CacheTable +CacheTable
CacheTable_End equ T_CacheTable_End-T_CacheTable +CacheTable	
tileChibiko3 equ $C00;FlipLut+384
	else
tileChibiko3 equ $C00;FlipLut+384	
	endif 

tileChibiko2 equ tileChibiko3+80
tilePlayer equ tileChibiko2+80
tileChibiko equ tilePlayer+80

Sprite1 equ tileChibiko+80
Sprite2 equ Sprite1+26
Sprite3 equ Sprite2+26
Sprite4 equ Sprite3+26
		
BackgroundTilemap2 equ CacheAddr3+512	;36*28*2+4	

BackgroundTilemapWidthV equ 36

;Logical units are pairs of pixels

VscreenMinX equ 64		;Top left of visible screen in logical co-ords
VscreenMinY equ 80

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96
	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0



;HiresX equ 1
;HiresY equ 1

;TileTest_BasicOnly equ 1
;TileTest_NoFlip equ 1


;AllowHalfTileScroll equ 1
;AllowQuarterTileScroll equ 1

;nodrawcache equ 1	



	;nolist
;SlowDownTest equ 1

	macro doei
	endm

z_Regs 		equ $20
							
							
							
	include "\SrcAll\BasicMacros.asm"
		


	org $8000		;Start of ROM
	SEI				;Stop interrupts
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
;ScreenInit

		 ;aaaabbbb -aaa=base addr for BG2 bbb=base addr for BG1
	lda #%00010001
	sta $210B 		;BG1 & BG2 VRAM location register [BG12NBA] 
	
	;     xxxxxxss 	- xxx=address… ss=SC size  00=32x32 01=64x32 10=32x64 11=64x64
	stz $2107		;BG1SC - BG1 Tilemap VRAM location
	
	; abcdefff - abcd=tile sizes e=pri fff=mode def
	lda #%00001001
	sta $2105		;BGMODE - Screen mode register
	
	;	  x000bbbb - x=screen disable (1=disable) bbbb=brightness (15=max)
	lda #%10000000	;Screen off
	sta $2100		;INIDISP - Screen display register

	

;PaletteDefs	
	ldx #16
	ldy #0
	loadpair z_hl,Palette
	stz $2121		;CGADD - Colour selection  
PaletteAgain:
		 ;gggrrrrr 
	lda (z_hl),y
	sta $2122		;CGDATA - Colour data register
		 ;?bbbbbgg 
	iny
	lda (z_hl),y
	sta $2122		;CGDATA
	iny
	dex
	bne PaletteAgain
			
	

;Clear Buffer
	loadpair z_hl,SnesScreenBuffer
	loadpair z_bc,$800		;;32x32x2= $800
	jsr cldir0				;Zero Range	
	
;Set Scroll position
	stz $210D  		;BG1HOFS BG1 horizontal scroll   
	stz $210D  		;BG1HOFS
	
	lda #-1
	sta $210E  		;BG1VOFS BG1 vertical scroll 
	stz $210E  		;BG1VOFS

;Clear Screen 
	stz $2116		;MemL -Video port address [VMADDL/VMADDH]  
	stz $2117		;MemH

	
	ifdef FourColorPatterns
		lda #0
		sta z_ixh		;Bitplane 2
		lda #0
		sta z_ixl		;Bitplane 3
	endif
	loadpair z_hl,Bitmap		;Source Bitmap Data
	loadpair z_bc,(BitmapEnd-Bitmap) ;Source Bitmap Data Length
	loadpair z_de,($1000+PatternData*16)	;Snes patterns start at $1000
	
	jsr DefineTiles		;Define the tile patterns
	
	loadpair z_hl,Bitmap		;Source Bitmap Data
	loadpair z_bc,(BitmapEnd-Bitmap) ;Source Bitmap Data Length
	loadpair z_de,($1000+(PatternData+OffsetToDoubled)*16)	
	;Snes patterns start at $1000
	
	jsr DefineDoubleTiles		;Define the tile patterns
	
	loadpair z_hl,Fills		;Source Bitmap Data
	loadpair z_bc,(FillsEnd-Fills) ;Source Bitmap Data Length
	loadpair z_de,($1000+(FillData*16))	;Snes patterns start at $1000
	
	jsr DefineFills		;Define the tile patterns
	
	
	
	
;Turn on the screen	
		; ---S4321 - S=sprites 4-1=enable Bgx
	lda #%00000001	;Turn on BG1
	sta $212C 		;Main screen designation [TM]    
	
	;	  x000bbbb - x=screen disable (1=disable) bbbb=brightness (15=max)
	lda #%00001111	;Screen on
	sta $2100		;INIDISP - Screen display register
	
	
	lda #%10000000		;Turn on interrupts
	sta $4200

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	ifndef DoubleBuffered

		loadpair z_hl,T_CacheTable
		loadpair z_de,CacheTable
		loadpair z_bc,(T_CacheTable_End-T_CacheTable)
		jsr ldir
	endif
	
	loadpair z_hl,T_BackgroundTilemap2
	loadpair z_de,BackgroundTilemap2
	loadpair z_bc,(36*28*2+4)
	jsr ldir
		
	
;Copy Sprite tilemaps to ram
	loadpair z_hl,T_SpriteTilemaps
	loadpair z_de,tileChibiko3
	loadpair z_bc,(80*4)
	jsr ldir
	
;Copy Sprite Object data to ram
	loadpair z_hl,T_Sprites
	loadpair z_de,Sprite1
	loadpair z_bc,(26*4)
	jsr ldir
	
	jmp RunTest2
	
PrintChar:
	rts	

	include "MaxTile_Test2.asm"

Fills:	
	db 0,0,0,0
	db 255,0,0,0
	db 0,255,0,0
	db 255,255,0,0
	db 255,255,255,0
	db 255,255,255,255
FillsEnd:
	
	org $A000
Bitmap:
	ifdef FourColorPatterns	
		ds 16
		incbin "\ResAll\Yquest\GMB_Yquest.RAW"
		org $A800-16
		incbin "\ResALL\ChibiFighter\GBC_Chibiko.RAW"
		org $B000
		incbin "\ResALL\ChibiFighter\GBC_Yarita.RAW"
	else 
		ds 32
		incbin "\ResAll\Yquest\SNS_YQuest.RAW"
		org $B000-32
		incbin "\ResALL\ChibiFighter\SNS_Chibiko.RAW"
		org $C000
		incbin "\ResALL\ChibiFighter\SNS_Yarita.RAW"
	endif
BitmapEnd:
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
T_Sprites:
T_Sprite1: 
	dw $4070	;0 XY
	dw $1420	;2 WH
	dw tilePlayer 	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 10 bytes
	 ds 8		;20 CropCache_back = 8  bytes
;26 bytes total

T_Sprite2: 
	dw $B060	;0 XY
	dw $1420	;2 WH
	dw tileChibiko	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes

T_Sprite3: 
	dw $5050	;0 XY
	dw $1420	;2 WH
	dw tileChibiko2	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes

T_Sprite4: 
	dw $4080	;0 XY
	dw $1420	;2 WH
	dw tileChibiko3	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes

T_Sprites_End:


			
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	include "\SrcALL\V1_MaxTile_Expanders.asm"

 	include "\SrcALL\V1_MaxTile.asm"


	ifdef DoubleBuffered
		include "\SrcALL\V1_MaxTile_DirectDriver.asm"
	else
		include "\SrcALL\V1_MaxTile_CacheDriver.asm"
	endif 

	include "\SrcSNS\SNS_V1_MaxTile_Normal.asm"


	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
CustomNmihandler:		;Vblank interrupt handler
	pha
		lda #0
		sta $2116		;MemL -Video port address [VMADDL/VMADDH] 
		sta $2117		;MemH
		
		lda #128
		sta $2115			;Inc address on write to $2119
			 
		lda #%00000001		;Write mode 001=two bytes alternate
		sta $4300
		
		lda #$18
		sta $4301			;Destination $21xx= 2118
		
		lda #<SnesScreenBuffer
		sta $4302			;Source (24 bit - Little endian)
		lda #>SnesScreenBuffer
		sta $4303
		lda #0				;bits 16-23
		sta $4304
		
		lda #<(32*32*2)
		sta $4305			;No of bytes (24 bit - Little endian
		lda #>(32*32*2)			;(only 1st 16 bits used?)
		sta $4306
		lda #0
		sta $4307
		
		lda #0
		sta $420C			;Disable H-DMA transfer 
		lda #%00000001		
		sta $420B			;enable DMA 0 (bit0=1)
		
		lda #0
		sta $2115			;Inc address on write to $2118
	pla
	rti

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
prepareVram:			
	jsr WaitVblank
	lda z_e
	sta $2116		;VMADDL - Destination address in VRAM L
	lda z_d
	sta $2117		;VMADDH - Destination address in VRAM H
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
WaitVblank:
	lda $4212 		;HVBJOY - Status 	
		; xy00000a	- x=vblank state y=hblank state a=joypad ready
	and #%10000000
	beq WaitVblank	;Wait until we get nonzero - this means we're in VBLANK
	rts	
	


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


readjoystick:
	;Strobe joysticks to reset them
	ldx #$01				;Send a 1 to joysticks (strobe reset)
	stx $4016				;JOYPAD1 port
	
	dex 					;Send a 0 to joysticks (read data)
	stx $4016				;JOYPAD1 port

	ldx #8					;Read in 8 bits from each joystick
Player_ReadControlsDualloop:
	lda $4016				;JOYPAD1
	lsr 	   				; bit0 -> Carry
	ror z_h  				;Add carry to Joy1 data
  
	lda $4017				;JOYPAD2
	lsr 	   				; bit0 -> Carry
	ror z_l  				;Add carry to Joy2 data
  
	dex 
	bne Player_ReadControlsDualloop
  
	lda z_h
	jsr Player_ReadControlsCorrectOrder
	sta z_h 
	
	rts
    
	;Convert: Right Left Down Up Start Select B A
	;To:	  Start Select B A Right Left Down Up 
Player_ReadControlsCorrectOrder:
	eor #255				;Flip bits so unpressed=1
	jsr SwapNibbles
	rts

; $4016/$4017 - 1=Pressed / 0=NotPressed

; Read  1 - B
; Read  2 - Y
; Read  3 - Select
; Read  4 - Start
; Read  5 - Up
; Read  6 - Down
; Read  7 - Left
; Read  8 - Right
; Read  9 - A
; Read 10 - X
; Read 11 - L
; Read 12 - R
; Read 13 - Zero
; Read 14 - Zero
; Read 15 - Zero
; Read 16 - Zero
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
	
Palette:
    dw %0000000010101010; ;0  %-BBBBBGGGGGRRRRR
    dw %0000000000000000; ;1  %-BBBBBGGGGGRRRRR
    dw %0010110101101011; ;2  %-BBBBBGGGGGRRRRR
    dw %0101001010010100; ;3  %-BBBBBGGGGGRRRRR
    dw %0111111111111111; ;4  %-BBBBBGGGGGRRRRR
    dw %0011001000000101; ;5  %-BBBBBGGGGGRRRRR
    dw %0001101111100010; ;6  %-BBBBBGGGGGRRRRR
    dw %0001000001111111; ;7  %-BBBBBGGGGGRRRRR
    dw %0110111010111110; ;8  %-BBBBBGGGGGRRRRR
    dw %0010011010011100; ;9  %-BBBBBGGGGGRRRRR
    dw %0010011111111111; ;10  %-BBBBBGGGGGRRRRR
    dw %0011100010110101; ;11  %-BBBBBGGGGGRRRRR
    dw %0111110000011111; ;12  %-BBBBBGGGGGRRRRR
    dw %0111100011000000; ;13  %-BBBBBGGGGGRRRRR
    dw %0110011001000100; ;14  %-BBBBBGGGGGRRRRR
    dw %0111111110000100; ;15  %-BBBBBGGGGGRRRRR


	include "\SrcAll\BasicFunctions.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
;	Footer
	
	org $FFC0
     ; "123456789012345678901"
	db "www.ChibiAkumas.com  "	; Program title (21 byte Ascii string)

	db $20		;Rom mode/speed (bits 7-4 = speed, bits 3-0 = map mode)
	db $00		;Rom type (bits 7-4 = co-processor, bits 3-0 = type)
	db $01 		;Rom size in banks (1bank=32k)
	db $00 		;Ram size (0=none)
	db $00		;Country/video refresh (ntsc 60hz, pal 50hz) (0=j 1=us/eu)
	db $00		;Developer id code
	db $00		;Rom version number
	db "cc"		;Complement check
	db "cs" 	;Checksum


;65816 mode vectors
	dw $0000 	;Reserved
	dw $0000 	;Reserved
	dw $0000 	;Cop vector   (cop opcode)
	dw $0000 	;Brk vector   (brk opcode)
	dw $0000 	;Abort vector (unused)
	dw CustomNmihandler	;Vblank interrupt handler
	dw $0000 	;Reset vector (unused)
	dw $0000 	;Irq vector   (h/v-timer/external interrupt)

;6502 mode vectors
	dw $0000 	;Reserved
	dw $0000	;Reserved
	dw $0000 	;Cop vector   (cop opcode)
	dw $0000 	;Brk vector   (unused)
	dw $0000 	;Abort vector (unused)
	dw CustomNmihandler	;Vblank interrupt handler
	dw $8000 	;Reset vector (cpu is always in 6502 mode on reset)
	dw $0000 	;Irq/brk vector
	
	
	
	