FourColorPatterns	 equ 1


HspriteNum equ z_Regs-1		;Next free Hardware sprite number 0-63

XShift equ z_Regs-2			;Used for XY sprite flip pos
YShift equ z_Regs-3


FillData equ $0040 ;Tile ram <&0400 (64) is tilemap

;Tiles 1024+ are used for Hsprites

;We don't have enough ram for all tiles and sprites, so doubleheight will
;be corrupted

PatternData equ $0080	;Start at tile 128

OffsetToXflipped equ 128	;Start at 128
OffsetToYflipped equ 128*2	;Start at 256
OffsetToXYflipped equ 128*3	;Start at 384

OffsetToDoubled equ 128*4	;Start at 512 (2047 max - only enough ram for 128 doubled tiles)


DoubleBuffered equ 1		;Disable caching - Full redraw each frame




CacheAddr1 equ $2200
CacheAddr2 equ $2300
CacheAddr3 equ $2400
;FlipLut equ $2500

RunFromRom equ 1

Vline equ CacheAddr3+256;  db 0		;For Screen Draw Sync to crt line
CropYH	equ Vline+1;: dw 0
CropXW equ CropYH+2 ;: dw 0

BackgroundTilemapBase equ CropXW+2;: dw BackgroundTilemap2+2
BackgroundTilemapWidth equ BackgroundTilemapBase+2;:	db 36*2
BackgroundTilemapScrollX equ BackgroundTilemapWidth+1;: db 0
BackgroundTilemapScrollY equ BackgroundTilemapScrollX+1;: db 0
TileTmpW equ BackgroundTilemapScrollY+1 ;: dw 0
SPrestore equ TileTmpW+2
CacheTableAddr equ  SPrestore+2 ;: dw CacheTable
FlipMode equ CacheTableAddr+2	;db 0 
TileTint equ FlipMode+1	;db 0 

		
	ifndef DoubleBuffered
CacheTable equ CacheAddr3+384 ;CacheTableAddr+2
CacheTable_Last equ T_CacheTable_Last-T_CacheTable +CacheTable
CacheTable_End equ T_CacheTable_End-T_CacheTable +CacheTable	
tileChibiko3 equ $3000;FlipLut+384
	else
tileChibiko3 equ $3000;FlipLut+384	
	endif 


tileChibiko2 equ tileChibiko3+80
tilePlayer equ tileChibiko2+80
tileChibiko equ tilePlayer+80


Sprite1 equ tileChibiko+80
Sprite2 equ Sprite1+26
Sprite3 equ Sprite2+26
Sprite4 equ Sprite3+26
	
BackgroundTilemap2 equ CacheAddr3+512	;36*28*2+4	

;HiresX equ 1
;HiresY equ 1

;TileTest_BasicOnly equ 1
;\]TileTest_NoFlip equ 1


;AllowHalfTileScroll equ 1
;AllowQuarterTileScroll equ 1

;nodrawcache equ 1	



BackgroundTilemapWidthV equ 36


	;nolist
;SlowDownTest equ 1

;Logical units are pairs of pixels

;UseStackMisuse equ 1

VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

;LIMITATION.. The Virtual screen cannot be smaller than the sprite or 
;the crop will malfunction! (It can be the same size)

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96

	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 2

	macro doei
	endm

z_Regs 		equ $20




ScreenBase equ $0000+64


	include "\SrcAll\BasicMacros.asm"
		



	

	org $4000		;bank $0	
	setdp $2000			;Define the direct page as #$2000
ProgramStart:
	sei				;Disable interrupts
	csh				;Highspeed Mode
	cld				;Clear Decimal mode
	
	
	
	
	
	    ;      T12 - TIQ, IRQ1, IRQ2
	lda #%00000111
	sta $1402		;IRQ mask... 1=Off
	
	lda #$f8		;map in RAM
	tam #%00000010	;TAM1 (2000-3FFF)

	lda #$ff		;map in I/O (#$ff)
	tam #%00000001	;TAM0 (0000-1FFF)
	tax				
	txs				;Init stack pointer
		
	;Page in the banks of our cartridge
	lda #$00		;map in ROM
	tam #%00000100	;TAM1 (4000-5FFF)
	lda #$01		;map in ROM
	tam #%00001000	;TAM1 (6000-7FFF)
	lda #$02		;map in ROM
	tam #%00010000	;TAM1 (8000-9FFF)
	lda #$03		;map in ROM
	tam #%00100000	;TAM1 (A000-BFFF)
	lda #$04		;map in ROM
	tam #%01000000	;TAM1 (C000-DFFF)
	
	
	jmp Restart		;Jump to $4000
Restart:		
	;Page in last bank (We were running here before)
	lda #$05		;map in ROM
	tam #%10000000	;TAM1 (E000-FFFF)	
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		

;	ScreenInit
	st0 #5				;RegSelect 5
		 ;BSXXIIII	Backgroundon Spriteon eXtendedsync Interruptenable
	st1 #%11000000		;Background ON, Sprites On
	st2 #0
	
	st0 #9			
		; 0BBB0000
	st1 #%00000000		;BACKGROUND Tilemap size (32x32)
	st2 #0
	
;Screen Shape	
	st0 #10			;Horizontal  Sync  Register (HSR)
	st1 #$02
	st2 #$02
	
	st0 #11			;Horizontal Display Register (HDR)
	st1 #$1F
	st2 #$03
	
	st0 #12			;Vertical Sync Register  (VPR)
	st1 #$02
	st2 #$0F
	
	st0 #13			;Vertical Display Register (VDR)
	st1 #$EF
	st2 #$00
	
	st0 #14			;Vertical Display End Position Register (VCR)
	st1 #$03
	st2 #$00
	
;Reset Background scroll registers
	st0 #7				;Background X-scroll (------XX XXXXXXXX)
	st1 #0
	st2 #0
	
	st0 #8				;Background Y-scroll (-------Y YYYYYYYY)
	st1 #248			;Move Byte pos 0 to top left of screen 
	st2 #0				
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;	Init Palette	
	loadpair z_hl,Palette
	stz $0402			;Palette address L
	stz $0403			;Palette address H
	jsr DefinePalette

; Sprite Palette	
	loadpair z_hl,Palette
	stz $0402			;Palette address L
	lda #1
	sta $0403			;Palette address H
	jsr DefinePalette
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;	Cls

	st0 #0			;VDP reg 0 (address)
	st1 #$00		;L - Start of tilemap $0000
	st2 #$00		;H
	
	st0 #2			;Select VDP Reg2 (data)	
	
	ldx #4
	ldy #0			;1024 tiles total (32x32)
ClsAgain:	
	st1 #64			;Fill the entire area with our "Space tile"
	st2 #0			;(tile 64)
	dey
	bne ClsAgain
	dex 
	bne ClsAgain
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;		


;Send the tiles to VRAM (Normal + X-flip)
	
	ifdef FourColorPatterns			
		lda #0
		sta z_ixh		;Bitplane 2
		sta z_ixl		;Bitplane 3
	endif
	
	loadpair z_hl,Bitmap			;Source Bitmap Data
	loadpair z_bc,(BitmapEnd-Bitmap) ;Source Bitmap Data Length
	loadpair z_de,(PatternData*16)	;32 bytes per tile - but 1 word per vram addr
	jsr DefineTilesCombo 			;Define the tile patterns
	
	loadpair z_hl,Fills			;Source Bitmap Data
	loadpair z_bc,(FillsEnd-Fills) ;Source Bitmap Data Length
	loadpair z_de,(FillData*16)	;32 bytes per tile - but 1 word per vram address
	jsr DefineFills 	;Define the tile patterns
	
	
	ifndef DoubleBuffered

		loadpair z_hl,T_CacheTable
		loadpair z_de,CacheTable
		loadpair z_bc,(T_CacheTable_End-T_CacheTable)
		jsr ldir
	endif
	
	loadpair z_hl,T_BackgroundTilemap2
	loadpair z_de,BackgroundTilemap2
	loadpair z_bc,(36*28*2+4)
	jsr ldir
		

;Copy Sprite tilemaps to ram
	loadpair z_hl,T_SpriteTilemaps
	loadpair z_de,tileChibiko3
	loadpair z_bc,(80*4)
	jsr ldir
	
;Copy Sprite Object data to ram
	loadpair z_hl,T_Sprites
	loadpair z_de,Sprite1
	loadpair z_bc,(26*4)
	jsr ldir
	
	
	jmp RunTest2

	
	
	
	
	
	
PrintChar:
	rts	




	include "\SrcALL\V1_MaxTile_Expanders.asm"




	ifdef DoubleBuffered
		include "\SrcALL\V1_MaxTile_DirectDriver.asm"
	else
		include "\SrcALL\V1_MaxTile_CacheDriver.asm"
	endif 
	
	include "\SrcPCE\PCE_V1_MaxTile_Normal.asm"

	include "\SrcALL\V1_MaxTile_HspriteDriver.asm"
	
	include "\SrcPCE\PCE_V1_MaxTile_Hsprite.asm"
	
	 
 	include "\SrcALL\V1_MaxTile.asm"

	include "MaxTile_Test2.asm"

	include "\SrcAll\BasicFunctions.asm"
	
	
	
	
readjoystick:
Player_ReadControlsDual:
	;R:      3210
	;W:		   CS			C=Clear S=Select key/dir
	
	;Reset the Multitap... following reads will read in 
		;from joysticks 1-5
	ldx #%00000001			;Reset Multitap 1
	jsr JoypadSendCommand
	ldx #%00000011			;Reset Multitap 2
	jsr JoypadSendCommand

	jsr Player_ReadControlsOne	;Read Pad 1
	sta z_h
	rts
	
								;Read Pad 2
Player_ReadControlsOne:	
	ldx #%00000001				
	jsr JoypadSendCommand	;----LDRU (Left/Down/Right/Up)
	jsr JoypadShiftFourBitsA
	dex
	jsr JoypadSendCommand	;---RSBA (Run/Start/B/A)
	jsr JoypadShiftFourBits
	lda z_as
	sta z_l
	rts
	
JoypadShiftFourBitsA:		;Swap LDRU to RLDU
	ror						;Up
	ror z_as		
	ror						;Right (for later)
	ror z_l			
	ror						;Down
	ror z_as
	ror						;Left
	ror z_as
	rol z_l					;Right
	ror z_as
	rts	

JoypadShiftFourBits:		;Shift RSBA in to z_as
	ldx #4
JoypadShiftFourBitsB:
	ror
	ror z_as
	dex
	bne JoypadShiftFourBitsB
	rts
	
JoypadSendCommand:
	stx $1000			;Set option from X
	
	PHA 				;Delay
	PLA 
	NOP 
	NOP
	
	lda $1000			;Load result
	rts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	org $5ffe
	dw $E000			;Reset Vector 

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
T_Sprites:
T_Sprite1: 
	dw $4070	;0 XY
	dw $1420	;2 WH
	dw tilePlayer 	;4 TilemapHL
	dw Bitmap  ;6 PatternHL
	 ds 10		;8	CropCache = 10 bytes
	 ds 8		;20 CropCache_back = 8  bytes
;26 bytes total

T_Sprite2: 
	dw $B060	;0 XY
	dw $1420	;2 WH
	dw tileChibiko	;4 TilemapHL
	dw Bitmap  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes

T_Sprite3: 
	dw $5050	;0 XY
	dw $1420	;2 WH
	dw tileChibiko2	;4 TilemapHL
	dw Bitmap  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes

T_Sprite4: 
	dw $4080	;0 XY
	dw $1420	;2 WH
	dw tileChibiko3	;4 TilemapHL
	dw Bitmap  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes

T_Sprites_End:



palette:
    dw %0000000000000000; ;0  %-------GGGRRRBBB
    dw %0000000000100111; ;1  %-------GGGRRRBBB
    dw %0000000111000111; ;2  %-------GGGRRRBBB
    dw %0000000111111111; ;3  %-------GGGRRRBBB
    dw %0000000000000100; ;4  %-------GGGRRRBBB
    dw %0000000000100100; ;5  %-------GGGRRRBBB
    dw %0000000100000100; ;6  %-------GGGRRRBBB
    dw %0000000110110110; ;7  %-------GGGRRRBBB
    dw %0000000100100100; ;8  %-------GGGRRRBBB
    dw %0000000000111000; ;9  %-------GGGRRRBBB
    dw %0000000111000000; ;10  %-------GGGRRRBBB
    dw %0000000111111000; ;11  %-------GGGRRRBBB
    dw %0000000000000111; ;12  %-------GGGRRRBBB
    dw %0000000000111111; ;13  %-------GGGRRRBBB
    dw %0000000111000111; ;14  %-------GGGRRRBBB
    dw %0000000111111111; ;15  %-------GGGRRRBBB


Fills:
	db 0,0,0,0
	db 255,0,0,0
	db 0,255,0,0
	db 255,255,0,0
	db 0,255,255,0
	db 255,255,255,0
	db 255,255,255,255
FillsEnd:	
	
DefinePalette:
	ldx #0
	ldy #0
PaletteAgain:
	lda (z_hl),y
	sta $0404		;GGRRRBBB
	iny
	lda (z_hl),y
	sta $0405		;-------G
	iny
	inx
	cpx #16
	bne PaletteAgain
	rts
	

	org $8000
Bitmap:
	ifdef FourColorPatterns	
		ds 16
		incbin "\ResAll\Yquest\GMB_Yquest.RAW"
		org $8800-16
		incbin "\ResALL\ChibiFighter\GBC_Chibiko.RAW"
		org $9000
		incbin "\ResALL\ChibiFighter\GBC_Yarita.RAW"
	else 
		ds 32
		incbin "\ResAll\Yquest\PCE_YQuest.RAW"
		org $9000
		incbin "\ResALL\MinTile\Chibiko2_PCE.RAW"
		org $A000
		incbin "\ResALL\ChibiFighter\PCE_Yarita.RAW"
	endif
BitmapEnd:
	
		
	
	org $ffff
	db $0			;End of cartridge
	
	