
RunTest2:
	lda #<(backgroundtilemap2+2)	;Default background tilemap
	sta backgroundtilemapbase
	lda #>(backgroundtilemap2+2)
	sta backgroundtilemapbase+1

	lda #<(36*2)
	sta backgroundtilemapwidth
	lda #>(36*2)
	sta backgroundtilemapwidth+1
	jsr SetScroll

	loadpair z_hl,teplateyarita	;Source	
	loadpair z_de,tileplayer	;Dest
	loadpair z_ix,($1000+1)		;Base tile
	lda #5						;Width
	sta z_iyh
	lda #8						;Height
	sta z_iyl
	jsr expandtilemap			;Expand the object tilemap of 
								; The players 'sprite'
	
	
;Define the cropping area to use the full window
	lda #vscreenminy
	sta CropYH+1
	lda #vscreenhei-vscreenheiclip
	sta CropYH
	
	lda #vscreenminx
	sta CropXW+1
	lda #(vscreenwid-vscreenwidclip)
	sta CropXW
	
	
;Calculate areas covered by sprites	
	loadpair z_bc,$4070
	pushpair z_bc
		loadpair z_ix,sprite1
		ldy #spr_xy
		lda z_c
		sta (z_ix),y		;Set player sprite pos
		iny
		lda z_b
		sta (z_ix),y
		

		loadpair z_ix,sprite1
		jsr CalcCropRemoveIX ;Calculate background area behind sprite
		
		loadpair z_ix,sprite2
		jsr CalcCropRemoveIX
		
		loadpair z_ix,sprite3
		jsr CalcCropRemoveIX
		
		loadpair z_ix,sprite4
		jsr CalcCropRemoveIX
		
		ifdef clearborder
			jsr clearborder	;Draw a border around the game area
		endif
	pullpair z_bc

	
infloop:
	loadpair z_ix,sprite2		;Move the test sprites
	ldy #spr_xy+1

	jsr inc_z_ix_y ;inc (z_ix),y
	jsr inc_z_ix_y ;inc (z_ix),y

	loadpair z_ix,sprite3
	dey 			;ldy #spr_xy
	jsr inc_z_ix_y 	;inc (z_ix),y
	
	loadpair z_ix,sprite4
	jsr inc_z_ix_y ;inc (z_ix),y
	iny
	jsr inc_z_ix_y ;inc (z_ix),y

	
	pushpair z_bc
		jsr readjoystick
		sta z_d			;Get Joystick D=%4321RLDU
	pullpair z_bc
	
	lda z_d
	and #%00000001
	bne joynotup			;jump if up not presesd
		dec z_c				;move y up the screen
		jsr MovePlayerSprite ;UpdateSprite pos, remove old sprite
joynotup:

	lda z_d
	and #%00000010
	bne joynotdown			;jump if down not presesd
		inc z_c				;Move Y down the screen
		jsr MovePlayerSprite ;UpdateSprite pos, remove old sprite
joynotdown:

	lda z_d
	and #%00000100
	bne joynotleft			;Jump if LEFT not presesd
		dec z_b				;Move X Left 
		jsr MovePlayerSprite ;UpdateSprite pos, remove old sprite
joynotleft:

	lda z_d
	and #%00001000		
	bne joynotright			;Jump if RIGHT not presesd
		inc z_b				;Move X Right
		jsr MovePlayerSprite ;UpdateSprite pos, remove old sprite
joynotright:


	lda z_d
	and #%00010000
	beq joyfire
		jmp joynotfire
		
joyfire:
	pushpair z_bc
		loadpair z_hl,teplateyarita	;source
		loadpair z_de,tileplayer	;dest
		loadpair z_ix,($1000+1)
		
   		lda #5				;Width
		sta z_iyh
		lda #8				;Height
		sta z_iyl	
		
		lda flipmode		;Flip player sprite
		clc
		adc #1
		and #%00000011
		sta flipmode
		jsr ExpandTilemapA	;Update cached player tilemap based on flip	A
		
		
		loadpair z_hl,backgroundtilemapbase
		lda backgroundtilemapscrollx	;Scroll the background a unit
		clc
		adc #1
		ifndef allowquartertilescroll
			clc
			adc #1
		endif
		ifndef allowhalftilescroll
			clc
			adc #1
			clc
			adc #1
		endif
		sta backgroundtilemapscrollx

		lda backgroundtilemapscrolly
		clc
		adc #1
		ifndef allowquartertilescroll
			clc
			adc #1
		endif
		ifndef allowhalftilescroll
			clc
			adc #1	
			clc
			adc #1
		endif
		sta backgroundtilemapscrolly

		
		ifdef allowhalftilescroll
			;This code is only used for 1/2 or 1/4 tile scrolls
			ifndef setspeedscroll
				jsr setscroll		;full scroll redraw
			else
				loadpair z_ix,sprite1
				jsr removespriteix
				
				loadpair z_ix,sprite2
				jsr removespriteix
				
				loadpair z_ix,sprite3
				jsr removespriteix
				
				loadpair z_ix,sprite4
				jsr removespriteix
				
				jsr setspeedscroll	;Speedscroll (LDIR VRAM bitmap copy)
			endif

			loadpairfrom z_hl,backgroundtilemapbase

			ifdef vscreenhei76
				loadpair z_bc,(backgroundtilemapwidthv*17*2)
			else
				loadpair z_bc,(backgroundtilemapwidthv*22*2)
			endif
			jsr addhl_bc

			loadpair z_bc,backgroundtilemapwidthv*2	;Bottom two lines
			jsr resettilemap		;Flag for redraw BC tiles of tilemap HL

			
			loadpairfrom z_hl,backgroundtilemapbase
			loadpair z_bc,vscreenwid/2-4
			jsr addhl_bc
	
			lda #backgroundtilemapwidthv*2
			sta z_c
	
			loadpair z_de,$0118			;Redraw right hand strip
			jsr resettilemappart		;DE=WH C=Tilewidth HL=Tile src

			jsr resetscrollb			;Redraw Tilemap

		else
			;This code is used for full tile scrolls
			jsr resetscroll	;partiall scroll redraw
	endif

	pullpair z_bc
	
	pushpair z_bc
		loadpair z_ix,sprite1
		jsr RemoveSpriteIX	;Remove the player sprite
	pullpair z_bc
	
joynotfire:


	pushpair z_bc

		loadpair z_ix,sprite2
		jsr RemoveSpriteIX	;Remove the sprites from the screen
		
		loadpair z_ix,sprite3
		jsr RemoveSpriteIX
		
		loadpair z_ix,sprite4
		jsr RemoveSpriteIX
				
		loadpair z_ix,sprite1	; Calculate the area of tilemap covered
		jsr CalcCropRemoveIX	;  By the sprite to remove it next time.
		
		loadpair z_ix,sprite2
		jsr CalcCropRemoveIX
		
		loadpair z_ix,sprite3
		jsr CalcCropRemoveIX
		
		loadpair z_ix,sprite4
		jsr CalcCropRemoveIX
		
	pullpair z_bc
	pushpair z_bc
		loadpair z_ix,sprite1
		
		ldy #spr_xy			;Update Sprite pos of player
		lda z_c
		sta (z_ix),y
		iny
		lda z_b
		sta (z_ix),y
	pullpair z_bc
	pushpair z_bc
		jsr drawscreen		;Redraw the screen.
		ifdef clearborder
			jsr clearborder	;Draw a border if needed
		endif
	pullpair z_bc

	jmp infloop

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MovePlayerSprite:
	loadpair z_ix,sprite1
	ldy #spr_xy
	lda z_c
	sta (z_ix),y			;Update Sprite XY Pos
	iny
	lda z_b
	sta (z_ix),y
	pushpair z_de
	pushpair z_bc
		jsr removespriteix ;Remove the player sprite from the screen
	pullpair z_bc
	pullpair z_de
	rts
	
	

drawscreen:
	loadpair z_ix,sprite1
	jsr resetdirtyspriteix			;Calculate if the sprite needs
									; drawing due to overlap
	;ifdef buildzxn
	;	lda #%00001100
		;sta tiletint
	;endif

	loadpair z_ix,sprite1
	jsr prepspriteix		;Calc crop
							; ZeroInCache (Don't update background)
	loadpair z_ix,sprite2	; FlagSprite for redraw (Flag Sprite Tilemap)
	jsr prepspriteix
	
	loadpair z_ix,sprite3
	jsr prepspriteix
	
	loadpair z_ix,sprite4
	jsr prepspriteix

	loadpair z_hl,patterndata
	lda backgroundtilemapbase
	sta z_e
	lda backgroundtilemapbase+1
	sta z_d

	jsr cache_tilemapcls		;Redraw Tilemap
	
	; ifdef buildzxn
		; lda #%00001000
		; sta tiletint
	; endif

	loadpair z_ix,sprite1
	jsr drawspriteix			;Draw player

	ifdef buildsam
		lda #%01000100
		sta tiletint
	endif
	
	loadpair z_ix,sprite2
	jsr drawspriteix			;Draw Cpu1
	
	; ifdef buildzxn
		; lda #%00000000
		; sta tiletint
	; endif
		
	loadpair z_ix,sprite3		;Draw Cpu2
	jsr drawspriteix
	loadpair z_ix,sprite4
	jsr drawspriteix			;Draw Cpu3

	ifdef clearunusedhsprites
		jsr clearunusedhsprites	;Remove any unused Hsprites
	endif						; From the screen

	ifndef doublebuffered
redrawcaches:
		ifndef nodrawcache
			;loadpair z_hl,$5000
			;loadpair z_bc,$3000
			;jsr cldir0			;Test CLS

			loadpair z_iy,cachetable
			jmp fastdrawcaches	;Draw the caches in order
		else
			rts
		endif
	else
		rts
	endif
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
recalcscroll:
	loadpair z_hl,backgroundtilemap2

	lda backgroundtilemapscrollx
	and #%000001100		;%????TTHH  T=whole Tile H=Half/Quarter
	lsr 				;2 bytes per tile
	sta z_c
	jsr addhl_0c		;Across C Tiles
	
	lda backgroundtilemapwidth
	sta z_c

	lda backgroundtilemapscrolly
	and #%00001100		;%????TTHH  T=whole Tile H=Half/Quarter
	lsr
	lsr
	beq recalcscrolldone

	tax
recalcscrollb:
		jsr addhl_0c	;Down X lines
	dex
	bne recalcscrollb

recalcscrolldone:
	lda z_l
	sta backgroundtilemapbase
	lda z_h
	sta backgroundtilemapbase+1
	loadpair z_bc,(backgroundtilemapwidthv*24)
	rts
	
	

setscroll:	;full scroll redraw
	jsr recalcscroll			;Reset BC tiles of Tilemap HL
	ifndef doublebuffered
		jsr resettilemap		;Force tilemap redraw
	endif

resetscrollb:
	ifdef buildzxn
		lda #%00001100
		sta tiletint
	endif
	
	loadpair z_hl,patterndata

	lda backgroundtilemapbase
	sta z_e
	lda backgroundtilemapbase+1
	sta z_d

	loadpair z_bc,cacheaddr1
	jmp cache_tilemapcls		;Draw the tilemap

	
	
resetscroll:			;partial scroll redraw
	lda backgroundtilemapbase
	sta z_e
	lda backgroundtilemapbase+1
	sta z_d
	jsr recalcscroll
	jsr resettilemapshift	;Flag the tilemap for redraw
	jmp resetscrollb		; where tile onscreen has changed

	
	

	ifndef doublebuffered
		ifndef nodrawcache

fastdrawcaches:
			lda #cacheentries	;No of caches
			sta z_b
redrawcacheagain:
			pushpair z_bc
				pushpair z_iy
					jsr getcacheiy	;Get Cache IX from list IY

					beq lbl41848
						jsr processcache	;NZ=Data to process
lbl41848
				pullpair z_iy
				lda #cacheentrybytes
				sta z_c
				jsr AddIY_0C				;Move to next cache
			pullpair z_bc
			dec z_b
			bne redrawcacheagain
			jmp resetcaches
		endif
	endif

	
	
	
resettilemapshift:
		ldx #0
resettilemapshiftB:	
	ifndef doublebuffered
		ldy #0
		lda (z_de),y		;Tilemap Src
		and #%11111110
		cmp (z_hl),y		;Tilemap Dest
		bne resettilemapchange	;Changed?

		iny
		lda (z_de),y
		cmp (z_hl),y
		beq resettilemapshiftskip	;Changed?
		dey
resettilemapchange:
		lda (z_hl,x)
		ora #%00000001			;Yes -Flag update
		sta (z_hl,x)
		
resettilemapshiftskip:
		jsr IncHLx2
		jsr IncDEx2	
		
		lda z_c
		bne resettilemapshiftskipNoB
		dec z_b
		bmi resettilemapshiftskipDone
resettilemapshiftskipNoB:
		dec z_c
		jmp resettilemapshiftB
resettilemapshiftskipDone
	endif
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
prepspriteix:
	pushpair z_ix
		jsr calccropix			;Calculate Sprite draw area
	pullpair z_ix

	pushpair z_ix
		jsr zerospriteincache	;Dont redraw tilemap behind sprite
	pullpair z_ix

	ifndef doublebuffered
		pushpair z_ix
			jsr flagspriteforredraw ;Flag sprite tilemap for redraw
		pullpair z_ix
	endif
	rts

	

;Init Draw Crop data for sprite IX

CalcCropIX:
	ldy #spr_tilemaphl	;Get Tilemap source
	lda (z_ix),y
	sta z_iyl
	iny
	lda (z_ix),y
	sta z_iyh

	
	ldy #spr_wh			;Get WidthHeight
	lda (z_ix),y
	sta z_l
	iny
	lda (z_ix),y
	sta z_h
	
	ldy #spr_xy			;Get XY Pos
	lda (z_ix),y
	pha ;sta z_c
		iny
		lda (z_ix),y
		pha ;sta z_b
			jsr AddIX_spr_cropcache	;move to crop cache
		pla
		sta z_b
	pla
	sta z_c

	lda #VscreenHei-VscreenHeiClip	;For hardware sprites
	sta CropYH

	lda #VscreenWid-VscreenWidClip	;Get Vram Destination
	sta CropXW

	
	jsr calccrop

	ifdef getscreenposh
		jsr getscreenposh
	else
		jsr getscreenpos
	endif

	ldy #crop_vraml
	lda z_l
	sta (z_ix),y				;Store VRAM draw pos in sprite object
	iny
	lda z_h
	sta (z_ix),y
	rts


;Caclulate Crop buffer for background behind sprite IX
calccropremoveix:
	
	ifndef doublebuffered
		ldy #spr_wh
		lda (z_ix),y
		sta z_l
		iny
		lda (z_ix),y
		sta z_h
		
		ldy #spr_xy
		lda (z_ix),y
		sta z_c
		iny
		lda (z_ix),y
		sta z_b
			
;Alter W/H X/Y shrinking range if we allow Half/Quarter shifts
		ifdef hiresx
			lda z_b
			and #%00000011
			beq remove_noinch
			lda z_h
			clc
			adc #4
			sta z_h
remove_noinch:
		endif
		
		ifdef hiresy
			lda z_c
			and #%00000011
			beq remove_noincl
			lda z_l
			clc
			adc #4
			sta z_l
remove_noincl:
		endif

		ifdef allowhalftilescroll
			lda backgroundtilemapscrollx
			ifdef allowquartertilescroll
				eor #255
				and #%00000011
				beq shifttilemapxok
			else
				and #%00000011
				bne shifttilemapxok
			endif
			
			lda z_b
			sec
			sbc #4
			sta z_b

			lda z_h
			clc
			adc #4
			sta z_h

shifttilemapxok:
			ifdef hiresy
				lda backgroundtilemapscrolly
				ifdef allowquartertilescroll
					eor #255
					and #%00000011
					beq shifttilemapyok
				else
					and #%00000011
					bne shifttilemapyok
				endif
				lda z_c
				sec
				sbc #4
				sta z_c
				
				lda z_l
				clc
				adc #4
				sta z_l

shifttilemapyok:
			endif
		endif
		
		jsr AddIX_spr_cropcacheBack		;Move  to Crop cache2
		
		
		lda #VscreenHei
		sta CropYH

		lda #VscreenWid
		sta CropXW
		
		jmp calccrop		;BC=XYpos
	else
		rts
	endif
	
	
;Remove a sprite from the screen
	
removespriteix:
	ifndef doublebuffered
		pushpair z_ix
			jsr AddIX_spr_cropcacheBack  ;Get cache data for back
										 ; (tilemap behind sprite)
			jsr removesprite			;BC= X,Y pos ;DE=Wid/Hei
		pullpair z_ix
	endif
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
	
	
inc_z_ix_y:
	lda (z_ix),y
	clc
	adc #1
	sta (z_ix),y
	rts
	

AddIX_spr_cropcacheBack:
	pushpair z_bc
		lda #spr_cropcache_back
		sta z_c
		jsr AddIX_0C
	pullpair z_bc
	rts
	
	
;%NNBBXYPU	U=update P=Program YX=flip NN NN=Tile H
;BB = Bank / palette / top 2 bits of tile num

;&???0 %???????0 ???????? = Tile to be skipped
;&???1 %???????1 ???????? = Tile to be drawn
;&nnn1 %nnnnBB01 nnnnnnnn = Normal tile       (&-1)
;&nnP3 %BBPP0011 nnnnnnnn = Custom Program PP (&-3) (PP=0... Fill / PP=1... Stretch / pp=3+bb=3... empty (for sprites / pp=2 unused)
;&nn03 %BB000011 nnnnnnnn = Program Fill
;&nn13 %BB010011 nnnnnnnn = Program DoubleHeight
;&FFF3 %11110011 11111111 = Program Empty tile	(&F3 FF  /  F2 FF)
;&nn33 %nn110011 nnnnnnnn = Transparent tile	(&33 nn  / &7C nn  /  BC nn  /  F3nn)
;&nnn7 %nnnn0111 BBnnnnnn = Y flipped tile    (&-7)
;&nnnB %nnnn1011 BBnnnnnn = X flipped tile    (&-B)
;&nnnF %nnnn1111 nnnnnnnn = XY flipped tile   (&-F)

	

;Background Tilemap (2 bytes per tile)


	align 2
	ifdef RunFromRom
T_BackgroundTilemap2:			;ROM
	else
BackgroundTilemap2:				;RAM
	endif
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0040,$0040,$0040,$0040,$0047,$0047,$0047,$0047,$004B,$004B,$004B,$004B,$004F,$004F,$004F,$004F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0040,$0040,$0040,$0040,$0047,$0047,$0047,$0047,$004B,$004B,$004B,$004B,$004F,$004F,$004F,$004F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0040,$0040,$0040,$0040,$0047,$0047,$0047,$0047,$004B,$004B,$004B,$004B,$004F,$004F,$004F,$004F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0040,$0040,$0040,$0040,$0047,$0047,$0047,$0047,$004B,$004B,$004B,$004B,$004F,$004F,$004F,$004F,$0030,$0030,$0030,$0030

	dw $0030,$0037,$003B,$003F,$1AA0,$1AA7,$1AAB,$1AAF,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0050,$0050,$0050,$0050
	dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050
	dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050
	dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050
	dw $0030,$0037,$003B,$003F,$1AA0,$1AA7,$1AAB,$1AAF,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0050,$0050,$0050,$0050
	dw $0030,$0037,$003B,$003F,$1AA0,$1AA7,$1AAB,$1AAF,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0050,$0050,$0050,$0050
	dw $0030,$0037,$003B,$003F,$1AA0,$1AA7,$1AAB,$1AAF,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0020,$0030,$0040,$0000,$0010,$0050,$0050,$0050,$0050
	
	;Double
	dw $1213,$2213,$3213,$0813,$1013,$1213,$1413,$0613,$0413,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $1313,$2313,$3313,$0913,$1113,$1313,$1513,$0713,$0513,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
		
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030

	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030

	dw $0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050
	dw $0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050
	dw $0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050
	dw $0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050,$0050

	dw 0,0,0,0


;One byte per tile sprite object tilemaps 
;	Must be expanded before use

TemplateChibiko:
	 db 1,1,2,3,1
  	db 4,5,6,7,8
	  db 9,10,11,12,1
	  db 13,14,15,16,17
	  db 18,19,20,21,22
	  db 1,23,24,25,1
 	 db 1,26,27,28,1
	  db 1,29,30,31,1

TeplateYarita:
	 db 0,1,2,3,0
  	db 4,5,6,7,8
	  db 9,10,11,12,0
	  db 13,14,15,16,17
	  db 18,19,20,21,22
	  db 0,23,24,25,0
 	 db 0,26,27,28,0
	  db 0,29,30,31,0

	  
	 
;Two byte per tile tilemaps

  	ifdef RunFromRom
T_SpriteTilemaps:
T_tileChibiko3:
	else 
tileChibiko3:
	endif
	dw $FFF2,$8133,$0820,$0830,$8433
	dw $8533,$0860,$0870,$0880,$8933
	dw $8A33,$08B0,$08C0,$08D0,$8E33
	dw $8F33,$0900,$0910,$0920,$9333
	dw $9433,$0950,$0960,$0970,$9833
	dw $9933,$09A0,$09B0,$09C0,$9D33
	dw $FFF2,$9E33,$9F33,$A033,$FFF2
	dw $FFF2,$A133,$A233,$A333,$FFF2
	
  	ifdef RunFromRom
T_tileChibiko2:
	else
tileChibiko2:
	endif
 	dw $0800,$0810,$0820,$0830,$0840
	dw $0850,$0860,$0870,$0880,$0890
	dw $08A0,$08B0,$08C0,$08D0,$08E0
	dw $08F0,$0900,$0910,$0920,$0930
	dw $0940,$0950,$0960,$0970,$0980
	dw $0990,$09A0,$09B0,$09C0,$09D0
	dw $FFF2,$09E0,$09F0,$0A00,$FFF2
	dw $FFF2,$0A10,$0A20,$0A30,$FFF2

  	ifdef RunFromRom
T_tilePlayer:
	else
tilePlayer:
	endif
	dw $0800+1,$0810+1,$0820+1,$0830+1,$0840+1
	dw $0850,$0860,$0870,$0880,$0890
	dw $08A0,$08B0,$08C0,$08D0,$08E0
	dw $08F0,$0900,$0910,$0920,$0930
	dw $0940,$0950,$0960,$0970,$0980
	dw $0990,$09A0,$09B0,$09C0,$09D0
	dw $FFF2,$09E0,$09F0,$0A00,$FFF2
	dw $FFF2,$0A10,$0A20,$0A30,$FFF2

  	ifdef RunFromRom
T_tileChibiko:
	else
tileChibiko:	
	endif

	dw $0800,$0810,$0820,$0830,$0840
	dw $0850,$0860,$0870,$0880,$0890
	dw $08A0,$08B0,$08C0,$08D0,$08E0
	dw $08F0,$0900,$0910,$0920,$0930
	dw $0940,$0950,$0960,$0970,$0980
	dw $0990,$09A0,$09B0,$09C0,$09D0
	dw $FFF2,$09E0,$09F0,$0A00,$FFF2
	dw $FFF2,$0A10,$0A20,$0A30,$FFF2

  	ifdef RunFromRom
T_SpriteTilemaps_End:
	endif
	
	;double test
	;dw $1213,$2213,$3213,$0813,$1013,$1213,$1413
	;dw $1313,$2313,$3313,$0913,$1113,$1313,$1513
	;Filled
	;dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050
	