

runtest1:

;Default background tilemap

	loadpair z_hl,(backgroundtilemap2+2)	
	lda z_l
	sta backgroundtilemapbase
	lda z_h
	sta backgroundtilemapbase+1

	loadpair z_hl,36*2
	lda z_l
	sta backgroundtilemapwidth
	lda z_h
	sta backgroundtilemapwidth+1

	jsr setscroll

;Define the cropping area to use the full window
	
	lda #vscreenminy
	sta cropyh+1
	lda #vscreenhei-vscreenheiclip 
	sta cropyh

	lda #vscreenminx
	sta cropxw+1
	lda #vscreenwid-vscreenwidclip
	sta cropxw
	
	jsr drawscreen
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


infloop:
	loadpair z_hl,backgroundtilemapbase

;Scroll the background a unit
	
	lda backgroundtilemapscrollx
	clc
	adc #2
	ifndef allowhalftilescroll
		clc
		adc #2
	endif
	sta backgroundtilemapscrollx

	lda backgroundtilemapscrolly
	clc
	adc #2
	ifndef allowhalftilescroll
		clc
		adc #2
	endif
	sta backgroundtilemapscrolly
	
;Redraw the screen

	ifdef allowhalftilescroll
		jsr setscroll		;full scroll redraw
	else
		jsr resetscroll		;partiall scroll redraw
	endif
	
	jsr drawscreen
	
	jmp infloop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
	
drawscreen:
redrawcaches:

	ifndef doublebuffered
		ifndef nodrawcache
			;doei			;Enable interrupts (if appropriate)
			loadpair z_iy,cachetable
			jmp fastdrawcaches	;Draw the caches in order
		endif	
	endif
	rts
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

recalcscroll:

	loadpair z_hl,backgroundtilemap2

	lda backgroundtilemapscrollx
	and #%000001100		;%????TTHH  T=whole Tile H=Half/Quarter
	lsr 				;2 bytes per tile
	sta z_c
	jsr addhl_0c		;Across C Tiles

	lda backgroundtilemapwidth
	sta z_c

	lda backgroundtilemapscrolly
	and #%00001100		;%????TTHH  T=whole Tile H=Half/Quarter
	lsr
	lsr
	beq recalcscrolldone

	tax
recalcscrollb:
	
	jsr addhl_0c	;Down A lines
	dex
	bne recalcscrollb

recalcscrolldone:
	lda z_l
	sta backgroundtilemapbase
	lda z_h
	sta backgroundtilemapbase+1
	loadpair z_bc,(backgroundtilemapwidthv*24)
	rts
	
	
setscroll:	;full scroll redraw
	jsr recalcscroll
	ifndef doublebuffered
		jsr resettilemap		;Reset BC tiles of Tilemap HL
	endif

resetscrollb:
	;ifdef buildzxn
		;lda #%00001100			;Example 'tint' code for 4color tiles
		;sta tiletint			; on 16 color systems
	;endif
	
	loadpair z_hl,patterndata

	lda backgroundtilemapbase
	sta z_e
	lda backgroundtilemapbase+1
	sta z_d

	loadpair z_bc,cacheaddr1
	jmp cache_tilemapcls

	
	
ReSetScroll:		;Partial scroll redraw
	lda backgroundtilemapbase
	sta z_e
	lda backgroundtilemapbase+1
	sta z_d
	jsr recalcscroll
	jsr resettilemapshift	;Flag the tilemap for redraw
	jmp resetscrollb		; where tile onscreen has changed

		
ResetTilemapShift:
	ifndef doublebuffered
		ldx #0
		lda (z_de,x)		;Tilemap Src
		jsr incde
		
		and #%11111110
		cmp (z_hl,x)		;Tilemap Dest
		
		bne resettilemapchange	;Changed?

		jsr inchl
		lda (z_de,x)
		cmp (z_hl,x)
		beq resettilemapshiftskip	;Changed?
		jsr dechl
resettilemapchange:
		lda (z_hl,x)
		ora #%00000001		;Yes -Flag update
		sta (z_hl,x)
		jsr inchl

resettilemapshiftskip:
		jsr inchl
		jsr incde

		jsr decbc			;Tile count
		lda z_b
		ora z_c
		bne resettilemapshift
	endif
	rts
	

	ifndef doublebuffered
fastdrawcaches:
		lda #cacheentries			;No of caches
		sta z_b
redrawcacheagain:
		pushpair z_bc
			pushpair z_iy
				jsr getcacheiy		;Get Cache IX from list IY
				beq lbl47293
				jsr processcache	;NZ=Data to process
lbl47293
			pullpair z_iy
			lda #cacheentrybytes	
			sta z_c
			jsr AddIY_0C			;Move to next cache
		pullpair z_bc
		dec z_b
		bne redrawcacheagain
		jmp resetcaches
	endif



;%NNCCXYPU	U=update P=Program YX=flip CC=color/more NN NN=Tile H

;BB = Bank / palette / top 2 bits of tile num

;&???0 %???????0 ???????? = Tile to be skipped
;&???1 %???????1 ???????? = Tile to be drawn
;&nnn1 %nnnnBB01 nnnnnnnn = Normal tile       (&-1)
;&nnP3 %BBPP0011 nnnnnnnn = Custom Program PP (&-3) (PP=0... Fill / PP=1... Stretch / pp=3+bb=3... empty (for sprites / pp=2 unused)
;&nn03 %BBPP0011 nnnnnnnn = Program Fill
;&nn13 %BBPP0011 nnnnnnnn = Program Stretch
;&FFF3 %11110011 11111111 = Program Empty tile	(&F3 FF  /  F2 FF)
;&nn33 %nn110011 nnnnnnnn = Transparent tile	(&33 nn  / &7C nn  /  BC nn  /  F3nn)
;&nnn7 %nnnn0111 BBnnnnnn = Y flipped tile    (&-7)
;&nnnB %nnnn1011 BBnnnnnn = X flipped tile    (&-B)
;&nnnF %nnnn1111 nnnnnnnn = XY flipped tile   (&-F)
	
	align 2
		
  	ifdef RunFromRom

T_BackgroundTilemap2:			;ROM
	else
BackgroundTilemap2:				;RAM
	endif
	dw $0031,$0041,$0051,$0061,$0071,$0081,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080

	;Filled
	dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050
	dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050
	dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050
	dw $0003,$0103,$0203,$0303,$0403,$0503,$0603,$0703,$0803,$0903,$0A03,$0B03,$0C03,$0D03,$0E03,$0F03,$1003,$1103,$1203,$1303,$1403,$1503,$1603,$1703,$1803,$1903,$1A03,$1B03,$1C03,$1D03,$1E03,$1F03,$0050,$0050,$0050,$0050

	dw $0030,$0040,$0050,$0060,$0070,$0080,$0090,$00A0,$00B0,$00C0,$00D0,$00E0,$00F0,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	;Yflip
	dw $0037,$0047,$0057,$0067,$0077,$0087,$0097,$00A7,$00B7,$00C7,$00D7,$00E7,$00F7,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037,$0037
	;Xflip
	dw $003B,$004B,$005B,$006B,$007B,$008B,$009B,$00AB,$00BB,$00CB,$00DB,$00EB,$00FB,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B,$003B
	;XYflip
	dw $003F,$004F,$005F,$006F,$007F,$008F,$009F,$00AF,$00BF,$00CF,$00DF,$00EF,$00FF,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F,$003F

	;More Flips
	dw $0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0040,$0040,$0040,$0040,$0047,$0047,$0047,$0047,$004B,$004B,$004B,$004B,$004F,$004F,$004F,$004F,$0030,$0030,$0030,$0030

	;Double Height
	dw $1213,$2213,$3213,$0813,$1013,$1213,$1413,$0613,$0413,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
	dw $1313,$2313,$3313,$0913,$1113,$1313,$1513,$0713,$0513,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030,$0037,$0037,$0037,$0037,$003B,$003B,$003B,$003B,$003F,$003F,$003F,$003F,$0030,$0030,$0030,$0030
		
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030

	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080

	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030

	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080

	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030
	dw $0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030,$0030

	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	dw $0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080,$0030,$0040,$0050,$0060,$0070,$0080
	
	dw 0,0,0,0


