
CacheAddr1 equ $E000
CacheAddr2 equ $E100
CacheAddr3 equ $E200
FlipLut equ $E300
;HiresX equ 1
;HiresY equ 1

;TileTest_BasicOnly equ 1
;TileTest_NoFlip equ 1


;AllowHalfTileScroll equ 1
;AllowQuarterTileScroll equ 1

;nodrawcache equ 1	
;DoubleBuffered equ 1		;Disable caching - Full redraw each frame


BackgroundTilemapWidthV equ 36


	;nolist
;SlowDownTest equ 1

;Logical units are pairs of pixels

;UseStackMisuse equ 1


VscreenMinX equ 76		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 94

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

VscreenWid equ 104		;Visible Screen Size in logical units
VscreenHei equ 68

	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0

	macro doei
	endm

z_Regs 		equ $20

ScreenBase equ $C000+1


	include "\SrcAll\BasicMacros.asm"
	
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	INIT

	org $200-10		;Our program starts at $0200
	db $80,$08,$02,$00,$40,$0A,$42,$53,$39,$33
	
;ScreenInit	-	SUZY chip needs low byte setting first 
					;OR IT WILL WIPE THE HIGH BYTE!

	;Set screen ram pointer to $C000
	stz $FD94		;DISPADR	Display Address L (Visible)
	lda #$C0	
	sta $FD95		;DISPADR	Display Address H (Visible)
	
	sei
	
;Do the palette
	ldx #0
	ldy #0
	loadpair z_hl,Palette
	stz $2121		;CGADD - Colour selection  
PaletteAgain:
		 ;gggrrrrr 
	lda (z_hl),y
	sta $FDB0,x		;CGDATA - Colour data register
		 ;?bbbbbgg 
	iny
	lda (z_hl),y
	sta $FDA0,x		;CGDATA
	iny
	inx
	cpx #16
	bne PaletteAgain

		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Build the X-Flip LUT

	ldy #0
	loadpair z_hl,FlipLUT
 FillLutAgain:
	tya
	jsr SwapNibbles			;%AAAABBBB = %BBBBAAAA
	sta (z_hl),y
	iny
	bne FillLutAgain


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
	jmp RunTest1
		
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PrintChar:
	rts		

	
ReadJoystick:
	lda #$FF
	sta z_h			;Player 1 
	;sta z_l			;Player 2 - Only one pad so disabled
	
	eor $FCB0		;JOYSTICK	Read Joystick and Switches	UDLR12IO
			;(I= Inside Fire, O=Outside Fire, 1=Option 1, 2=Option 2)
			
	;FCB1 = Pause button on bit 0
			
	jsr SwapNibbles	; swap UDLR12IO to 12IOUDLR	
	tay				;Back up for later

	ldx #4
JoystickNextBitsB:	;shift 12IOUDLR into ---RLDU
	ror
	rol z_h			;Flip the order of the bits
	dex
	bne JoystickNextBitsB
	
	tya				;Get back backup 12IOUDLR
	ora #%00001111	;Get Fires 12IO---
	and z_h			;Or in ---RLDU
	sta z_h
	rts

;We Return ---FRLDU in z_h for Player 0, and z_L for Player 1
		
		
		

Vline: db 0		;For Screen Draw Sync to crt line
CropYH: dw 0
CropXW: dw 0
BackgroundTilemapBase: dw BackgroundTilemap2+2
BackgroundTilemapWidth:	db 36*2
BackgroundTilemapScrollX: db 0
BackgroundTilemapScrollY: db 0
		
		
		
	align 4
PatternData:
	db %00000000,%00000000
	db %10100000,%01010000
	db %11110000,%11110000
	db %01011010,%10100101
	db %00001111,%00001111
	db %10101111,%01011111
	db %11111111,%11111111
	db %01010101,%10101010
	
	db %00000000,%00000000
	db %00001010,%00000101
	db %00001111,%00000000
	db %11111111,%11111010
	db %11110101,%11110000
	db %00001111,%11111111
	db %11110000,%00000000
	db %00000000,%00000000
	
	db 0,0,0,0
	
		incbin "\ResAll\MinTile\TileTestLNX.raw"
TestChibiko:
	incbin "\ResALL\MinTile\Chibiko2_LNX.raw"


	
	
Palette:
	dw $0000; ;0  -GBR
	dw $00F8; ;1  -GBR
	dw $0FF0; ;2  -GBR
	dw $0FFF; ;3  -GBR
	dw $0080; ;4  -GBR
	dw $0088; ;5  -GBR
	dw $0880; ;6  -GBR
	dw $0CCC; ;7  -GBR
	dw $0888; ;8  -GBR
	dw $000F; ;9  -GBR
	dw $0F00; ;10  -GBR
	dw $0F0F; ;11  -GBR
	dw $00F0; ;12  -GBR
	dw $00FF; ;13  -GBR
	dw $0FF0; ;14  -GBR
	dw $0FFF; ;15  -GBR

	
	


 	include "\SrcALL\V1_MaxTile.asm"


	ifdef DoubleBuffered
		include "\SrcALL\V1_MaxTile_DirectDriver.asm"
	else
		include "\SrcALL\V1_MaxTile_CacheDriver.asm"
	endif 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


	include "\SrcLNX\LNX_V1_MaxTile_Normal.asm"



	include "MaxTile_Test1.asm"	
	
	include "\SrcAll\BasicFunctions.asm"
		
		