
;HiresX equ 1
;HiresY equ 1

;TileTest_BasicOnly equ 1
;TileTest_NoFlip equ 1

;SlowDownTest equ 1

;AllowHalfTileScroll equ 1
;AllowQuarterTileScroll equ 1

;nodrawcache equ 1	
;DoubleBuffered equ 1		;Disable caching - Full redraw each frame


FourColor equ 1				;Enable 4 color mode

CacheAddr1 equ $5C00		;3 x 256 byte draw caches
CacheAddr2 equ $5D00
CacheAddr3 equ $5E00

FlipLut equ $5F00			;256 byte X-flip LUT

BackgroundTilemapWidthV equ 36	;Tilemap width in tiles.

;Logical units are pairs of pixels

VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96
	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0

z_Regs 		equ $20

ScreenBase equ $6020	;VRAM base of virtual 32x24 tile screen


	macro doei
	endm

	include "\SrcAll\BasicMacros.asm"

GameRam equ $6000

;Init Routine
*=$0801
	db $0E,$08,$0A,$00,$9E,$20,$28,$32,$30,$36,$34,$29,$00,$00,$00  
*=$0810	;Start at $0810

	;	  LXMSHVVV - L=Cur Line X=extended BG M=mode 
				;(Txt/Bmp) S=screen on H=height V=Vert scroll
	lda #%00111011	;turn on graphics mode
	sta $D011
	
	
	;     ---MWHHH - M=Multicolor W=scr width H=horiz scroll
	ifdef FourColor
		lda #%11011000  ;1=Multicolor 4 coor 
	else
		lda #%11001000  ;0=standard 2 color 
	endif
	sta $D016

	;     SSSSTTT- - T=Text/Bmp screen address S=Screen (color) address
	lda #%00011000  ;T=1 Screen at $2000 					
	sta $D018			;(Other bits have no function in bitmap mode)
	
	lda $DD00
	and #%11111100
	ora #%00000010	;Screen base at $4000 range
	sta $DD00
	
	;	  ----CCCC
	lda #%00000000
	sta $D021		;Background color (only bits #0-#3).	
	lda #%00000000
	sta $D020		;Border 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	loadpair z_hl,$4400		
	loadpair z_bc,$0400		
	ifdef FourColor
		lda #$43			;Magenta / Cyan 
	else 
		lda #$40			;Magenta / Black
	endif
	jsr cldir			;Clear Colors 1
	
	ifdef FourColor
		loadpair z_hl,$D800		
		loadpair z_bc,$03E7
		lda #$01			;White
		jsr cldir			;Clear Colors 2
	endif

	loadpair z_hl,$6000		
	loadpair z_bc,$2000		
	jsr cldir0			;Clear Screen
	
;;;;;;;;;;;;;;;;;;;;;;

;Build the X-flip LUT
	
	ldy #0
	loadpair z_hl,FlipLUT
FillLutAgain:
	tya
	ifdef FourColor
		and #%11000000	;A
		clc
		rol
		rol
		rol
		sta z_c
		tya 
		and #%00110000	;B
		ror
		ror
		ora z_c
		sta z_c
		tya 
		and #%00001100	;C
		rol
		rol
		ora z_c
		sta z_c
		tya 
		and #%00000011	;D
		ror
		ror
		ror
		ora z_c
	else				;2 color mode
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		lda z_c
	endif
	sta (z_hl),y
	iny
	bne FillLutAgain
	
	
	jmp RunTest2

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	
ReadJoystick:	
	;lda $DC00			;Read in Joystick 1
	lda $DC01			;Read in Joystick 2
	sta z_h			;%---FRLDU
	rts
		
PrintChar:
	rts		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



 	include "\SrcALL\V1_MaxTile.asm"


	ifdef DoubleBuffered
		include "\SrcALL\V1_MaxTile_DirectDriver.asm"
	else
		include "\SrcALL\V1_MaxTile_CacheDriver.asm"
	endif 

	

	


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;





	include "\SrcC64\C64_V1_MaxTile_Normal.asm"
	
	include "\SrcALL\V1_MaxTile_Expanders.asm"






FlipMode: db 0		;For player flip test
Vline: db 0		;For Screen Draw Sync to crt line


CropYH: dw 0
CropXW: dw 0

BackgroundTilemapBase: dw BackgroundTilemap2+2
BackgroundTilemapWidth:	db 36*2
BackgroundTilemapScrollX: db 0
BackgroundTilemapScrollX2: db 0

BackgroundTilemapScrollY: db 0
BackgroundTilemapScrollY2: db 0




Sprite1: 
	dw $4070	;0 XY
	dw $1420	;2 WH
	dw tilePlayer 	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 10 bytes
	 ds 8		;20 CropCache_back = 8  bytes
;30 bytes total

Sprite2: 
	dw $B060	;0 XY
	dw $1420	;2 WH
	dw tileChibiko	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes


Sprite3: 
	dw $5050	;0 XY
	dw $1420	;2 WH
	dw tileChibiko2	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes



Sprite4: 
	dw $4080	;0 XY
	dw $1420	;2 WH
	dw tileChibiko3	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes






	include "MaxTile_Test2.asm"

	include "\SrcAll\BasicFunctions.asm"
	
	
	

	
	org $2800
PatternData:
	db %00000000,%00000000		;Fills (2 bytes per tile)
	db %10100000,%01010000
	db %11110000,%11110000
	db %01011010,%10100101
	db %00001111,%00001111
	db %10101111,%01011111
	db %11111111,%11111111
	db %01010101,%10101010
	db %00000000,%00000000
	db %00001010,%00000101
	db %00001111,%00000000
	db %11111111,%11111010
	db %11110101,%11110000
	db %00001111,%11111111
	db %11110000,%00000000
	db %00000000,%00000000
	
	;Regular tiles (8 bytes per tile)
	incbin "\ResAll\Yquest\C64_YQuest.RAW"
	org $2C00
	incbin "\ResALL\MinTile\Chibiko2_C64.raw"
	org $3000
	incbin "\ResALL\ChibiFighter\C64_Yarita.RAW"


	