
HiresX equ 1
;HiresY equ 1

;TileTest_BasicOnly equ 1
;TileTest_NoFlip equ 1


;AllowHalfTileScroll equ 1
;AllowQuarterTileScroll equ 1

;nodrawcache equ 1
;doubleBuffered equ 1		;Disable caching - Full redraw each frame


BackgroundTilemapWidthV equ 36


	;nolist
;SlowDownTest equ 1

;Logical units are pairs of pixels



CacheAddr1 equ $4C00
CacheAddr2 equ $4D00
CacheAddr3 equ $4E00
FlipLut equ $4F00

VscreenMinX equ 64		;Top left of visible screen in logical units
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96
	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0


	macro doei
	endm
	
ScreenBase equ $5000	;VRAM screen base

	include "\SrcAll\BasicMacros.asm"
	

	macro PushPair,ra	;Push a pair onto the stack (eg PushPair z_HL)
		lda \ra			
		pha				;Push lower Zpage entry
		lda \ra+1
		pha
	endm				;Push higher Zpage entry
	
	macro PullPair,ra	;Pull a pair onto the stack (eg PullPair z_HL)
		pla
		sta \ra+1		;Pull lower Zpage entry
		pla
		sta \ra			;Pull higher Zpage entry
	endm
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

z_Regs 		equ $20

RunLocation equ $0200

	ORG RunLocation  ;Actually our code runs at $3000 - but we shift it to here
	Jmp BootStrap+$3000-$200		;Bootstrap moved to end of program
start:


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	loadpair z_hl,CacheAddr1
	loadpair z_bc,$400
	;jsr CLDIR0
	
;ScreenInit

	lda #$D8		;Mode 1
	sta $FE20		;Video ULA Control	
SendULA:
	ldx #0
NextULAreg	
	lda ULAConfig,X
	sta $FE21		;ULA Load in color config
	
	stx $FE00		;CRTC Reg Select
	lda CRTCConfig,X
	sta $FE01		;CRTC Reg Data
	
	inx
	cpx #16
	bne NextULAreg	

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Build the lookup table	
	
	ldy #0			;Offset / Byte to flip	
	loadpair z_hl,FlipLUT
FillLutAgain:
	tya				
	and #%10001000	;A
	clc
	ror
	ror
	ror
	sta z_c
	tya 
	and #%01000100	;B
	ror
	ora z_c
	sta z_c
	tya 
	and #%00100010	;C
	rol
	ora z_c
	sta z_c
	tya 
	and #%00010001	;D
	rol
	rol
	rol
	ora z_c
	sta (z_hl),y
	iny
	bne FillLutAgain
	
	
	
	jmp RunTest2



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
PrintChar:
	rts	



readjoystick:
	lda #$F0				;Set port to read (For fire button)
	STA $FE43				;SN76489 - Data Direction
	sta z_as
	
	;lda #%00000000			;Get Channel 0 - Joy 1 LR
	jsr Player_ReadControlsGetData
	lda #%00000001			;Get Channel 1 - Joy 1 UD
	jsr Player_ReadControlsGetData
		
	lda $FE40
	and #%00010000			;Get the fire button 1 (PB4 / PB5)
	ora z_as
	eor #%11101111
	sta z_h
	rts
	
	;See page 429 of the 'BBC Microcomputer Advanced user Guide' 
	
Player_ReadControlsGetData:	;We need to convert analog to digital
	sta $FEC0						;Select channel
Player_ReadControlsDualWait:
	lda $FEC0						;Get Data
	and #%10000000
	bne Player_ReadControlsDualWait	;0= data ready
	
	lda $FEC1						;8 bit analog data
	cmp #255-32
	bcs Player_ReadControlsDualHigh
	cmp #32				
	bcc Player_ReadControlsDualLow 	;Centered
	clc
	bcc Player_ReadControlsDualB	;efective branch always
;	rol z_as
;	clc
;	rol z_as
;	rts
	
Player_ReadControlsDualLow:		;R/D
	sec
Player_ReadControlsDualB:
	rol z_as
	clc
	rol z_as
	rts
Player_ReadControlsDualHigh:	;U/L
	clc
	rol z_as
	sec
	rol z_as
	rts
	
	
;Define a 256 x 192 screen
	
CRTCConfig:
	db $7F		;0 - Horizontal total
	db $40		;1 - Horizontal displayed characters
	db $5A		;2 - Horizontal sync position
	db $28		;3 - Horizontal sync width/Vertical sync time
	db $26			;4 - Vertical total
	db $00			;5 - Vertical total adjust
	db 24			;6 - Vertical displayed characters (25)
	db 31			;7 - Vertical sync position
	db $01			;8 - Interlace/Display delay/Cursor delay
	db $07			;9 - Scan lines per character
	db %00110000	;10 - Cursor start line and blink type
	db $0			;11 - Cursor end line
	db $0A		;12 - Screen start address H (Address /8)
	db $00		;13 - Screen start address L 
	
ULAConfig:	
Palette0:	;Colours
;		SC  SC		-	S=Screen C=Color
	db $07,$17	;0
	db $47,$57	;0
Palette1:
	db $22,$32		;1
	db $62,$72		;1
Palette2:
	db $81,$91			;2
	db $C1,$D1			;2
Palette3:
	db $A0,$B0				;3
	db $E0,$F0				;3
	
;EOR True   Color
;7  (0) 	black
;6  (1) 	red
;5  (2) 	green
;4  (3) 	yellow (green—red)
;3  (4) 	blue
;2  (5) 	magenta (red—blue)
;1  (6) 	cyan (green—blue)
;0  (7) 	white








FlipMode: db 0		;For player flip test
Vline: db 0		;For Screen Draw Sync to crt line


CropYH: dw 0
CropXW: dw 0

BackgroundTilemapBase: dw BackgroundTilemap2+2
BackgroundTilemapWidth:	db 36*2
BackgroundTilemapScrollX: db 0
BackgroundTilemapScrollX2: db 0

BackgroundTilemapScrollY: db 0
BackgroundTilemapScrollY2: db 0




Sprite1: 
	dw $4070	;0 XY
	dw $1420	;2 WH
	dw tilePlayer 	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 10 bytes
	 ds 8		;20 CropCache_back = 8  bytes
;30 bytes total

Sprite2: 
	dw $B060	;0 XY
	dw $1420	;2 WH
	dw tileChibiko	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes


Sprite3: 
	dw $5050	;0 XY
	dw $1420	;2 WH
	dw tileChibiko2	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes



Sprite4: 
	dw $4080	;0 XY
	dw $1420	;2 WH
	dw tileChibiko3	;4 TilemapHL
	dw PatternData  ;6 PatternHL
	 ds 10		;8	CropCache = 12 bytes
	 ds 8		;20 CropCache_back = 10  bytes


	include "/srcBBC/BBC_V1_SpeedTile_ClearBorder.asm"


	ifdef DoubleBuffered
		include "\SrcALL\V1_MaxTile_DirectDriver.asm"
	else
		include "\SrcALL\V1_MaxTile_CacheDriver.asm"
	endif 


	include "\SrcBBC\BBC_V1_MaxTile_Normal.asm"
	;ifdef HiresY
		;include "\SrcCPC\CPC_V1_MaxTile_HalfShift.asm"
	;endif


	include "MaxTile_Test2.asm"


	include "\SrcALL\V1_MaxTile_Expanders.asm"

 	include "\SrcALL\V1_MaxTile.asm"
	include "\SrcAll\BasicFunctions.asm"

	org $2000
PatternData:
	db %00000000,%00000000
	db %10100000,%01010000
	db %11110000,%11110000
	db %01011010,%10100101
	db %00001111,%00001111
	db %10101111,%01011111
	db %11111111,%11111111
	db %01010101,%10101010
	db %00000000,%00000000
	db %00001010,%00000101
	db %00001111,%00000000
	db %11111111,%11111010
	db %11110101,%11110000
	db %00001111,%11111111
	db %11110000,%00000000
	db %00000000,%00000000
	incbin "\ResAll\Yquest\BBC_YQuest.RAW"
		
	org $2800
	incbin "\ResALL\MinTile\TileTestBBC.RAW"

	org $3000
	incbin "\ResALL\ChibiFighter\BBC_Yarita.RAW"
	
	


BBCLastByte: 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Our program is so big, the relocator code was being overwritten by the end of the block we were moving!
;So long as our program doesn't go over memory address $5000 it should work now
BootStrap:
	SEI			;Stop interrupts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;Stop the sound chip making a noise!

	;$43 = Data Dir Reg A
	;$40 = I/O Reg B $40
	;$41 = I/O Reg A $41
	
	lda #255		;Set all bits to write
	sta $FE43 ; Data direction port
	
	;	  1CCOVVVV = CC=channel O=operation (1=volume) V=Value (Volume 15=off)
	lda #%10011111	;Turn off channel 0
	sta $FE41
		
	    ; ----BAAA   =A=address (0=sound chip, 3=Keyboard) B=new setting for address AAA
	lda #%00001000		;Send data to Sound Chip
	sta $FE40			
	lda #%00000000		;Stop sending data to sound chip
	sta $FE40
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Transfer program from load address ($3000) 
;To Run address $0200 (out the way of screen)
	
	lda #$30	;Source H $3000
	sta z_h
	
	lda #>(BBCLastByte-RunLocation)
	sta z_b		;Byte count H
	
	lda #>RunLocation
	sta z_d		;Destination H $0200
	
	ldy #0		;Low byte of address
	sty z_l
	sty z_e

BBCLDIR:		
    lda (z_HL),Y
    sta (z_DE),Y
	iny
	BNE	BBCLDIR_SkipInc1
	INC	z_H ;Inc Ybytes of address
	INC	z_D
	DEC z_B
	BEQ	BBCLDIR_Done
BBCLDIR_SkipInc1:
	sec	;Relative jump (JR)
	bcs BBCLDIR	;this program code is relocated
BBCLDIR_Done:
;Jump to the new address in copied code ($0200)
	jmp start 
	