z_Regs 		equ $20


CacheAddr1 equ $200
CacheAddr2 equ $300
CacheAddr3 equ $400
FlipLut equ $500
;HiresX equ 1
;HiresY equ 1

;TileTest_BasicOnly equ 1
;TileTest_NoFlip equ 1


;AllowHalfTileScroll equ 1
;AllowQuarterTileScroll equ 1

;nodrawcache equ 1	
;DoubleBuffered equ 1		;Disable caching - Full redraw each frame


BackgroundTilemapWidthV equ 36


	;nolist
;SlowDownTest equ 1

;Logical units are pairs of pixels

;UseStackMisuse equ 1

VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

;LIMITATION.. The Virtual screen cannot be smaller than the sprite or 
;the crop will malfunction! (It can be the same size)

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96

	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0

	macro doei
	endm


	include "\SrcAll\BasicMacros.asm"
	

ScreenBase equ $4000+4

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

	ORG $0C00	;Program Start
	sei 		;Disable interrupts
	
	lda $C050 	;TXTCLR:   Display Graphics
	lda $C052 	;MIXCLR:   Display Full Screen
	lda $c057 	;HIRES:    Display HiRes Graphics
	lda $C055 	;TXTPAGE2: If 80STORE Off: Display Page 2
	
	loadpair z_hl,$4000
	loadpair z_bc,$1F00
	jsr cldir0			;Clear Screen
	
	
;Build the lookup table
	
	ldy #0
	loadpair z_hl,FlipLUT	;X-Flip Look up table
FillLutAgain:
	tya
	rol
	rol z_c			;Color bit
	
	tya
	ror
	rol z_c			;1
	ror
	rol z_c			;2
	ror
	rol z_c			;3
	ror
	rol z_c			;4
	ror
	rol z_c			;5
	ror
	rol z_c			;6
	ror
	rol z_c			;7
	lda z_c
	sta (z_hl),y	;Store flipped Byte

	iny
	bne FillLutAgain	;Repeat for 0-255
	
	
	
	jmp RunTest1

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




 	include "\SrcALL\V1_MaxTile.asm"


	ifdef DoubleBuffered
		include "\SrcALL\V1_MaxTile_DirectDriver.asm"
	else
		include "\SrcALL\V1_MaxTile_CacheDriver.asm"
	endif 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



	include "\SrcAP2\AP2_V1_MaxTile_Normal.asm"



	include "MaxTile_Test1.asm"

	include "\SrcAll\BasicFunctions.asm"
		
;Apple Joysticks are annoying!
;they are analog... we have to strobe the port 
;then read from the X and Y ports, and count up until the top bit changes
;this is a 'timer'...using just 1 bit (the top one) 
;it effectively returns an 'analog' value from about 0-100
	
ReadJoystick:	;---FRLDU
	lda $C061			;Fire 1
	and #%10000000
	rol	;Move in the fire button
	rol z_h
	
	lda $C070			;Strobe Joypads
	ldy #0
	ldx #0 
Joy_ReadAgain:
	pha
	pla					;delay
Joy_gotPDL1:			;Jump backhere when we get X
Joy_ChkPDl0:
	lda	$C064 			;<--SM ***   Y
JoySelfModAA_Plus2:
	bpl Joy_gotPDL0		;Have we got Y?
	nop
	iny	
	lda $C065			;<--SM ***   X
JoySelfModB_Plus2:
	bmi Joy_nogots		;Have we got X?
	bpl Joy_gotPDL1
Joy_nogots:
	inx
	jmp Joy_ChkPdl0
Joy_gotPDL0:			;We've Got Tpos - just waiting for X
	lda  $C065			;<--SM ***   X
JoySelfModBB_Plus2:
	bmi Joy_Nogots
	
	tya
	jsr JoyConvertAnalog;Convert Y
	txa
						;Convert X
	jsr JoyConvertAnalog;Convert Y
	lda z_h
	eor #%11111111
	sta z_h

PrintChar:
	rts
	
JoyConvertAnalog:	;covert analog from 0-100 into L/R or U/D
	cmp #$66
	bcs Joy_Rbit
	cmp #$33
	bcc Joy_Lbit
	clc 
	bcc Joy_Cbit
Joy_Rbit:
	sec 
Joy_Cbit:
	rol z_h
	clc
	rol z_h
	rts
	
Joy_Lbit:
	clc
	rol z_h
	sec 
	rol z_h
	rts
	



Vline: db 0		;For Screen Draw Sync to crt line
CropYH: dw 0
CropXW: dw 0
BackgroundTilemapBase: dw BackgroundTilemap2+2
BackgroundTilemapWidth:	db 36*2
BackgroundTilemapScrollX: db 0
BackgroundTilemapScrollY: db 0



	org $3000
PatternData:
	db %00000000,%00000000
	db %10100000,%01010000
	db %11110000,%11110000
	db %01011010,%10100101
	db %00001111,%00001111
	db %10101111,%01011111
	db %11111111,%11111111
	db %01010101,%10101010
	db %00000000,%00000000
	db %00001010,%00000101
	db %00001111,%00000000
	db %11111111,%11111010
	db %11110101,%11110000
	db %00001111,%11111111
	db %11110000,%00000000
	db %00000000,%00000000
	incbin "\ResAll\Yquest\AP2_YQuest.raw"
	org $3400
	incbin "\ResALL\MinTile\Chibiko2TilesAP2.RAW"
	
		
		
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;