;DoubleBuffered equ 1		;Disable caching - Full redraw each frame


FourColor equ 1

CacheAddr1 equ $200
CacheAddr2 equ $300
CacheAddr3 equ $400
FlipLut equ $500

RunFromRom equ 1

Vline equ FlipLut+256;  db 0		;For Screen Draw Sync to crt line
CropYH	equ Vline+1;: dw 0
CropXW equ CropYH+2 ;: dw 0

BackgroundTilemapBase equ CropXW+2;: dw BackgroundTilemap2+2
BackgroundTilemapWidth equ BackgroundTilemapBase+2;:	db 36*2
BackgroundTilemapScrollX equ BackgroundTilemapWidth+1;: db 0
BackgroundTilemapScrollY equ BackgroundTilemapScrollX+1;: db 0
TileTmpW equ BackgroundTilemapScrollY+1 ;: dw 0
SPrestore equ TileTmpW+2
CacheTableAddr equ  SPrestore+2 ;: dw CacheTable
	
	ifndef DoubleBuffered
CacheTable equ FlipLut+384 ;CacheTableAddr+2
CacheTable_Last equ T_CacheTable_Last-T_CacheTable +CacheTable
CacheTable_End equ T_CacheTable_End-T_CacheTable +CacheTable	
	endif 
	
BackgroundTilemap2 equ FlipLut+512	;36*28*2+4	

;HiresX equ 1
;HiresY equ 1

;TileTest_BasicOnly equ 1
;TileTest_NoFlip equ 1


;AllowHalfTileScroll equ 1
;AllowQuarterTileScroll equ 1

;nodrawcache equ 1	



BackgroundTilemapWidthV equ 36


	;nolist
;SlowDownTest equ 1

;Logical units are pairs of pixels

;UseStackMisuse equ 1

VscreenMinX equ 64		;Top left of visible screen in logical co-ordinates
VscreenMinY equ 80

;VscreenWid equ 24		;Visible Screen Size in logical units
;VscreenHei equ 24

;LIMITATION.. The Virtual screen cannot be smaller than the sprite or 
;the crop will malfunction! (It can be the same size)

VscreenWid equ 128		;Visible Screen Size in logical units
VscreenHei equ 96

	
VscreenWidClip equ 2	;alter right boundary due to working in words
VscreenHeiClip equ 0

	macro doei
	endm

z_Regs 		equ $20


ScreenBase equ $2064


	include "\SrcAll\BasicMacros.asm"
	


	ifdef BuildA80		;Atari 800 settings
GTIA equ $D000			;GTIA address
PIA  equ $D300			;PIA address
	org $A000     	  	;Start of cartridge area
	
	else				;Atari 5200 settings
GTIA  equ $C000			;GTIA address
POKEY equ $E800			;POKEY address
	org $4000       	;Start of cartridge area	
	endif
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	INIT

ProgramStart:        
	sei             ;Disable interrupts
	
    ldx #$00		;Zero GTIA area and Zero Page
    txa
ClearLoop    
    sta $00,x   	;Clear zero page
    sta GTIA,x      ;Clear GTIA
    dex
    bne ClearLoop
		
	lda #<DisplayList
	sta $D402 		;DLISTL - Display list lo
	lda #>DisplayList
	sta $D403 		;DLISTH - Display list hi
	
	lda #%00100010   	
	sta $D400 		;DMACTL - DMA Control (screen on)

	ifdef FourColor
		lda #$98      	;Set color PF1 (foreground) (CYAN)
		sta GTIA+ $17 	;COLPF1 equ 
		
		lda #$0F       	;Set color PF2 (background) (White)
		sta GTIA+ $18	;COLPF2 

		lda #$68        ;Set color PF0 (Purple)
		sta GTIA+ $16
		
		lda #$00       ;Set color PF0 (Black)
		sta GTIA+ $1A
	else
		lda #$0F
		sta GTIA+ $17 	;COLPF1 equ 		
		
		lda #$00        ;2 color mode only uses the brightness of color1
		sta  GTIA+ $16
		sta  GTIA+ $18
		sta  GTIA+ $1A	
	endif

	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Build the X-flip LUT

	ldy #0					;Y offset & source byte
	loadpair z_hl,FlipLUT 
FillLutAgain:
	tya
	ifdef FourColor
		and #%11000000	;A
		clc
		rol
		rol
		rol
		sta z_c
		tya 
		and #%00110000	;B
		ror
		ror
		ora z_c
		sta z_c
		tya 
		and #%00001100	;C
		rol
		rol
		ora z_c
		sta z_c
		tya 
		and #%00000011	;D
		ror
		ror
		ror
		ora z_c
	else				;2 color mode
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		ror
		rol z_c
		lda z_c
	endif
	sta (z_hl),y		;Write the calculate byte
	iny
	bne FillLutAgain	;Repeat for 0-255
	
	
	ifndef DoubleBuffered

		loadpair z_hl,T_CacheTable
		loadpair z_de,CacheTable
		loadpair z_bc,T_CacheTable_End-T_CacheTable
		jsr ldir
	endif
	
	loadpair z_hl,T_BackgroundTilemap2
	loadpair z_de,BackgroundTilemap2
	loadpair z_bc,(36*28*2+4)
	jsr ldir
		

	
	jmp RunTest1

	
	
	
	;We Return ---FRLDU in z_h for Player 0, and z_L for Player 1
	ifdef BuildA80	
ReadJoystick:
		lda PIA+$0	;22221111 - RLDU in player controls
		and #%00001111	;Bottom Nibble is Player 1 Joystick
		ora #%11100000
		sta z_h

		lda GTIA+$10	;$D010 - TRIG0 - joystick trigger 0
		clc
		rol
		rol
		rol
		rol
		ora z_h			;Joystick 1 Done
		sta z_h			
		
	rts
	endif
	
	
	ifdef BuildA52		;Atari 5200 doesn't have PIA 
ReadJoystick:
	lda GTIA+$10		;$C010 - TRIG0 - joystick trigger 0
	sta z_as
	
	lda pokey+0			;$E800 - POT0 - game paddle 0
	jsr Player_ReadControlsProcessAnalog
	
	lda pokey+1			;$E801 - POT1 - game paddle 1
	jsr Player_ReadControlsProcessAnalog
	
	lda #%11100000
	ora z_as
	sta z_h
	rts
	
	;Convert Analog to Digital
Player_ReadControlsProcessAnalog:
	cmp #255-64
	bcs Player_ReadControlsProcessHigh
	cmp #64
	bcc Player_ReadControlsProcessLow
	sec
	bcs Player_ReadControlsProcessB
;		rol z_h
;		sec
;		rol z_h
;		rts
Player_ReadControlsProcessHigh:		;B/R
	clc
Player_ReadControlsProcessB:
	rol z_as
	sec
	rol z_as
	rts
Player_ReadControlsProcessLow:		;T/L
	sec
	rol z_as
	clc
	rol z_as
	rts
	endif
	
	
PrintChar:
	rts		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




 	include "\SrcALL\V1_MaxTile.asm"


	ifdef DoubleBuffered
		include "\SrcALL\V1_MaxTile_DirectDriver.asm"
	else
		include "\SrcALL\V1_MaxTile_CacheDriver.asm"
	endif 

	include "\SrcA52\A52_V1_MaxTile_Normal.asm"



	include "MaxTile_Test1.asm"

	include "\SrcAll\BasicFunctions.asm"
	
	
	

	
	org $B800
PatternData:
	db %00000000,%00000000
	db %10100000,%01010000
	db %11110000,%11110000
	db %01011010,%10100101
	db %00001111,%00001111
	db %10101111,%01011111
	db %11111111,%11111111
	db %01010101,%10101010
	db %00000000,%00000000
	db %00001010,%00000101
	db %00001111,%00000000
	db %11111111,%11111010
	db %11110101,%11110000
	db %00001111,%11111111
	db %11110000,%00000000
	db %00000000,%00000000
	incbin "\ResAll\Yquest\C64_YQuest.RAW"
	org $BC00
	incbin "\ResALL\MinTile\Chibiko2_C64.raw"
		
		
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Display List
  
    org $bf20
	ifdef FourColor	
Smode Equ $0E	;E=4 color.... F=2 color
	else
Smode Equ $0F	;E=4 color.... F=2 color
	endif

DisplayList:				;Display list data
	db $70,$70,$70;$70 7= 8 blank lines 0= blank lines

		db $40+Smode,$60,$20	;Strange start ($2060) to safely step over the boundary
		
		db	         Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
		db $40+Smode,$00,$30	;Have to manually step over the 4k boundary ($3000)
		db	         Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		db	   Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode,Smode
		
	db $41					;Loop
	dw DisplayList
		

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Rom Header
        org $bffd
        db $FF         ;Disable Atari Logo
        dw ProgramStart;program Start
		
		
		