
	
	
syscallChipEXT equ 0
syscallVmControl equ 1
syscallMonitor equ 2
syscallAdventure equ 3	
	
syscallNativeSprite equ 7
  

regNO equ %11000000		;Don't Read or Write Regs
regRR equ %10000000		;Only Read Regs
regWW equ %01000000		;Only Write Regs

vm_SysCalls:
	dw Dummy		;0
	dw Dummy		;1
	dw Dummy		;2
	dw AdventureCall;3
	dw Dummy 		;4 - ChibiSoundCall
	dw Dummy		;5 - MaxTileCall  
	dw Dummy		;6 - QTVCall
	ifd NativeSpriteCall
		dw NativeSpriteCall ;7 - NSCall
	else 
		dw Dummy ;7 - NSCall
	endif
	dw Dummy ;8 - LoadMultiReg
	
AdventureCall:
	lda #>vecAdventureCall
	sta z_d
	lda #<vecAdventureCall
	sta z_e
	
ChibiVM_VectorCall:
	lda VM_RamBase+VM_rPC
	sta z_l
	lda VM_RamBase+VM_rPC+1
	sta z_h
	
	ldy #0
	lda (z_hl),y
	tax
	and #regRR
	bne ChibiVM_VectorCallNoWrite
	
	lda #>(AdventureCallDone-1)		;Writeback Regs
	pha
	lda #<(AdventureCallDone-1)
	pha	
ChibiVM_VectorCallNoWrite:	

	txa
	and #%00111111
	asl					;2 bytes per vector
	tay
	jsr incHL
	
	lda z_l
	sta VM_RamBase+VM_rPC
	lda z_h
	sta VM_RamBase+VM_rPC+1
		
	iny ;1
	lda (z_de),y		;H
	pha
	dey ;0
	lda (z_de),y		;L
	pha

	txa
	and #regWW
	bne ChibiVM_VectorCallNoRead
	
	lda VM_RamBase+2
	sta z_c
	lda VM_RamBase+3
	sta z_b
	lda VM_RamBase+4
	sta z_e
	lda VM_RamBase+5
	sta z_d
	lda VM_RamBase+6
	sta z_l
	lda VM_RamBase+7
	sta z_h
	lda VM_RamBase
ChibiVM_VectorCallNoRead:
	rts
	
	
AdventureCallDone:
	sta VM_RamBase
	lda z_c
	sta VM_RamBase+2
	lda z_b
	sta VM_RamBase+3
	lda z_e
	sta VM_RamBase+4
	lda z_d
	sta VM_RamBase+5
	lda z_l
	sta VM_RamBase+6
	lda z_h
	sta VM_RamBase+7
	
	rts
	
	
aPrintChar equ 0
aPrintSeq equ 1
aPrintNumber equ 2
aPrintSeqNC equ 3
aPrintSeqNL equ 4
aShowDecimal equ 5
aNewLine equ 6
acls equ 7
aFillArea equ 8
aWaitForFire equ 9
aJoyAxis equ 10
aPause50 equ 11
aPauseA equ 12
aDivideAbyH equ 13
aRangedRandom equ 14
aRangeLimit equ 15
aRangeTest equ 16
aDoRandom equ 17
aChibiSoundBeep equ 18
aChibiSound equ 19
aDoLdir equ 20
aDoLddr equ 21
aSlowDown equ 22
aReadJoystick equ 23
aWaitForRelease equ 24
aLastCommand equ 25
	
	
vecAdventureCall:	
	dw PrintChar-1
	dw PrintSeq-1
	dw PrintNumber-1
	dw PrintSeqNC-1
	dw PrintSeqNL-1
	dw ShowDecimal-1
	dw NewLine-1
	dw cls-1
	dw FillArea-1
	dw WaitForFire-1
	dw JoyAxis-1
	dw Pause50-1
	dw PauseA-1
	dw DivideAbyH-1
	dw RangedRandom-1
	dw RangeLimit-1
	dw RangeTest-1
	dw DoRandom-1
	dw Dummy-1
	dw Dummy-1
	dw DoLdir-1
	dw DoLddr-1
	dw SlowDown-1
	dw ReadJoystick-1
	dw WaitForRelease-1
	
Dummy:
	rts
	
	