
	include "\SrcAll\BasicMacros.asm"


VM_RamBase equ $6100
VM_StackTop equ $6200


;Controls:
;Fire: Cause Trap
;UP: Step 1 Tick
;Right: run emulator

;vm_useVMEM equ 1			;Enable Virtual address remapper

	include "\SrcALL\ChibiVm_InstSet.asm"

	;Basic macros for ASM tasks
	include "\SrcAll\BasicMacros.asm"

z_Regs 		equ $70
SPpage equ $0100

PrintChar equ $FFE3	;OSASCI 
NewLine equ $FFE7	;OSNEWL

	ORG $3000			;Start of our program code.
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;Stop the sound chip making a noise!

	;$43 = Data Dir Reg A
	;$40 = I/O Reg B $40
	;$41 = I/O Reg A $41
	
	lda #255		;Set all bits to write
	sta $FE43 ; Data direction port
	
	;	  1CCOVVVV = CC=channel O=operation (1=volume) V=Value (Volume 15=off)
	lda #%10011111	;Turn off channel 0
	sta $FE41
		
	    ; ----BAAA   =A=address (0=sound chip, 3=Keyboard) B=new setting for address AAA
	lda #%00001000		;Send data to Sound Chip
	sta $FE40			
	lda #%00000000		;Stop sending data to sound chip
	sta $FE40
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	lda #12				;CLS
	jsr PrintChar		;Print Character
	
	
	lda #0
	tay
VMInitClearRamAgain:
	sta VM_RamBase,y			;Clear 512 bytes VM RAM
	sta VM_RamBase+256,y
	iny
	bne VMInitClearRamAgain
	
	
	lda vm_Traps				;Get Reset Vector
	sta VM_RamBase+VM_rPC
	lda vm_Traps+1				;Get Reset Vector
	sta VM_RamBase+VM_rPC+1
	
	lda #<VM_StackTop			;Define Stack Pointer
	sta VM_RamBase+VM_rSP
	lda #>VM_StackTop			;Define Stack Pointer
	sta VM_RamBase+VM_rSP+1
	
	
;These are only needed if vm_useVMEM is defined
	lda #$00
	sta VM_RamBase+vm_rBank0+1	;Bits 15,16 select banknum,
	lda #$40					; value added to other 14 bits
	sta VM_RamBase+vm_rBank1+1
	lda #$80
	sta VM_RamBase+vm_rBank2+1	
	lda #$C0
	sta VM_RamBase+vm_rBank3+1	
	
	
InfLoop:	
	;jsr VM_Tick			;Process the next VM command at the PC
	;jmp InfLoop

	
	lda #30				;Home Cursor
	jsr PrintChar		;Print Character
	
;ZeroPage
	jsr MemDump			;Show Some Ram to screen
    word VM_RamBase     ;Address to show
    byte $3         	;Lines
	
;Stack
	jsr MemDump			;Show Some Ram to screen
    word VM_StackTop-16 ;Address to show
    byte $2        		;Lines
	
;Program
	lda VM_RamBase+VM_rPC
	sta t_MemdumpL
	lda VM_RamBase+VM_rPC+1
	sta t_MemdumpH
	ldx #1
	jsr MemDumpDirect

	
	;jsr Monitor
	
	jsr VM_Tick
			
	;jsr Monitor
	
	;jsr WaitForPress
	
	;jsr MonitorStack
	
	
	jmp InfLoop

MonitorStack:
	lda #$FF
	pha
	pha
	
	jsr MemDump			;Show Some Ram to screen
    word $01E0      		;Address to show
    byte $3         		;Lines
	
	pla
	pla
	rts

	
WaitForPress:
	jsr Player_ReadControlsDual
	lda z_h
	eor #255
	cmp #255
	beq WaitForPress		;See if no keys are pressed
	
	cmp #%11101111
	beq NoTrapTest
		;ld c,1				;Trap Number
		;call VM_CauseTrapFromOutsideVM	;Cause a Trap interrupt
	
NoTrapTest:
	
WaitForRelease:
	jsr Player_ReadControlsDual
	lda z_h
	eor #255
	cmp #%11111110
	beq WaitForRelease		;See if no keys are pressed
	rts


VMStart:
	include "\SrcALL\ChibiVm_CPU.asm"
VMEND:
	

	org $3800
	
;FU records stage being run.
;OK = no problems
;NG = No Good - Problem occurred at stage marked by FU register
	
TestProgram:
	;db secb
	;db sbci,1
	;db hltb
	;db secb
	;db tstb
	
	;db incb
	;dbw braj,TestAdd
;	db nopb
	
;Test 1 - Flags
	dbw mov16i,$0100						;Move $0100 R0
	db mov16x,RF_R0						;move $01 into FU
	db phfb									;Push F onto stack
	db pl4b									;Pop into R4
	db ph4b
	db pl2b										;PUSHPOP
	dbbw cmp16x,R2_imm16,$0100
	dbw bnej,ProgramFailed

TestAdd:
; Test 2 - ADD
	db movx,ZeroPg_imm8,vm_RFU,$02
	
	db movi,$FE
	db addi,1									;ADD
	db cmpx,RF_imm8,$00
	dbw bnej,ProgramFailed
	db addi,1
	db cmpx,RF_imm8,$03							;Carry+Z
	dbw bnej,ProgramFailed

TestSubt:	
; Test 3 - SUB
	db movx,ZeroPg_imm8,vm_RFU,$03
	
	db addi,1
	
	db subi,1									;SUB
	db cmpx,RF_imm8,$02
	dbw bnej,ProgramFailed
	db subi,1
	db cmpx,RF_imm8,$01							;Carry+Z
	dbw bnej,ProgramFailed
	
TestIncDec:
; Test 4 - INC DEC
	db movx,ZeroPg_imm8,vm_RFU,$04
	dbw mov16i,$FF01
	
	db incz,0									;INC
	db incz,0
	dbw beqj,ProgramFailed
	db incz,0
	
	db decz,1									;DEC
	db decz,1
	dbw beqj,ProgramFailed
	db decz,1
	dbbw cmp16x,R0_imm16,$FC04
	dbw bnej,ProgramFailed

TestSTO:
; Test 5 - STO STO16
	db movx,ZeroPg_imm8,vm_RFU,$05
	dbw mov16i,$1234
	db sto16z,2									;STO16
	db stoz,4									;STO
	dbbw cmp16x,R2_imm16,$1234
	dbw bnej,ProgramFailed
	
	db cmpx,R4_imm8,$34
	dbw bnej,ProgramFailed

	
TestLEA:
; Test 6 - LEA
	db movx,ZeroPg_imm8,vm_RFU,$06
	db leaz,2									;LEA
	dbbbw mov16x,ZeroPg_imm16,4,VM_RamBase
	db movx,ZeroPg_Imm8,4,$02
	dbb cmp16x,R0_R4
	dbw bnej,ProgramFailed
	
TestNEG:	
;Test 7 - NEG SWP16
	db movx,ZeroPg_imm8,vm_RFU,$07
	dbw mov16i,$0000
	db incb
	db NEGb										;NEG
	dbbw cmp16x,R0_imm16,$00FF
	dbw bnej,ProgramFailed
	db NEGb
	db NEGb
	dbw beqj,ProgramFailed
	
	db swp16b									;Swp16
	dbbw cmp16x,R2_imm16,$00FF
	dbw bnej,ProgramFailed
		
TestROL:
;Test 8 - ROL ROR
	db movx,ZeroPg_imm8,vm_RFU,$08
	db movx,rF_imm8,3
	dbw mov16i,$0041	
	db rolb										;ROL
	dbbw cmp16x,R0_imm16,$0083
	dbw bnej,ProgramFailed
	db rolb
	db rolb
	db rolb
	db rolb
	db rolb
	db rolb
	db rolb
	db rolb
	dbbw cmp16x,R0_imm16,$0041
	dbw bnej,ProgramFailed
	dbw mov16i,$0080
	db rolb
	dbw bccj,ProgramFailed
	dbw bnej,ProgramFailed
	
	dbw mov16i,$0041	
	db rorb										;ROR
	db rorb
	db rorb
	db rorb
	db rorb
	db rorb
	db rorb
	db rorb
	db rorb
	dbbw cmp16x,R0_imm16,$0041
	dbw bnej,ProgramFailed
	
TestASL:
;Test 9 - ASL ASR LSL
	db movx,ZeroPg_imm8,vm_RFU,$09
	dbw mov16i,$0043	
	db aslb										;ASL
	db aslb
	db aslb
	db aslb
	dbbw cmp16x,R0_imm16,$0030
	dbw bnej,ProgramFailed
	
	dbw mov16i,$0043	
	db lsrb										;LSR
	db lsrb
	db lsrb
	db lsrb
	dbbw cmp16x,R0_imm16,$0004
	dbw bnej,ProgramFailed
	
	dbw mov16i,$0083	
	db asrb										;ASR
	db asrb
	db asrb
	db asrb
	dbbw cmp16x,R0_imm16,$00F8
	dbw bnej,ProgramFailed
	
TestLogOps:
;Test 10 A - AND OR XOR
	db movx,ZeroPg_imm8,vm_RFU,$0A
	dbw mov16i,$0043	
	
	db andi,$0F									;AND
	dbbw cmp16x,R0_imm16,$0003
	dbw bnej,ProgramFailed
	
	db orri,$7F									;OR
	dbbw cmp16x,R0_imm16,$007F
	dbw bnej,ProgramFailed
	
	db xori,$F0									;XOR
	dbbw cmp16x,R0_imm16,$008F
	dbw bnej,ProgramFailed
	
	db tsti,$80									;TST 
	dbw beqj,ProgramFailed
	db tsti,$40
	dbw bnej,ProgramFailed
	

Test16bit:
;Test 11 (b) - MOV16b INC16b DEC16b ADD16b SUB16b
	db movx,ZeroPg_imm8,vm_RFU,$0B
	dbw mov16i,$8765
	
	db inc16b									;INC 16
	dbbw cmp16x,R0_imm16,$8766
	dbw bnej,ProgramFailed
	
	db dec16b									;DEC 16
	dbbw cmp16x,R0_imm16,$8765
	dbw bnej,ProgramFailed
	
	dbw add16i,$8000							;16bit add
	dbw bccj,ProgramFailed
	dbbw cmp16x,R0_imm16,$0765
	dbw bnej,ProgramFailed
		
	dbw sub16i,$8000							;16 bit subtract
	dbw bccj,ProgramFailed
	dbbw cmp16x,R0_imm16,$8765
	dbw bnej,ProgramFailed
	

TestTrapSys:
;Test 12 (C) - TRPb SYSb BRA2 BSR2
	db movx,ZeroPg_imm8,vm_RFU,$0C
	db trpi,1									;Trap Test (F3)
	db sysi,1									;System Test (E4)
	dbbw cmp16x,R0_imm16,$E4F3
	dbw bnej,ProgramFailed
	
	dbw bsrj,TestSub							;Sub test
	dbbw cmp16x,R0_imm16,$7766
	dbw bnej,ProgramFailed
	
	db inc16b,nopb								
	db bra2										;Skip next 2 bytes
	db inc16b,nopb
	db inc16b,nopb
	dbbw cmp16x,R0_imm16,$7768
	dbw bnej,ProgramFailed
	
	db brai,4									;Skip next 4 bytes
	db inc16b,nopb
	db inc16b,nopb
	
	dbbw cmp16x,R0_imm16,$7768
	dbw bnej,ProgramFailed
	
	dbw bsr16i,TestSub-AddressCalc1				;16 bit Relative Sub test
AddressCalc1:
	dbbw cmp16x,R0_imm16,$7766
	dbw bnej,ProgramFailed
	
	dbbw mov16x,r6_imm16,TestSub2
	db bsrh										;branch to sub in R6/7
	dbbw cmp16x,R0_imm16,$8877
	dbw bnej,ProgramFailed
	
TestAddressing:
;Test 13 - Addressing Modes
	db movx,ZeroPg_imm8,vm_RFU,$0D	
	
	dbbw mov16x,R0_Addr16,TestLoadAddress		;Store to address
	dbbw cmp16x,R0_imm16,$C0C1
	dbw bnej,ProgramFailed
	
	dbbw mov16x,R6_imm16,TestLoadAddress+2
	dbb movx,R0_AtR6							;Indirection
	dbbb cmpx,R0_imm8,$C3
	dbw bnej,ProgramFailed
	
	dbbw mov16x,R2_imm16,VM_RamBase+16
	dbb movx,AtR2inc_AtR6						;Autoinc
	dbb movx,AtR2inc_AtR6
	dbb movx,AtR2inc_AtR6
	dbb movx,AtR2inc_AtR6
	dbb movx,AtR2inc_AtR6
	dbbwb cmpx,Addr16_imm8,VM_RamBase+16+4,$C3	
	dbw bnej,ProgramFailed
	
	dbbw mov16x,R4_imm16,TestLoadAddress
	dbbb mov16x,R0_AtR4PlIm,4					;Base+Offset
	dbbb cmpx,r0_imm8,$C5
	dbw bnej,ProgramFailed
	
	dbbw mov16x,R6_imm16,$7770
	db ph6b
	dbbw cmp16x,AtSP_imm16,$7770				;Compare to top of stack
	dbw bnej,ProgramFailed
	
	
	
	dbw mov16i,'OK'
	db HLTb
	
TestSub:	
	dbw mov16i,$7766
	db retb
	
TestSub2:	
	dbw mov16i,$8877
	db retb
	
ProgramFailed:
	dbw mov16i,'NG'
	db HLTb
		

TestLoadAddress:
	dw $C0C1,$C2C3,$C4C5





vm_Traps:
	dw TestProgram
	dw TestTrap1
	
TestTrap1:
	db MOVi,$F3
	db RETb
	
TestSysCall1:	
	lda #$E4
	sta VM_RamBase+VM_rR1
	rts
	
vm_SysCalls:
	dw testhello
	dw TestSysCall1
	

testhello:
	rts
	
Trap1:
	db MOVi,$EE	
	db RETb
	
Trap2:
	db vm_PHF
	;db vm_MOV+ParamExtByt,Dest_ZeroPg+Param_ZeroPg,VM_rFs,VM_rF
	;db vm_PH0
		db vm_ORR+ParamExtByt,Dest_ZeroPg+Param_Imm8,VM_rF,VM_fTrap 

		db vm_MOV+vm_aIM,$DD
	
	;db vm_AND+ParamExtByt,Dest_Addr8+Param_Imm8
	;db 8,%10111111
	;db vm_MOV+ParamExtByt,Dest_ZeroPg+Param_ZeroPg,VM_rF,VM_rFs
	db vm_PLF
	db vm_RET

	
	
	
	
	
	;Debugging tools
	include "\SrcAll\monitor.asm"		
	;Basic commands for ASM tasks
	include "\SrcAll\BasicFunctions.asm"	
	

Player_ReadControlsDual:;----LRUD
	lda #$F0					;Set port to read (For fire button)
	STA $FE43				;SN76489 - Data Direction
	sta z_h
	
	;lda #%00000000			;Get Channel 0 - Joy 1 LR
	jsr Player_ReadControlsGetData
	lda #%00000001			;Get Channel 1 - Joy 1 UD
	jsr Player_ReadControlsGetData
	rts
	
	;See page 429 of the 'BBC Microcomputer Advanced user Guide' 
Player_ReadControlsGetData:	;We need to convert analog to digital
	sta $FEC0						;Select channel
Player_ReadControlsDualWait:
	lda $FEC0						;Get Data
	and #%10000000
	bne Player_ReadControlsDualWait	;0= data ready
	
	lda $FEC1						;8 bit analog data
	cmp #255-32
	bcs Player_ReadControlsDualHigh
	cmp #32				
	bcc Player_ReadControlsDualLow 	;Centered
	clc
	bcc Player_ReadControlsDualB	;efective branch always
	
Player_ReadControlsDualLow:		;R/D
	sec
Player_ReadControlsDualB:
	rol z_h
	clc
	rol z_h
	rts
Player_ReadControlsDualHigh:	;U/L
	clc
	rol z_h
	sec
	rol z_h
	rts

	
	dw VMEND-VMStart