
	ifndef z_HL
z_BC equ z_Regs+0	;Define 16 bit pairs for temp vars
z_C  equ z_Regs+0
z_B  equ z_Regs+1

z_DE equ z_Regs+2	;D,E is used for Cursor X,Y pos
z_E  equ z_Regs+2
z_D  equ z_Regs+3

z_HL equ z_Regs+4
z_L  equ z_Regs+4
z_H  equ z_Regs+5

z_As equ z_Regs+6
	endif


screenwidth equ ramarea+2



ClearRam:			;Clear 256 bytes of ram
	lda #0
	tax
ClearRamAgain:
	sta ramarea,x	
	inx
	bne ClearRamAgain

	ldx #16
ClearZpAgain:
	sta z_Regs,x	;Clear Zerpoage pairs
	dex
	bpl ClearZpAgain
	
	jmp cls			;Clear the screen


DoLdir:		;Copy BC bytes from HL to DE in ascending order
	ldx #0
	lda (z_HL,x)
	sta (z_DE,x)
	jsr IncHL
	jsr IncDE
	jsr DecBC
	lda z_B
	ora z_C
	bne doldir
	rts
		
	
DoLddr:		;Copy BC bytes from HL to DE in descending order
	ldx #0
	lda (z_HL,x)
	sta (z_DE,x)
	jsr DecHL
	jsr DecDE
	jsr DecBC
	lda z_B
	ora z_C
	bne dolddr
	rts
	
	
printseqfill:
	lda z_b
	pha
	lda z_c
	pha
		ldx #0
		lda (z_hl,x)	;W
		sta z_b		
		jsr inchl
		
		lda (z_hl,x)	;H
		sta z_c
		jsr inchl

		ldx #0
		lda (z_hl,x)	;Char
		jsr inchl
		tay
	lda z_h
	pla
	lda z_l
	pha
		lda (z_hl,x)	;Inc
		sta z_l
	
		tya
		sta z_h

		jsr FillArea
	pla
	sta z_l
	pla
	sta z_h
	jsr inchl			;Skip Inc byte
	jmp printseq_poprep

	
printseqCRNL:
	jsr newline		;zero x, move down a line
	jmp printseq


YposChange:
	cmp #251
	beq printseqfill	;&FB	 = Fill Area (W,H,Char,Inc)
	cmp #252
	beq printseqnc		;&FC 	 = New Column (Vertical)
	cmp #253
	beq printseqcrnl	;&FD     = New Line (True)
	cmp #254
	beq printseqnl		;&FE     = New Line (horizontal)
	cmp #255			;&FF     = End of List

	bne lbl38138		;yes? then return
	rts
lbl38138
	and #$1f
	sta z_e	;new ypos
	
	lda z_b
	sta z_d
	jmp printseqb
	
	
PrintSeqNC:
	lda z_c				;Restore Ypos
	sta z_e
	inc z_d				;Inc Xpos
	jmp printseq
	
PrintSeqNL:
	lda z_b				;Restore Xpos
	sta z_d
	inc z_e				;Inc Ypos
	
PrintSeq:				;Print Seq HL at location DE
	lda z_d
	sta z_b				;Backup DE->BC
	lda z_e
	sta z_c
	
;&00     = empty (nothing drawn)

PrintSeqB:
	ldx #0
	lda (z_hl,x)		;Get a char
	php
		jsr inchl		;Move to next char
	plp
	beq doprintchar		;0=Empty char
	cmp #32
	bcc xposchange		;&01-&1F = new absolute Xpos (use NL for Xpos=0)
	cmp #$e0
	bcs yposchange		;&E0-&F8 = new Absolute Ypos
	cmp #$a0
	bcs sequenceh		;&A0-&BF = Horizontal sequence of one char
doprintchar:
	jsr printchar		;&20-&9F = Character
	jmp printseqb
	
	
XposChange:
	sta z_d				;New Xpos
	jmp printseq
	
	
SequenceH:
	tay
	lda z_b
	pha
		tya
		cmp #$C0	;&C0-&DF = Vertical sequence of one char
		bcs sequencev	
		
		and #$1f
		clc
		adc #1
		sta z_b				;Count

		ldx #0
		lda (z_hl,x)		;get a char
		jsr inchl			;move to next char
SequenceH2:
		jsr printchar
		dec z_b
		bne sequenceh2
printseq_poprep:
	pla
	sta z_b
	jmp printseqb

	
SequenceV:
	and #$1f
	clc
	adc #1
	sta z_b			;Count

	ldx #0
	lda (z_hl,x)	;get a char
	jsr inchl		;move to next char
SequenceV2:
	pha
		tay
		lda z_d
		pha
		lda z_e
		pha
			tya
			jsr printchar
		pla
		sta z_e
		pla
		sta z_d
	pla
	inc z_e			;Move Down
	dec z_b			;Decrease Count
	bne sequencev2	
	jmp printseq_poprep

	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	

FillArea:			;H=Char L=Char increment DE=X,Ypos BC=Wid,Hei
	lda z_d
	pha
	lda z_e
	pha
FillAreaY:
		lda z_d
		pha
		;lda z_e
		;pha
		lda z_b
		pha
		;lda z_c
		;pha
FillAreaX:
			lda z_h		;char to show
			jsr printchar
			clc
			adc z_l		;move l chars
			
			sta z_h		;char to show next time

			dec z_b
			bne FillAreaX
		;pla
		;sta z_c
		pla
		sta z_b
		;pla
		;sta z_e
		pla
		sta z_d
	
	inc z_e				;next line
	dec z_c
	bne FillAreaY		;repeat for next line
	pla
	sta	z_e
	pla
	sta z_d
	rts
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
waitforfire:			;Pause for a fire press
	jsr WaitForRelease	;Wait for fire to be released
WaitForFire2:
	jsr DoRandom		;Re-seed the random generator
	jsr ReadJoystick	;Read from the joystick
	and #%00010000		;Test Fire
	bne WaitForFire2	;Not Preseed? Then repeat
	rts

WaitForRelease:			;Wait for the joystick to be released
	jsr ReadJoystick	;Get Joystick input
	cmp #255			;Any keys pressed?
	bne WaitForRelease	;Yes? then wait for release
	rts

	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	
joyaxis:		;A=Value to test C=Joypresses %---FRLDU
	sta z_b				;Backup previous value in B
	tax
	lda z_c
	and #%00000001		;Up or Left
	bne notupleft
	dex
notupleft:
	lda z_c
	and #%00000010		;Down or Right
	bne notdownright
	inx
notdownright:
	lsr z_c				;Skip 2 direction bits
	lsr z_c
	txa					;New value for A
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
pause50:
	lda #50				;Wait for 50
	
pausea:					;Wait for A * 255
	tay				
	ldx #0
pausebc2:
	jsr SlowDown
	dex 
	bne pausebc2
	dey 
	bne pausebc2
	rts	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
ShowDecimal:		;Draw a 3 digit decimal number (non-BCD)
	pha
	tay
		lda z_b
		pha
		lda z_c
		pha
		lda z_h
		pha
			lda #100
			sta z_h
			tya
			jsr divideabyh	;/100
			lda #10
			sta z_h
			lda z_b			;Get remainer
			jsr divideabyh	;/10
			lda z_b
			jsr printnumber	;/1
		pla 
		sta z_h
		pla
		sta z_c
		pla
		sta z_b
	pla
	rts

	
DivideAbyH:
	ldx #0				;X=Count
DivideBbyHagain:
	cmp z_h
	bcc DivideBbyH_LessThan		;Still A>=H
	inx					;Yes! Count+1
	sec
	sbc z_h				;-G
	jmp DivideBbyHagain
DivideBbyH_LessThan:
	sta z_b				;Remainder
	txa					;Count
	jmp PrintNumber		;Print A as a digit


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
	
RangeTest:		;ensure A is between D and E (>=D <E)
	cmp z_e
	bcs setcarry	;higher or equal to E
	cmp z_d
	bcc setcarry	;lower than d?
	clc				;Carry Clear = Value in range
	rts

setcarry:
	sec				;Carry Set = Value out of range
	rts


RangeLimit:			;reset a=b if over range de
	jsr rangetest
	bcc lbl57581
	lda z_b			;Reset A
lbl57581
	rts


	
randomseed equ ramarea	;2 bytes

DoRandom:			;Generate a psuedo random byte
	lda z_b
	pha
	lda z_c
	pha
		lda randomseed
		sta z_c
		lda randomseed+1
		sta z_b
		jsr incbc
		lda z_c
		sta randomseed
		sta z_b
		sta randomseed+1
		lda z_b
		ora z_c
		ror
		eor z_h
		ror
		eor z_d
		eor z_c			
		ror
		eor z_l
		ror
		eor z_e
		eor z_b
		ror
		eor #%10011101
		eor z_c
		tax
	pla
	sta z_c
	pla 
	sta z_b
	txa
	rts

	
rangedrandom:	;Return a value between D and E (>=D <E)
	jsr dorandom
	jsr rangetest
	bcs rangedrandom	;C=Out of range
	rts



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
;Shared Functions		
	

	ifndef IncBC	
IncBC:
		INC z_C
		BNE	IncBC_Done
		INC	z_B
IncBC_Done:
		rts
	endif
	
	ifndef IncHL		
IncDE:
		INC z_E
		BNE	IncDE_Done
		INC	z_D
IncDE_Done:
		rts
	endif
	
	ifndef IncHL	
IncHL:
		INC z_L
		BNE	IncHL_Done
		INC	z_H
IncHL_Done:
		rts
	endif
	
	ifndef DecBC
DecBC:	
		pha
			lda z_C
			bne DecBC_b
			DEC z_B
DecBC_b:	
			DEC z_C
		pla
		rts
	endif
	
	ifndef DecHL
DecHL:		
		pha
			lda z_L
			bne DecHL_h
			DEC z_H
DecHL_h:	
			DEC z_L
		pla
		rts
	endif
	
	ifndef DecDE
DecDE:		
		pha
			lda z_E
			bne DecDE_D
			DEC z_D
DecDE_D:	
			DEC z_E
		pla
		rts
	endif
	
