


NewLine:
	lda #0			;Cursor X=0
	sta z_d

	inc z_e			;Cursor Y++

	lda z_e
	cmp #23			;At bottom of screen?
	bcs cls			;no? return, else cls!
	rts

Cls:
	lda z_h
	pha
	lda z_l
	pha
		lda z_b
		pha
		lda z_c
		pha
			lda #0
			sta z_d			;x,y
			sta z_e
			sta z_l			;char,inc
			lda #$20
			sta z_h

			lda #22		;Width,Height
			sta z_b
			lda #23
			sta z_c

			jsr fillarea	;Clear the screen
		pla
		sta	z_c
		pla
		sta z_b
	pla
	sta	z_l
	pla
	sta z_h
slowdown:	;This exists for systems that run too fast
	rts



PrintNumber:		;Print Digit 0-9
	clc
	adc #48			;ascii 0

PrintChar:			;Print char A at loc D,E
	cmp #0
	bne Notprintchar0
		inc z_d			;Char=0? then just inc CursorX
		rts
Notprintchar0:	
	
	tax
	pha
	lda z_h
	pha
	lda z_l
	pha
		lda #$1E			;Screen base is $1E00
		sta z_h				;Vram= $1E00+ (Ypos*22) + Xpos
				
		lda z_d				;Xpos

		ldy z_e				;Ypos
		beq GetVDPScreenPos_YZero
				
GetVDPScreenPos_Addagain:	;Repeatedly add screen width (22) Y times 
		clc
		adc #22				;40 bytes per line

		bcc GetVDPScreenPos_AddagainB
		inc z_h				;Add Carry
GetVDPScreenPos_AddagainB		
		dey
		bne GetVDPScreenPos_Addagain
		
GetVDPScreenPos_YZero:	
		sta z_l

		txa					;Character
		cmp #64	
		bcc PrintChar_Symbols

		sbc #64				;Letters
		and #%00011111		;Force uppercase Letter
PrintChar_Symbols:
		ldx #0
		sta (z_hl,x)		;Set Character

		lda z_h
		adc #$78	;Colors at $9600 (add $7800 offset)
		sta z_h
		
		lda #3
		sta (z_hl,x)		;Set Color (3=Cyan)
	pla
	sta	z_l
	pla
	sta z_h
	pla
	inc z_d
	rts

	
	
			
;We Return ---FRLDU in z_h for Player 0, and z_L for Player 1

ReadJoystick:	;Returns %---FRLDU
	lda #%01111111
	sta $9122	;Set Data Direction of port B to READ (0=read)
	sta z_as	;Set unused buttons to unpressed
	
	lda $911F	;Port A (--FLDU-- Switches)
	rol
	rol
	rol
	rol z_as		;Shift in Fire
	rol $9120	;Port B (R------- Switch)
	ldx #4
ReadJoystickAgain:
	rol z_as		;Shift in Right
	rol
	dex
	bne ReadJoystickAgain
		
	lda z_as
	rts
	
	
VicScreenSettings:
	db $0C		;$9000 - horizontal centering
	db $26		;$9001 - vertical centering
	db $96		;$9002 - set # of columns / 
					;Bit7 = screen base bit ($16 for screen at $1000)
	db $AE		;$9003 - set # of rows
	db $7A		;$9004 - TV raster beam line
	db $F0		;$9005 - bits 0-3 start of character memory /  
					;bits 4-7 is rest of video address 
					;$(CF for screen at $1000)
	db $57		;$9006 - horizontal position of light pen
	db $EA		;$9007 - vertical position of light pen
	db $FF		;$9008 - Digitized value of paddle X
	db $FF		;$9009 - Digitized value of paddle Y
	db $00		;$900A - Frequency for oscillator 1 (low)
	db $00		;$900B - Frequency for oscillator 2 (medium)
	db $00		;$900C - Frequency for oscillator 3 (high)
	db $00		;$900D - Frequency of noise source
	db $00		;$900E - bit 0-3 sets volume of all sound / 
					;bits 4-7 are auxiliary color information
	db $00+8 	;$900F - Screen and border color register
	